/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.events;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.gwt.command.client.GwtRpcResponse;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.PageAccessException;
import org.unitime.timetable.model.Meeting;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.UserAuthority;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.evaluation.UniTimePermissionCheck;
import org.unitime.timetable.security.qualifiers.SimpleQualifier;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.Formats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EventAction<T extends EventInterface.EventRpcRequest<R>, R extends GwtRpcResponse>
implements GwtRpcImplementation<T, R> {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    protected static GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    protected static Formats.Format<Date> sDateFormat = Formats.getDateFormat(Formats.Pattern.DATE_EVENT_SHORT);

    @Override
    public R execute(T request, SessionContext context) {
        context.checkPermissionAnyAuthority(Right.Events, new SimpleQualifier("Session", ((EventInterface.EventRpcRequest)request).getSessionId()));
        return this.execute(request, new EventContext(context, ((EventInterface.EventRpcRequest)request).getSessionId()));
    }

    public abstract R execute(T var1, EventContext var2);

    protected static Formats.Format<Date> getDateFormat() {
        return sDateFormat;
    }

    protected static String toString(EventInterface.MeetingInterface meeting) {
        return (meeting instanceof EventInterface.MeetingConflictInterface ? ((EventInterface.MeetingConflictInterface)meeting).getName() + " " : "") + (meeting.getMeetingDate() == null ? "" : EventAction.getDateFormat().format(meeting.getMeetingDate()) + " ") + meeting.getAllocatedTime(CONSTANTS) + (meeting.hasLocation() ? " " + meeting.getLocationName() : "");
    }

    protected static String toString(Meeting meeting) {
        return (meeting.getMeetingDate() == null ? "" : EventAction.getDateFormat().format(meeting.getMeetingDate()) + " ") + EventAction.time2string(meeting.getStartPeriod(), 0) + " - " + EventAction.time2string(meeting.getStopPeriod(), 0) + (meeting.getLocation() == null ? " " + meeting.getLocation().getLabel() : "");
    }

    protected static String time2string(int slot, int offset) {
        int min = 5 * slot + offset;
        if (min == 0 || min == 1440) {
            return CONSTANTS.timeMidnight();
        }
        if (min == 720) {
            return CONSTANTS.timeNoon();
        }
        int h = min / 60;
        int m = min % 60;
        if (CONSTANTS.useAmPm()) {
            return (h > 12 ? h - 12 : h) + ":" + (m < 10 ? "0" : "") + m + (h == 24 ? "a" : (h >= 12 ? "p" : "a"));
        }
        return h + ":" + (m < 10 ? "0" : "") + m;
    }

    public static class EventContext
    implements SessionContext {
        private SessionContext iContext;
        private Qualifiable[] iFilter;
        private Date iToday;
        private Date iBegin;
        private Date iEnd;
        private UserContext iUser;
        private boolean iAllowEditPast = false;

        public EventContext(SessionContext context, UserContext user, Long sessionId) {
            this.iContext = context;
            this.iUser = user;
            if (sessionId == null) {
                sessionId = context.getUser().getCurrentAcademicSessionId();
            }
            this.iFilter = new Qualifiable[]{new SimpleQualifier("Session", sessionId)};
            Calendar cal = Calendar.getInstance(Localization.getJavaLocale());
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            this.iToday = cal.getTime();
            Session session = (Session)SessionDAO.getInstance().get(sessionId);
            if (session != null) {
                this.iBegin = session.getEventBeginDate();
                cal.setTime(session.getEventEndDate());
                cal.add(6, 1);
                this.iEnd = cal.getTime();
            }
            if (user != null) {
                String role = user.getCurrentAuthority() == null ? null : user.getCurrentAuthority().getRole();
                for (UserAuthority userAuthority : user.getAuthorities()) {
                    if (userAuthority.getAcademicSession() == null || !userAuthority.getAcademicSession().getQualifierId().equals(sessionId) || role != null && !role.equals(userAuthority.getRole())) continue;
                    this.iUser = new UniTimePermissionCheck.UserContextWrapper(user, userAuthority);
                    if (role == null) break;
                    this.iFilter = new Qualifiable[]{new SimpleQualifier("Session", sessionId), new SimpleQualifier("Role", (Serializable)((Object)role))};
                    break;
                }
            }
            this.iAllowEditPast = context.hasPermission(Right.EventEditPast);
        }

        public EventContext(SessionContext context, Long sessionId) {
            this(context, context.getUser(), sessionId);
        }

        public boolean isOutside(Date date) {
            return date == null || this.iBegin != null && date.before(this.iBegin) || this.iEnd != null && !date.before(this.iEnd);
        }

        public boolean isPast(Date date) {
            return !this.iAllowEditPast && (date == null || date.before(this.iToday));
        }

        public boolean isPastOrOutside(Date date) {
            return this.isPast(date) || this.isOutside(date);
        }

        public boolean isAuthenticated() {
            return this.iUser != null;
        }

        public UserContext getUser() {
            return this.iUser;
        }

        public boolean isHttpSessionNew() {
            return this.iContext.isHttpSessionNew();
        }

        public String getHttpSessionId() {
            return this.iContext.getHttpSessionId();
        }

        public Object getAttribute(String name) {
            return this.iContext.getAttribute(name);
        }

        public void removeAttribute(String name) {
            this.iContext.removeAttribute(name);
        }

        public void setAttribute(String name, Object value) {
            this.iContext.setAttribute(name, value);
        }

        public void removeAttribute(SessionAttribute attribute) {
            this.iContext.removeAttribute(attribute);
        }

        public void setAttribute(SessionAttribute attribute, Object value) {
            this.iContext.setAttribute(attribute, value);
        }

        public Object getAttribute(SessionAttribute attribute) {
            return this.iContext.getAttribute(attribute);
        }

        public PageAccessException getException() {
            if (this.iContext.isAuthenticated()) {
                return new PageAccessException(MESSAGES.authenticationInsufficient());
            }
            return new PageAccessException(this.iContext.isHttpSessionNew() ? MESSAGES.authenticationExpired() : MESSAGES.authenticationRequired());
        }

        public void checkPermission(Right right) {
            if (!this.iContext.hasPermissionAnyAuthority(right, this.iFilter)) {
                throw this.getException();
            }
        }

        public void checkPermission(Serializable targetId, String targetType, Right right) {
            if (!this.iContext.hasPermissionAnyAuthority(targetId, targetType, right, this.iFilter)) {
                throw this.getException();
            }
        }

        public void checkPermission(Object targetObject, Right right) {
            if (!this.iContext.hasPermissionAnyAuthority(targetObject, right, this.iFilter)) {
                throw this.getException();
            }
        }

        public boolean hasPermission(Right right) {
            return this.iContext.hasPermissionAnyAuthority(right, this.iFilter);
        }

        public boolean hasPermission(Serializable targetId, String targetType, Right right) {
            return this.iContext.hasPermissionAnyAuthority(targetId, targetType, right, this.iFilter);
        }

        public boolean hasPermission(Object targetObject, Right right) {
            return this.iContext.hasPermissionAnyAuthority(targetObject, right, this.iFilter);
        }

        public boolean hasPermissionAnyAuthority(Right right, Qualifiable ... filter) {
            return this.iContext.hasPermissionAnyAuthority(right, filter == null || filter.length == 0 ? this.iFilter : filter);
        }

        public boolean hasPermissionAnyAuthority(Serializable targetId, String targetType, Right right, Qualifiable ... filter) {
            return this.iContext.hasPermissionAnyAuthority(targetId, targetType, right, filter == null || filter.length == 0 ? this.iFilter : filter);
        }

        public boolean hasPermissionAnyAuthority(Object targetObject, Right right, Qualifiable ... filter) {
            return this.iContext.hasPermissionAnyAuthority(targetObject, right, filter == null || filter.length == 0 ? this.iFilter : filter);
        }

        public void checkPermissionAnyAuthority(Right right, Qualifiable ... filter) {
            this.iContext.checkPermissionAnyAuthority(right, filter == null || filter.length == 0 ? this.iFilter : filter);
        }

        public void checkPermissionAnyAuthority(Serializable targetId, String targetType, Right right, Qualifiable ... filter) {
            this.iContext.checkPermissionAnyAuthority(targetId, targetType, right, filter == null || filter.length == 0 ? this.iFilter : filter);
        }

        public void checkPermissionAnyAuthority(Object targetObject, Right right, Qualifiable ... filter) {
            this.iContext.checkPermissionAnyAuthority(targetObject, right, filter == null || filter.length == 0 ? this.iFilter : filter);
        }
    }
}

