/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.util.Properties;
import org.dom4j.Document;
import org.dom4j.Element;
import org.unitime.timetable.dataexchange.BaseExport;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentClassEnrollment;

public class StudentEnrollmentExport
extends BaseExport {
    public void saveXml(Document document, Session session, Properties parameters) throws Exception {
        try {
            this.beginTransaction();
            Element root = document.addElement("studentEnrollments");
            root.addAttribute("campus", session.getAcademicInitiative());
            root.addAttribute("year", session.getAcademicYear());
            root.addAttribute("term", session.getAcademicTerm());
            document.addDocType("studentEnrollments", "-//UniTime//UniTime Student Enrollments DTD/EN", "http://www.unitime.org/interface/StudentEnrollment.dtd");
            for (Student student : this.getHibSession().createQuery("select s from Student s where s.session.uniqueId = :sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                if (student.getClassEnrollments().isEmpty()) continue;
                Element studentEl = root.addElement("student");
                studentEl.addAttribute("externalId", student.getExternalUniqueId() == null || student.getExternalUniqueId().isEmpty() ? student.getUniqueId().toString() : student.getExternalUniqueId());
                for (StudentClassEnrollment enrollment : student.getClassEnrollments()) {
                    String extId;
                    Element classEl = studentEl.addElement("class");
                    Class_ clazz = enrollment.getClazz();
                    CourseOffering course = enrollment.getCourseOffering();
                    String string = extId = course == null ? clazz.getExternalUniqueId() : clazz.getExternalId(course);
                    if (extId != null && !extId.isEmpty()) {
                        classEl.addAttribute("externalId", extId);
                    }
                    classEl.addAttribute("id", clazz.getUniqueId().toString());
                    if (course != null) {
                        if (course.getExternalUniqueId() != null && !course.getExternalUniqueId().isEmpty()) {
                            classEl.addAttribute("courseId", course.getExternalUniqueId());
                        }
                        classEl.addAttribute("subject", course.getSubjectAreaAbbv());
                        classEl.addAttribute("courseNbr", course.getCourseNbr());
                    }
                    classEl.addAttribute("type", clazz.getSchedulingSubpart().getItypeDesc().trim());
                    classEl.addAttribute("suffix", clazz.getSectionNumberString());
                }
            }
            this.commitTransaction();
        }
        catch (Exception e) {
            this.fatal("Exception: " + e.getMessage(), e);
            this.rollbackTransaction();
        }
    }
}

