/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.web.WebTable;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.ExportUtils;
import org.unitime.timetable.webutil.PdfWebTable;
import org.unitime.timetable.webutil.TimetableManagerBuilder;

@Service(value="/timetableManagerList")
public class TimetableManagerListAction
extends Action {
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String tblData;
        String errM = "";
        this.sessionContext.checkPermission(Right.TimetableManagers);
        WebTable.setOrder(this.sessionContext, "timetableManagerList.ord", request.getParameter("order"), 1);
        boolean showAll = "1".equals(this.sessionContext.getUser().getProperty("TimetableManagers.showAll", "0"));
        if (request.getParameter("all") != null) {
            showAll = "true".equalsIgnoreCase(request.getParameter("all"));
            this.sessionContext.getUser().setProperty("TimetableManagers.showAll", showAll ? "1" : "0");
        }
        PdfWebTable table = new TimetableManagerBuilder().getManagersTable(this.sessionContext, true, showAll);
        int order = WebTable.getOrder(this.sessionContext, "timetableManagerList.ord");
        String string = tblData = order >= 1 ? table.printTable(order) : table.printTable();
        if ("Export PDF".equals(request.getParameter("op"))) {
            ExportUtils.exportPDF(new TimetableManagerBuilder().getManagersTable(this.sessionContext, false, showAll), order, response, "managers");
            return null;
        }
        request.setAttribute("schedDeputyList", (Object)(errM + tblData));
        request.setAttribute("showAllManagers", (Object)showAll);
        return mapping.findForward("success");
    }
}

