/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.timetable.form.SponsoringOrgEditForm;
import org.unitime.timetable.model.SponsoringOrganization;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;

@Service(value="/sponsoringOrgEdit")
public class SponsoringOrgEditAction
extends Action {
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionErrors errors;
        SponsoringOrgEditForm myForm = (SponsoringOrgEditForm)form;
        String op = myForm.getOp();
        this.sessionContext.checkPermission(Right.SponsoringOrganizations);
        if ("Back".equals(op)) {
            return mapping.findForward("list");
        }
        if ("Save".equals(op)) {
            this.sessionContext.checkPermission(Right.SponsoringOrganizationAdd);
            errors = myForm.validate(mapping, request);
            if (!errors.isEmpty()) {
                this.saveErrors(request, (ActionMessages)errors);
            } else {
                Transaction tx = null;
                try {
                    Session hibSession = new _RootDAO().getSession();
                    tx = hibSession.beginTransaction();
                    SponsoringOrganization spor = new SponsoringOrganization();
                    if (myForm.getOrgName() != null) {
                        spor.setName(myForm.getOrgName());
                    }
                    if (myForm.getOrgEmail() != null) {
                        spor.setEmail(myForm.getOrgEmail());
                    }
                    hibSession.saveOrUpdate((Object)spor);
                    tx.commit();
                }
                catch (Exception e) {
                    if (tx != null) {
                        tx.rollback();
                    }
                    throw e;
                }
                return mapping.findForward("list");
            }
        }
        if ("Update".equals(op)) {
            this.sessionContext.checkPermission(myForm.getId(), "SponsoringOrganization", Right.SponsoringOrganizationEdit);
            errors = myForm.validate(mapping, request);
            if (!errors.isEmpty()) {
                this.saveErrors(request, (ActionMessages)errors);
            } else {
                Transaction tx = null;
                try {
                    Session hibSession = new _RootDAO().getSession();
                    tx = hibSession.beginTransaction();
                    SponsoringOrganization spor = myForm.getOrg();
                    spor.setName(myForm.getOrgName() == null ? "" : myForm.getOrgName());
                    spor.setEmail(myForm.getOrgEmail() == null ? "" : myForm.getOrgEmail());
                    hibSession.saveOrUpdate((Object)spor);
                    tx.commit();
                }
                catch (Exception e) {
                    if (tx != null) {
                        tx.rollback();
                    }
                    e.printStackTrace();
                    throw e;
                }
                return mapping.findForward("list");
            }
        }
        if ("Delete".equals(op)) {
            this.sessionContext.checkPermission(myForm.getId(), "SponsoringOrganization", Right.SponsoringOrganizationDelete);
            Transaction tx = null;
            try {
                Session hibSession = new _RootDAO().getSession();
                tx = hibSession.beginTransaction();
                SponsoringOrganization spor = myForm.getOrg();
                hibSession.delete((Object)spor);
                tx.commit();
                return mapping.findForward("list");
            }
            catch (Exception e) {
                if (tx != null) {
                    tx.rollback();
                }
                throw e;
            }
        }
        if ("add".equals(myForm.getScreen())) {
            return mapping.findForward("add");
        }
        return mapping.findForward("show");
    }
}

