/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.OutputStream;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.timetable.action.RoomFeatureListAction;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.form.RoomFeatureListForm;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.ExportUtils;
import org.unitime.timetable.util.LookupTables;

@Service(value="/roomFeatureSearch")
public class RoomFeatureSearchAction
extends Action {
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RoomFeatureListForm roomFeatureListForm = (RoomFeatureListForm)form;
        this.sessionContext.checkPermission(Right.RoomFeatures);
        String deptCode = roomFeatureListForm.getDeptCodeX();
        if (deptCode == null) {
            deptCode = (String)this.sessionContext.getAttribute(SessionAttribute.DepartmentCodeRoom);
        }
        if (deptCode == null && (deptCode = request.getParameter("default")) != null) {
            this.sessionContext.setAttribute(SessionAttribute.DepartmentCodeRoom, (Object)deptCode);
        }
        if (deptCode != null && !deptCode.isEmpty() && ("All".equals(deptCode) || deptCode.matches("Exam[0-9]*") || this.sessionContext.hasPermission((Serializable)((Object)deptCode), "Department", Right.RoomFeatures))) {
            roomFeatureListForm.setDeptCodeX(deptCode);
            if ("Export PDF".equals(request.getParameter("op"))) {
                this.sessionContext.checkPermission(Right.RoomFeaturesExportPdf);
                OutputStream out = ExportUtils.getPdfOutputStream(response, "roomFeatures");
                RoomFeatureListAction.printPdfFeatureTable(out, this.sessionContext, roomFeatureListForm);
                out.flush();
                out.close();
                return null;
            }
            return mapping.findForward("roomFeatureList");
        }
        if (this.sessionContext.getUser().getCurrentAuthority().getQualifiers("Department").size() == 1) {
            roomFeatureListForm.setDeptCodeX(this.sessionContext.getUser().getCurrentAuthority().getQualifiers("Department").get(0).getQualifierReference());
            return mapping.findForward("roomFeatureList");
        }
        LookupTables.setupDepartments(request, this.sessionContext, true);
        LookupTables.setupExamTypes(request, this.sessionContext.getUser().getCurrentAcademicSessionId());
        return mapping.findForward("showRoomFeatureSearch");
    }
}

