/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.hibernate.HibernateException;
import org.hibernate.Transaction;
import org.hibernate.criterion.Order;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.form.RoomFeatureEditForm;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentRoomFeature;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.GlobalRoomFeature;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.RoomDept;
import org.unitime.timetable.model.RoomFeature;
import org.unitime.timetable.model.RoomFeaturePref;
import org.unitime.timetable.model.RoomFeatureType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.base.BaseDepartment;
import org.unitime.timetable.model.dao.ExamTypeDAO;
import org.unitime.timetable.model.dao.RoomFeatureDAO;
import org.unitime.timetable.model.dao.RoomFeatureTypeDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.spring.struts.SpringAwareLookupDispatchAction;
import org.unitime.timetable.util.Constants;

@Service(value="/roomFeatureEdit")
public class RoomFeatureEditAction
extends SpringAwareLookupDispatchAction {
    @Autowired
    SessionContext sessionContext;

    protected Map getKeyMethodMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("editRoomFeature", "editRoomFeature");
        map.put("button.delete", "deleteRoomFeature");
        map.put("button.update", "saveRoomFeature");
        map.put("button.addNew", "saveRoomFeature");
        map.put("button.returnToRoomFeatureList", "cancelRoomFeature");
        return map;
    }

    public ActionForward editRoomFeature(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws HibernateException, Exception {
        Object dept;
        RoomFeatureEditForm roomFeatureEditForm = (RoomFeatureEditForm)form;
        Long id = new Long(Long.parseLong(request.getParameter("id")));
        roomFeatureEditForm.setId(id.toString());
        RoomFeatureDAO rdao = new RoomFeatureDAO();
        RoomFeature rf = (RoomFeature)rdao.get(id);
        this.sessionContext.checkPermission(rf, rf instanceof GlobalRoomFeature ? Right.GlobalRoomFeatureEdit : Right.DepartmenalRoomFeatureEdit);
        roomFeatureEditForm.setSessionId(this.sessionContext.getUser().getCurrentAcademicSessionId());
        roomFeatureEditForm.setFeatureTypeId(rf.getFeatureType() == null ? -1L : rf.getFeatureType().getUniqueId());
        if (rf instanceof GlobalRoomFeature) {
            Department department;
            roomFeatureEditForm.setGlobal(true);
            roomFeatureEditForm.setDeptCode(null);
            roomFeatureEditForm.setDeptName(null);
            dept = (String)this.sessionContext.getAttribute(SessionAttribute.DepartmentCodeRoom);
            if (dept != null && ((String)dept).matches("Exam[0-9]*")) {
                roomFeatureEditForm.setDeptName(((ExamType)ExamTypeDAO.getInstance().get(Long.valueOf(((String)dept).substring(4)))).getLabel() + " Examination Rooms");
            } else if (dept != null && !((String)dept).isEmpty() && !"All".equals(dept) && (department = Department.findByDeptCode((String)dept, this.sessionContext.getUser().getCurrentAcademicSessionId())) != null) {
                roomFeatureEditForm.setDeptName(department.getDeptCode() + " - " + department.getName());
            }
        }
        if (rf instanceof DepartmentRoomFeature) {
            roomFeatureEditForm.setGlobal(false);
            dept = ((DepartmentRoomFeature)rf).getDepartment();
            roomFeatureEditForm.setDeptCode(((BaseDepartment)dept).getDeptCode());
            roomFeatureEditForm.setDeptName(((BaseDepartment)dept).getDeptCode() + " - " + ((BaseDepartment)dept).getName());
        }
        if (roomFeatureEditForm.getName() == null || roomFeatureEditForm.getName().isEmpty()) {
            roomFeatureEditForm.setName(rf.getLabel());
        }
        if (roomFeatureEditForm.getAbbv() == null || roomFeatureEditForm.getAbbv().isEmpty()) {
            roomFeatureEditForm.setAbbv(rf.getAbbv());
        }
        Collection assigned = this.getAssignedRooms(rf);
        Collection available = this.getAvailableRooms(rf);
        TreeSet sortedAssignedRooms = new TreeSet(assigned);
        roomFeatureEditForm.setAssignedRooms(sortedAssignedRooms);
        TreeSet sortedAvailableRooms = new TreeSet(available);
        roomFeatureEditForm.setNotAssignedRooms(sortedAvailableRooms);
        roomFeatureEditForm.setRooms();
        request.setAttribute("featureTypes", RoomFeatureTypeDAO.getInstance().findAll(Order.asc((String)"label")));
        return mapping.findForward("showEdit");
    }

    public ActionForward deleteRoomFeature(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RoomFeatureEditForm roomFeatureEditForm = (RoomFeatureEditForm)form;
        Long id = new Long(roomFeatureEditForm.getId());
        RoomFeatureDAO rdao = new RoomFeatureDAO();
        org.hibernate.Session hibSession = rdao.getSession();
        Transaction tx = null;
        try {
            tx = hibSession.beginTransaction();
            RoomFeature rf = (RoomFeature)rdao.get(id, hibSession);
            if (rf != null) {
                this.sessionContext.checkPermission(rf, rf instanceof GlobalRoomFeature ? Right.GlobalRoomFeatureDelete : Right.DepartmenalRoomFeatureDelete);
                ChangeLog.addChange(hibSession, this.sessionContext, rf, ChangeLog.Source.ROOM_FEATURE_EDIT, ChangeLog.Operation.DELETE, null, rf instanceof DepartmentRoomFeature ? ((DepartmentRoomFeature)rf).getDepartment() : null);
                for (Location loc : rf.getRooms()) {
                    loc.getFeatures().remove(rf);
                    hibSession.save((Object)loc);
                }
                for (RoomFeaturePref p : hibSession.createQuery("from RoomFeaturePref p where p.roomFeature.uniqueId = :id").setLong("id", id.longValue()).list()) {
                    p.getOwner().getPreferences().remove(p);
                    hibSession.delete((Object)p);
                    hibSession.saveOrUpdate((Object)p.getOwner());
                }
                hibSession.delete((Object)rf);
            }
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            throw e;
        }
        roomFeatureEditForm.setDeptCode((String)this.sessionContext.getAttribute(SessionAttribute.DepartmentCodeRoom));
        return mapping.findForward("showRoomFeatureList");
    }

    public ActionForward saveRoomFeature(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RoomFeatureEditForm roomFeatureEditForm = (RoomFeatureEditForm)form;
        ActionMessages errors = new ActionMessages();
        errors = roomFeatureEditForm.validate(mapping, request);
        if (errors.size() != 0) {
            this.saveErrors(request, errors);
            this.editRoomFeature(mapping, form, request, response);
            return mapping.findForward("showEdit");
        }
        this.update(mapping, roomFeatureEditForm, request, response);
        roomFeatureEditForm.setDeptCode((String)this.sessionContext.getAttribute(SessionAttribute.DepartmentCodeRoom));
        if (roomFeatureEditForm.getId() != null) {
            request.setAttribute("hash", (Object)("A" + roomFeatureEditForm.getId()));
        }
        return mapping.findForward("showRoomFeatureList");
    }

    private void update(ActionMapping mapping, RoomFeatureEditForm roomFeatureEditForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Long id = new Long(roomFeatureEditForm.getId());
        org.hibernate.Session hibSession = new RoomFeatureDAO().getSession();
        Transaction tx = null;
        try {
            Set<RoomFeature> features;
            HashSet<Location> m;
            tx = hibSession.beginTransaction();
            RoomFeature roomFeature = (RoomFeature)new RoomFeatureDAO().get(id, hibSession);
            this.sessionContext.checkPermission(roomFeature, roomFeature instanceof GlobalRoomFeature ? Right.GlobalRoomFeatureEdit : Right.DepartmenalRoomFeatureEdit);
            roomFeature.setLabel(roomFeatureEditForm.getName());
            roomFeature.setAbbv(roomFeatureEditForm.getAbbv());
            Object[] selectedAssigned = roomFeatureEditForm.getAssignedSelected();
            Object[] selectedNotAssigned = roomFeatureEditForm.getNotAssignedSelected();
            Collection assignedRooms = this.getAssignedRooms(roomFeature);
            Collection notAssignedRooms = this.getAvailableRooms(roomFeature);
            if (roomFeatureEditForm.getFeatureTypeId() != null && roomFeatureEditForm.getFeatureTypeId() >= 0L) {
                roomFeature.setFeatureType((RoomFeatureType)RoomFeatureTypeDAO.getInstance().get(roomFeatureEditForm.getFeatureTypeId()));
            } else {
                roomFeature.setFeatureType(null);
            }
            String s1 = null;
            String s2 = null;
            s1 = selectedAssigned.length != 0 ? Constants.arrayToStr(selectedAssigned, "", ",") : new String();
            s2 = selectedNotAssigned.length != 0 ? Constants.arrayToStr(selectedNotAssigned, "", ",") : new String();
            Set<Location> rooms = roomFeature.getRooms();
            if (selectedAssigned.length != assignedRooms.size()) {
                m = new HashSet<Location>();
                Iterator iter = rooms.iterator();
                while (iter.hasNext()) {
                    Location r = (Location)iter.next();
                    if (!assignedRooms.contains(r) || s1.indexOf(r.getUniqueId().toString()) != -1) continue;
                    iter.remove();
                    m.add(r);
                }
                for (Location r : m) {
                    features = r.getFeatures();
                    Iterator innerIter = features.iterator();
                    while (innerIter.hasNext()) {
                        RoomFeature innerRf = (RoomFeature)innerIter.next();
                        if (!roomFeature.equals(innerRf)) continue;
                        innerIter.remove();
                    }
                    hibSession.saveOrUpdate((Object)r);
                }
            }
            if (selectedNotAssigned.length != 0) {
                m = new HashSet();
                for (Location r : notAssignedRooms) {
                    if (s2.indexOf(r.getUniqueId().toString()) == -1) continue;
                    rooms.add(r);
                    m.add(r);
                }
                for (Location r : m) {
                    features = r.getFeatures();
                    features.add(roomFeature);
                    hibSession.saveOrUpdate((Object)r);
                }
            }
            hibSession.saveOrUpdate((Object)roomFeature);
            ChangeLog.addChange(hibSession, this.sessionContext, roomFeature, ChangeLog.Source.ROOM_FEATURE_EDIT, ChangeLog.Operation.UPDATE, null, roomFeature instanceof DepartmentRoomFeature ? ((DepartmentRoomFeature)roomFeature).getDepartment() : null);
            tx.commit();
        }
        catch (Exception e) {
            Debug.error(e);
            try {
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
            }
            catch (Exception e1) {
                // empty catch block
            }
            throw e;
        }
    }

    public ActionForward cancelRoomFeature(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        RoomFeatureEditForm roomFeatureEditForm = (RoomFeatureEditForm)form;
        roomFeatureEditForm.setDeptCode((String)this.sessionContext.getAttribute(SessionAttribute.DepartmentCodeRoom));
        if (roomFeatureEditForm.getId() != null) {
            request.setAttribute("hash", (Object)("A" + roomFeatureEditForm.getId()));
        }
        return mapping.findForward("showRoomFeatureList");
    }

    private Collection getAvailableRooms(RoomFeature rf) throws Exception {
        ArrayList<Object> rooms = null;
        if (rf instanceof DepartmentRoomFeature) {
            Department dept = ((DepartmentRoomFeature)rf).getDepartment();
            rooms = new ArrayList<Location>();
            for (RoomDept rd : dept.getRoomDepts()) {
                rooms.add(rd.getRoom());
            }
        } else {
            Session session = ((GlobalRoomFeature)rf).getSession();
            String dept = (String)this.sessionContext.getAttribute(SessionAttribute.DepartmentCodeRoom);
            if (dept != null && dept.matches("Exam[0-9]*")) {
                rooms = new ArrayList(Location.findAllExamLocations(session.getUniqueId(), Long.valueOf(dept.substring(4))));
            } else if (dept != null && !dept.isEmpty() && !"All".equals(dept)) {
                Department department = Department.findByDeptCode(dept, session.getUniqueId());
                if (department != null) {
                    rooms = new ArrayList();
                    for (RoomDept rd : department.getRoomDepts()) {
                        rooms.add(rd.getRoom());
                    }
                } else {
                    rooms = new ArrayList<Location>(Location.findAll(session.getUniqueId()));
                }
            } else {
                rooms = new ArrayList<Location>(Location.findAll(session.getUniqueId()));
            }
        }
        Collections.sort(rooms);
        rooms.removeAll(rf.getRooms());
        return rooms;
    }

    private Collection getAssignedRooms(RoomFeature rf) throws Exception {
        ArrayList<Location> rooms;
        block4: {
            Department department;
            String dept;
            block3: {
                rooms = new ArrayList<Location>(rf.getRooms());
                dept = (String)this.sessionContext.getAttribute(SessionAttribute.DepartmentCodeRoom);
                if (dept == null || !dept.matches("Exam[0-9]*")) break block3;
                Long examType = Long.valueOf(dept.substring(4));
                Iterator i = rooms.iterator();
                while (i.hasNext()) {
                    if (((Location)i.next()).isExamEnabled(examType)) continue;
                    i.remove();
                }
                break block4;
            }
            if (dept == null || dept.isEmpty() || "All".equals(dept) || (department = Department.findByDeptCode(dept, this.sessionContext.getUser().getCurrentAcademicSessionId())) == null) break block4;
            Iterator i = rooms.iterator();
            block1: while (i.hasNext()) {
                Location location = (Location)i.next();
                for (RoomDept rd : location.getRoomDepts()) {
                    if (!rd.getDepartment().equals(department)) continue;
                    continue block1;
                }
                i.remove();
            }
        }
        return rooms;
    }
}

