/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.File;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.cpsolver.coursett.model.TimeLocation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.commons.MultiComparable;
import org.unitime.commons.web.WebTable;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.events.QueryEncoderBackend;
import org.unitime.timetable.form.PersonalizedExamReportForm;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.interfaces.ExternalUidTranslation;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamOwner;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Meeting;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Solution;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.base.BaseDepartmentalInstructor;
import org.unitime.timetable.model.base.BaseStudent;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.model.dao.ExamDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.reports.exam.InstructorExamReport;
import org.unitime.timetable.reports.exam.StudentExamReport;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.exam.ui.ExamAssignment;
import org.unitime.timetable.solver.exam.ui.ExamAssignmentInfo;
import org.unitime.timetable.solver.exam.ui.ExamInfo;
import org.unitime.timetable.util.AccessDeniedException;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.ExportUtils;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.webutil.PdfWebTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="/personalSchedule")
public class PersonalizedExamReportAction
extends Action {
    protected static GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    public static ExternalUidTranslation sTranslation;
    private static Log sLog;
    @Autowired
    SessionContext sessionContext;
    public static String[] DAY_NAMES_SHORT;

    public static String translate(String uid, ExternalUidTranslation.Source target) {
        if (sTranslation == null || uid == null || target.equals((Object)ExternalUidTranslation.Source.User)) {
            return uid;
        }
        return sTranslation.translate(uid, ExternalUidTranslation.Source.User, target);
    }

    public static boolean hasPersonalReport(String userId) {
        if (userId == null) {
            return false;
        }
        HashSet<Session> sessions = new HashSet<Session>();
        BaseDepartmentalInstructor instructor = null;
        for (DepartmentalInstructor s : new DepartmentalInstructorDAO().getSession().createQuery("select i from DepartmentalInstructor i where i.externalUniqueId=:externalId").setString("externalId", userId).setCacheable(true).list()) {
            if (!PersonalizedExamReportAction.canDisplay(s.getDepartment().getSession())) continue;
            sessions.add(s.getDepartment().getSession());
            if (instructor != null && instructor.getDepartment().getSession().compareTo(s.getDepartment().getSession()) >= 0) continue;
            instructor = s;
        }
        BaseStudent student = null;
        for (Student s : new StudentDAO().getSession().createQuery("select s from Student s where s.externalUniqueId=:externalId").setString("externalId", userId).setCacheable(true).list()) {
            if (!PersonalizedExamReportAction.canDisplay(s.getSession())) continue;
            sessions.add(s.getSession());
            if (student != null && student.getSession().compareTo(s.getSession()) >= 0) continue;
            student = s;
        }
        return instructor != null || student != null;
    }

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Object table;
        TreeSet<ExamAssignmentInfo> exams;
        PdfWebTable table2;
        String[] params;
        PersonalizedExamReportForm myForm = (PersonalizedExamReportForm)form;
        String back = (String)request.getSession().getAttribute("loginPage");
        if (back == null) {
            back = "back";
        }
        try {
            this.sessionContext.checkPermission(Right.PersonalSchedule);
        }
        catch (AccessDeniedException e) {
            request.setAttribute("message", (Object)e.getMessage());
            return mapping.findForward(back);
        }
        if (request.getParameter("q") != null && (params = QueryEncoderBackend.decode(request.getParameter("q")).split(":")) != null && params.length == 2) {
            myForm.setUid(params[0]);
            myForm.setSessionId(Long.valueOf(params[1]));
        }
        String externalId = this.sessionContext.getUser().getExternalUserId();
        String userName = this.sessionContext.getUser().getName();
        myForm.setAdmin(this.sessionContext.hasPermission(Right.PersonalScheduleLookup));
        myForm.setLogout(!"back".equals(back));
        if (this.sessionContext.hasPermission(Right.PersonalScheduleLookup) && myForm.getUid() != null && !myForm.getUid().isEmpty()) {
            externalId = myForm.getUid();
            userName = (myForm.getLname() == null || myForm.getLname().length() == 0 ? "" : " " + Constants.toInitialCase(myForm.getLname())) + (myForm.getFname() == null || myForm.getFname().length() == 0 ? "" : " " + myForm.getFname().substring(0, 1).toUpperCase()) + (myForm.getMname() == null || myForm.getMname().length() == 0 ? "" : " " + myForm.getMname().substring(0, 1).toUpperCase());
        }
        if (externalId == null || externalId.length() == 0) {
            request.setAttribute("message", (Object)"No user id provided.");
            return mapping.findForward(back);
        }
        if ("Log Out".equals(myForm.getOp())) {
            SecurityContextHolder.getContext().setAuthentication(null);
            return mapping.findForward(back);
        }
        if ("classes".equals(back)) {
            if (myForm.getSessionId() == null) {
                myForm.setSessionId((Long)request.getSession().getAttribute("Classes.session"));
            } else {
                request.getSession().setAttribute("Classes.session", (Object)myForm.getSessionId());
            }
        } else if ("exams".equals(back)) {
            if (myForm.getSessionId() == null) {
                myForm.setSessionId((Long)request.getSession().getAttribute("Exams.session"));
            } else {
                request.getSession().setAttribute("Exams.session", (Object)myForm.getSessionId());
            }
        }
        HashSet<Session> sessions = new HashSet<Session>();
        BaseDepartmentalInstructor instructor = null;
        for (DepartmentalInstructor s : new DepartmentalInstructorDAO().getSession().createQuery("select i from DepartmentalInstructor i where i.externalUniqueId=:externalId").setString("externalId", PersonalizedExamReportAction.translate(externalId, ExternalUidTranslation.Source.Staff)).setCacheable(true).list()) {
            if (!PersonalizedExamReportAction.canDisplay(s.getDepartment().getSession())) continue;
            sessions.add(s.getDepartment().getSession());
            if (myForm.getSessionId() == null) {
                if (instructor != null && instructor.getDepartment().getSession().compareTo(s.getDepartment().getSession()) >= 0) continue;
                instructor = s;
                continue;
            }
            if (!myForm.getSessionId().equals(s.getDepartment().getSession().getUniqueId())) continue;
            instructor = s;
        }
        BaseStudent student = null;
        for (Student s : new StudentDAO().getSession().createQuery("select s from Student s where s.externalUniqueId=:externalId").setString("externalId", PersonalizedExamReportAction.translate(externalId, ExternalUidTranslation.Source.Student)).setCacheable(true).list()) {
            if (!PersonalizedExamReportAction.canDisplay(s.getSession())) continue;
            sessions.add(s.getSession());
            if (myForm.getSessionId() == null) {
                if (student != null && student.getSession().compareTo(s.getSession()) >= 0) continue;
                student = s;
                continue;
            }
            if (!myForm.getSessionId().equals(s.getSession().getUniqueId())) continue;
            student = s;
        }
        if (instructor == null && student == null) {
            if (myForm.getAdmin()) {
                back = "back";
                myForm.setLogout(false);
            } else {
                if ("classes".equals(back)) {
                    request.setAttribute("message", (Object)"No classes found.");
                } else if ("exams".equals(back)) {
                    request.setAttribute("message", (Object)"No examinations found.");
                } else {
                    request.setAttribute("message", (Object)"No schedule found.");
                }
                sLog.info((Object)("No matching instructor or student found for " + userName + " (" + PersonalizedExamReportAction.translate(externalId, ExternalUidTranslation.Source.Student) + "), forwarding back (" + back + ")."));
                return mapping.findForward(back);
            }
        }
        myForm.setCanExport(false);
        if (instructor != null && student != null && !instructor.getDepartment().getSession().equals(student.getSession())) {
            if (instructor.getDepartment().getSession().compareTo(student.getSession()) < 0) {
                instructor = null;
            } else {
                student = null;
            }
        }
        long t0 = System.currentTimeMillis();
        if (instructor != null) {
            sLog.info((Object)("Requesting schedule for " + ((DepartmentalInstructor)instructor).getName(DepartmentalInstructor.sNameFormatShort) + " (instructor)"));
        } else if (student != null) {
            sLog.info((Object)("Requesting schedule for " + ((Student)student).getName(DepartmentalInstructor.sNameFormatShort) + " (student)"));
        }
        HashSet<ExamOwner> studentExams = new HashSet<ExamOwner>();
        if (student != null) {
            Iterator i;
            studentExams.addAll(new ExamDAO().getSession().createQuery("select distinct o from Student s inner join s.classEnrollments ce, ExamOwner o inner join o.course co inner join co.instructionalOffering io inner join io.instrOfferingConfigs ioc inner join ioc.schedulingSubparts ss inner join ss.classes c where s.uniqueId=:studentId and c=ce.clazz and ((o.ownerType=1 and o.ownerId=co.uniqueId) or (o.ownerType=0 and o.ownerId=io.uniqueId) or (o.ownerType=2 and o.ownerId=ioc.uniqueId) or (o.ownerType=3 and o.ownerId=c.uniqueId) )").setLong("studentId", student.getUniqueId().longValue()).setCacheable(true).list());
            if (!student.getSession().getStatusType().canNoRoleReportExamFinal()) {
                i = studentExams.iterator();
                while (i.hasNext()) {
                    if (((ExamOwner)i.next()).getExam().getExamType().getType() != 0) continue;
                    i.remove();
                }
            }
            if (!student.getSession().getStatusType().canNoRoleReportExamMidterm()) {
                i = studentExams.iterator();
                while (i.hasNext()) {
                    if (((ExamOwner)i.next()).getExam().getExamType().getType() != 1) continue;
                    i.remove();
                }
            }
        }
        HashSet<Exam> instructorExams = new HashSet<Exam>();
        if (instructor != null) {
            if (instructor.getDepartment().getSession().getStatusType().canNoRoleReportExamMidterm()) {
                instructorExams.addAll(((DepartmentalInstructor)instructor).getExams(1));
            }
            if (instructor.getDepartment().getSession().getStatusType().canNoRoleReportExamFinal()) {
                instructorExams.addAll(((DepartmentalInstructor)instructor).getExams(0));
            }
        }
        WebTable.setOrder(this.sessionContext, "exams.o0", request.getParameter("o0"), 1);
        WebTable.setOrder(this.sessionContext, "exams.o1", request.getParameter("o1"), 1);
        WebTable.setOrder(this.sessionContext, "exams.o2", request.getParameter("o2"), 1);
        WebTable.setOrder(this.sessionContext, "exams.o3", request.getParameter("o3"), 1);
        WebTable.setOrder(this.sessionContext, "exams.o4", request.getParameter("o4"), 1);
        WebTable.setOrder(this.sessionContext, "exams.o5", request.getParameter("o5"), 1);
        WebTable.setOrder(this.sessionContext, "exams.o6", request.getParameter("o6"), 1);
        WebTable.setOrder(this.sessionContext, "exams.o7", request.getParameter("o7"), 1);
        boolean hasClasses = false;
        if (student != null && student.getSession().getStatusType().canNoRoleReportClass() && !student.getClassEnrollments().isEmpty() && !(table2 = this.getStudentClassSchedule(true, (Student)student)).getLines().isEmpty()) {
            request.setAttribute("clsschd", (Object)table2.printTable(WebTable.getOrder(this.sessionContext, "exams.o6")));
            hasClasses = true;
            myForm.setCanExport(true);
        }
        if (instructor != null && instructor.getDepartment().getSession().getStatusType().canNoRoleReportClass() && !(table2 = this.getInstructorClassSchedule(true, (DepartmentalInstructor)instructor)).getLines().isEmpty()) {
            request.setAttribute("iclsschd", (Object)table2.printTable(Math.abs(WebTable.getOrder(this.sessionContext, "exams.o7"))));
            hasClasses = true;
            myForm.setCanExport(true);
        }
        if (instructor != null && sessions.size() > 1) {
            table2 = this.getSessions(true, sessions, ((DepartmentalInstructor)instructor).getName(DepartmentalInstructor.sNameFormatLastFist), instructor.getDepartment().getSession().getUniqueId());
            request.setAttribute("sessions", (Object)table2.printTable(WebTable.getOrder(this.sessionContext, "exams.o0")));
        } else if (student != null && sessions.size() > 1) {
            table2 = this.getSessions(true, sessions, ((Student)student).getName(DepartmentalInstructor.sNameFormatLastFist), student.getSession().getUniqueId());
            request.setAttribute("sessions", (Object)table2.printTable(WebTable.getOrder(this.sessionContext, "exams.o0")));
        }
        if (!hasClasses && instructorExams.isEmpty() && studentExams.isEmpty()) {
            if ("classes".equals(back)) {
                myForm.setMessage("No classes found in " + (instructor != null ? instructor.getDepartment().getSession() : student.getSession()).getLabel() + ".");
            } else if ("exams".equals(back)) {
                myForm.setMessage("No examinations found in " + (instructor != null ? instructor.getDepartment().getSession() : student.getSession()).getLabel() + ".");
            } else if (student != null || instructor != null) {
                myForm.setMessage("No classes or examinations found in " + (instructor != null ? instructor.getDepartment().getSession() : student.getSession()).getLabel() + ".");
            } else if (this.sessionContext.hasPermission(Right.PersonalScheduleLookup)) {
                myForm.setMessage("No classes or examinations found in " + ((Session)SessionDAO.getInstance().get(this.sessionContext.getUser().getCurrentAcademicSessionId())).getLabel() + ".");
            } else {
                myForm.setMessage("No classes or examinations found for " + userName + ".");
            }
            sLog.info((Object)("No classes or exams found for " + (instructor != null ? ((DepartmentalInstructor)instructor).getName(DepartmentalInstructor.sNameFormatShort) : (student != null ? ((Student)student).getName(DepartmentalInstructor.sNameFormatShort) : userName))));
        }
        boolean useCache = ApplicationProperty.ExaminationCacheConflicts.isTrue();
        if ("Export PDF".equals(myForm.getOp())) {
            sLog.info((Object)("  Generating PDF for " + (instructor != null ? ((DepartmentalInstructor)instructor).getName(DepartmentalInstructor.sNameFormatShort) : ((Student)student).getName(DepartmentalInstructor.sNameFormatShort))));
            OutputStream out = ExportUtils.getPdfOutputStream(response, "schedule");
            if (!instructorExams.isEmpty()) {
                TreeSet<ExamAssignmentInfo> exams2 = new TreeSet<ExamAssignmentInfo>();
                for (Exam exam : instructorExams) {
                    if (exam.getAssignedPeriod() == null) continue;
                    exams2.add(new ExamAssignmentInfo(exam, useCache));
                }
                InstructorExamReport ir = new InstructorExamReport(0, out, instructor.getDepartment().getSession(), null, null, exams2);
                ir.setM2d(true);
                ir.setDirect(true);
                ir.setClassSchedule(instructor.getDepartment().getSession().getStatusType().canNoRoleReportClass());
                ir.printHeader();
                ir.printReport(ExamInfo.createInstructorInfo((DepartmentalInstructor)instructor), exams2);
                ir.lastPage();
                ir.close();
            } else if (!studentExams.isEmpty()) {
                TreeSet<ExamAssignmentInfo> exams3 = new TreeSet<ExamAssignmentInfo>();
                TreeSet<ExamInfo.ExamSectionInfo> sections = new TreeSet<ExamInfo.ExamSectionInfo>();
                for (ExamOwner examOwner : studentExams) {
                    if (examOwner.getExam().getAssignedPeriod() == null) continue;
                    ExamAssignmentInfo x = new ExamAssignmentInfo(examOwner, (Student)student, studentExams);
                    exams3.add(x);
                    sections.addAll(x.getSectionsIncludeCrosslistedDummies());
                }
                StudentExamReport sr = new StudentExamReport(0, out, student.getSession(), null, null, exams3);
                sr.setM2d(true);
                sr.setBtb(true);
                sr.setDirect(true);
                sr.setClassSchedule(student.getSession().getStatusType().canNoRoleReportClass());
                sr.printHeader();
                sr.printReport((Student)student, sections);
                sr.lastPage();
                sr.close();
            } else if (hasClasses) {
                if (instructor != null) {
                    InstructorExamReport ir = new InstructorExamReport(0, out, instructor.getDepartment().getSession(), null, null, new TreeSet<ExamAssignmentInfo>());
                    ir.setM2d(true);
                    ir.setDirect(true);
                    ir.setClassSchedule(instructor.getDepartment().getSession().getStatusType().canNoRoleReportClass());
                    ir.printHeader();
                    ir.printReport(ExamInfo.createInstructorInfo((DepartmentalInstructor)instructor), new TreeSet<ExamAssignmentInfo>());
                    ir.lastPage();
                    ir.close();
                } else if (student != null) {
                    StudentExamReport sr = new StudentExamReport(0, out, student.getSession(), null, null, new TreeSet<ExamAssignmentInfo>());
                    sr.setM2d(true);
                    sr.setBtb(true);
                    sr.setDirect(true);
                    sr.setClassSchedule(student.getSession().getStatusType().canNoRoleReportClass());
                    sr.printHeader();
                    sr.printReport((Student)student, new TreeSet<ExamInfo.ExamSectionInfo>());
                    sr.lastPage();
                    sr.close();
                }
            }
            out.flush();
            out.close();
            return null;
        }
        if ("iCalendar".equals(myForm.getOp())) {
            Long sid = instructor != null ? instructor.getDepartment().getSession().getUniqueId() : student.getSession().getUniqueId();
            response.sendRedirect(response.encodeURL("export?q=" + QueryEncoderBackend.encode("output=events.ics&type=person&ext=" + externalId + (sid == null ? "" : "&sid=" + sid))));
            return null;
        }
        if (!studentExams.isEmpty()) {
            myForm.setCanExport(true);
            exams = new TreeSet<ExamAssignmentInfo>();
            for (ExamOwner examOwner : studentExams) {
                exams.add(new ExamAssignmentInfo(examOwner, (Student)student, studentExams));
            }
            table = this.getStudentExamSchedule(true, exams, (Student)student);
            request.setAttribute("schedule", (Object)((WebTable)table).printTable(WebTable.getOrder(this.sessionContext, "exams.o1")));
            table = this.getStudentConflits(true, exams, (Student)student);
            if (!((WebTable)table).getLines().isEmpty()) {
                request.setAttribute("conf", (Object)((WebTable)table).printTable(WebTable.getOrder(this.sessionContext, "exams.o3")));
            }
        }
        if (!instructorExams.isEmpty()) {
            myForm.setCanExport(true);
            exams = new TreeSet();
            for (Exam exam : instructorExams) {
                exams.add(new ExamAssignmentInfo(exam, useCache));
            }
            table = this.getInstructorExamSchedule(true, exams, (DepartmentalInstructor)instructor);
            request.setAttribute("ischedule", (Object)((WebTable)table).printTable(WebTable.getOrder(this.sessionContext, "exams.o2")));
            table = this.getInstructorConflits(true, exams, (DepartmentalInstructor)instructor);
            if (!((WebTable)table).getLines().isEmpty()) {
                request.setAttribute("iconf", (Object)((WebTable)table).printTable(WebTable.getOrder(this.sessionContext, "exams.o4")));
            }
            if (!((WebTable)(table = this.getStudentConflits(true, exams, (DepartmentalInstructor)instructor))).getLines().isEmpty()) {
                request.setAttribute("sconf", (Object)((WebTable)table).printTable(WebTable.getOrder(this.sessionContext, "exams.o5")));
            }
        }
        long t1 = System.currentTimeMillis();
        sLog.info((Object)("Request processed in " + new DecimalFormat("0.00").format((double)(t1 - t0) / 1000.0) + " s for " + (instructor != null ? ((DepartmentalInstructor)instructor).getName(DepartmentalInstructor.sNameFormatShort) : (student != null ? ((Student)student).getName(DepartmentalInstructor.sNameFormatShort) : userName))));
        return mapping.findForward("show");
    }

    public static boolean canDisplay(Session session) {
        if (session.getStatusType() == null) {
            return false;
        }
        if (session.getStatusType().canNoRoleReportExamFinal() && Exam.hasTimetable(session.getUniqueId(), 0)) {
            return true;
        }
        if (session.getStatusType().canNoRoleReportExamMidterm() && Exam.hasTimetable(session.getUniqueId(), 1)) {
            return true;
        }
        return session.getStatusType().canNoRoleReportClass() && Solution.hasTimetable(session.getUniqueId());
    }

    public int getDaysCode(Set meetings) {
        int daysCode = 0;
        for (Meeting meeting : meetings) {
            Calendar date = Calendar.getInstance(Locale.US);
            date.setTime(meeting.getMeetingDate());
            switch (date.get(7)) {
                case 2: {
                    daysCode |= Constants.DAY_CODES[0];
                    break;
                }
                case 3: {
                    daysCode |= Constants.DAY_CODES[1];
                    break;
                }
                case 4: {
                    daysCode |= Constants.DAY_CODES[2];
                    break;
                }
                case 5: {
                    daysCode |= Constants.DAY_CODES[3];
                    break;
                }
                case 6: {
                    daysCode |= Constants.DAY_CODES[4];
                    break;
                }
                case 7: {
                    daysCode |= Constants.DAY_CODES[5];
                    break;
                }
                case 1: {
                    daysCode |= Constants.DAY_CODES[6];
                }
            }
        }
        return daysCode;
    }

    protected long getMeetingComparable(ExamInfo.ExamSectionInfo section) {
        if (section.getOwner().getOwnerObject() instanceof Class_) {
            TreeSet<Meeting> meetings;
            Class_ clazz = (Class_)section.getOwner().getOwnerObject();
            Assignment assignment = clazz.getCommittedAssignment();
            TreeSet<Meeting> treeSet = meetings = clazz.getEvent() == null ? null : new TreeSet<Meeting>(clazz.getEvent().getMeetings());
            if (meetings != null && !meetings.isEmpty()) {
                return meetings.first().getMeetingDate().getTime();
            }
            if (assignment != null) {
                return assignment.getTimeLocation().getStartSlot();
            }
        }
        return -1L;
    }

    protected String getMeetingTime(ExamInfo.ExamSectionInfo section) {
        String meetingTime = "";
        if (section.getOwner().getOwnerObject() instanceof Class_) {
            DatePattern dp;
            TreeSet<Meeting> meetings;
            Formats.Format<Date> dpf = Formats.getDateFormat(Formats.Pattern.DATE_EVENT_SHORT);
            Class_ clazz = (Class_)section.getOwner().getOwnerObject();
            Assignment assignment = clazz.getCommittedAssignment();
            TreeSet<Meeting> treeSet = meetings = clazz.getEvent() == null ? null : new TreeSet<Meeting>(clazz.getEvent().getMeetings());
            if (meetings != null && !meetings.isEmpty()) {
                Date first = meetings.first().getMeetingDate();
                Date last = meetings.last().getMeetingDate();
                meetingTime = meetingTime + dpf.format(first) + " - " + dpf.format(last);
            } else if (assignment != null && assignment.getDatePattern() != null && (dp = assignment.getDatePattern()) != null && !dp.isDefault()) {
                meetingTime = dp.getType() == 1 ? meetingTime + dp.getName() : meetingTime + dpf.format(dp.getStartDate()) + " - " + dpf.format(dp.getEndDate());
            }
            if (meetings != null && !meetings.isEmpty()) {
                int dayCode = this.getDaysCode(meetings);
                String days = "";
                for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
                    if ((dayCode & Constants.DAY_CODES[i]) == 0) continue;
                    days = days + Constants.DAY_NAMES_SHORT[i];
                }
                meetingTime = meetingTime + " " + days;
                Meeting first = meetings.first();
                meetingTime = meetingTime + " " + first.startTime() + " - " + first.stopTime();
            } else if (assignment != null) {
                TimeLocation t = assignment.getTimeLocation();
                meetingTime = meetingTime + " " + t.getDayHeader() + " " + t.getStartTimeHeader(CONSTANTS.useAmPm()) + " - " + t.getEndTimeHeader(CONSTANTS.useAmPm());
            }
        }
        return meetingTime;
    }

    public PdfWebTable getSessions(boolean html, HashSet<Session> sessions, String name, Long sessionId) {
        PdfWebTable table = new PdfWebTable(5, "Available Academic Sessions for " + name, "personalSchedule.do?o0=%%" + (sessionId == null ? "" : "&sessionId=" + sessionId), new String[]{"Term", "Year", "Campus"}, new String[]{"left", "left", "left"}, new boolean[]{true, true, true});
        table.setRowStyle("white-space:nowrap");
        for (Session session : sessions) {
            String bgColor = null;
            if (sessionId.equals(session.getUniqueId())) {
                bgColor = "rgb(168,187,225)";
            }
            table.addLine("onClick=\"personalizedExamReportForm.sessionId.value='" + session.getUniqueId() + "'; personalizedExamReportForm.submit();\"", new String[]{session.getAcademicTerm(), session.getAcademicYear(), session.getAcademicInitiative()}, new Comparable[]{new MultiComparable(session.getSessionBeginDateTime(), (Comparable)((Object)session.getAcademicInitiative())), new MultiComparable(session.getSessionBeginDateTime(), (Comparable)((Object)session.getAcademicInitiative())), new MultiComparable((Comparable)((Object)session.getAcademicInitiative()), session.getSessionBeginDateTime())}).setBgColor(bgColor);
        }
        return table;
    }

    public PdfWebTable getStudentExamSchedule(boolean html, TreeSet<ExamAssignmentInfo> exams, Student student) {
        PdfWebTable table = new PdfWebTable(5, student.getSession().getLabel() + " Examination Schedule for " + student.getName(DepartmentalInstructor.sNameFormatLastFist), "personalSchedule.do?o1=%%&q=" + QueryEncoderBackend.encode(student.getExternalUniqueId() + ":" + student.getSession().getUniqueId()), new String[]{"Class / Course", "Meeting Time", "Date", "Time", "Room"}, new String[]{"left", "left", "left", "left", "left"}, new boolean[]{true, true, true, true, true});
        table.setRowStyle("white-space:nowrap");
        String noRoom = ApplicationProperty.ExaminationsNoRoomText.value();
        for (ExamAssignmentInfo exam : exams) {
            if (exam.getPeriod() == null) continue;
            for (ExamInfo.ExamSectionInfo section : exam.getSectionsIncludeCrosslistedDummies()) {
                if (!section.getStudentIds().contains(student.getUniqueId())) continue;
                String sectionName = section.getName();
                table.addLine(new String[]{sectionName, this.getMeetingTime(section), exam.getDate(false), exam.getTime(false), exam.getNrRooms() == 0 ? noRoom : (html ? exam.getRoomsNameWithHint(false, ", ") : exam.getRoomsName(false, ", "))}, new Comparable[]{new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), (Comparable)((Object)sectionName), exam), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), Long.valueOf(this.getMeetingComparable(section)), (Comparable)((Object)sectionName), exam), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), exam.getPeriodOrd(), (Comparable)((Object)sectionName), exam), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), Integer.valueOf(exam.getPeriod() == null ? -1 : exam.getPeriod().getStartSlot()), (Comparable)((Object)sectionName), exam), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), (Comparable)((Object)exam.getRoomsName(":")), (Comparable)((Object)sectionName), exam)});
            }
        }
        table.setWebTableTweakStyle(new WebTable.WebTableTweakStyle(){

            public String getStyleHtml(WebTable.WebTableLine current, WebTable.WebTableLine next, int order) {
                if (next != null && ((MultiComparable)current.getOrderBy()[0]).getContent()[0].compareTo(((MultiComparable)next.getOrderBy()[0]).getContent()[0]) != 0) {
                    return "border-bottom: rgb(81,81,81) 1px dashed";
                }
                return null;
            }
        });
        return table;
    }

    public PdfWebTable getStudentConflits(boolean html, TreeSet<ExamAssignmentInfo> exams, Student student) {
        String nl = html ? "<br>" : "\n";
        boolean showBackToBack = ApplicationProperty.ExaminationReportsStudentBackToBacks.isTrue();
        PdfWebTable table = new PdfWebTable(6, student.getSession().getLabel() + " Examination Conflicts" + (showBackToBack ? " and/or Back-To-Back Examinations" : "") + " for " + student.getName(DepartmentalInstructor.sNameFormatLastFist), "personalSchedule.do?o3=%%&q=" + QueryEncoderBackend.encode(student.getExternalUniqueId() + ":" + student.getSession().getUniqueId()), new String[]{"Type", "Class / Course", "Date", "Time", "Room", "Distance"}, new String[]{"left", "left", "left", "left", "left", "left"}, new boolean[]{true, true, true, true, true, true});
        table.setRowStyle("white-space:nowrap");
        String noRoom = ApplicationProperty.ExaminationsNoRoomText.value();
        for (ExamAssignmentInfo exam : exams) {
            boolean firstSection;
            String room;
            String time;
            String date;
            Object classes;
            for (ExamAssignmentInfo.DirectConflict directConflict : exam.getDirectConflicts()) {
                if (directConflict.getOtherExam() != null && exam.compareTo(directConflict.getOtherExam()) >= 0 && exams.contains(directConflict.getOtherExam()) || !directConflict.getStudents().contains(student.getUniqueId())) continue;
                classes = "";
                date = "";
                time = "";
                room = "";
                firstSection = true;
                for (ExamInfo.ExamSectionInfo section : exam.getSectionsIncludeCrosslistedDummies()) {
                    if (!section.getStudentIds().contains(student.getUniqueId())) continue;
                    if (((String)classes).length() > 0) {
                        classes = (String)classes + nl;
                        date = date + nl;
                        time = time + nl;
                        room = room + nl;
                    }
                    classes = (String)classes + section.getName();
                    if (firstSection) {
                        date = date + exam.getDate(false);
                        time = time + exam.getTime(false);
                        room = room + (exam.getNrRooms() == 0 ? noRoom : (html ? exam.getRoomsNameWithHint(false, ", ") : exam.getRoomsName(false, ", ")));
                    }
                    firstSection = false;
                }
                firstSection = true;
                if (directConflict.getOtherExam() != null) {
                    for (ExamInfo.ExamSectionInfo section : directConflict.getOtherExam().getSectionsIncludeCrosslistedDummies()) {
                        if (!section.getStudentIds().contains(student.getUniqueId())) continue;
                        if (((String)classes).length() > 0) {
                            classes = (String)classes + nl;
                            date = date + nl;
                            time = time + nl;
                            room = room + nl;
                        }
                        classes = (String)classes + section.getName();
                        if (firstSection) {
                            room = room + (directConflict.getOtherExam().getNrRooms() == 0 ? noRoom : directConflict.getOtherExam().getRoomsName(false, ", "));
                        }
                        firstSection = false;
                    }
                } else if (directConflict.getOtherEventId() != null) {
                    classes = (String)classes + nl;
                    date = date + nl;
                    time = time + nl;
                    room = room + nl;
                    classes = (String)classes + directConflict.getOtherEventName();
                    room = room + directConflict.getOtherEventRoom();
                    time = time + directConflict.getOtherEventTime();
                }
                String[] stringArray = new String[6];
                stringArray[0] = (html ? "<font color='" + PreferenceLevel.prolog2color("P") + "'>" : "") + (directConflict.getOtherEventId() != null ? (directConflict.isOtherClass() ? "Class" : "Event") : "Direct") + (html ? "</font>" : "");
                stringArray[1] = classes;
                stringArray[2] = date;
                stringArray[3] = time;
                stringArray[4] = room;
                stringArray[5] = "";
                table.addLine(stringArray, new Comparable[]{new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), Integer.valueOf(0), exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), exam, exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), exam.getPeriodOrd(), exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), exam.getPeriod().getStartSlot(), exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), (Comparable)((Object)exam.getRoomsName(":")), exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), Double.valueOf(-1.0), exam, Integer.valueOf(0))});
            }
            if (showBackToBack) {
                for (ExamAssignmentInfo.BackToBackConflict backToBackConflict : exam.getBackToBackConflicts()) {
                    if (exam.compareTo(backToBackConflict.getOtherExam()) >= 0 && exams.contains(backToBackConflict.getOtherExam()) || !backToBackConflict.getStudents().contains(student.getUniqueId())) continue;
                    classes = "";
                    date = "";
                    time = "";
                    room = "";
                    firstSection = true;
                    for (ExamInfo.ExamSectionInfo section : exam.getSectionsIncludeCrosslistedDummies()) {
                        if (!section.getStudentIds().contains(student.getUniqueId())) continue;
                        if (((String)classes).length() > 0) {
                            classes = (String)classes + nl;
                            date = date + nl;
                            time = time + nl;
                            room = room + nl;
                        }
                        classes = (String)classes + section.getName();
                        if (firstSection) {
                            date = date + exam.getDate(false);
                            time = time + exam.getTime(false);
                            room = room + (exam.getNrRooms() == 0 ? noRoom : exam.getRoomsName(false, ", "));
                        }
                        firstSection = false;
                    }
                    firstSection = true;
                    for (ExamInfo.ExamSectionInfo section : backToBackConflict.getOtherExam().getSectionsIncludeCrosslistedDummies()) {
                        if (!section.getStudentIds().contains(student.getUniqueId())) continue;
                        if (((String)classes).length() > 0) {
                            classes = (String)classes + nl;
                            date = date + nl;
                            time = time + nl;
                            room = room + nl;
                        }
                        classes = (String)classes + section.getName();
                        if (firstSection) {
                            time = time + backToBackConflict.getOtherExam().getTime(false);
                            room = room + (backToBackConflict.getOtherExam().getNrRooms() == 0 ? noRoom : backToBackConflict.getOtherExam().getRoomsName(false, ", "));
                        }
                        firstSection = false;
                    }
                    table.addLine(new String[]{(html ? "<font color='" + PreferenceLevel.prolog2color("1") + "'>" : "") + "Back-To-Back" + (html ? "</font>" : ""), classes, date, time, room, (int)(backToBackConflict.getDistance() * 10.0) + " m"}, new Comparable[]{new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), Integer.valueOf(2), exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), exam, exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), exam.getPeriodOrd(), exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), exam.getPeriod().getStartSlot(), exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), (Comparable)((Object)exam.getRoomsName(":")), exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), Double.valueOf(backToBackConflict.getDistance()), exam, Integer.valueOf(0))});
                }
            }
            block7: for (ExamAssignmentInfo.MoreThanTwoADayConflict moreThanTwoADayConflict : exam.getMoreThanTwoADaysConflicts()) {
                for (ExamAssignment other : moreThanTwoADayConflict.getOtherExams()) {
                    if (exam.compareTo(other) < 0 || !exams.contains(other)) continue;
                    continue block7;
                }
                if (!moreThanTwoADayConflict.getStudents().contains(student.getUniqueId())) continue;
                classes = "";
                date = "";
                time = "";
                room = "";
                firstSection = true;
                for (ExamInfo.ExamSectionInfo section : exam.getSectionsIncludeCrosslistedDummies()) {
                    if (!section.getStudentIds().contains(student.getUniqueId())) continue;
                    if (((String)classes).length() > 0) {
                        classes = (String)classes + nl;
                        date = date + nl;
                        time = time + nl;
                        room = room + nl;
                    }
                    classes = (String)classes + section.getName();
                    if (firstSection) {
                        date = date + exam.getDate(false);
                        time = time + exam.getTime(false);
                        room = room + (exam.getNrRooms() == 0 ? noRoom : exam.getRoomsName(false, ", "));
                    }
                    firstSection = false;
                }
                for (ExamAssignment other : moreThanTwoADayConflict.getOtherExams()) {
                    firstSection = true;
                    for (ExamInfo.ExamSectionInfo section : other.getSectionsIncludeCrosslistedDummies()) {
                        if (!section.getStudentIds().contains(student.getUniqueId())) continue;
                        if (((String)classes).length() > 0) {
                            classes = (String)classes + nl;
                            date = date + nl;
                            time = time + nl;
                            room = room + nl;
                        }
                        classes = (String)classes + section.getName();
                        if (firstSection) {
                            time = time + other.getTime(false);
                            room = room + (other.getNrRooms() == 0 ? noRoom : other.getRoomsName(false, ", "));
                        }
                        firstSection = false;
                    }
                }
                table.addLine(this.sessionContext.hasPermission(exam, Right.ExaminationDetail) ? "onClick=\"document.location='examDetail.do?examId=" + exam.getExamId() + "';\"" : "", new String[]{(html ? "<font color='" + PreferenceLevel.prolog2color("2") + "'>" : "") + (html ? "&gt;" : "") + "2 A Day" + (html ? "</font>" : ""), classes, date, time, room, ""}, new Comparable[]{new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), Integer.valueOf(1), exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), exam, exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), exam.getPeriodOrd(), exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), exam.getPeriod().getStartSlot(), exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), (Comparable)((Object)exam.getRoomsName(":")), exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), Double.valueOf(-1.0), exam, Integer.valueOf(0))}, exam.getExamId().toString());
            }
        }
        table.setWebTableTweakStyle(new WebTable.WebTableTweakStyle(){

            public String getStyleHtml(WebTable.WebTableLine current, WebTable.WebTableLine next, int order) {
                if (next != null && ((MultiComparable)current.getOrderBy()[0]).getContent()[0].compareTo(((MultiComparable)next.getOrderBy()[0]).getContent()[0]) != 0) {
                    return "border-bottom: rgb(81,81,81) 1px dashed";
                }
                return null;
            }
        });
        return table;
    }

    public PdfWebTable getInstructorExamSchedule(boolean html, TreeSet<ExamAssignmentInfo> exams, DepartmentalInstructor instructor) {
        String nl = html ? "<br>" : "\n";
        PdfWebTable table = new PdfWebTable(8, instructor.getDepartment().getSession().getLabel() + " Examination Instructor Schedule for " + instructor.getName(DepartmentalInstructor.sNameFormatLastFist), "personalSchedule.do?o2=%%&q=" + QueryEncoderBackend.encode(instructor.getExternalUniqueId() + ":" + instructor.getDepartment().getSession().getUniqueId()), new String[]{"Class / Course", "Enrollment", "Seating" + nl + "Type", "Meeting Times", "Date", "Time", "Room", "Capacity"}, new String[]{"left", "right", "center", "left", "left", "left", "left", "right"}, new boolean[]{true, true, true, true, true, true, true, true});
        table.setRowStyle("white-space:nowrap");
        String noRoom = ApplicationProperty.ExaminationsNoRoomText.value();
        for (ExamAssignmentInfo exam : exams) {
            if (exam.getPeriod() == null) continue;
            for (ExamInfo.ExamSectionInfo section : exam.getSectionsIncludeCrosslistedDummies()) {
                table.addLine(new String[]{section.getName(), String.valueOf(section.getNrStudents()), Exam.sSeatingTypes[exam.getSeatingType()], this.getMeetingTime(section), exam.getDate(false), exam.getTime(false), exam.getNrRooms() == 0 ? noRoom : exam.getRoomsName(false, ", "), exam.getRoomsCapacity(false, ", ")}, new Comparable[]{new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), (Comparable)((Object)section.getName()), exam), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), Integer.valueOf(-exam.getNrStudents()), (Comparable)((Object)section.getName()), exam), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), Integer.valueOf(exam.getSeatingType()), (Comparable)((Object)section.getName()), exam), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), Long.valueOf(this.getMeetingComparable(section)), (Comparable)((Object)section.getName()), exam), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), exam.getPeriodOrd(), (Comparable)((Object)section.getName()), exam), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), Integer.valueOf(exam.getPeriod() == null ? -1 : exam.getPeriod().getStartSlot()), (Comparable)((Object)section.getName()), exam), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), (Comparable)((Object)exam.getRoomsName(":")), (Comparable)((Object)section.getName()), exam), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), Integer.valueOf(-exam.getRoomsCapacity()), (Comparable)((Object)section.getName()), exam)});
            }
        }
        table.setWebTableTweakStyle(new WebTable.WebTableTweakStyle(){

            public String getStyleHtml(WebTable.WebTableLine current, WebTable.WebTableLine next, int order) {
                if (next != null && ((MultiComparable)current.getOrderBy()[0]).getContent()[0].compareTo(((MultiComparable)next.getOrderBy()[0]).getContent()[0]) != 0) {
                    return "border-bottom: rgb(81,81,81) 1px dashed";
                }
                return null;
            }
        });
        return table;
    }

    public PdfWebTable getInstructorConflits(boolean html, TreeSet<ExamAssignmentInfo> exams, DepartmentalInstructor instructor) {
        String nl = html ? "<br>" : "\n";
        boolean showBackToBack = ApplicationProperty.ExaminationReportsInstructorBackToBacks.isTrue();
        PdfWebTable table = new PdfWebTable(8, instructor.getDepartment().getSession().getLabel() + " Examination Instructor Conflicts" + (showBackToBack ? " and/or Back-To-Back Examinations" : "") + " for " + instructor.getName(DepartmentalInstructor.sNameFormatLastFist), "personalSchedule.do?o4=%%&q=" + QueryEncoderBackend.encode(instructor.getExternalUniqueId() + ":" + instructor.getDepartment().getSession().getUniqueId()), new String[]{"Type", "Class / Course", "Enrollment", "Seating" + nl + "Type", "Date", "Time", "Room", "Distance"}, new String[]{"left", "left", "right", "center", "left", "left", "left", "left"}, new boolean[]{true, true, true, true, true, true, true, true});
        table.setRowStyle("white-space:nowrap");
        String noRoom = ApplicationProperty.ExaminationsNoRoomText.value();
        for (ExamAssignmentInfo exam : exams) {
            boolean firstSection;
            String room;
            String time;
            String date;
            String seating;
            String enrollment;
            Object classes;
            for (ExamAssignmentInfo.DirectConflict directConflict : exam.getInstructorDirectConflicts()) {
                if (directConflict.getOtherExam() != null && exam.compareTo(directConflict.getOtherExam()) >= 0 && exams.contains(directConflict.getOtherExam())) continue;
                classes = "";
                enrollment = "";
                seating = "";
                date = "";
                time = "";
                room = "";
                firstSection = true;
                for (ExamInfo.ExamSectionInfo section : exam.getSectionsIncludeCrosslistedDummies()) {
                    if (((String)classes).length() > 0) {
                        classes = (String)classes + nl;
                        enrollment = enrollment + nl;
                        seating = seating + nl;
                        date = date + nl;
                        time = time + nl;
                        room = room + nl;
                    }
                    classes = (String)classes + section.getName();
                    enrollment = enrollment + String.valueOf(section.getNrStudents());
                    if (firstSection) {
                        seating = seating + Exam.sSeatingTypes[exam.getSeatingType()];
                        date = date + exam.getDate(false);
                        time = time + exam.getTime(false);
                        room = room + (exam.getNrRooms() == 0 ? noRoom : exam.getRoomsName(false, ", "));
                    }
                    firstSection = false;
                }
                firstSection = true;
                if (directConflict.getOtherExam() != null) {
                    for (ExamInfo.ExamSectionInfo section : directConflict.getOtherExam().getSectionsIncludeCrosslistedDummies()) {
                        if (((String)classes).length() > 0) {
                            classes = (String)classes + nl;
                            enrollment = enrollment + nl;
                            seating = seating + nl;
                            date = date + nl;
                            time = time + nl;
                            room = room + nl;
                        }
                        classes = (String)classes + section.getName();
                        enrollment = enrollment + String.valueOf(section.getNrStudents());
                        if (firstSection) {
                            seating = seating + Exam.sSeatingTypes[directConflict.getOtherExam().getSeatingType()];
                            room = room + (directConflict.getOtherExam().getNrRooms() == 0 ? directConflict.getOtherExam() : exam.getRoomsName(false, ", "));
                        }
                        firstSection = false;
                    }
                } else if (directConflict.getOtherEventId() != null) {
                    classes = (String)classes + nl;
                    enrollment = enrollment + nl;
                    seating = seating + nl;
                    date = date + nl;
                    time = time + nl;
                    room = room + nl;
                    classes = (String)classes + directConflict.getOtherEventName();
                    enrollment = enrollment + directConflict.getOtherEventSize();
                    seating = seating + (directConflict.isOtherClass() ? "Class" : "Event");
                    room = room + directConflict.getOtherEventRoom();
                    time = time + directConflict.getOtherEventTime();
                }
                String[] stringArray = new String[8];
                stringArray[0] = (html ? "<font color='" + PreferenceLevel.prolog2color("P") + "'>" : "") + (directConflict.getOtherEventId() != null ? (directConflict.isOtherClass() ? "Class" : "Event") : "Direct") + (html ? "</font>" : "");
                stringArray[1] = classes;
                stringArray[2] = enrollment;
                stringArray[3] = seating;
                stringArray[4] = date;
                stringArray[5] = time;
                stringArray[6] = room;
                stringArray[7] = "";
                table.addLine(stringArray, new Comparable[]{new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), Integer.valueOf(0), exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), exam, exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), Integer.valueOf(-exam.getNrStudents() - (directConflict.getOtherExam() == null ? 0 : directConflict.getOtherExam().getNrStudents())), exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), (Comparable)((Object)exam.getExamTypeLabel()), exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), exam.getPeriodOrd(), exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), exam.getPeriod().getStartSlot(), exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), (Comparable)((Object)exam.getRoomsName(":")), exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), Double.valueOf(-1.0), exam, Integer.valueOf(0))});
            }
            if (showBackToBack) {
                for (ExamAssignmentInfo.BackToBackConflict backToBackConflict : exam.getInstructorBackToBackConflicts()) {
                    if (exam.compareTo(backToBackConflict.getOtherExam()) >= 0 && exams.contains(backToBackConflict.getOtherExam())) continue;
                    classes = "";
                    enrollment = "";
                    seating = "";
                    date = "";
                    time = "";
                    room = "";
                    firstSection = true;
                    for (ExamInfo.ExamSectionInfo section : exam.getSectionsIncludeCrosslistedDummies()) {
                        if (((String)classes).length() > 0) {
                            classes = (String)classes + nl;
                            enrollment = enrollment + nl;
                            seating = seating + nl;
                            date = date + nl;
                            time = time + nl;
                            room = room + nl;
                        }
                        classes = (String)classes + section.getName();
                        enrollment = enrollment + String.valueOf(section.getNrStudents());
                        if (firstSection) {
                            seating = seating + Exam.sSeatingTypes[exam.getSeatingType()];
                            date = date + exam.getDate(false);
                            time = time + exam.getTime(false);
                            room = room + (exam.getNrRooms() == 0 ? noRoom : exam.getRoomsName(false, ", "));
                        }
                        firstSection = false;
                    }
                    firstSection = true;
                    for (ExamInfo.ExamSectionInfo section : backToBackConflict.getOtherExam().getSectionsIncludeCrosslistedDummies()) {
                        if (((String)classes).length() > 0) {
                            classes = (String)classes + nl;
                            enrollment = enrollment + nl;
                            seating = seating + nl;
                            date = date + nl;
                            time = time + nl;
                            room = room + nl;
                        }
                        classes = (String)classes + section.getName();
                        enrollment = enrollment + String.valueOf(section.getNrStudents());
                        if (firstSection) {
                            seating = seating + Exam.sSeatingTypes[backToBackConflict.getOtherExam().getSeatingType()];
                            time = time + backToBackConflict.getOtherExam().getTime(false);
                            room = room + (backToBackConflict.getOtherExam().getNrRooms() == 0 ? backToBackConflict.getOtherExam() : exam.getRoomsName(false, ", "));
                        }
                        firstSection = false;
                    }
                    table.addLine(new String[]{(html ? "<font color='" + PreferenceLevel.prolog2color("1") + "'>" : "") + "Back-To-Back" + (html ? "</font>" : ""), classes, enrollment, seating, date, time, room, (int)(backToBackConflict.getDistance() * 10.0) + " m"}, new Comparable[]{new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), Integer.valueOf(2), exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), exam, exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), Integer.valueOf(-exam.getNrStudents() - (backToBackConflict.getOtherExam() == null ? 0 : backToBackConflict.getOtherExam().getNrStudents())), exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), (Comparable)((Object)exam.getExamTypeLabel()), exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), exam.getPeriodOrd(), exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), exam.getPeriod().getStartSlot(), exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), (Comparable)((Object)exam.getRoomsName(":")), exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), Double.valueOf(backToBackConflict.getDistance()), exam, Integer.valueOf(0))});
                }
            }
            block7: for (ExamAssignmentInfo.MoreThanTwoADayConflict moreThanTwoADayConflict : exam.getInstructorMoreThanTwoADaysConflicts()) {
                for (ExamAssignment other : moreThanTwoADayConflict.getOtherExams()) {
                    if (exam.compareTo(other) < 0 || !exams.contains(other)) continue;
                    continue block7;
                }
                classes = "";
                enrollment = "";
                seating = "";
                date = "";
                time = "";
                room = "";
                int nrStudents = exam.getNrStudents();
                boolean firstSection2 = true;
                for (ExamInfo.ExamSectionInfo section : exam.getSectionsIncludeCrosslistedDummies()) {
                    if (((String)classes).length() > 0) {
                        classes = (String)classes + nl;
                        enrollment = enrollment + nl;
                        seating = seating + nl;
                        date = date + nl;
                        time = time + nl;
                        room = room + nl;
                    }
                    classes = (String)classes + section.getName();
                    enrollment = enrollment + String.valueOf(section.getNrStudents());
                    if (firstSection2) {
                        seating = seating + Exam.sSeatingTypes[exam.getSeatingType()];
                        date = date + exam.getDate(false);
                        time = time + exam.getTime(false);
                        room = room + (exam.getNrRooms() == 0 ? noRoom : exam.getRoomsName(false, ", "));
                    }
                    firstSection2 = false;
                }
                for (ExamAssignment other : moreThanTwoADayConflict.getOtherExams()) {
                    firstSection2 = true;
                    nrStudents += other.getNrStudents();
                    for (ExamInfo.ExamSectionInfo section : other.getSectionsIncludeCrosslistedDummies()) {
                        if (((String)classes).length() > 0) {
                            classes = (String)classes + nl;
                            enrollment = enrollment + nl;
                            seating = seating + nl;
                            date = date + nl;
                            time = time + nl;
                            room = room + nl;
                        }
                        classes = (String)classes + section.getName();
                        enrollment = enrollment + String.valueOf(section.getNrStudents());
                        if (firstSection2) {
                            seating = seating + Exam.sSeatingTypes[exam.getSeatingType()];
                            time = time + other.getTime(false);
                            room = room + (other.getNrRooms() == 0 ? noRoom : other.getRoomsName(false, ", "));
                        }
                        firstSection2 = false;
                    }
                }
                table.addLine(this.sessionContext.hasPermission(exam, Right.ExaminationDetail) ? "onClick=\"document.location='examDetail.do?examId=" + exam.getExamId() + "';\"" : "", new String[]{(html ? "<font color='" + PreferenceLevel.prolog2color("2") + "'>" : "") + (html ? "&gt;" : "") + "2 A Day" + (html ? "</font>" : ""), classes, enrollment, seating, date, time, room, ""}, new Comparable[]{new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), Integer.valueOf(1), exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), exam, exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), Integer.valueOf(-nrStudents), exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), (Comparable)((Object)exam.getExamTypeLabel()), exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), exam.getPeriodOrd(), exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), exam.getPeriod().getStartSlot(), exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), (Comparable)((Object)exam.getRoomsName(":")), exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), Double.valueOf(-1.0), exam, Integer.valueOf(0))}, exam.getExamId().toString());
            }
        }
        table.setWebTableTweakStyle(new WebTable.WebTableTweakStyle(){

            public String getStyleHtml(WebTable.WebTableLine current, WebTable.WebTableLine next, int order) {
                if (next != null && ((MultiComparable)current.getOrderBy()[0]).getContent()[0].compareTo(((MultiComparable)next.getOrderBy()[0]).getContent()[0]) != 0) {
                    return "border-bottom: rgb(81,81,81) 1px dashed";
                }
                return null;
            }
        });
        return table;
    }

    public PdfWebTable getStudentConflits(boolean html, TreeSet<ExamAssignmentInfo> exams, DepartmentalInstructor instructor) {
        String nl = html ? "<br>" : "\n";
        PdfWebTable table = new PdfWebTable(8, instructor.getDepartment().getSession().getLabel() + " Examination Conflicts for " + instructor.getName(DepartmentalInstructor.sNameFormatLastFist), "personalSchedule.do?o5=%%&q=" + QueryEncoderBackend.encode(instructor.getExternalUniqueId() + ":" + instructor.getDepartment().getSession().getUniqueId()), new String[]{"Name", "Type", "Class / Course", "Enrollment", "Seating" + nl + "Type", "Date", "Time", "Room"}, new String[]{"left", "left", "left", "right", "center", "left", "left", "left"}, new boolean[]{true, true, true, true, true, true, true, true});
        table.setRowStyle("white-space:nowrap");
        String noRoom = ApplicationProperty.ExaminationsNoRoomText.value();
        table.setBlankWhenSame(true);
        for (ExamAssignmentInfo exam : exams) {
            String room;
            String time;
            String date;
            String seating;
            String enrollment;
            String classes;
            String name;
            String id;
            Student student;
            for (ExamAssignmentInfo.DirectConflict directConflict : exam.getDirectConflicts()) {
                if (directConflict.getOtherExam() != null && exam.compareTo(directConflict.getOtherExam()) >= 0 && exams.contains(directConflict.getOtherExam())) continue;
                for (Long studentId : directConflict.getStudents()) {
                    student = (Student)new StudentDAO().get(studentId);
                    id = student.getExternalUniqueId();
                    name = student.getName(DepartmentalInstructor.sNameFormatLastFist);
                    classes = "";
                    enrollment = "";
                    seating = "";
                    date = "";
                    time = "";
                    room = "";
                    boolean firstSection = true;
                    for (ExamInfo.ExamSectionInfo section : exam.getSectionsIncludeCrosslistedDummies()) {
                        if (!section.getStudentIds().contains(studentId)) continue;
                        if (classes.length() > 0) {
                            classes = classes + nl;
                            enrollment = enrollment + nl;
                            seating = seating + nl;
                            date = date + nl;
                            time = time + nl;
                            room = room + nl;
                        }
                        classes = classes + section.getName();
                        enrollment = enrollment + String.valueOf(section.getNrStudents());
                        if (firstSection) {
                            seating = seating + Exam.sSeatingTypes[exam.getSeatingType()];
                            date = date + exam.getDate(false);
                            time = time + exam.getTime(false);
                            room = room + (exam.getNrRooms() == 0 ? noRoom : exam.getRoomsName(false, ", "));
                        }
                        firstSection = false;
                    }
                    firstSection = true;
                    if (directConflict.getOtherExam() != null) {
                        for (ExamInfo.ExamSectionInfo section : directConflict.getOtherExam().getSectionsIncludeCrosslistedDummies()) {
                            if (!section.getStudentIds().contains(studentId)) continue;
                            if (classes.length() > 0) {
                                classes = classes + nl;
                                enrollment = enrollment + nl;
                                seating = seating + nl;
                                date = date + nl;
                                time = time + nl;
                                room = room + nl;
                            }
                            classes = classes + section.getName();
                            enrollment = enrollment + String.valueOf(section.getNrStudents());
                            if (firstSection) {
                                seating = seating + Exam.sSeatingTypes[exam.getSeatingType()];
                                room = room + (directConflict.getOtherExam().getNrRooms() == 0 ? noRoom : directConflict.getOtherExam().getRoomsName(false, ", "));
                            }
                            firstSection = false;
                        }
                    } else if (directConflict.getOtherEventId() != null) {
                        classes = classes + nl;
                        enrollment = enrollment + nl;
                        seating = seating + nl;
                        date = date + nl;
                        time = time + nl;
                        room = room + nl;
                        classes = classes + directConflict.getOtherEventName();
                        enrollment = enrollment + directConflict.getOtherEventSize();
                        seating = seating + (directConflict.isOtherClass() ? "Class" : "Event");
                        room = room + directConflict.getOtherEventRoom();
                        time = time + directConflict.getOtherEventTime();
                    }
                    table.addLine(new String[]{name, (html ? "<font color='" + PreferenceLevel.prolog2color("P") + "'>" : "") + "Direct" + (html ? "</font>" : ""), classes, enrollment, seating, date, time, room}, new Comparable[]{new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), (Comparable)((Object)name), (Comparable)((Object)id), exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), Integer.valueOf(0), exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), exam, exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), Integer.valueOf(-exam.getNrStudents() - (directConflict.getOtherExam() == null ? 0 : directConflict.getOtherExam().getNrStudents())), exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), (Comparable)((Object)exam.getExamTypeLabel()), exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), exam.getPeriodOrd(), exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), Integer.valueOf(exam.getPeriod() == null ? -1 : exam.getPeriod().getStartSlot()), exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), (Comparable)((Object)exam.getRoomsName(":")), exam, Integer.valueOf(0))});
                }
            }
            block5: for (ExamAssignmentInfo.MoreThanTwoADayConflict moreThanTwoADayConflict : exam.getMoreThanTwoADaysConflicts()) {
                for (ExamAssignment other : moreThanTwoADayConflict.getOtherExams()) {
                    if (exam.compareTo(other) < 0 || !exams.contains(other)) continue;
                    continue block5;
                }
                for (Long studentId : moreThanTwoADayConflict.getStudents()) {
                    student = (Student)new StudentDAO().get(studentId);
                    id = student.getExternalUniqueId();
                    name = student.getName(DepartmentalInstructor.sNameFormatLastFist);
                    classes = "";
                    enrollment = "";
                    seating = "";
                    date = "";
                    time = "";
                    room = "";
                    int nrStudents = exam.getNrStudents();
                    boolean firstSection = true;
                    for (ExamInfo.ExamSectionInfo section : exam.getSectionsIncludeCrosslistedDummies()) {
                        if (!section.getStudentIds().contains(studentId)) continue;
                        if (classes.length() > 0) {
                            classes = classes + nl;
                            enrollment = enrollment + nl;
                            seating = seating + nl;
                            date = date + nl;
                            time = time + nl;
                            room = room + nl;
                        }
                        classes = classes + section.getName();
                        enrollment = enrollment + String.valueOf(section.getNrStudents());
                        if (firstSection) {
                            seating = seating + Exam.sSeatingTypes[exam.getSeatingType()];
                            date = date + exam.getDate(false);
                            time = time + exam.getTime(false);
                            room = room + (exam.getNrRooms() == 0 ? noRoom : exam.getRoomsName(false, ", "));
                        }
                        firstSection = false;
                    }
                    for (ExamAssignment other : moreThanTwoADayConflict.getOtherExams()) {
                        firstSection = true;
                        nrStudents += other.getNrStudents();
                        for (ExamInfo.ExamSectionInfo section : other.getSectionsIncludeCrosslistedDummies()) {
                            if (!section.getStudentIds().contains(studentId)) continue;
                            if (classes.length() > 0) {
                                classes = classes + nl;
                                enrollment = enrollment + nl;
                                seating = seating + nl;
                                date = date + nl;
                                time = time + nl;
                                room = room + nl;
                            }
                            classes = classes + section.getName();
                            enrollment = enrollment + String.valueOf(section.getNrStudents());
                            if (firstSection) {
                                seating = seating + Exam.sSeatingTypes[exam.getSeatingType()];
                                time = time + other.getTime(false);
                                room = room + (other.getNrRooms() == 0 ? noRoom : other.getRoomsName(false, ", "));
                            }
                            firstSection = false;
                        }
                    }
                    table.addLine(new String[]{name, (html ? "<font color='" + PreferenceLevel.prolog2color("2") + "'>" : "") + (html ? "&gt;" : "") + "2 A Day" + (html ? "</font>" : ""), classes, enrollment, seating, date, time, room}, new Comparable[]{new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), (Comparable)((Object)name), (Comparable)((Object)id), exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), Integer.valueOf(1), exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), exam, exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), Integer.valueOf(-nrStudents), exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), (Comparable)((Object)exam.getExamTypeLabel()), exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), exam.getPeriodOrd(), exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), exam.getPeriod().getStartSlot(), exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(-exam.getExamType().getType().intValue()), (Comparable)((Object)exam.getRoomsName(":")), exam, Integer.valueOf(0))});
                }
            }
        }
        table.setWebTableTweakStyle(new WebTable.WebTableTweakStyle(){

            public String getStyleHtml(WebTable.WebTableLine current, WebTable.WebTableLine next, int order) {
                if (next != null && ((MultiComparable)current.getOrderBy()[0]).getContent()[0].compareTo(((MultiComparable)next.getOrderBy()[0]).getContent()[0]) != 0) {
                    return "border-bottom: rgb(81,81,81) 1px solid";
                }
                return null;
            }
        });
        return table;
    }

    protected String getMeetingTime(Class_ clazz) {
        DatePattern dp;
        String meetingTime = "";
        Formats.Format<Date> dpf = Formats.getDateFormat(Formats.Pattern.DATE_EVENT_SHORT);
        Assignment assignment = clazz.getCommittedAssignment();
        TreeSet<Meeting> meetings = clazz.getEvent() == null ? null : new TreeSet<Meeting>(clazz.getEvent().getMeetings());
        DatePattern datePattern = dp = assignment == null ? null : assignment.getDatePattern();
        if (meetings != null && !meetings.isEmpty()) {
            int dayCode = this.getDaysCode(meetings);
            String days = "";
            for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
                if ((dayCode & Constants.DAY_CODES[i]) == 0) continue;
                days = days + Constants.DAY_NAMES_SHORT[i];
            }
            meetingTime = meetingTime + days;
            Meeting first = meetings.first();
            meetingTime = meetingTime + " " + first.startTime() + " - " + first.stopTime();
        } else if (assignment != null) {
            TimeLocation t = assignment.getTimeLocation();
            meetingTime = meetingTime + t.getDayHeader() + " " + t.getStartTimeHeader(CONSTANTS.useAmPm()) + " - " + t.getEndTimeHeader(CONSTANTS.useAmPm());
        } else {
            meetingTime = meetingTime + "Arr Hrs";
        }
        if (meetings != null && !meetings.isEmpty()) {
            if (dp == null || !dp.isDefault()) {
                Date first = meetings.first().getMeetingDate();
                Date last = meetings.last().getMeetingDate();
                meetingTime = dp != null && dp.getType() == 1 ? meetingTime + " (" + dpf.format(first) + " - " + dpf.format(last) + " " + dp.getName() + ")" : meetingTime + " (" + dpf.format(first) + " - " + dpf.format(last) + ")";
            }
        } else if (dp != null && !dp.isDefault()) {
            meetingTime = dp.getType() == 1 ? meetingTime + " (" + dpf.format(dp.getStartDate()) + " - " + dpf.format(dp.getEndDate()) + " " + dp.getName() + ")" : meetingTime + " (" + dpf.format(dp.getStartDate()) + " - " + dpf.format(dp.getEndDate()) + ")";
        }
        return meetingTime;
    }

    protected String getMeetingRooms(boolean html, Class_ clazz) {
        String meetingRooms = "";
        Assignment assignment = clazz.getCommittedAssignment();
        TreeSet<Meeting> meetings = clazz.getEvent() == null ? null : new TreeSet<Meeting>(clazz.getEvent().getMeetings());
        TreeSet<Location> locations = new TreeSet<Location>();
        if (meetings != null && !meetings.isEmpty()) {
            for (Meeting meeting : meetings) {
                if (meeting.getLocation() == null) continue;
                locations.add(meeting.getLocation());
            }
        } else if (assignment != null && assignment.getDatePattern() != null) {
            Iterator<Location> i = assignment.getRooms().iterator();
            while (i.hasNext()) {
                locations.add(i.next());
            }
        }
        for (Location location : locations) {
            if (meetingRooms.length() > 0) {
                meetingRooms = meetingRooms + ", ";
            }
            meetingRooms = meetingRooms + (html ? location.getLabelWithHint() : location.getLabel());
        }
        return meetingRooms;
    }

    protected long getMeetingComparable(Class_ clazz) {
        TreeSet<Meeting> meetings;
        Assignment assignment = clazz.getCommittedAssignment();
        TreeSet<Meeting> treeSet = meetings = clazz.getEvent() == null ? null : new TreeSet<Meeting>(clazz.getEvent().getMeetings());
        if (meetings != null && !meetings.isEmpty()) {
            return meetings.first().getMeetingDate().getTime();
        }
        if (assignment != null) {
            return assignment.getTimeLocation().getStartSlot();
        }
        return -1L;
    }

    protected String getMeetingInstructor(Class_ clazz) {
        String meetingInstructor = "";
        if (!clazz.isDisplayInstructor().booleanValue()) {
            return meetingInstructor;
        }
        for (ClassInstructor ci : new TreeSet<ClassInstructor>(clazz.getClassInstructors())) {
            if (meetingInstructor.length() > 0) {
                meetingInstructor = meetingInstructor + ", ";
            }
            meetingInstructor = meetingInstructor + ci.getInstructor().getName(DepartmentalInstructor.sNameFormatLastInitial);
        }
        return meetingInstructor;
    }

    public PdfWebTable getStudentClassSchedule(boolean html, Student student) {
        String nl = html ? "<br>" : "\n";
        PdfWebTable table = new PdfWebTable(6, student.getSession().getLabel() + " Class Schedule for " + student.getName(DepartmentalInstructor.sNameFormatLastFist), "personalSchedule.do?o6=%%&q=" + QueryEncoderBackend.encode(student.getExternalUniqueId() + ":" + student.getSession().getUniqueId()), new String[]{"Course", "Instruction" + nl + "Type", "Section", "Time", "Room", "Instructor"}, new String[]{"left", "left", "left", "left", "left", "left"}, new boolean[]{true, true, true, true, true, true});
        table.setRowStyle("white-space:nowrap");
        table.setBlankWhenSame(true);
        boolean suffix = ApplicationProperty.ExaminationReportsClassSufix.isTrue();
        for (StudentClassEnrollment sce : student.getClassEnrollments()) {
            String course = sce.getCourseOffering().getCourseName();
            String itype = sce.getClazz().getSchedulingSubpart().getItypeDesc();
            int itypeCmp = sce.getClazz().getSchedulingSubpart().getItype().getItype();
            String section = suffix && sce.getClazz().getClassSuffix() != null ? sce.getClazz().getClassSuffix() : sce.getClazz().getSectionNumberString();
            String time = this.getMeetingTime(sce.getClazz());
            long timeCmp = this.getMeetingComparable(sce.getClazz());
            String room = this.getMeetingRooms(html, sce.getClazz());
            String instr = this.getMeetingInstructor(sce.getClazz());
            table.addLine(new String[]{course, itype, section, time, room, instr}, new Comparable[]{new MultiComparable((Comparable)((Object)course), Integer.valueOf(itypeCmp), (Comparable)((Object)section), Long.valueOf(timeCmp), (Comparable)((Object)room), (Comparable)((Object)instr)), new MultiComparable(Integer.valueOf(itypeCmp), (Comparable)((Object)course), (Comparable)((Object)section), Long.valueOf(timeCmp), (Comparable)((Object)room), (Comparable)((Object)instr)), new MultiComparable((Comparable)((Object)course), (Comparable)((Object)section), Integer.valueOf(itypeCmp), Long.valueOf(timeCmp), (Comparable)((Object)room), (Comparable)((Object)instr)), new MultiComparable(Long.valueOf(timeCmp), (Comparable)((Object)room), (Comparable)((Object)course), Integer.valueOf(itypeCmp), (Comparable)((Object)section), (Comparable)((Object)instr)), new MultiComparable((Comparable)((Object)room), Long.valueOf(timeCmp), (Comparable)((Object)course), Integer.valueOf(itypeCmp), (Comparable)((Object)section), (Comparable)((Object)instr)), new MultiComparable((Comparable)((Object)instr), (Comparable)((Object)course), Integer.valueOf(itypeCmp), (Comparable)((Object)section), Long.valueOf(timeCmp), (Comparable)((Object)room))});
        }
        return table;
    }

    public PdfWebTable getInstructorClassSchedule(boolean html, DepartmentalInstructor instructor) {
        String nl = html ? "<br>" : "\n";
        PdfWebTable table = new PdfWebTable(6, instructor.getDepartment().getSession().getLabel() + " Class Schedule for " + instructor.getName(DepartmentalInstructor.sNameFormatLastFist), "personalSchedule.do?o7=%%&q=" + QueryEncoderBackend.encode(instructor.getExternalUniqueId() + ":" + instructor.getDepartment().getSession().getUniqueId()), new String[]{"Course", "Instruction" + nl + "Type", "Section", "Time", "Room", "Share"}, new String[]{"left", "left", "left", "left", "left", "left"}, new boolean[]{true, true, true, true, true, true});
        HashSet<ClassInstructor> allClasses = new HashSet<ClassInstructor>();
        for (DepartmentalInstructor di : DepartmentalInstructor.getAllForInstructor(instructor, instructor.getDepartment().getSession().getUniqueId())) {
            allClasses.addAll(di.getClasses());
        }
        table.setRowStyle("white-space:nowrap");
        table.setBlankWhenSame(true);
        boolean suffix = ApplicationProperty.ExaminationReportsClassSufix.isTrue();
        for (ClassInstructor ci : allClasses) {
            String course = ci.getClassInstructing().getSchedulingSubpart().getControllingCourseOffering().getCourseName();
            String itype = ci.getClassInstructing().getSchedulingSubpart().getItypeDesc();
            int itypeCmp = ci.getClassInstructing().getSchedulingSubpart().getItype().getItype();
            String section = suffix && ci.getClassInstructing().getClassSuffix() != null ? ci.getClassInstructing().getClassSuffix() : ci.getClassInstructing().getSectionNumberString();
            String time = this.getMeetingTime(ci.getClassInstructing());
            long timeCmp = this.getMeetingComparable(ci.getClassInstructing());
            String room = this.getMeetingRooms(html, ci.getClassInstructing());
            String share = ci.getPercentShare() + "%";
            if (html && ci.isLead().booleanValue()) {
                share = "<b>" + share + "</b>";
            }
            table.addLine(new String[]{course, itype, section, time, room, share}, new Comparable[]{new MultiComparable((Comparable)((Object)course), Integer.valueOf(itypeCmp), (Comparable)((Object)section), Long.valueOf(timeCmp), (Comparable)((Object)room), (Comparable)((Object)"")), new MultiComparable(Integer.valueOf(itypeCmp), (Comparable)((Object)course), (Comparable)((Object)section), Long.valueOf(timeCmp), (Comparable)((Object)room), (Comparable)((Object)"")), new MultiComparable((Comparable)((Object)course), (Comparable)((Object)section), Integer.valueOf(itypeCmp), Long.valueOf(timeCmp), (Comparable)((Object)room), (Comparable)((Object)"")), new MultiComparable(Long.valueOf(timeCmp), (Comparable)((Object)room), (Comparable)((Object)course), Integer.valueOf(itypeCmp), (Comparable)((Object)section), (Comparable)((Object)"")), new MultiComparable((Comparable)((Object)room), Long.valueOf(timeCmp), (Comparable)((Object)course), Integer.valueOf(itypeCmp), (Comparable)((Object)section), (Comparable)((Object)"")), new MultiComparable(Integer.valueOf(-ci.getPercentShare().intValue()), (Comparable)((Object)course), Integer.valueOf(itypeCmp), (Comparable)((Object)section), Long.valueOf(timeCmp), (Comparable)((Object)room), (Comparable)((Object)""))});
            if (ci.getClassInstructing().getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getCourseOfferings().size() <= 1) continue;
            String clist = "";
            for (CourseOffering co : ci.getClassInstructing().getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getCourseOfferings()) {
                if (co.isIsControl().booleanValue()) continue;
                if (clist.length() > 0) {
                    clist = clist + ", ";
                }
                String xcourse = co.getCourseName();
                String xsection = suffix && ci.getClassInstructing().getClassSuffix(co) != null ? ci.getClassInstructing().getClassSuffix(co) : ci.getClassInstructing().getSectionNumberString();
                table.addLine(new String[]{"&nbsp;&nbsp;&nbsp;w / " + xcourse, "", section.equals(xsection) ? "" : xsection, "", "", ""}, new Comparable[]{new MultiComparable((Comparable)((Object)course), Integer.valueOf(itypeCmp), (Comparable)((Object)section), Long.valueOf(timeCmp), (Comparable)((Object)room), (Comparable)((Object)xcourse)), new MultiComparable(Integer.valueOf(itypeCmp), (Comparable)((Object)course), (Comparable)((Object)section), Long.valueOf(timeCmp), (Comparable)((Object)room), (Comparable)((Object)xcourse)), new MultiComparable((Comparable)((Object)course), (Comparable)((Object)section), Integer.valueOf(itypeCmp), Long.valueOf(timeCmp), (Comparable)((Object)room), (Comparable)((Object)xcourse)), new MultiComparable(Long.valueOf(timeCmp), (Comparable)((Object)room), (Comparable)((Object)course), Integer.valueOf(itypeCmp), (Comparable)((Object)section), (Comparable)((Object)xcourse)), new MultiComparable((Comparable)((Object)room), Long.valueOf(timeCmp), (Comparable)((Object)course), Integer.valueOf(itypeCmp), (Comparable)((Object)section), (Comparable)((Object)xcourse)), new MultiComparable(Integer.valueOf(-ci.getPercentShare().intValue()), (Comparable)((Object)course), Integer.valueOf(itypeCmp), (Comparable)((Object)section), Long.valueOf(timeCmp), (Comparable)((Object)room), (Comparable)((Object)xcourse))});
            }
        }
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStudentSchedule(File file, Student student, HashSet<ExamOwner> exams) throws Exception {
        PrintWriter out = null;
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
            df.setTimeZone(TimeZone.getTimeZone("UTC"));
            SimpleDateFormat tf = new SimpleDateFormat("HHmmss");
            tf.setTimeZone(TimeZone.getTimeZone("UTC"));
            out = new PrintWriter(new FileWriter(file));
            out.println("BEGIN:VCALENDAR");
            out.println("VERSION:2.0");
            out.println("CALSCALE:GREGORIAN");
            out.println("METHOD:PUBLISH");
            out.println("X-WR-CALNAME:" + student.getName(DepartmentalInstructor.sNameFormatLastFist));
            out.println("X-WR-TIMEZONE:" + TimeZone.getDefault().getID());
            out.println("PRODID:-//UniTime " + Constants.getVersion() + "/UniTime Personal Schedule//NONSGML v1.0//EN");
            if (student.getSession().getStatusType().canNoRoleReportClass()) {
                for (StudentClassEnrollment sce : student.getClassEnrollments()) {
                    if (sce.getClazz().getEvent() == null) continue;
                    for (Meeting meeting : sce.getClazz().getEvent().getMeetings()) {
                        out.println("BEGIN:VEVENT");
                        out.println("UID:m" + meeting.getUniqueId());
                        out.println("DTSTART:" + df.format(meeting.getStartTime()) + "T" + tf.format(meeting.getStartTime()) + "Z");
                        out.println("DTEND:" + df.format(meeting.getStopTime()) + "T" + tf.format(meeting.getStopTime()) + "Z");
                        out.println("SUMMARY:" + sce.getClazz().getClassLabel(sce.getCourseOffering()) + " (" + meeting.getEvent().getEventTypeLabel() + ")");
                        if (meeting.getLocation() != null) {
                            out.println("LOCATION:" + meeting.getLocation().getLabel());
                        }
                        out.println("END:VEVENT");
                    }
                }
            }
            for (ExamOwner examOwner : exams) {
                Exam exam = examOwner.getExam();
                if (exam.getAssignedPeriod() == null) continue;
                for (ExamInfo.ExamSectionInfo section : new ExamAssignment(exam).getSectionsIncludeCrosslistedDummies()) {
                    if (!section.getStudentIds().contains(student.getUniqueId())) continue;
                    out.println("BEGIN:VEVENT");
                    out.println("UID:x" + exam.getUniqueId());
                    out.println("DTSTART:" + df.format(exam.getAssignedPeriod().getStartTime()) + "T" + tf.format(exam.getAssignedPeriod().getStartTime()) + "Z");
                    Calendar endTime = Calendar.getInstance();
                    endTime.setTime(exam.getAssignedPeriod().getStartTime());
                    endTime.add(12, exam.getLength());
                    out.println("DTEND:" + df.format(endTime.getTime()) + "T" + tf.format(endTime.getTime()) + "Z");
                    out.println("SUMMARY:" + section.getName() + " (" + exam.getExamType().getLabel() + " Exam)");
                    if (!exam.getAssignedRooms().isEmpty()) {
                        String rooms = "";
                        for (Location location : new TreeSet<Location>(exam.getAssignedRooms())) {
                            if (rooms.length() > 0) {
                                rooms = rooms + ", ";
                            }
                            rooms = rooms + location.getLabel();
                        }
                        out.println("LOCATION:" + rooms);
                    }
                    out.println("END:VEVENT");
                }
            }
            out.println("END:VCALENDAR");
            Object var17_16 = null;
            if (out != null) {
                out.flush();
                out.close();
            }
        }
        catch (Throwable throwable) {
            Object var17_17 = null;
            if (out != null) {
                out.flush();
                out.close();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printInstructorSchedule(File file, DepartmentalInstructor instructor, HashSet<Exam> exams) throws Exception {
        PrintWriter out = null;
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
            df.setTimeZone(TimeZone.getTimeZone("UTC"));
            SimpleDateFormat tf = new SimpleDateFormat("HHmmss");
            tf.setTimeZone(TimeZone.getTimeZone("UTC"));
            out = new PrintWriter(new FileWriter(file));
            out.println("BEGIN:VCALENDAR");
            out.println("VERSION:2.0");
            out.println("CALSCALE:GREGORIAN");
            out.println("METHOD:PUBLISH");
            out.println("X-WR-CALNAME:" + instructor.getName(DepartmentalInstructor.sNameFormatLastFist));
            out.println("X-WR-TIMEZONE:" + TimeZone.getDefault().getID());
            out.println("PRODID:-//UniTime " + Constants.getVersion() + "/UniTime Personal Schedule//NONSGML v1.0//EN");
            if (instructor.getDepartment().getSession().getStatusType().canNoRoleReportClass()) {
                for (DepartmentalInstructor di : DepartmentalInstructor.getAllForInstructor(instructor, instructor.getDepartment().getSession().getUniqueId())) {
                    for (ClassInstructor ci : di.getClasses()) {
                        if (ci.getClassInstructing().getEvent() == null) continue;
                        for (Meeting meeting : ci.getClassInstructing().getEvent().getMeetings()) {
                            out.println("BEGIN:VEVENT");
                            out.println("UID:m" + meeting.getUniqueId());
                            out.println("DTSTART:" + df.format(meeting.getStartTime()) + "T" + tf.format(meeting.getStartTime()) + "Z");
                            out.println("DTEND:" + df.format(meeting.getStopTime()) + "T" + tf.format(meeting.getStopTime()) + "Z");
                            out.println("SUMMARY:" + meeting.getEvent().getEventName() + " (" + meeting.getEvent().getEventTypeLabel() + ")");
                            if (meeting.getLocation() != null) {
                                out.println("LOCATION:" + meeting.getLocation().getLabel());
                            }
                            out.println("END:VEVENT");
                        }
                    }
                }
            }
            for (Exam exam : exams) {
                if (exam.getAssignedPeriod() == null) continue;
                out.println("BEGIN:VEVENT");
                out.println("UID:x" + exam.getUniqueId());
                out.println("DTSTART:" + df.format(exam.getAssignedPeriod().getStartTime()) + "T" + tf.format(exam.getAssignedPeriod().getStartTime()) + "Z");
                Calendar endTime = Calendar.getInstance();
                endTime.setTime(exam.getAssignedPeriod().getStartTime());
                endTime.add(12, exam.getLength());
                out.println("DTEND:" + df.format(endTime.getTime()) + "T" + tf.format(endTime.getTime()) + "Z");
                out.println("SUMMARY:" + exam.getLabel() + " (" + exam.getExamType().getLabel() + " Exam)");
                if (!exam.getAssignedRooms().isEmpty()) {
                    String rooms = "";
                    for (Location location : new TreeSet<Location>(exam.getAssignedRooms())) {
                        if (rooms.length() > 0) {
                            rooms = rooms + ", ";
                        }
                        rooms = rooms + location.getLabel();
                    }
                    out.println("LOCATION:" + rooms);
                }
                out.println("END:VEVENT");
            }
            out.println("END:VCALENDAR");
            Object var14_13 = null;
            if (out != null) {
                out.flush();
                out.close();
            }
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            if (out != null) {
                out.flush();
                out.close();
            }
            throw throwable;
        }
    }

    static {
        sLog = LogFactory.getLog(PersonalizedExamReportAction.class);
        if (ApplicationProperty.ExternalUserIdTranslation.value() != null) {
            try {
                sTranslation = (ExternalUidTranslation)Class.forName(ApplicationProperty.ExternalUserIdTranslation.value()).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                Debug.error("Unable to instantiate external uid translation class, " + e.getMessage());
            }
        }
        DAY_NAMES_SHORT = new String[]{"M", "T", "W", "R", "F", "S", "U"};
    }
}

