/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.commons;

import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitime.commons.Email;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;

public class JavaMailWrapper
extends Email {
    private static Log sLog = LogFactory.getLog(Email.class);
    private Session iMailSession = null;
    private MimeMessage iMail = null;
    private Multipart iBody = null;

    public JavaMailWrapper() {
        Properties p = ApplicationProperties.getProperties();
        if (p.getProperty("mail.smtp.host") == null && p.getProperty("tmtbl.smtp.host") != null) {
            p.setProperty("mail.smtp.host", p.getProperty("tmtbl.smtp.host"));
        }
        final String user = ApplicationProperty.EmailSmtpUser.value();
        final String password = ApplicationProperty.EmailSmtpPassword.value();
        Authenticator a = null;
        if (user != null && password != null) {
            p.setProperty("mail.smtp.user", user);
            p.setProperty("mail.smtp.auth", "true");
            a = new Authenticator(){

                public PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(user, password);
                }
            };
        }
        this.iMailSession = Session.getDefaultInstance((Properties)p, a);
        this.iMail = new MimeMessage(this.iMailSession);
        this.iBody = new MimeMultipart();
    }

    public void setSubject(String subject) throws MessagingException {
        this.iMail.setSubject(subject, "UTF-8");
    }

    public void setFrom(String email, String name) throws MessagingException, UnsupportedEncodingException {
        if (email != null) {
            this.iMail.setFrom((Address)new InternetAddress(email, name, "UTF-8"));
        }
    }

    public void setReplyTo(String email, String name) throws UnsupportedEncodingException, MessagingException {
        if (email != null) {
            this.iMail.setReplyTo((Address[])new InternetAddress[]{new InternetAddress(email, name, "UTF-8")});
        }
    }

    public void addReplyTo(String email, String name) throws UnsupportedEncodingException, MessagingException {
        if (email == null || email.isEmpty()) {
            return;
        }
        Address[] replyTo = this.iMail.getReplyTo();
        if (replyTo == null || replyTo.length == 0) {
            this.iMail.setReplyTo((Address[])new InternetAddress[]{new InternetAddress(email, name, "UTF-8")});
        } else {
            Address[] newReplyTo = new Address[replyTo.length + 1];
            for (int i = 0; i < replyTo.length; ++i) {
                newReplyTo[i] = replyTo[i];
            }
            newReplyTo[replyTo.length] = new InternetAddress(email, name, "UTF-8");
            this.iMail.setReplyTo(newReplyTo);
        }
    }

    protected void addRecipient(Message.RecipientType type, String email, String name) throws UnsupportedEncodingException, MessagingException {
        this.iMail.addRecipient(type, (Address)new InternetAddress(email, name, "UTF-8"));
    }

    public void addRecipient(String email, String name) throws UnsupportedEncodingException, MessagingException {
        this.addRecipient(Message.RecipientType.TO, email, name);
    }

    public void addRecipientCC(String email, String name) throws UnsupportedEncodingException, MessagingException {
        this.addRecipient(Message.RecipientType.CC, email, name);
    }

    public void addRecipientBCC(String email, String name) throws UnsupportedEncodingException, MessagingException {
        this.addRecipient(Message.RecipientType.BCC, email, name);
    }

    public void setBody(String message, String type) throws MessagingException {
        MimeBodyPart text = new MimeBodyPart();
        text.setContent((Object)message, type);
        this.iBody.addBodyPart((BodyPart)text);
    }

    protected void addAttachement(String name, DataHandler data) throws MessagingException {
        MimeBodyPart attachement = new MimeBodyPart();
        attachement.setDataHandler(data);
        attachement.setFileName(name);
        attachement.setHeader("Content-ID", "<" + name + ">");
        this.iBody.addBodyPart((BodyPart)attachement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send() throws MessagingException, UnsupportedEncodingException {
        long t0 = System.currentTimeMillis();
        try {
            if (this.iMail.getFrom() == null || this.iMail.getFrom().length == 0) {
                this.setFrom(ApplicationProperty.EmailSenderAddress.value(), ApplicationProperty.EmailSenderName.value());
            }
            if (this.iMail.getReplyTo() == null || this.iMail.getReplyTo().length == 0) {
                this.setReplyTo(ApplicationProperty.EmailReplyToAddress.value(), ApplicationProperty.EmailReplyToName.value());
            }
            this.iMail.setSentDate(new Date());
            this.iMail.setContent(this.iBody);
            this.iMail.saveChanges();
            Transport.send((Message)this.iMail);
        }
        finally {
            long t = System.currentTimeMillis() - t0;
            if (t > 30000L) {
                sLog.warn((Object)("It took " + new DecimalFormat("0.00").format((double)t / 1000.0) + " seconds to send an email."));
            } else if (t > 5000L) {
                sLog.info((Object)("It took " + new DecimalFormat("0.00").format((double)t / 1000.0) + " seconds to send an email."));
            }
        }
    }

    public void setInReplyTo(String messageId) throws MessagingException {
        if (messageId != null) {
            this.iMail.setHeader("In-Reply-To", messageId);
        }
    }

    public String getMessageId() throws MessagingException {
        return this.iMail.getHeader("Message-Id", null);
    }
}

