/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.online.selection;

import java.util.Hashtable;
import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.Subpart;
import org.cpsolver.studentsct.online.OnlineSectioningModel;
import org.cpsolver.studentsct.online.selection.OnlineSectioningCriterion;

public class EqualWeightCriterion
extends OnlineSectioningCriterion {
    public EqualWeightCriterion(Student student, OnlineSectioningModel model, Assignment<Request, Enrollment> assignment, Hashtable<CourseRequest, Set<Section>> preferredSections) {
        super(student, model, assignment, preferredSections);
    }

    @Override
    public int compare(Assignment<Request, Enrollment> assignment, Enrollment[] current, Enrollment[] best) {
        double currentUnavailableSizeFraction;
        if (best == null) {
            return -1;
        }
        int currentAssignedCourseReq = 0;
        int bestAssignedCourseReq = 0;
        int currentAssignedRequests = 0;
        int bestAssignedRequests = 0;
        int currentAssignedPriority = 0;
        int bestAssignedPriority = 0;
        int currentAssignedAlternativity = 0;
        int bestAssignedAlternativity = 0;
        for (int idx = 0; idx < current.length; ++idx) {
            if (current[idx] != null && current[idx].getAssignments() != null) {
                ++currentAssignedRequests;
                if (current[idx].isCourseRequest()) {
                    ++currentAssignedCourseReq;
                }
                currentAssignedPriority += current[idx].getPriority() * current[idx].getPriority();
                currentAssignedAlternativity += current[idx].getRequest().isAlternative() ? 1 : 0;
            }
            if (best[idx] == null || best[idx].getAssignments() == null) continue;
            ++bestAssignedRequests;
            if (best[idx].isCourseRequest()) {
                ++bestAssignedCourseReq;
            }
            bestAssignedPriority += best[idx].getPriority() * best[idx].getPriority();
            bestAssignedAlternativity += best[idx].getRequest().isAlternative() ? 1 : 0;
        }
        if (currentAssignedCourseReq > bestAssignedCourseReq) {
            return -1;
        }
        if (bestAssignedCourseReq > currentAssignedCourseReq) {
            return 1;
        }
        if (currentAssignedPriority < bestAssignedPriority) {
            return -1;
        }
        if (bestAssignedPriority < currentAssignedPriority) {
            return 1;
        }
        if (currentAssignedAlternativity < bestAssignedAlternativity) {
            return -1;
        }
        if (bestAssignedAlternativity < currentAssignedAlternativity) {
            return 1;
        }
        if (this.getModel().getTimeOverlaps() != null) {
            int bestTimeOverlaps = 0;
            int currentTimeOverlaps = 0;
            for (int idx = 0; idx < current.length; ++idx) {
                int x;
                if (best[idx] != null && best[idx].getAssignments() != null && best[idx].getRequest() instanceof CourseRequest) {
                    for (x = 0; x < idx; ++x) {
                        if (best[x] == null || best[x].getAssignments() == null || !(best[x].getRequest() instanceof CourseRequest)) continue;
                        bestTimeOverlaps += this.getModel().getTimeOverlaps().nrConflicts(best[x], best[idx]);
                    }
                }
                if (current[idx] == null || current[idx].getAssignments() == null || !(current[idx].getRequest() instanceof CourseRequest)) continue;
                for (x = 0; x < idx; ++x) {
                    if (current[x] == null || current[x].getAssignments() == null || !(current[x].getRequest() instanceof CourseRequest)) continue;
                    currentTimeOverlaps += this.getModel().getTimeOverlaps().nrConflicts(current[x], current[idx]);
                }
            }
            if (currentTimeOverlaps < bestTimeOverlaps) {
                return -1;
            }
            if (bestTimeOverlaps < currentTimeOverlaps) {
                return 1;
            }
        }
        double bestPenalties = 0.0;
        double currentPenalties = 0.0;
        for (int idx = 0; idx < current.length; ++idx) {
            if (best[idx] != null && best[idx].getAssignments() != null && best[idx].isCourseRequest()) {
                for (Section section : best[idx].getSections()) {
                    bestPenalties += this.getModel().getOverExpected(assignment, section, best[idx].getRequest());
                }
            }
            if (current[idx] == null || current[idx].getAssignments() == null || !current[idx].isCourseRequest()) continue;
            for (Section section : current[idx].getSections()) {
                currentPenalties += this.getModel().getOverExpected(assignment, section, current[idx].getRequest());
            }
        }
        if (currentPenalties < bestPenalties) {
            return -1;
        }
        if (bestPenalties < currentPenalties) {
            return 1;
        }
        if (currentAssignedRequests > bestAssignedRequests) {
            return -1;
        }
        if (bestAssignedRequests > currentAssignedRequests) {
            return 1;
        }
        int bestSelected = 0;
        int currentSelected = 0;
        for (int idx = 0; idx < current.length; ++idx) {
            Set<Section> preferred = this.getPreferredSections(this.getRequest(idx));
            if (preferred == null || preferred.isEmpty()) continue;
            if (best[idx] != null && best[idx].getAssignments() != null && best[idx].isCourseRequest()) {
                for (Section section : best[idx].getSections()) {
                    if (!preferred.contains(section)) continue;
                    ++bestSelected;
                }
            }
            if (current[idx] == null || current[idx].getAssignments() == null || !current[idx].isCourseRequest()) continue;
            for (Section section : current[idx].getSections()) {
                if (!preferred.contains(section)) continue;
                ++currentSelected;
            }
        }
        if (currentSelected > bestSelected) {
            return -1;
        }
        if (bestSelected > currentSelected) {
            return 1;
        }
        if (this.getModel().getTimeOverlaps() != null) {
            int bestTimeOverlaps = 0;
            int currentTimeOverlaps = 0;
            for (int idx = 0; idx < current.length; ++idx) {
                int x;
                if (best[idx] != null && best[idx].getAssignments() != null) {
                    for (x = 0; x < idx; ++x) {
                        if (best[x] != null && best[x].getAssignments() != null) {
                            bestTimeOverlaps += this.getModel().getTimeOverlaps().nrConflicts(best[x], best[idx]);
                            continue;
                        }
                        if (!(this.getStudent().getRequests().get(x) instanceof FreeTimeRequest)) continue;
                        bestTimeOverlaps += this.getModel().getTimeOverlaps().nrConflicts(((FreeTimeRequest)this.getStudent().getRequests().get(x)).createEnrollment(), best[idx]);
                    }
                }
                if (current[idx] == null || current[idx].getAssignments() == null) continue;
                for (x = 0; x < idx; ++x) {
                    if (current[x] != null && current[x].getAssignments() != null) {
                        currentTimeOverlaps += this.getModel().getTimeOverlaps().nrConflicts(current[x], current[idx]);
                        continue;
                    }
                    if (!(this.getStudent().getRequests().get(x) instanceof FreeTimeRequest)) continue;
                    currentTimeOverlaps += this.getModel().getTimeOverlaps().nrConflicts(((FreeTimeRequest)this.getStudent().getRequests().get(x)).createEnrollment(), current[idx]);
                }
            }
            if (currentTimeOverlaps < bestTimeOverlaps) {
                return -1;
            }
            if (bestTimeOverlaps < currentTimeOverlaps) {
                return 1;
            }
        }
        if (this.getModel().getDistanceConflict() != null) {
            int bestDistanceConf = 0;
            int currentDistanceConf = 0;
            for (int idx = 0; idx < current.length; ++idx) {
                int x;
                if (best[idx] != null && best[idx].getAssignments() != null) {
                    for (x = 0; x < idx; ++x) {
                        if (best[x] == null || best[x].getAssignments() == null) continue;
                        bestDistanceConf += this.getModel().getDistanceConflict().nrConflicts(best[x], best[idx]);
                    }
                }
                if (current[idx] == null || current[idx].getAssignments() == null) continue;
                for (x = 0; x < idx; ++x) {
                    if (current[x] == null || current[x].getAssignments() == null) continue;
                    currentDistanceConf += this.getModel().getDistanceConflict().nrConflicts(current[x], current[idx]);
                }
            }
            if (currentDistanceConf < bestDistanceConf) {
                return -1;
            }
            if (bestDistanceConf < currentDistanceConf) {
                return 1;
            }
        }
        int bestNoTime = 0;
        int currentNoTime = 0;
        for (int idx = 0; idx < current.length; ++idx) {
            if (best[idx] != null && best[idx].getAssignments() != null) {
                for (Section section : best[idx].getSections()) {
                    if (section.getTime() != null) continue;
                    ++bestNoTime;
                }
            }
            if (current[idx] == null || current[idx].getAssignments() == null) continue;
            for (Section section : current[idx].getSections()) {
                if (section.getTime() != null) continue;
                ++currentNoTime;
            }
        }
        if (currentNoTime < bestNoTime) {
            return -1;
        }
        if (bestNoTime < currentNoTime) {
            return 1;
        }
        double bestUnavailableSize = 0.0;
        double currentUnavailableSize = 0.0;
        int bestAltSectionsWithLimit = 0;
        int currentAltSectionsWithLimit = 0;
        for (int idx = 0; idx < current.length; ++idx) {
            double averageSize;
            Subpart subpart;
            if (best[idx] != null && best[idx].getAssignments() != null) {
                for (Section section : best[idx].getSections()) {
                    subpart = section.getSubpart();
                    if (subpart.getSections().size() <= 1 || subpart.getLimit() <= 0) continue;
                    averageSize = (double)subpart.getLimit() / (double)subpart.getSections().size();
                    if ((double)section.getLimit() < averageSize) {
                        bestUnavailableSize += (averageSize - (double)section.getLimit()) / averageSize;
                    }
                    ++bestAltSectionsWithLimit;
                }
            }
            if (current[idx] == null || current[idx].getAssignments() == null) continue;
            for (Section section : current[idx].getSections()) {
                subpart = section.getSubpart();
                if (subpart.getSections().size() <= 1 || subpart.getLimit() <= 0) continue;
                averageSize = (double)subpart.getLimit() / (double)subpart.getSections().size();
                if ((double)section.getLimit() < averageSize) {
                    currentUnavailableSize += (averageSize - (double)section.getLimit()) / averageSize;
                }
                ++currentAltSectionsWithLimit;
            }
        }
        double bestUnavailableSizeFraction = bestUnavailableSize > 0.0 ? bestUnavailableSize / (double)bestAltSectionsWithLimit : 0.0;
        double d = currentUnavailableSizeFraction = currentUnavailableSize > 0.0 ? currentUnavailableSize / (double)currentAltSectionsWithLimit : 0.0;
        if (currentUnavailableSizeFraction < bestUnavailableSizeFraction) {
            return -1;
        }
        if (bestUnavailableSizeFraction < currentUnavailableSizeFraction) {
            return 1;
        }
        double bestPenalty = 0.0;
        double currentPenalty = 0.0;
        for (int idx = 0; idx < current.length; ++idx) {
            if (best[idx] != null && best[idx].getAssignments() != null) {
                for (Section section : best[idx].getSections()) {
                    bestPenalty += section.getPenalty();
                }
            }
            if (current[idx] == null || current[idx].getAssignments() == null) continue;
            for (Section section : current[idx].getSections()) {
                currentPenalty += section.getPenalty();
            }
        }
        if (currentPenalty < bestPenalty) {
            return -1;
        }
        if (bestPenalty < currentPenalty) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean canImprove(Assignment<Request, Enrollment> assignment, int maxIdx, Enrollment[] current, Enrollment[] best) {
        double currentUnavailableSizeFraction;
        int currentAssignedCourseReq = 0;
        int bestAssignedCourseReq = 0;
        int currentAssignedRequests = 0;
        int bestAssignedRequests = 0;
        int currentAssignedPriority = 0;
        int bestAssignedPriority = 0;
        int currentAssignedAlternativity = 0;
        int bestAssignedAlternativity = 0;
        int alt = 0;
        for (int idx = 0; idx < current.length; ++idx) {
            if (idx < maxIdx) {
                if (current[idx] != null && current[idx].getAssignments() != null) {
                    ++currentAssignedRequests;
                    if (current[idx].isCourseRequest()) {
                        ++currentAssignedCourseReq;
                    }
                    currentAssignedPriority += current[idx].getPriority() * current[idx].getPriority();
                    currentAssignedAlternativity += current[idx].getRequest().isAlternative() ? 1 : 0;
                } else if (!this.isFreeTime(idx) && !this.getRequest(idx).isAlternative()) {
                    ++alt;
                }
            } else if (!this.getRequest(idx).isAlternative()) {
                ++currentAssignedRequests;
                if (!this.isFreeTime(idx)) {
                    ++currentAssignedCourseReq;
                }
            } else if (alt > 0) {
                ++currentAssignedRequests;
                ++currentAssignedCourseReq;
                --alt;
                ++currentAssignedAlternativity;
            }
            if (best[idx] == null || best[idx].getAssignments() == null) continue;
            ++bestAssignedRequests;
            if (best[idx].isCourseRequest()) {
                ++bestAssignedCourseReq;
            }
            bestAssignedPriority += best[idx].getPriority() * best[idx].getPriority();
            bestAssignedAlternativity += best[idx].getRequest().isAlternative() ? 1 : 0;
        }
        if (currentAssignedCourseReq > bestAssignedCourseReq) {
            return true;
        }
        if (bestAssignedCourseReq > currentAssignedCourseReq) {
            return false;
        }
        if (currentAssignedPriority < bestAssignedPriority) {
            return true;
        }
        if (bestAssignedPriority < currentAssignedPriority) {
            return false;
        }
        if (currentAssignedAlternativity < bestAssignedAlternativity) {
            return true;
        }
        if (bestAssignedAlternativity < currentAssignedAlternativity) {
            return false;
        }
        if (this.getModel().getTimeOverlaps() != null) {
            int bestTimeOverlaps = 0;
            int currentTimeOverlaps = 0;
            for (int idx = 0; idx < current.length; ++idx) {
                int x;
                if (best[idx] != null && best[idx].getRequest() instanceof CourseRequest) {
                    for (x = 0; x < idx; ++x) {
                        if (best[x] == null || !(best[x].getRequest() instanceof CourseRequest)) continue;
                        bestTimeOverlaps += this.getModel().getTimeOverlaps().nrConflicts(best[x], best[idx]);
                    }
                }
                if (current[idx] == null || idx >= maxIdx || !(current[idx].getRequest() instanceof CourseRequest)) continue;
                for (x = 0; x < idx; ++x) {
                    if (current[x] == null || !(current[x].getRequest() instanceof CourseRequest)) continue;
                    currentTimeOverlaps += this.getModel().getTimeOverlaps().nrConflicts(current[x], current[idx]);
                }
            }
            if (currentTimeOverlaps < bestTimeOverlaps) {
                return true;
            }
            if (bestTimeOverlaps < currentTimeOverlaps) {
                return false;
            }
        }
        double bestPenalties = 0.0;
        double currentPenalties = 0.0;
        for (int idx = 0; idx < current.length; ++idx) {
            if (best[idx] != null) {
                for (Section section : best[idx].getSections()) {
                    bestPenalties += this.getModel().getOverExpected(assignment, section, best[idx].getRequest());
                }
            }
            if (current[idx] == null || idx >= maxIdx) continue;
            for (Section section : current[idx].getSections()) {
                currentPenalties += this.getModel().getOverExpected(assignment, section, current[idx].getRequest());
            }
        }
        if (currentPenalties < bestPenalties) {
            return true;
        }
        if (bestPenalties < currentPenalties) {
            return false;
        }
        if (currentAssignedRequests > bestAssignedRequests) {
            return true;
        }
        if (bestAssignedRequests > currentAssignedRequests) {
            return false;
        }
        int bestSelected = 0;
        int currentSelected = 0;
        for (int idx = 0; idx < current.length; ++idx) {
            Set<Section> preferred;
            if (best[idx] != null && best[idx].isCourseRequest() && (preferred = this.getPreferredSections(best[idx].getRequest())) != null && !preferred.isEmpty()) {
                for (Section section : best[idx].getSections()) {
                    if (preferred.contains(section)) {
                        if (idx >= maxIdx) continue;
                        ++bestSelected;
                        continue;
                    }
                    if (idx < maxIdx) continue;
                    --bestSelected;
                }
            }
            if (current[idx] == null || idx >= maxIdx || !current[idx].isCourseRequest() || (preferred = this.getPreferredSections(current[idx].getRequest())) == null || preferred.isEmpty()) continue;
            for (Section section : current[idx].getSections()) {
                if (!preferred.contains(section)) continue;
                ++currentSelected;
            }
        }
        if (currentSelected > bestSelected) {
            return true;
        }
        if (bestSelected > currentSelected) {
            return false;
        }
        if (this.getModel().getTimeOverlaps() != null) {
            int bestTimeOverlaps = 0;
            int currentTimeOverlaps = 0;
            for (int idx = 0; idx < current.length; ++idx) {
                int x;
                if (best[idx] != null) {
                    for (x = 0; x < idx; ++x) {
                        if (best[x] != null) {
                            bestTimeOverlaps += this.getModel().getTimeOverlaps().nrConflicts(best[x], best[idx]);
                            continue;
                        }
                        if (!(this.getStudent().getRequests().get(x) instanceof FreeTimeRequest)) continue;
                        bestTimeOverlaps += this.getModel().getTimeOverlaps().nrConflicts(((FreeTimeRequest)this.getStudent().getRequests().get(x)).createEnrollment(), best[idx]);
                    }
                }
                if (current[idx] == null || idx >= maxIdx) continue;
                for (x = 0; x < idx; ++x) {
                    if (current[x] != null) {
                        currentTimeOverlaps += this.getModel().getTimeOverlaps().nrConflicts(current[x], current[idx]);
                        continue;
                    }
                    if (!(this.getStudent().getRequests().get(x) instanceof FreeTimeRequest)) continue;
                    currentTimeOverlaps += this.getModel().getTimeOverlaps().nrConflicts(((FreeTimeRequest)this.getStudent().getRequests().get(x)).createEnrollment(), current[idx]);
                }
            }
            if (currentTimeOverlaps < bestTimeOverlaps) {
                return true;
            }
            if (bestTimeOverlaps < currentTimeOverlaps) {
                return false;
            }
        }
        if (this.getModel().getDistanceConflict() != null) {
            int bestDistanceConf = 0;
            int currentDistanceConf = 0;
            for (int idx = 0; idx < current.length; ++idx) {
                int x;
                if (best[idx] != null) {
                    for (x = 0; x < idx; ++x) {
                        if (best[x] == null) continue;
                        bestDistanceConf += this.getModel().getDistanceConflict().nrConflicts(best[x], best[idx]);
                    }
                }
                if (current[idx] == null || idx >= maxIdx) continue;
                for (x = 0; x < idx; ++x) {
                    if (current[x] == null) continue;
                    currentDistanceConf += this.getModel().getDistanceConflict().nrConflicts(current[x], current[idx]);
                }
            }
            if (currentDistanceConf < bestDistanceConf) {
                return true;
            }
            if (bestDistanceConf < currentDistanceConf) {
                return false;
            }
        }
        int bestNoTime = 0;
        int currentNoTime = 0;
        for (int idx = 0; idx < current.length; ++idx) {
            if (best[idx] != null) {
                for (Section section : best[idx].getSections()) {
                    if (section.getTime() != null) continue;
                    ++bestNoTime;
                }
            }
            if (current[idx] == null || idx >= maxIdx) continue;
            for (Section section : current[idx].getSections()) {
                if (section.getTime() != null) continue;
                ++currentNoTime;
            }
        }
        if (currentNoTime < bestNoTime) {
            return true;
        }
        if (bestNoTime < currentNoTime) {
            return false;
        }
        double bestUnavailableSize = 0.0;
        double currentUnavailableSize = 0.0;
        int bestAltSectionsWithLimit = 0;
        int currentAltSectionsWithLimit = 0;
        for (int idx = 0; idx < current.length; ++idx) {
            double averageSize;
            Subpart subpart;
            if (best[idx] != null) {
                for (Section section : best[idx].getSections()) {
                    subpart = section.getSubpart();
                    if (subpart.getSections().size() <= 1 || subpart.getLimit() <= 0) continue;
                    averageSize = (double)subpart.getLimit() / (double)subpart.getSections().size();
                    if ((double)section.getLimit() < averageSize) {
                        bestUnavailableSize += (averageSize - (double)section.getLimit()) / averageSize;
                    }
                    ++bestAltSectionsWithLimit;
                }
            }
            if (current[idx] == null || idx >= maxIdx) continue;
            for (Section section : current[idx].getSections()) {
                subpart = section.getSubpart();
                if (subpart.getSections().size() <= 1 || subpart.getLimit() <= 0) continue;
                averageSize = (double)subpart.getLimit() / (double)subpart.getSections().size();
                if ((double)section.getLimit() < averageSize) {
                    currentUnavailableSize += (averageSize - (double)section.getLimit()) / averageSize;
                }
                ++currentAltSectionsWithLimit;
            }
        }
        double bestUnavailableSizeFraction = bestUnavailableSize > 0.0 ? bestUnavailableSize / (double)bestAltSectionsWithLimit : 0.0;
        double d = currentUnavailableSizeFraction = currentUnavailableSize > 0.0 ? currentUnavailableSize / (double)currentAltSectionsWithLimit : 0.0;
        if (currentUnavailableSizeFraction < bestUnavailableSizeFraction) {
            return true;
        }
        if (bestUnavailableSizeFraction < currentUnavailableSizeFraction) {
            return false;
        }
        double bestPenalty = 0.0;
        double currentPenalty = 0.0;
        for (int idx = 0; idx < current.length; ++idx) {
            if (best[idx] != null) {
                for (Section section : best[idx].getSections()) {
                    bestPenalty += section.getPenalty();
                }
                if (idx >= maxIdx && best[idx].isCourseRequest()) {
                    bestPenalty -= ((CourseRequest)best[idx].getRequest()).getMinPenalty();
                }
            }
            if (current[idx] == null || idx >= maxIdx) continue;
            for (Section section : current[idx].getSections()) {
                currentPenalty += section.getPenalty();
            }
        }
        if (currentPenalty < bestPenalty) {
            return true;
        }
        return !(bestPenalty < currentPenalty);
    }
}

