/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.criteria;

import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.ifs.criteria.AbstractCriterion;
import org.cpsolver.ifs.solver.Solver;

public abstract class TimetablingCriterion
extends AbstractCriterion<Lecture, Placement> {
    private double[] iPlacementSelectionWeight = null;
    private Double[][] iPlacementSelectionAdjusts = null;

    @Override
    public boolean init(Solver<Lecture, Placement> solver) {
        super.init(solver);
        if (this.getPlacementSelectionWeightName() != null) {
            int i;
            this.iPlacementSelectionWeight = new double[]{0.0, 0.0, 0.0};
            for (i = 0; i < 3; ++i) {
                this.iPlacementSelectionWeight[i] = solver.getProperties().getPropertyDouble(this.getPlacementSelectionWeightName() + (1 + i), this.getPlacementSelectionWeightDefault(i));
            }
            this.iPlacementSelectionAdjusts = new Double[][]{null, null, null};
            for (i = 0; i < 3; ++i) {
                this.iPlacementSelectionAdjusts[i] = solver.getProperties().getPropertyDoubleArry(this.getPlacementSelectionAdjustmentsName() + (1 + i), solver.getProperties().getPropertyDoubleArry(this.getPlacementSelectionAdjustmentsName(), null));
            }
        }
        return true;
    }

    public String getPlacementSelectionWeightName() {
        return "Placement." + this.getClass().getName().substring(1 + this.getClass().getName().lastIndexOf(46)) + "Weight";
    }

    public String getPlacementSelectionAdjustmentsName() {
        return this.getPlacementSelectionWeightName() + "Adjustments";
    }

    public double getPlacementSelectionWeight(int level, int idx) {
        double w;
        double d = w = this.iPlacementSelectionWeight == null ? 0.0 : this.iPlacementSelectionWeight[level];
        if (idx < 0 || this.iPlacementSelectionAdjusts == null || this.iPlacementSelectionAdjusts[level] == null || idx >= this.iPlacementSelectionAdjusts[level].length || this.iPlacementSelectionAdjusts[level][idx] == null) {
            return w;
        }
        return w * this.iPlacementSelectionAdjusts[level][idx];
    }

    public double getPlacementSelectionWeightDefault(int level) {
        return level <= 1 ? this.getWeight() : 0.0;
    }
}

