/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett;

import org.apache.log4j.Logger;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.Callback;

public abstract class TimetableSaver
implements Runnable {
    private Solver<Lecture, Placement> iSolver = null;
    private Callback iCallback = null;

    public TimetableSaver(Solver<Lecture, Placement> solver) {
        this.iSolver = solver;
    }

    public Solver<Lecture, Placement> getSolver() {
        return this.iSolver;
    }

    protected Solution<Lecture, Placement> getSolution() {
        return this.iSolver.currentSolution();
    }

    protected TimetableModel getModel() {
        return (TimetableModel)this.iSolver.currentSolution().getModel();
    }

    public Assignment<Lecture, Placement> getAssignment() {
        return this.getSolution().getAssignment();
    }

    public abstract void save() throws Exception;

    public void setCallback(Callback callback) {
        this.iCallback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.save();
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass()).error(e.getMessage(), e);
        }
        finally {
            if (this.iCallback != null) {
                this.iCallback.execute();
            }
        }
    }
}

