/*
 * Decompiled with CFR 0.152.
 */
package biweekly.util;

import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Duration {
    private final Integer weeks;
    private final Integer days;
    private final Integer hours;
    private final Integer minutes;
    private final Integer seconds;
    private final boolean prior;

    private Duration(Builder b) {
        this.weeks = b.weeks;
        this.days = b.days;
        this.hours = b.hours;
        this.minutes = b.minutes;
        this.seconds = b.seconds;
        this.prior = b.prior;
    }

    public static Duration parse(String value) {
        if (!value.matches("-?P.*")) {
            throw new IllegalArgumentException("Invalid duration string: " + value);
        }
        return Duration.builder().prior(value.startsWith("-")).weeks(Duration.parseComponent(value, 'W')).days(Duration.parseComponent(value, 'D')).hours(Duration.parseComponent(value, 'H')).minutes(Duration.parseComponent(value, 'M')).seconds(Duration.parseComponent(value, 'S')).build();
    }

    public static Duration diff(Date start, Date end) {
        return Duration.fromMillis(end.getTime() - start.getTime());
    }

    public static Duration fromMillis(long milliseconds) {
        Integer minutes;
        Integer hours;
        Integer days;
        int seconds;
        Integer weeks;
        Builder builder = Duration.builder();
        if (milliseconds < 0L) {
            builder.prior(true);
            milliseconds *= -1L;
        }
        if ((weeks = Integer.valueOf((seconds = (int)(milliseconds / 1000L)) / 604800)) > 0) {
            builder.weeks(weeks);
        }
        if ((days = Integer.valueOf((seconds %= 604800) / 86400)) > 0) {
            builder.days(days);
        }
        if ((hours = Integer.valueOf((seconds %= 86400) / 3600)) > 0) {
            builder.hours(hours);
        }
        if ((minutes = Integer.valueOf((seconds %= 3600) / 60)) > 0) {
            builder.minutes(minutes);
        }
        if ((seconds %= 60) > 0) {
            builder.seconds(seconds);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static Integer parseComponent(String value, char ch) {
        Pattern p = Pattern.compile("(\\d+)" + ch);
        Matcher m = p.matcher(value);
        return m.find() ? Integer.valueOf(m.group(1)) : null;
    }

    public boolean isPrior() {
        return this.prior;
    }

    public Integer getWeeks() {
        return this.weeks;
    }

    public Integer getDays() {
        return this.days;
    }

    public Integer getHours() {
        return this.hours;
    }

    public Integer getMinutes() {
        return this.minutes;
    }

    public Integer getSeconds() {
        return this.seconds;
    }

    public Date add(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        if (this.weeks != null) {
            int weeks = this.weeks * (this.prior ? -1 : 1);
            c.add(5, weeks * 7);
        }
        if (this.days != null) {
            int days = this.days * (this.prior ? -1 : 1);
            c.add(5, days);
        }
        if (this.hours != null) {
            int hours = this.hours * (this.prior ? -1 : 1);
            c.add(11, hours);
        }
        if (this.minutes != null) {
            int minutes = this.minutes * (this.prior ? -1 : 1);
            c.add(12, minutes);
        }
        if (this.seconds != null) {
            int seconds = this.seconds * (this.prior ? -1 : 1);
            c.add(13, seconds);
        }
        return c.getTime();
    }

    public long toMillis() {
        long totalSeconds = 0L;
        if (this.weeks != null) {
            totalSeconds += 604800L * (long)this.weeks.intValue();
        }
        if (this.days != null) {
            totalSeconds += 86400L * (long)this.days.intValue();
        }
        if (this.hours != null) {
            totalSeconds += 3600L * (long)this.hours.intValue();
        }
        if (this.minutes != null) {
            totalSeconds += 60L * (long)this.minutes.intValue();
        }
        if (this.seconds != null) {
            totalSeconds += (long)this.seconds.intValue();
        }
        if (this.prior) {
            totalSeconds *= -1L;
        }
        return totalSeconds * 1000L;
    }

    public boolean hasTime() {
        return this.hours != null || this.minutes != null || this.seconds != null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.days == null ? 0 : this.days.hashCode());
        result = 31 * result + (this.hours == null ? 0 : this.hours.hashCode());
        result = 31 * result + (this.minutes == null ? 0 : this.minutes.hashCode());
        result = 31 * result + (this.prior ? 1231 : 1237);
        result = 31 * result + (this.seconds == null ? 0 : this.seconds.hashCode());
        result = 31 * result + (this.weeks == null ? 0 : this.weeks.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Duration other = (Duration)obj;
        if (this.days == null ? other.days != null : !this.days.equals(other.days)) {
            return false;
        }
        if (this.hours == null ? other.hours != null : !this.hours.equals(other.hours)) {
            return false;
        }
        if (this.minutes == null ? other.minutes != null : !this.minutes.equals(other.minutes)) {
            return false;
        }
        if (this.prior != other.prior) {
            return false;
        }
        if (this.seconds == null ? other.seconds != null : !this.seconds.equals(other.seconds)) {
            return false;
        }
        return !(this.weeks == null ? other.weeks != null : !this.weeks.equals(other.weeks));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.prior) {
            sb.append('-');
        }
        sb.append('P');
        if (this.weeks != null) {
            sb.append(this.weeks).append('W');
        }
        if (this.days != null) {
            sb.append(this.days).append('D');
        }
        if (this.hasTime()) {
            sb.append('T');
            if (this.hours != null) {
                sb.append(this.hours).append('H');
            }
            if (this.minutes != null) {
                sb.append(this.minutes).append('M');
            }
            if (this.seconds != null) {
                sb.append(this.seconds).append('S');
            }
        }
        return sb.toString();
    }

    public static class Builder {
        private Integer weeks;
        private Integer days;
        private Integer hours;
        private Integer minutes;
        private Integer seconds;
        private boolean prior = false;

        public Builder() {
        }

        public Builder(Duration source) {
            this.weeks = source.weeks;
            this.days = source.days;
            this.hours = source.hours;
            this.minutes = source.minutes;
            this.seconds = source.seconds;
            this.prior = source.prior;
        }

        public Builder weeks(Integer weeks) {
            this.weeks = weeks;
            return this;
        }

        public Builder days(Integer days) {
            this.days = days;
            return this;
        }

        public Builder hours(Integer hours) {
            this.hours = hours;
            return this;
        }

        public Builder minutes(Integer minutes) {
            this.minutes = minutes;
            return this;
        }

        public Builder seconds(Integer seconds) {
            this.seconds = seconds;
            return this;
        }

        public Builder prior(boolean prior) {
            this.prior = prior;
            return this;
        }

        public Duration build() {
            return new Duration(this);
        }
    }
}

