/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.property;

import biweekly.ICalDataType;
import biweekly.Warning;
import biweekly.io.CannotParseException;
import biweekly.io.json.JCalValue;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.io.xml.XCalElement;
import biweekly.parameter.ICalParameters;
import biweekly.property.Trigger;
import biweekly.util.Duration;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TriggerScribe
extends ICalPropertyScribe<Trigger> {
    public TriggerScribe() {
        super(Trigger.class, "TRIGGER", ICalDataType.DURATION);
    }

    @Override
    protected ICalDataType _dataType(Trigger property) {
        return property.getDate() == null ? ICalDataType.DURATION : ICalDataType.DATE_TIME;
    }

    @Override
    protected String _writeText(Trigger property) {
        Duration duration = property.getDuration();
        if (duration != null) {
            return duration.toString();
        }
        Date date = property.getDate();
        if (date != null) {
            return TriggerScribe.date(date).write();
        }
        return "";
    }

    @Override
    protected Trigger _parseText(String value, ICalDataType dataType, ICalParameters parameters, List<Warning> warnings) {
        value = TriggerScribe.unescape(value);
        try {
            Date date = TriggerScribe.date(value).tzid(parameters.getTimezoneId(), warnings).parse();
            return new Trigger(date);
        }
        catch (IllegalArgumentException e) {
            try {
                return new Trigger(Duration.parse(value), parameters.getRelated());
            }
            catch (IllegalArgumentException e2) {
                throw new CannotParseException(25, new Object[0]);
            }
        }
    }

    @Override
    protected void _writeXml(Trigger property, XCalElement element) {
        Duration duration = property.getDuration();
        if (duration != null) {
            element.append(ICalDataType.DURATION, duration.toString());
            return;
        }
        Date date = property.getDate();
        if (date != null) {
            element.append(ICalDataType.DATE_TIME, TriggerScribe.date(date).extended(true).write());
            return;
        }
        element.append(this.defaultDataType, "");
    }

    @Override
    protected Trigger _parseXml(XCalElement element, ICalParameters parameters, List<Warning> warnings) {
        String value = element.first(ICalDataType.DURATION);
        if (value != null) {
            try {
                return new Trigger(Duration.parse(value), parameters.getRelated());
            }
            catch (IllegalArgumentException e) {
                throw new CannotParseException(26, value);
            }
        }
        value = element.first(ICalDataType.DATE_TIME);
        if (value != null) {
            try {
                Date date = TriggerScribe.date(value).tzid(parameters.getTimezoneId(), warnings).parse();
                return new Trigger(date);
            }
            catch (IllegalArgumentException e) {
                throw new CannotParseException(27, value);
            }
        }
        throw TriggerScribe.missingXmlElements(ICalDataType.DURATION, ICalDataType.DATE_TIME);
    }

    @Override
    protected JCalValue _writeJson(Trigger property) {
        Duration duration = property.getDuration();
        if (duration != null) {
            return JCalValue.single(duration.toString());
        }
        Date date = property.getDate();
        if (date != null) {
            return JCalValue.single(TriggerScribe.date(date).extended(true).write());
        }
        return JCalValue.single("");
    }

    @Override
    protected Trigger _parseJson(JCalValue value, ICalDataType dataType, ICalParameters parameters, List<Warning> warnings) {
        String valueStr = value.asSingle();
        try {
            Date date = TriggerScribe.date(valueStr).tzid(parameters.getTimezoneId(), warnings).parse();
            return new Trigger(date);
        }
        catch (IllegalArgumentException e) {
            try {
                return new Trigger(Duration.parse(valueStr), parameters.getRelated());
            }
            catch (IllegalArgumentException e2) {
                throw new CannotParseException(25, new Object[0]);
            }
        }
    }
}

