/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.property;

import biweekly.ICalDataType;
import biweekly.Warning;
import biweekly.io.CannotParseException;
import biweekly.io.json.JCalValue;
import biweekly.io.scribe.property.ListPropertyScribe;
import biweekly.io.xml.XCalElement;
import biweekly.parameter.ICalParameters;
import biweekly.property.ExceptionDates;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionDatesScribe
extends ListPropertyScribe<ExceptionDates, Date> {
    public ExceptionDatesScribe() {
        super(ExceptionDates.class, "EXDATE", ICalDataType.DATE_TIME);
    }

    @Override
    protected ICalDataType _dataType(ExceptionDates property) {
        return property.hasTime() ? ICalDataType.DATE_TIME : ICalDataType.DATE;
    }

    @Override
    protected ExceptionDates newInstance(ICalDataType dataType, ICalParameters parameters) {
        return new ExceptionDates(dataType != ICalDataType.DATE);
    }

    @Override
    protected String writeValue(ExceptionDates property, Date value) {
        return ExceptionDatesScribe.date(value).time(property.hasTime()).tzid(property.getParameters().getTimezoneId()).write();
    }

    @Override
    protected Date readValue(String value, ICalDataType dataType, ICalParameters parameters, List<Warning> warnings) {
        try {
            return ExceptionDatesScribe.date(value).tzid(parameters.getTimezoneId(), warnings).parse();
        }
        catch (IllegalArgumentException e) {
            throw new CannotParseException(19, new Object[0]);
        }
    }

    @Override
    protected void _writeXml(ExceptionDates property, XCalElement element) {
        ICalDataType dataType = this.dataType(property);
        for (Date value : property.getValues()) {
            String dateStr = ExceptionDatesScribe.date(value).time(property.hasTime()).tzid(property.getParameters().getTimezoneId()).extended(true).write();
            element.append(dataType, dateStr);
        }
    }

    @Override
    protected ExceptionDates _parseXml(XCalElement element, ICalParameters parameters, List<Warning> warnings) {
        List<String> values = element.all(ICalDataType.DATE_TIME);
        ICalDataType dataType = values.isEmpty() ? ICalDataType.DATE : ICalDataType.DATE_TIME;
        values.addAll(element.all(ICalDataType.DATE));
        if (values.isEmpty()) {
            throw ExceptionDatesScribe.missingXmlElements(ICalDataType.DATE_TIME, ICalDataType.DATE);
        }
        ExceptionDates prop = new ExceptionDates(dataType == ICalDataType.DATE_TIME);
        for (String value : values) {
            Object date = this.readValue(value, dataType, parameters, (List)warnings);
            prop.addValue(date);
        }
        return prop;
    }

    @Override
    protected JCalValue _writeJson(ExceptionDates property) {
        List values = property.getValues();
        if (values.isEmpty()) {
            return JCalValue.single("");
        }
        ArrayList<String> valuesStr = new ArrayList<String>();
        for (Date value : values) {
            String dateStr = ExceptionDatesScribe.date(value).time(property.hasTime()).tzid(property.getParameters().getTimezoneId()).extended(true).write();
            valuesStr.add(dateStr);
        }
        return JCalValue.multi(valuesStr);
    }

    @Override
    protected ExceptionDates _parseJson(JCalValue value, ICalDataType dataType, ICalParameters parameters, List<Warning> warnings) {
        List<String> valueStrs = value.asMulti();
        ExceptionDates prop = new ExceptionDates(dataType == ICalDataType.DATE_TIME);
        for (String valueStr : valueStrs) {
            Object date = this.readValue(valueStr, dataType, parameters, (List)warnings);
            prop.addValue(date);
        }
        return prop;
    }
}

