/*
 * Decompiled with CFR 0.152.
 */
package biweekly.component;

import biweekly.Warning;
import biweekly.component.ICalComponent;
import biweekly.property.Comment;
import biweekly.property.DateStart;
import biweekly.property.ExceptionDates;
import biweekly.property.RecurrenceDates;
import biweekly.property.RecurrenceRule;
import biweekly.property.TimezoneName;
import biweekly.property.TimezoneOffsetFrom;
import biweekly.property.TimezoneOffsetTo;
import biweekly.util.DateTimeComponents;
import biweekly.util.Recurrence;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Observance
extends ICalComponent {
    public DateStart getDateStart() {
        return this.getProperty(DateStart.class);
    }

    public void setDateStart(DateStart dateStart) {
        if (dateStart != null) {
            dateStart.setLocalTime(true);
        }
        this.setProperty(DateStart.class, dateStart);
    }

    public DateStart setDateStart(DateTimeComponents components) {
        DateStart prop = components == null ? null : new DateStart(components);
        this.setDateStart(prop);
        return prop;
    }

    public TimezoneOffsetTo getTimezoneOffsetTo() {
        return this.getProperty(TimezoneOffsetTo.class);
    }

    public void setTimezoneOffsetTo(TimezoneOffsetTo timezoneOffsetTo) {
        this.setProperty(TimezoneOffsetTo.class, timezoneOffsetTo);
    }

    public TimezoneOffsetTo setTimezoneOffsetTo(Integer hour, Integer minute) {
        TimezoneOffsetTo prop = new TimezoneOffsetTo(hour, minute);
        this.setTimezoneOffsetTo(prop);
        return prop;
    }

    public TimezoneOffsetFrom getTimezoneOffsetFrom() {
        return this.getProperty(TimezoneOffsetFrom.class);
    }

    public void setTimezoneOffsetFrom(TimezoneOffsetFrom timezoneOffsetFrom) {
        this.setProperty(TimezoneOffsetFrom.class, timezoneOffsetFrom);
    }

    public TimezoneOffsetFrom setTimezoneOffsetFrom(Integer hour, Integer minute) {
        TimezoneOffsetFrom prop = new TimezoneOffsetFrom(hour, minute);
        this.setTimezoneOffsetFrom(prop);
        return prop;
    }

    public RecurrenceRule getRecurrenceRule() {
        return this.getProperty(RecurrenceRule.class);
    }

    public RecurrenceRule setRecurrenceRule(Recurrence recur) {
        RecurrenceRule prop = recur == null ? null : new RecurrenceRule(recur);
        this.setRecurrenceRule(prop);
        return prop;
    }

    public void setRecurrenceRule(RecurrenceRule recurrenceRule) {
        this.setProperty(RecurrenceRule.class, recurrenceRule);
    }

    public List<Comment> getComments() {
        return this.getProperties(Comment.class);
    }

    public void addComment(Comment comment) {
        this.addProperty(comment);
    }

    public Comment addComment(String comment) {
        Comment prop = new Comment(comment);
        this.addComment(prop);
        return prop;
    }

    public List<RecurrenceDates> getRecurrenceDates() {
        return this.getProperties(RecurrenceDates.class);
    }

    public void addRecurrenceDates(RecurrenceDates recurrenceDates) {
        this.addProperty(recurrenceDates);
    }

    public List<TimezoneName> getTimezoneNames() {
        return this.getProperties(TimezoneName.class);
    }

    public void addTimezoneName(TimezoneName timezoneName) {
        this.addProperty(timezoneName);
    }

    public TimezoneName addTimezoneName(String timezoneName) {
        TimezoneName prop = new TimezoneName(timezoneName);
        this.addTimezoneName(prop);
        return prop;
    }

    public List<ExceptionDates> getExceptionDates() {
        return this.getProperties(ExceptionDates.class);
    }

    public void addExceptionDates(ExceptionDates exceptionDates) {
        this.addProperty(exceptionDates);
    }

    @Override
    protected void validate(List<ICalComponent> components, List<Warning> warnings) {
        this.checkRequiredCardinality(warnings, DateStart.class, TimezoneOffsetTo.class, TimezoneOffsetFrom.class);
        DateStart dateStart = this.getDateStart();
        RecurrenceRule rrule = this.getRecurrenceRule();
        if (dateStart != null && rrule != null) {
            Date start = dateStart.getValue();
            Recurrence recur = (Recurrence)rrule.getValue();
            if (!(start == null || recur == null || dateStart.hasTime() || recur.getByHour().isEmpty() && recur.getByMinute().isEmpty() && recur.getBySecond().isEmpty())) {
                warnings.add(Warning.validate(5, new Object[0]));
            }
        }
        if (this.getProperties(RecurrenceRule.class).size() > 1) {
            warnings.add(Warning.validate(6, new Object[0]));
        }
    }
}

