/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.webutil;

import java.util.Collection;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.unitime.commons.Debug;
import org.unitime.commons.web.WebTable;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.ItypeDesc;
import org.unitime.timetable.model.SimpleItypeConfig;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.Constants;

public class SchedulingSubpartTableBuilder {
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);

    public static String buildSubpartsTable(HttpServletRequest request, SessionContext context, int limit, String uid, boolean createAsNew, boolean unlimitedEnroll) throws Exception {
        boolean varLimits = "y".equals(request.getParameter("varLimits"));
        Vector sp = (Vector)context.getAttribute(SimpleItypeConfig.CONFIGS_ATTR_NAME);
        boolean autoCalc = true;
        if (!CommonValues.Yes.eq(UserProperty.ConfigAutoCalc.get(context.getUser()))) {
            autoCalc = false;
        }
        Collection extDepts = (Collection)request.getAttribute(Department.EXTERNAL_DEPT_ATTR_NAME);
        String extDeptsOption = "<OPTION value='-1'>Department</OPTION>";
        for (Department d : extDepts) {
            extDeptsOption = extDeptsOption + "<OPTION value='" + d.getUniqueId().toString() + "'>" + d.getManagingDeptLabel() + "</OPTION>";
        }
        if (sp != null && sp.size() > 0) {
            if (!varLimits) {
                for (int i = 0; i < sp.size(); ++i) {
                    SimpleItypeConfig sic = (SimpleItypeConfig)sp.elementAt(i);
                    if (!SchedulingSubpartTableBuilder.hasVarLimitsInSubpart(request, sic)) continue;
                    varLimits = true;
                    break;
                }
            }
            WebTable tbl = new WebTable(9, "", new String[]{unlimitedEnroll ? "" : "<<00>>", "&nbsp;", !varLimits ? "<<1>>" : MSG.columnSubpartMinLimitPerClass(), !varLimits ? "<<11>>" : MSG.columnSubpartMaxLimitPerClass(), MSG.columnSubpartNumberOfClasses(), MSG.columnSubpartMinutesPerWeek(), MSG.columnSubpartNumberOfRooms(), MSG.columnSubpartRoomRatio(), MSG.columnSubpartManagingDepartment()}, new String[]{"left", "left", "center", "center", "center", "center", "center", "center", "center"}, null);
            tbl.setSuppressRowHighlight(true);
            for (int i = 0; i < sp.size(); ++i) {
                SimpleItypeConfig sic = (SimpleItypeConfig)sp.elementAt(i);
                SchedulingSubpartTableBuilder.setupSubpart(request, context, sic, 1, tbl, i, sp.size(), -1, -1, limit, null, autoCalc, createAsNew, extDeptsOption, unlimitedEnroll, varLimits);
            }
            request.setAttribute("subpartsExist", (Object)"true");
            String varLimitsCheckBox = "<input type='checkbox' name='varLimits' value='y' <<0>>" + (varLimits ? "checked" : "") + " onClick=\"doClick('multipleLimits', 0);\"> <small>Allow variable limits</small>";
            String tblStr = tbl.printTable();
            if (request.getAttribute("varLimits") != null) {
                tblStr = tblStr.replaceAll("<<00>>", varLimitsCheckBox);
                tblStr = tblStr.replaceAll("<<0>>", "checked");
                tblStr = tblStr.replaceAll("<<1>>", MSG.columnSubpartMinLimitPerClass());
                tblStr = tblStr.replaceAll("<<11>>", MSG.columnSubpartMaxLimitPerClass());
            } else {
                if (CommonValues.Yes.eq(UserProperty.VariableClassLimits.get(context.getUser()))) {
                    tblStr = tblStr.replaceAll("<<00>>", varLimitsCheckBox);
                    tblStr = tblStr.replaceAll("<<0>>", " ");
                } else {
                    tblStr = tblStr.replaceAll("<<00>>", " ");
                }
                tblStr = tblStr.replaceAll("<<1>>", " ");
                tblStr = tblStr.replaceAll("<<11>>", MSG.columnSubpartLimitPerClass());
            }
            return tblStr;
        }
        request.setAttribute("subpartsExist", (Object)"false");
        return "";
    }

    private static boolean hasVarLimitsInSubpart(HttpServletRequest request, SimpleItypeConfig sic) {
        int mxlpc;
        int mnlpc;
        if (request.getParameter("mnlpc" + sic.getId()) != null) {
            sic.setMinLimitPerClass(Constants.getPositiveInteger(request.getParameter("mnlpc" + sic.getId()), -1));
        }
        if (request.getParameter("mxlpc" + sic.getId()) != null) {
            sic.setMaxLimitPerClass(Constants.getPositiveInteger(request.getParameter("mxlpc" + sic.getId()), -1));
        }
        if ((mnlpc = sic.getMinLimitPerClass()) != (mxlpc = sic.getMaxLimitPerClass())) {
            return true;
        }
        Vector v = sic.getSubparts();
        for (int i = 0; i < v.size(); ++i) {
            SimpleItypeConfig sic1 = (SimpleItypeConfig)v.elementAt(i);
            if (!SchedulingSubpartTableBuilder.hasVarLimitsInSubpart(request, sic1)) continue;
            return true;
        }
        return false;
    }

    private static void setupSubpart(HttpServletRequest request, SessionContext context, SimpleItypeConfig sic, int level, WebTable tbl, int rowNum, int maxRows, int spRowNum, int maxSp, int limit, SimpleItypeConfig parentSic, boolean autoCalc, boolean createAsNew, String extDepts, boolean unlimitedEnroll, boolean varLimits) throws Exception {
        int i;
        ItypeDesc itype = sic.getItype();
        if (request.getParameter("mnlpc" + sic.getId()) != null) {
            sic.setMinLimitPerClass(Constants.getPositiveInteger(request.getParameter("mnlpc" + sic.getId()), -1));
        }
        if (request.getParameter("mxlpc" + sic.getId()) != null) {
            sic.setMaxLimitPerClass(Constants.getPositiveInteger(request.getParameter("mxlpc" + sic.getId()), -1));
        }
        if (request.getParameter("mpw" + sic.getId()) != null) {
            sic.setMinPerWeek(Constants.getPositiveInteger(request.getParameter("mpw" + sic.getId()), -1));
        }
        if (request.getParameter("nc" + sic.getId()) != null) {
            sic.setNumClasses(Constants.getPositiveInteger(request.getParameter("nc" + sic.getId()), -1));
        }
        if (request.getParameter("nr" + sic.getId()) != null) {
            sic.setNumRooms(Constants.getPositiveInteger(request.getParameter("nr" + sic.getId()), -1));
        }
        if (request.getParameter("rr" + sic.getId()) != null) {
            sic.setRoomRatio(Constants.getPositiveFloat(request.getParameter("rr" + sic.getId()), 1.0f));
        }
        if (request.getParameter("md" + sic.getId()) != null) {
            sic.setManagingDeptId(Long.parseLong(request.getParameter("md" + sic.getId())));
        }
        if (request.getParameter("disabled" + sic.getId()) != null) {
            sic.setDisabled(new Boolean(request.getParameter("disabled" + sic.getId())));
        }
        int mnlpc = sic.getMinLimitPerClass();
        int mxlpc = sic.getMaxLimitPerClass();
        int mpw = sic.getMinPerWeek();
        int nc = sic.getNumClasses();
        int nr = sic.getNumRooms();
        float rr = sic.getRoomRatio();
        long md = sic.getManagingDeptId();
        long subpartId = -1L;
        if (!createAsNew) {
            subpartId = sic.getSubpartId();
        }
        long sicId = sic.getId();
        boolean disabled = sic.isDisabled();
        boolean notOwned = sic.isNotOwned();
        boolean hasError = sic.getHasError();
        boolean uDisabled = unlimitedEnroll;
        Vector v = sic.getSubparts();
        boolean mgrDisabled = false;
        if (subpartId >= 0L && !context.hasPermission(Long.valueOf(subpartId), "SchedulingSubpart", Right.InstrOfferingConfigEditSubpart)) {
            mgrDisabled = true;
            if (createAsNew) {
                md = -1L;
            }
        }
        if (unlimitedEnroll) {
            mnlpc = -1;
            mxlpc = -1;
            nr = -1;
            rr = -1.0f;
        }
        Debug.debug("setting up subpart: " + itype.getAbbv() + ", Level: " + level);
        String onBlur1 = "";
        String onBlur2 = "";
        String maxClasses = "if ( document.forms[0].nc" + sicId + ".value > 999) { document.forms[0].nc" + sicId + ".value=0 } ";
        if (autoCalc) {
            onBlur1 = " onBlur=\"if (this.value!=0 && (document.forms[0].mxlpc" + sicId + ".value==''|| document.forms[0].mxlpc" + sicId + ".value==null) ) {" + " document.forms[0].mxlpc" + sicId + ".value=this.value; }\"";
            onBlur2 = parentSic != null ? " onBlur=\"if (this.value!=0) { document.forms[0].nc" + sicId + ".value=Math.ceil( (document.forms[0].mxlpc" + parentSic.getId() + ".value * document.forms[0].nc" + parentSic.getId() + ".value) / this.value ); " + maxClasses + " } " : " onBlur=\"if (this.value!=0) { document.forms[0].nc" + sicId + ".value=Math.ceil(document.forms[0].limit.value/this.value); " + maxClasses + "} ";
        }
        onBlur2 = !varLimits ? (onBlur2.length() == 0 ? "onBlur=\"document.forms[0].mnlpc" + sicId + ".value=this.value; \"" : onBlur2 + "document.forms[0].mnlpc" + sicId + ".value=this.value; \"") : onBlur2 + "\"";
        String indent = "";
        for (i = 1; i < level; ++i) {
            indent = indent + "\n<IMG width=\"16\" align=\"absmiddle\" src=\"images/blank.png\">";
        }
        if (indent.length() != 0) {
            indent = indent + "\n<IMG align=\"absmiddle\" src=\"images/indent.png\">&nbsp;";
        }
        if (!varLimits && mnlpc != mxlpc) {
            if (mnlpc == -1) {
                mnlpc = mxlpc;
            } else {
                request.setAttribute("varLimits", (Object)"1");
            }
        }
        String[] stringArray = new String[9];
        stringArray[0] = indent + "<span style='font-weight:bold;'>" + itype.getDesc() + "</span>" + (hasError ? "&nbsp; <IMG align=\"absmiddle\" src=\"images/cancel.png\">" : "");
        stringArray[1] = !disabled ? SchedulingSubpartTableBuilder.getIcons(sic, level, rowNum, maxRows, spRowNum, maxSp) : (notOwned ? "<img align=\"absmiddle\" border=\"0\" src=\"images/lock.png\">" : "");
        stringArray[2] = "\n\t <INPUT type=\"hidden\" name=\"subpartId" + sicId + "\" value=\"" + subpartId + "\">" + "\n\t <INPUT type=\"hidden\" name=\"disabled" + sicId + "\" value=\"" + disabled + "\">" + (disabled || uDisabled || !varLimits && mnlpc == mxlpc ? "\n\t<INPUT  name=\"mnlpc" + sicId + "\" type=\"hidden\" value=\"" + (mnlpc >= 0 ? "" + mnlpc : "") + "\"" + " >" + ((disabled || uDisabled) && mnlpc >= 0 && varLimits || !varLimits && mnlpc != mxlpc ? "" + mnlpc : "") : "\n\t<INPUT  name=\"mnlpc" + sicId + "\" type=\"text\" size=\"4\" maxlength=\"4\" value=\"" + (mnlpc >= 0 ? "" + mnlpc : "") + "\"" + onBlur1 + " >");
        String string = disabled || uDisabled ? "\n\t<INPUT  name=\"mxlpc" + sicId + "\" type=\"hidden\" value=\"" + (mxlpc >= 0 ? "" + mxlpc : "") + "\"" + " >" + (mxlpc >= 0 ? "" + mxlpc : "") : (stringArray[3] = "\n\t<INPUT  name=\"mxlpc" + sicId + "\" type=\"text\" size=\"4\" maxlength=\"4\" value=\"" + (mxlpc >= 0 ? "" + mxlpc : "") + "\"" + onBlur2 + " >");
        String string2 = disabled ? "\n\t<INPUT  name=\"nc" + sicId + "\" type=\"hidden\" value=\"" + (nc >= 0 ? "" + nc : "") + "\">" + (nc >= 0 ? "" + nc : "") : (stringArray[4] = "\n\t<INPUT  name=\"nc" + sicId + "\" type=\"text\" size=\"3\" maxlength=\"3\" value=\"" + (nc >= 0 ? "" + nc : "") + "\" onblur=\"if (!confirmNumClasses(this.value)) { this.value = 0 }\">");
        String string3 = disabled ? "\n\t<INPUT  name=\"mpw" + sicId + "\" type=\"hidden\" value=\"" + (mpw >= 0 ? "" + mpw : "") + "\">" + (mpw >= 0 ? "" + mpw : "") : (stringArray[5] = "\n\t<INPUT  name=\"mpw" + sicId + "\" type=\"text\" size=\"4\" maxlength=\"4\" value=\"" + (mpw >= 0 ? "" + mpw : "") + "\">");
        String string4 = disabled || uDisabled ? "\n\t<INPUT  name=\"nr" + sicId + "\" type=\"hidden\" value=\"" + (nr >= 0 ? "" + nr : "") + "\">" + (nr >= 0 ? "" + nr : "") : (stringArray[6] = "\n\t<INPUT  name=\"nr" + sicId + "\" type=\"text\" size=\"4\" maxlength=\"2\" value=\"" + (nr >= 0 ? "" + nr : "") + "\">");
        stringArray[7] = disabled || uDisabled ? "\n\t<INPUT  name=\"rr" + sicId + "\" type=\"hidden\" value=\"" + (rr >= 0.0f ? "" + rr : "") + "\">" + (rr >= 0.0f ? "" + rr : "") : "\n\t<INPUT  name=\"rr" + sicId + "\" type=\"text\" size=\"4\" maxlength=\"4\" value=\"" + (rr >= 0.0f ? "" + rr : "") + "\">";
        stringArray[8] = disabled || mgrDisabled ? "\n\t<INPUT  name=\"md" + sicId + "\" type=\"hidden\" value=\"" + md + "\">" + SchedulingSubpartTableBuilder.getManagingDeptLabel(request, md) : "\n\t<SELECT  name=\"md" + sicId + "\">" + extDepts.replaceAll("'" + md + "'", "'" + md + "' selected") + "</SELECT>";
        tbl.addLine(stringArray, null);
        for (i = 0; i < v.size(); ++i) {
            SimpleItypeConfig sic1 = (SimpleItypeConfig)v.elementAt(i);
            SchedulingSubpartTableBuilder.setupSubpart(request, context, sic1, level + 1, tbl, rowNum, maxRows, i, v.size(), limit, sic, autoCalc, createAsNew, extDepts, unlimitedEnroll, varLimits);
        }
    }

    private static String getManagingDeptLabel(HttpServletRequest request, long md) {
        if (md < 0L) {
            return "Department";
        }
        if (md == 0L) {
            return "Multiple Departments";
        }
        Department d = (Department)new DepartmentDAO().get(new Long(md));
        if (d != null) {
            if (d.isExternalManager().booleanValue()) {
                return d.getExternalMgrLabel();
            }
            return "Department";
        }
        return "Not Found";
    }

    private static String getIcons(SimpleItypeConfig sic, int level, int rowNum, int maxRows, int spRowNum, int maxSp) {
        String html = "";
        html = level == 1 && rowNum > 0 || level > 1 && spRowNum > 0 ? html + "<IMG border=\"0\" alt=\"" + MSG.titleMoveToChildLevel() + "\" title=\"" + MSG.titleMoveToChildLevel() + "\" align=\"absmiddle\" src=\"images/arrow_right.png\" " + "onClick=\"doClick('shiftRight', " + sic.getId() + ");\" onMouseOver=\"this.style.cursor='hand';this.style.cursor='pointer';\">" : html + "<IMG align=\"top\" src=\"images/blank.png\">";
        html = level > 1 ? html + "<IMG border=\"0\" alt=\"" + MSG.titleMoveToParentLevel() + "\" title=\"" + MSG.titleMoveToParentLevel() + "\" align=\"absmiddle\" src=\"images/arrow_left.png\" " + "onClick=\"doClick('shiftLeft', " + sic.getId() + ");\" onMouseOver=\"this.style.cursor='hand';this.style.cursor='pointer';\">" : html + "<IMG align=\"top\" src=\"images/blank.png\">";
        html = level == 1 && rowNum > 0 || level > 1 && spRowNum > 0 ? html + "<IMG border=\"0\" alt=\"" + MSG.altMoveUp() + "\" align=\"absmiddle\" src=\"images/arrow_up.png\" " + "onClick=\"doClick('shiftUp', " + sic.getId() + ");\" onMouseOver=\"this.style.cursor='hand';this.style.cursor='pointer';\">" : html + "<IMG align=\"absmiddle\" src=\"images/blank.png\">";
        html = level == 1 && rowNum + 1 < maxRows || level > 1 && spRowNum + 1 < maxSp ? html + "<IMG border=\"0\" alt=\"" + MSG.altMoveDown() + "\" align=\"absmiddle\" src=\"images/arrow_down.png\" " + "onClick=\"doClick('shiftDown', " + sic.getId() + ");\" onMouseOver=\"this.style.cursor='hand';this.style.cursor='pointer';\">" : html + "<IMG align=\"absmiddle\" src=\"images/blank.png\">";
        html = html + "<IMG border=\"0\" alt=\"" + MSG.altDelete() + "\" title=\"" + MSG.titleDeleteInstructionalType() + "\" align=\"absmiddle\" src=\"images/action_delete.png\" " + "onClick=\"doClick('delete', " + sic.getId() + ");\" onMouseOver=\"this.style.cursor='hand';this.style.cursor='pointer';\">&nbsp; ";
        html = html + "&nbsp; &nbsp;";
        return html;
    }
}

