/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.webutil;

import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.unitime.commons.web.WebTable;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.model.BuildingPref;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.RoomFeaturePref;
import org.unitime.timetable.model.RoomGroupPref;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.comparators.ClassInstructorComparator;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.webutil.PdfWebTable;
import org.unitime.timetable.webutil.RequiredTimeTable;

public class InstructorListBuilder {
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);

    public String htmlTableForInstructor(SessionContext context, String deptId, int order, String backId) throws Exception {
        int cols = 11;
        boolean timeVertical = RequiredTimeTable.getTimeGridVertical(context.getUser());
        boolean gridAsText = RequiredTimeTable.getTimeGridAsText(context.getUser());
        String timeGridSize = RequiredTimeTable.getTimeGridSize(context.getUser());
        WebTable webTable = new WebTable(cols, "", "instructorList.do?order=%%&deptId=" + deptId, new String[]{MSG.columnExternalId(), MSG.columnInstructorName(), MSG.columnInstructorPosition(), MSG.columnInstructorNote(), MSG.columnPreferences() + "<BR>" + MSG.columnTimePref(), "<BR>" + MSG.columnRoomPref(), "<BR>" + MSG.columnDistributionPref(), MSG.columnInstructorClassAssignments(), MSG.columnInstructorExamAssignments(), MSG.columnInstructorIgnoreTooFar()}, new String[]{"left", "left", "left", "left", "left", "left", "left", "left", "left", "left"}, new boolean[]{true, true, true, true, true, true, true, true, true, true});
        webTable.setRowStyle("white-space:nowrap;");
        webTable.enableHR("#9CB0CE");
        List<DepartmentalInstructor> list = null;
        list = deptId.equals(Constants.ALL_OPTION_VALUE) ? DepartmentalInstructor.findInstructorsForSession(context.getUser().getCurrentAcademicSessionId()) : DepartmentalInstructor.findInstructorsForDepartment(Long.valueOf(deptId));
        if (list == null || list.size() == 0) {
            return null;
        }
        String instructorNameFormat = UserProperty.NameFormat.get(context.getUser());
        String instructorSortOrder = UserProperty.SortNames.get(context.getUser());
        for (DepartmentalInstructor di : list) {
            String puid = "";
            puid = di.getExternalUniqueId() != null && di.getExternalUniqueId().trim().length() > 0 ? di.getExternalUniqueId() : "<center><IMG src='images/error.png' border='0' alt='" + MSG.altNotAvailableExternalId() + "' title='" + MSG.titleInstructorExternalIdNotSupplied() + "'></center>";
            String name = Constants.toInitialCase(di.getName(instructorNameFormat), "-".toCharArray());
            String nameOrd = di.nameLastNameFirst().toLowerCase();
            if (CommonValues.SortAsDisplayed.eq(instructorSortOrder)) {
                nameOrd = name.toLowerCase();
            }
            String posType = MSG.instructorPositionNotSpecified();
            if (di.getPositionType() != null) {
                posType = di.getPositionType().getLabel();
            }
            String note = "";
            if (di.getNote() != null) {
                note = di.getNote();
            }
            String rmPref = "";
            String x = di.getEffectivePrefHtmlForPrefType(RoomPref.class);
            if (x != null && x.trim().length() > 0) {
                rmPref = rmPref + x;
            }
            if ((x = di.getEffectivePrefHtmlForPrefType(BuildingPref.class)) != null && x.trim().length() > 0) {
                if (rmPref.length() > 0) {
                    rmPref = rmPref + "<br>";
                }
                rmPref = rmPref + x;
            }
            if ((x = di.getEffectivePrefHtmlForPrefType(RoomFeaturePref.class)) != null && x.trim().length() > 0) {
                if (rmPref.length() > 0) {
                    rmPref = rmPref + "<br>";
                }
                rmPref = rmPref + x;
            }
            if ((x = di.getEffectivePrefHtmlForPrefType(RoomGroupPref.class)) != null && x.trim().length() > 0) {
                if (rmPref.length() > 0) {
                    rmPref = rmPref + "<br>";
                }
                rmPref = rmPref + x;
            }
            StringBuffer timePref = new StringBuffer();
            if (di.getTimePreferences() != null) {
                try {
                    for (TimePref tp : di.getTimePreferences()) {
                        RequiredTimeTable rtt = tp.getRequiredTimeTable();
                        if (gridAsText) {
                            timePref.append("<span onmouseover=\"showGwtInstructorAvailabilityHint(this, '" + di.getUniqueId() + "');\" onmouseout=\"hideGwtInstructorAvailabilityHint();\">" + rtt.getModel().toString().replaceAll(", ", "<br>") + "</span>");
                            continue;
                        }
                        rtt.getModel().setDefaultSelection(timeGridSize);
                        timePref.append("<img border='0' onmouseover=\"showGwtInstructorAvailabilityHint(this, '" + di.getUniqueId() + "');\" onmouseout=\"hideGwtInstructorAvailabilityHint();\" " + "src='pattern?v=" + (timeVertical ? 1 : 0) + "&s=" + rtt.getModel().getDefaultSelection() + "&p=" + rtt.getModel().getPreferences() + "' title='" + rtt.getModel().toString() + "' >&nbsp;");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            String distPref = di.getEffectivePrefHtmlForPrefType(DistributionPref.class);
            TreeSet<ClassInstructor> classes = new TreeSet<ClassInstructor>(new ClassInstructorComparator(new ClassComparator(2)));
            classes.addAll(di.getClasses());
            String classesStr = "";
            Iterator i = classes.iterator();
            while (i.hasNext()) {
                String className;
                ClassInstructor ci = (ClassInstructor)i.next();
                Class_ c = ci.getClassInstructing();
                String title = className = c.getClassLabel();
                title = title + " (" + ci.getPercentShare() + "%" + (ci.isLead() != false ? ", " + MSG.titleCheckConflicts() : "") + ")";
                if (!c.isDisplayInstructor().booleanValue()) {
                    title = title + " - " + MSG.titleDoNotDisplayInstructor();
                }
                classesStr = ci.isLead() != false ? classesStr + "<span style='font-weight:bold;" + (c.isDisplayInstructor() != false ? "" : "font-style:italic;") + "' title='" + title + "'>" : classesStr + "<span title='" + title + "'>";
                classesStr = classesStr + className;
                classesStr = classesStr + "</span>";
                if (!i.hasNext()) continue;
                classesStr = classesStr + "<br>";
            }
            TreeSet<Exam> exams = new TreeSet<Exam>(di.getExams());
            String examsStr = "";
            Iterator<Exam> i2 = exams.iterator();
            while (i2.hasNext()) {
                Exam exam = i2.next();
                String examName = exam.getLabel();
                examsStr = exam.getExamType().getType() == 1 ? examsStr + "<span title='" + examName + " " + MSG.titleMidtermExamination() + "'>" + examName + "</span>" : examsStr + "<span style='font-weight:bold;' title='" + examName + " " + MSG.titleFinalExamination() + "'>" + examName + "</span>";
                if (!i2.hasNext()) continue;
                examsStr = examsStr + "<br>";
            }
            boolean back = di.getUniqueId().toString().equals(backId);
            boolean itf = di.isIgnoreToFar() == null ? false : di.isIgnoreToFar();
            webTable.addLine("onClick=\"document.location='instructorDetail.do?instructorId=" + di.getUniqueId() + "&deptId=" + deptId + "';\"", new String[]{(back ? "<A name=\"back\"></A>" : "") + puid, name, this.putSpace(posType), this.putSpace(note), this.putSpace(timePref.toString()), this.putSpace(rmPref), this.putSpace(distPref), this.putSpace(classesStr), this.putSpace(examsStr), itf ? "<IMG border='0' title='" + MSG.titleIgnoreTooFarDistances() + "' alt='true' align='absmiddle' src='images/accept.png'>" : "&nbsp;"}, new Comparable[]{puid, nameOrd, posType, null, null, null, null, null, null, new Integer(itf ? 0 : 1)});
        }
        String tblData = webTable.printTable(order);
        return tblData;
    }

    public PdfWebTable pdfTableForInstructor(SessionContext context, String deptId) throws Exception {
        int cols = 10;
        boolean timeVertical = RequiredTimeTable.getTimeGridVertical(context.getUser());
        boolean gridAsText = RequiredTimeTable.getTimeGridAsText(context.getUser());
        String timeGridSize = RequiredTimeTable.getTimeGridSize(context.getUser());
        PdfWebTable webTable = new PdfWebTable(cols, MSG.sectionTitleInstructorList(), null, new String[]{MSG.columnExternalId(), MSG.columnInstructorName(), MSG.columnInstructorPosition(), MSG.columnInstructorNote(), MSG.columnPreferences() + "\n" + MSG.columnTimePref(), "\n" + MSG.columnRoomPref(), "\n" + MSG.columnDistributionPref(), MSG.columnInstructorClassAssignmentsPDF(), MSG.columnInstructorExamAssignmentsPDF(), MSG.columnInstructorIgnoreTooFarPDF()}, new String[]{"left", "left", "left", "left", "left", "left", "left", "left", "left", "left"}, new boolean[]{true, true, true, true, true, true, true, true, true, true});
        List<DepartmentalInstructor> list = null;
        list = deptId.equals(Constants.ALL_OPTION_VALUE) ? DepartmentalInstructor.findInstructorsForSession(context.getUser().getCurrentAcademicSessionId()) : DepartmentalInstructor.findInstructorsForDepartment(Long.valueOf(deptId));
        if (list == null || list.size() == 0) {
            return null;
        }
        String instructorNameFormat = UserProperty.NameFormat.get(context.getUser());
        String instructorSortOrder = UserProperty.SortNames.get(context.getUser());
        for (DepartmentalInstructor di : list) {
            String puid = "";
            puid = di.getExternalUniqueId() != null && di.getExternalUniqueId().trim().length() > 0 ? di.getExternalUniqueId() : "@@ITALIC " + MSG.instructorExternalIdNotSpecified();
            String name = Constants.toInitialCase(di.getName(instructorNameFormat), "-".toCharArray());
            String nameOrd = di.nameLastNameFirst().toLowerCase();
            if (CommonValues.SortAsDisplayed.eq(instructorSortOrder)) {
                nameOrd = name.toLowerCase();
            }
            String posType = "@@ITALIC " + MSG.instructorPositionNotSpecified();
            if (di.getPositionType() != null) {
                posType = di.getPositionType().getLabel();
            }
            String note = "";
            if (di.getNote() != null) {
                note = di.getNote();
            }
            String rmPref = "";
            for (RoomPref rp : di.effectivePreferences(RoomPref.class)) {
                if (rmPref.length() > 0) {
                    rmPref = rmPref + "\n";
                }
                rmPref = rmPref + "@@COLOR " + PreferenceLevel.prolog2color(rp.getPrefLevel().getPrefProlog()) + " " + PreferenceLevel.prolog2abbv(rp.getPrefLevel().getPrefProlog()) + " " + rp.getRoom().getLabel();
            }
            for (BuildingPref bp : di.effectivePreferences(BuildingPref.class)) {
                if (rmPref.length() > 0) {
                    rmPref = rmPref + "\n";
                }
                rmPref = rmPref + "@@COLOR " + PreferenceLevel.prolog2color(bp.getPrefLevel().getPrefProlog()) + " " + PreferenceLevel.prolog2abbv(bp.getPrefLevel().getPrefProlog()) + " " + bp.getBuilding().getAbbreviation();
            }
            for (RoomFeaturePref rfp : di.effectivePreferences(RoomFeaturePref.class)) {
                if (rmPref.length() > 0) {
                    rmPref = rmPref + "\n";
                }
                rmPref = rmPref + "@@COLOR " + PreferenceLevel.prolog2color(rfp.getPrefLevel().getPrefProlog()) + " " + PreferenceLevel.prolog2abbv(rfp.getPrefLevel().getPrefProlog()) + " " + rfp.getRoomFeature().getLabel();
            }
            for (RoomGroupPref rgp : di.effectivePreferences(RoomGroupPref.class)) {
                if (rmPref.length() > 0) {
                    rmPref = rmPref + "\n";
                }
                rmPref = rmPref + "@@COLOR " + PreferenceLevel.prolog2color(rgp.getPrefLevel().getPrefProlog()) + " " + PreferenceLevel.prolog2abbv(rgp.getPrefLevel().getPrefProlog()) + " " + rgp.getRoomGroup().getName();
            }
            StringBuffer timePref = new StringBuffer();
            if (di.getTimePreferences() != null) {
                Iterator i = di.getTimePreferences().iterator();
                while (i.hasNext()) {
                    TimePref tp = (TimePref)i.next();
                    RequiredTimeTable rtt = tp.getRequiredTimeTable();
                    if (gridAsText) {
                        timePref.append(rtt.getModel().toString().replaceAll(", ", "\n"));
                        continue;
                    }
                    rtt.getModel().setDefaultSelection(timeGridSize);
                    BufferedImage image = rtt.createBufferedImage(timeVertical);
                    if (image != null) {
                        webTable.addImage(tp.getUniqueId().toString(), image);
                        timePref.append("@@IMAGE " + tp.getUniqueId().toString() + " ");
                    } else {
                        timePref.append(rtt.getModel().toString().replaceAll(", ", "\n"));
                    }
                    if (!i.hasNext()) continue;
                    timePref.append("\n");
                }
            }
            String distPref = "";
            for (DistributionPref dp : di.effectivePreferences(DistributionPref.class)) {
                if (distPref.length() > 0) {
                    distPref = distPref + "\n";
                }
                distPref = distPref + "@@COLOR " + PreferenceLevel.prolog2color(dp.getPrefLevel().getPrefProlog()) + " " + PreferenceLevel.prolog2abbv(dp.getPrefLevel().getPrefProlog()) + " " + dp.getDistributionType().getAbbreviation();
            }
            TreeSet<ClassInstructor> classes = new TreeSet<ClassInstructor>(new ClassInstructorComparator(new ClassComparator(2)));
            classes.addAll(di.getClasses());
            String classesStr = "";
            Iterator i = classes.iterator();
            while (i.hasNext()) {
                ClassInstructor ci = (ClassInstructor)i.next();
                Class_ c = ci.getClassInstructing();
                String className = c.getClassLabel();
                if (ci.isLead().booleanValue()) {
                    classesStr = classesStr + "@@BOLD ";
                }
                if (!c.isDisplayInstructor().booleanValue()) {
                    classesStr = classesStr + "@@ITALIC ";
                }
                classesStr = classesStr + className;
                if (!c.isDisplayInstructor().booleanValue()) {
                    classesStr = classesStr + "@@END_ITALIC ";
                }
                if (ci.isLead().booleanValue()) {
                    classesStr = classesStr + "@@END_BOLD ";
                }
                if (!i.hasNext()) continue;
                classesStr = classesStr + "\n";
            }
            TreeSet<Exam> exams = new TreeSet<Exam>(di.getExams());
            String examsStr = "";
            Iterator<Exam> i2 = exams.iterator();
            while (i2.hasNext()) {
                Exam exam = i2.next();
                String examName = exam.getLabel();
                examsStr = exam.getExamType().getType() == 1 ? examsStr + examName : examsStr + "@@BOLD " + examName + "@@END_BOLD ";
                if (!i2.hasNext()) continue;
                examsStr = examsStr + "\n";
            }
            webTable.addLine(null, new String[]{puid, name, posType, note, timePref.toString(), rmPref, distPref, classesStr, examsStr, di.isIgnoreToFar() != null && di.isIgnoreToFar() != false ? "@@ITALIC " + MSG.yes() : "@@ITALIC " + MSG.no()}, new Comparable[]{puid, nameOrd, posType, null, null, null, null, null, null, di.isIgnoreToFar()});
        }
        return webTable;
    }

    private String putSpace(String str) {
        if (str == null || str.trim().length() == 0) {
            return "&nbsp;";
        }
        return str;
    }
}

