/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.DefaultSingleAssignment;
import org.cpsolver.ifs.heuristics.BacktrackNeighbourSelection;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solution.SolutionListener;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.solver.SolverListener;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.ToolBox;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.StudentSectioningXMLSaver;
import org.cpsolver.studentsct.check.InevitableStudentConflicts;
import org.cpsolver.studentsct.check.OverlapCheck;
import org.cpsolver.studentsct.check.SectionLimitCheck;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.report.CourseConflictTable;
import org.cpsolver.studentsct.report.DistanceConflictTable;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.timetable.test.BatchStudentSectioningLoader;
import org.unitime.timetable.test.BatchStudentSectioningSaver;

public class BatchStudentSectioningTest {
    private static Log sLog = LogFactory.getLog(BatchStudentSectioningTest.class);
    private static DecimalFormat sDF = new DecimalFormat("0.000");
    private static boolean sIncludeCourseDemands = true;
    private static boolean sIncludeLastLikeStudents = true;
    private static boolean sIncludeUseCommittedAssignments = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void batchSectioning(DataProperties cfg) {
        StudentSectioningModel model = new StudentSectioningModel(cfg);
        DefaultSingleAssignment assignment = new DefaultSingleAssignment();
        try {
            new BatchStudentSectioningLoader(model, (Assignment<Request, Enrollment>)assignment).load();
        }
        catch (Exception e) {
            sLog.error((Object)("Unable to load problem, reason: " + e.getMessage()), (Throwable)e);
            return;
        }
        Solver solver = new Solver(cfg);
        Solution solution = new Solution((Model)model, (Assignment)assignment, 0L, 0.0);
        solver.setInitalSolution(solution);
        solver.addSolverListener((SolverListener)new SolverListener<Request, Enrollment>(){

            public boolean variableSelected(Assignment<Request, Enrollment> assignment, long iteration, Request variable) {
                return true;
            }

            public boolean valueSelected(Assignment<Request, Enrollment> assignment, long iteration, Request variable, Enrollment value) {
                return true;
            }

            public boolean neighbourSelected(Assignment<Request, Enrollment> assignment, long iteration, Neighbour<Request, Enrollment> neighbour) {
                sLog.debug((Object)("Select[" + iteration + "]: " + neighbour));
                return true;
            }

            public void neighbourFailed(Assignment<Request, Enrollment> assignment, long iteration, Neighbour<Request, Enrollment> neighbour) {
            }
        });
        solution.addSolutionListener(new SolutionListener(){

            public void solutionUpdated(Solution solution) {
            }

            public void getInfo(Solution solution, Map info) {
            }

            public void getInfo(Solution solution, Map info, Collection variables) {
            }

            public void bestCleared(Solution solution) {
            }

            public void bestSaved(Solution solution) {
                StudentSectioningModel m = (StudentSectioningModel)solution.getModel();
                Assignment a = solution.getAssignment();
                sLog.debug((Object)("**BEST** V:" + m.nrAssignedVariables(a) + "/" + m.variables().size() + " - S:" + ((StudentSectioningModel.StudentSectioningModelContext)m.getContext(a)).nrComplete() + "/" + m.getStudents().size() + " - TV:" + sDF.format(m.getTotalValue(a))));
            }

            public void bestRestored(Solution solution) {
            }
        });
        try {
            new StudentSectioningXMLSaver(solver).save(new File(new File(cfg.getProperty("General.Output", ".")), "input.xml"));
        }
        catch (Exception e) {
            sLog.error((Object)("Unable to save input data, reason: " + e.getMessage()), (Throwable)e);
        }
        solver.start();
        try {
            solver.getSolverThread().join();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        solution = solver.lastSolution();
        solution.restoreBest();
        model = (StudentSectioningModel)solution.getModel();
        try {
            InevitableStudentConflicts inevitableStudentConflicts;
            File outDir = new File(cfg.getProperty("General.Output", "."));
            outDir.mkdirs();
            CourseConflictTable cct = new CourseConflictTable((StudentSectioningModel)solution.getModel());
            cct.createTable((Assignment)assignment, true, false, true).save(new File(outDir, "conflicts-lastlike.csv"));
            cct.createTable((Assignment)assignment, false, true, true).save(new File(outDir, "conflicts-real.csv"));
            DistanceConflictTable dct = new DistanceConflictTable((StudentSectioningModel)solution.getModel());
            dct.createTable((Assignment)assignment, true, false, true).save(new File(outDir, "distances-lastlike.csv"));
            dct.createTable((Assignment)assignment, false, true, true).save(new File(outDir, "distances-real.csv"));
            if (cfg.getPropertyBoolean("Test.InevitableStudentConflictsCheck", false) && !(inevitableStudentConflicts = new InevitableStudentConflicts(model)).check((Assignment)assignment)) {
                inevitableStudentConflicts.getCSVFile().save(new File(outDir, "inevitable-conflicts.csv"));
            }
        }
        catch (IOException e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
        }
        solution.saveBest();
        model.computeOnlineSectioningInfos((Assignment)assignment);
        new OverlapCheck((StudentSectioningModel)solution.getModel()).check((Assignment)assignment);
        new SectionLimitCheck((StudentSectioningModel)solution.getModel()).check((Assignment)assignment);
        sLog.info((Object)("Best solution found after " + solution.getBestTime() + " seconds (" + solution.getBestIteration() + " iterations)."));
        sLog.info((Object)("Number of assigned variables is " + solution.getModel().nrAssignedVariables((Assignment)assignment)));
        sLog.info((Object)("Number of students with complete schedule is " + ((StudentSectioningModel.StudentSectioningModelContext)model.getContext((Assignment)assignment)).nrComplete()));
        sLog.info((Object)("Total value of the solution is " + solution.getModel().getTotalValue((Assignment)assignment)));
        sLog.info((Object)("Average unassigned priority " + sDF.format(model.avgUnassignPriority((Assignment)assignment))));
        sLog.info((Object)("Average number of requests " + sDF.format(model.avgNrRequests())));
        sLog.info((Object)("Unassigned request weight " + sDF.format(model.getUnassignedRequestWeight((Assignment)assignment)) + " / " + sDF.format(model.getTotalRequestWeight())));
        sLog.info((Object)("Info: " + ToolBox.dict2string((Map)solution.getExtendedInfo(), (int)2)));
        PrintWriter pw = null;
        try {
            try {
                pw = new PrintWriter(new FileWriter(new File(new File(cfg.getProperty("General.Output", ".")), "info.properties")));
                TreeSet entrySet = new TreeSet(new Comparator(){

                    public int compare(Object o1, Object o2) {
                        Map.Entry e1 = (Map.Entry)o1;
                        Map.Entry e2 = (Map.Entry)o2;
                        return ((Comparable)e1.getKey()).compareTo(e2.getKey());
                    }
                });
                entrySet.addAll(solution.getExtendedInfo().entrySet());
                for (Map.Entry entry : entrySet) {
                    pw.println(entry.getKey().toString().toLowerCase().replace(' ', '.') + "=" + entry.getValue());
                }
                pw.flush();
            }
            catch (IOException e) {
                sLog.error((Object)("Unable to save info, reason: " + e.getMessage()), (Throwable)e);
                Object var10_19 = null;
                if (pw != null) {
                    pw.close();
                }
            }
            Object var10_18 = null;
            if (pw != null) {
                pw.close();
            }
        }
        catch (Throwable throwable) {
            Object var10_20 = null;
            if (pw != null) {
                pw.close();
            }
            throw throwable;
        }
        try {
            new StudentSectioningXMLSaver(solver).save(new File(new File(cfg.getProperty("General.Output", ".")), "solution.xml"));
        }
        catch (Exception e) {
            sLog.error((Object)("Unable to save solution, reason: " + e.getMessage()), (Throwable)e);
        }
        try {
            new BatchStudentSectioningSaver(solver).save();
        }
        catch (Exception e) {
            sLog.error((Object)("Unable to save solution, reason: " + e.getMessage()), (Throwable)e);
        }
    }

    public static void main(String[] args) {
        try {
            DataProperties cfg = new DataProperties();
            cfg.setProperty("Termination.Class", "org.cpsolver.ifs.termination.GeneralTerminationCondition");
            cfg.setProperty("Termination.StopWhenComplete", "true");
            cfg.setProperty("Termination.TimeOut", "600");
            cfg.setProperty("Comparator.Class", "org.cpsolver.ifs.solution.GeneralSolutionComparator");
            cfg.setProperty("Value.Class", "org.cpsolver.ifs.heuristics.GeneralValueSelection");
            cfg.setProperty("Value.WeightConflicts", "1.0");
            cfg.setProperty("Value.WeightNrAssignments", "0.0");
            cfg.setProperty("Variable.Class", "org.cpsolver.ifs.heuristics.GeneralVariableSelection");
            cfg.setProperty("Neighbour.Class", "org.cpsolver.studentsct.heuristics.StudentSctNeighbourSelection");
            cfg.setProperty("General.SaveBestUnassigned", "-1");
            cfg.setProperty("Extensions.Classes", "org.cpsolver.ifs.extension.ConflictStatistics;org.cpsolver.studentsct.extension.DistanceConflict");
            cfg.setProperty("Data.Initiative", "woebegon");
            cfg.setProperty("Data.Term", "Fal");
            cfg.setProperty("Data.Year", "2007");
            cfg.setProperty("Load.IncludeCourseDemands", sIncludeCourseDemands ? "true" : "false");
            cfg.setProperty("Load.IncludeLastLikeStudents", sIncludeLastLikeStudents ? "true" : "false");
            cfg.setProperty("Load.IncludeUseCommittedAssignments", sIncludeUseCommittedAssignments ? "true" : "false");
            if (args.length >= 1) {
                cfg.load((InputStream)new FileInputStream(args[0]));
            }
            cfg.putAll((Map)System.getProperties());
            if (args.length >= 2) {
                File logFile = new File(ToolBox.configureLogging((String)args[1], (Properties)cfg, (boolean)true, (boolean)false));
                cfg.setProperty("General.Output", logFile.getParentFile().getAbsolutePath());
            } else {
                ToolBox.configureLogging();
                cfg.setProperty("General.Output", System.getProperty("user.home", ".") + File.separator + "Sectioning-Test");
            }
            Logger.getLogger(BacktrackNeighbourSelection.class).setLevel(cfg.getPropertyBoolean("Debug.BacktrackNeighbourSelection", false) ? Level.DEBUG : Level.INFO);
            HibernateUtil.configureHibernate((Properties)cfg);
            BatchStudentSectioningTest.batchSectioning(cfg);
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
    }
}

