/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.ui;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.hibernate.Session;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Solution;
import org.unitime.timetable.solver.ui.UnassignedClassRow;
import org.unitime.timetable.solver.ui.UnassignedClassesModel;

public class SolutionUnassignedClassesModel
extends UnassignedClassesModel {
    private static final long serialVersionUID = 8222974077941239586L;

    public SolutionUnassignedClassesModel(Collection solutions, Session hibSession, String instructorFormat, String prefix) {
        for (Solution solution : solutions) {
            for (Class_ clazz : solution.getOwner().getNotAssignedClasses(solution)) {
                String name = clazz.getClassLabel();
                if (prefix != null && !name.startsWith(prefix)) continue;
                String onClick = "showGwtDialog('Suggestions', 'suggestions.do?id=" + clazz.getUniqueId() + "&op=Reset','900','90%');";
                List<DepartmentalInstructor> leads = clazz.getLeadInstructors();
                StringBuffer leadsSb = new StringBuffer();
                Iterator<DepartmentalInstructor> e = leads.iterator();
                while (e.hasNext()) {
                    DepartmentalInstructor instructor = e.next();
                    leadsSb.append(instructor.getName(instructorFormat));
                    if (!e.hasNext()) continue;
                    leadsSb.append(";");
                }
                String instructorName = leadsSb.toString();
                int nrStudents = ((Number)hibSession.createQuery("select count(s) from StudentEnrollment as s where s.clazz.uniqueId=:classId and s.solution.uniqueId=:solutionId").setLong("classId", clazz.getUniqueId().longValue()).setInteger("solutionId", solution.getUniqueId().intValue()).uniqueResult()).intValue();
                this.rows().addElement(new UnassignedClassRow(onClick, name, instructorName, nrStudents, null, clazz));
            }
        }
    }
}

