/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.ui;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.cpsolver.coursett.constraint.SpreadConstraint;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.solver.Solver;
import org.unitime.timetable.solver.interactive.ClassAssignmentDetails;
import org.unitime.timetable.util.Constants;

public class SameSubpartBalancingReport
implements Serializable {
    private static final long serialVersionUID = 1L;
    private HashSet iGroups = new HashSet();

    public SameSubpartBalancingReport(Solver solver) {
        TimetableModel model = (TimetableModel)solver.currentSolution().getModel();
        Assignment assignment = solver.currentSolution().getAssignment();
        for (SpreadConstraint spread : model.getSpreadConstraints()) {
            if (spread.getPenalty(assignment) == 0) continue;
            this.iGroups.add(new SameSubpartBalancingGroup(solver, spread));
        }
    }

    public Set getGroups() {
        return this.iGroups;
    }

    public class SameSubpartBalancingGroup
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String iName = null;
        private int[][] iLimit;
        private int[][] iUsage;
        private HashSet[][] iCourses;

        public SameSubpartBalancingGroup(Solver solver, SpreadConstraint spread) {
            Assignment assignment = solver.currentSolution().getAssignment();
            SpreadConstraint.SpreadConstraintContext context = (SpreadConstraint.SpreadConstraintContext)spread.getContext(assignment);
            this.iName = spread.getName();
            this.iLimit = new int[Constants.SLOTS_PER_DAY_NO_EVENINGS][Constants.NR_DAYS_WEEK];
            this.iUsage = new int[Constants.SLOTS_PER_DAY_NO_EVENINGS][Constants.NR_DAYS_WEEK];
            this.iCourses = new HashSet[Constants.SLOTS_PER_DAY_NO_EVENINGS][Constants.NR_DAYS_WEEK];
            Hashtable<Long, ClassAssignmentDetails> detailCache = new Hashtable<Long, ClassAssignmentDetails>();
            for (int i = 0; i < Constants.SLOTS_PER_DAY_NO_EVENINGS; ++i) {
                for (int j = 0; j < Constants.NR_DAYS_WEEK; ++j) {
                    this.iLimit[i][j] = context.getMaxCourses(i + Constants.DAY_SLOTS_FIRST, j);
                    this.iUsage[i][j] = context.getCourses(i + Constants.DAY_SLOTS_FIRST, j).size();
                    this.iCourses[i][j] = new HashSet(context.getCourses(i + Constants.DAY_SLOTS_FIRST, j).size());
                    for (Placement placement : context.getCourses(i + Constants.DAY_SLOTS_FIRST, j)) {
                        Lecture lecture = (Lecture)placement.variable();
                        ClassAssignmentDetails ca = (ClassAssignmentDetails)detailCache.get(lecture.getClassId());
                        if (ca == null) {
                            ca = new ClassAssignmentDetails(solver, lecture, false);
                            detailCache.put(lecture.getClassId(), ca);
                        }
                        this.iCourses[i][j].add(ca);
                    }
                }
            }
        }

        public String getName() {
            return this.iName;
        }

        public int getLimit(int slot, int day) {
            if (slot < Constants.DAY_SLOTS_FIRST || slot > Constants.DAY_SLOTS_LAST) {
                return 0;
            }
            if (day >= Constants.NR_DAYS_WEEK) {
                return 0;
            }
            return this.iLimit[slot - Constants.DAY_SLOTS_FIRST][day];
        }

        public int getUsage(int slot, int day) {
            if (slot < Constants.DAY_SLOTS_FIRST || slot > Constants.DAY_SLOTS_LAST) {
                return 0;
            }
            if (day >= Constants.NR_DAYS_WEEK) {
                return 0;
            }
            return this.iUsage[slot - Constants.DAY_SLOTS_FIRST][day];
        }

        public Collection getClasses(int slot, int day) {
            if (slot < Constants.DAY_SLOTS_FIRST || slot > Constants.DAY_SLOTS_LAST) {
                return new HashSet(0);
            }
            if (day >= Constants.NR_DAYS_WEEK) {
                return new HashSet(0);
            }
            return this.iCourses[slot - Constants.DAY_SLOTS_FIRST][day];
        }

        public int getLimit(int slot) {
            if (slot < Constants.DAY_SLOTS_FIRST || slot > Constants.DAY_SLOTS_LAST) {
                return 0;
            }
            int ret = 0;
            for (int day = 0; day < Constants.NR_DAYS_WEEK; ++day) {
                ret += this.iLimit[slot - Constants.DAY_SLOTS_FIRST][day];
            }
            return ret;
        }

        public int getUsage(int slot) {
            if (slot < Constants.DAY_SLOTS_FIRST || slot > Constants.DAY_SLOTS_LAST) {
                return 0;
            }
            int ret = 0;
            for (int day = 0; day < Constants.NR_DAYS_WEEK; ++day) {
                ret += this.iUsage[slot - Constants.DAY_SLOTS_FIRST][day];
            }
            return ret;
        }

        public Collection getClasses(int slot) {
            if (slot < Constants.DAY_SLOTS_FIRST || slot > Constants.DAY_SLOTS_LAST) {
                return new HashSet(0);
            }
            HashSet ret = new HashSet();
            for (int day = 0; day < Constants.NR_DAYS_WEEK; ++day) {
                ret.addAll(this.iCourses[slot - Constants.DAY_SLOTS_FIRST][day]);
            }
            return ret;
        }

        public int getExcess(int slot) {
            if (slot < Constants.DAY_SLOTS_FIRST || slot > Constants.DAY_SLOTS_LAST) {
                return 0;
            }
            int ret = 0;
            for (int day = 0; day < Constants.NR_DAYS_WEEK; ++day) {
                ret += Math.max(0, this.iUsage[slot - Constants.DAY_SLOTS_FIRST][day] - this.iLimit[slot - Constants.DAY_SLOTS_FIRST][day]);
            }
            return ret;
        }
    }
}

