/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.jgroups;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.ToolBox;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.SuspectedException;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.blocks.locking.LockService;
import org.jgroups.blocks.mux.MuxRpcDispatcher;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServerContext;
import org.unitime.timetable.onlinesectioning.server.CheckMaster;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.jgroups.OnlineStudentSchedulingContainer;
import org.unitime.timetable.solver.jgroups.RemoteSolver;
import org.unitime.timetable.solver.jgroups.ReplicatedSolverContainer;
import org.unitime.timetable.solver.jgroups.SolverServerImplementation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OnlineStudentSchedulingContainerRemote
extends OnlineStudentSchedulingContainer
implements ReplicatedSolverContainer<OnlineSectioningServer> {
    private static Log sLog = LogFactory.getLog(OnlineStudentSchedulingContainerRemote.class);
    private RpcDispatcher iDispatcher;
    private EmbeddedCacheManager iCacheManager = null;
    private LockService iLockService;

    public OnlineStudentSchedulingContainerRemote(JChannel channel, short scope) {
        this.iDispatcher = new MuxRpcDispatcher(scope, (Channel)channel, null, null, (Object)this);
        this.iLockService = new LockService(channel);
    }

    @Override
    public RpcDispatcher getDispatcher() {
        return this.iDispatcher;
    }

    public LockService getLockService() {
        return this.iLockService;
    }

    @Override
    public void start() {
        super.start();
        this.createCacheManagerIfNeeded();
    }

    private synchronized void createCacheManagerIfNeeded() {
        if (this.iCacheManager == null && ApplicationProperty.OnlineSchedulingServerReplicated.isTrue()) {
            GlobalConfiguration global = GlobalConfigurationBuilder.defaultClusteredBuilder().transport().addProperty("channelLookup", "org.unitime.commons.jgroups.SectioningChannelLookup").clusterName("UniTime:sectioning").asyncTransportExecutor().addProperty("maxThreads", "50").globalJmxStatistics().cacheManagerName("OnlineSchedulingCacheManager").allowDuplicateDomains(Boolean.valueOf(true)).disable().build();
            Configuration config = new ConfigurationBuilder().clustering().cacheMode(CacheMode.REPL_ASYNC).async().useReplQueue(true).replQueueInterval(500L, TimeUnit.MILLISECONDS).replQueueMaxElements(1000).invocationBatching().enable().storeAsBinary().enable().build();
            this.iCacheManager = new DefaultCacheManager(global, config);
        }
    }

    @Override
    public void stop() {
        super.stop();
        if (this.iCacheManager != null) {
            this.iCacheManager.stop();
            this.iCacheManager = null;
        }
    }

    @Override
    public boolean hasMaster(String sessionId) {
        OnlineSectioningServer server = this.getInstance(Long.valueOf(sessionId));
        return server != null && server.isMaster();
    }

    @Override
    public boolean createRemoteSolver(String sessionId, DataProperties config, Address caller) {
        return super.createSolver(sessionId, config) != null;
    }

    @Override
    public Object invoke(String method, String sessionId, Class[] types, Object[] args) throws Exception {
        Object object;
        OnlineSectioningServer solver;
        block6: {
            solver = (OnlineSectioningServer)this.iInstances.get(Long.valueOf(sessionId));
            if (!"exists".equals(method) || types.length != 0) break block6;
            Boolean bl = solver != null;
            Object var8_9 = null;
            _RootDAO.closeCurrentThreadSessions();
            return bl;
        }
        try {
            if (solver == null) {
                throw new Exception("Server " + sessionId + " does not exist.");
            }
            object = solver.getClass().getMethod(method, types).invoke((Object)solver, args);
            Object var8_10 = null;
        }
        catch (InvocationTargetException e) {
            try {
                throw (Exception)e.getTargetException();
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                _RootDAO.closeCurrentThreadSessions();
                throw throwable;
            }
        }
        _RootDAO.closeCurrentThreadSessions();
        return object;
    }

    @Override
    public Object dispatch(Address address, String sessionId, Method method, Object[] args) throws Exception {
        try {
            return this.iDispatcher.callRemoteMethod(address, "invoke", new Object[]{method.getName(), sessionId, method.getParameterTypes(), args}, new Class[]{String.class, String.class, Class[].class, Object[].class}, SolverServerImplementation.sFirstResponse);
        }
        catch (InvocationTargetException e) {
            throw (Exception)e.getTargetException();
        }
        catch (Exception e) {
            if ("exists".equals(method.getName()) && e instanceof SuspectedException) {
                return false;
            }
            sLog.debug((Object)("Excution of " + method.getName() + " on server " + sessionId + " failed: " + e.getMessage()), (Throwable)e);
            throw e;
        }
    }

    @Override
    public Object dispatch(Collection<Address> addresses, String sessionId, Method method, Object[] args) throws Exception {
        try {
            if (addresses.size() == 1) {
                return this.dispatch((Address)ToolBox.random(addresses), sessionId, method, args);
            }
            Address address = (Address)ToolBox.random(addresses);
            CheckMaster ch = method.getAnnotation(CheckMaster.class);
            if (ch == null && "execute".equals(method.getName())) {
                ch = args[0].getClass().getAnnotation(CheckMaster.class);
            }
            RspList ret = this.iDispatcher.callRemoteMethods(addresses, "hasMaster", new Object[]{sessionId}, new Class[]{String.class}, SolverServerImplementation.sAllResponses);
            if (ch != null && ch.value() == CheckMaster.Master.REQUIRED) {
                for (Rsp rsp : ret) {
                    if (rsp == null || !((Boolean)rsp.getValue()).booleanValue()) continue;
                    address = rsp.getSender();
                    break;
                }
            } else {
                ArrayList<Address> slaves = new ArrayList<Address>();
                for (Rsp rsp : ret) {
                    if (rsp == null || ((Boolean)rsp.getValue()).booleanValue()) continue;
                    slaves.add(rsp.getSender());
                }
                if (!slaves.isEmpty()) {
                    address = (Address)ToolBox.random(slaves);
                }
            }
            return this.dispatch(address, sessionId, method, args);
        }
        catch (InvocationTargetException e) {
            throw (Exception)e.getTargetException();
        }
    }

    @Override
    public OnlineSectioningServer createProxy(Address address, String user) {
        ServerInvocationHandler handler = new ServerInvocationHandler(address, user);
        OnlineSectioningServer px = (OnlineSectioningServer)Proxy.newProxyInstance(SolverProxy.class.getClassLoader(), new Class[]{OnlineSectioningServer.class, RemoteSolver.class}, (InvocationHandler)handler);
        return px;
    }

    @Override
    public OnlineSectioningServer createProxy(Collection<Address> addresses, String user) {
        ReplicatedServerInvocationHandler handler = new ReplicatedServerInvocationHandler(addresses, user);
        OnlineSectioningServer px = (OnlineSectioningServer)Proxy.newProxyInstance(SolverProxy.class.getClassLoader(), new Class[]{OnlineSectioningServer.class, RemoteSolver.class}, (InvocationHandler)handler);
        return px;
    }

    @Override
    public OnlineSectioningServerContext getServerContext(final Long academicSessionId) {
        return new OnlineSectioningServerContext(){

            public Long getAcademicSessionId() {
                return academicSessionId;
            }

            public boolean isWaitTillStarted() {
                return false;
            }

            public EmbeddedCacheManager getCacheManager() {
                return OnlineStudentSchedulingContainerRemote.this.getCacheManager();
            }

            public LockService getLockService() {
                return OnlineStudentSchedulingContainerRemote.this.iLockService;
            }
        };
    }

    public EmbeddedCacheManager getCacheManager() {
        this.createCacheManagerIfNeeded();
        return this.iCacheManager;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ReplicatedServerInvocationHandler
    implements InvocationHandler {
        private Collection<Address> iAddresses;
        private String iUser;

        private ReplicatedServerInvocationHandler(Collection<Address> addresses, String user) {
            this.iAddresses = addresses;
            this.iUser = user;
        }

        public String getHost() {
            return this.iAddresses.toString();
        }

        public String getUser() {
            return this.iUser;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return this.getClass().getMethod(method.getName(), method.getParameterTypes()).invoke((Object)this, args);
            }
            catch (NoSuchMethodException e) {
                return OnlineStudentSchedulingContainerRemote.this.dispatch(this.iAddresses, this.iUser, method, args);
            }
        }
    }

    public class ServerInvocationHandler
    implements InvocationHandler {
        private Address iAddress;
        private String iUser;

        private ServerInvocationHandler(Address address, String user) {
            this.iAddress = address;
            this.iUser = user;
        }

        public String getHost() {
            return this.iAddress.toString();
        }

        public String getUser() {
            return this.iUser;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return this.getClass().getMethod(method.getName(), method.getParameterTypes()).invoke((Object)this, args);
            }
            catch (NoSuchMethodException e) {
                return OnlineStudentSchedulingContainerRemote.this.dispatch(this.iAddress, this.iUser, method, args);
            }
        }
    }
}

