/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.course.ui;

import java.io.Serializable;
import org.hibernate.Session;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.dao.ClassInstructorDAO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassInstructorInfo
implements Serializable,
Comparable<ClassInstructorInfo> {
    private static final long serialVersionUID = 8576391767085203451L;
    protected Long iId;
    protected String iExternalUniqueId = null;
    protected String iName = null;
    protected boolean iIsLead = false;
    protected int iShare = 0;
    protected transient ClassInstructor iInstructor;

    public ClassInstructorInfo(ClassInstructor instructor) {
        this.iId = instructor.getUniqueId();
        this.iName = instructor.getInstructor().getNameLastFirst();
        this.iIsLead = instructor.isLead();
        this.iShare = instructor.getPercentShare();
        this.iExternalUniqueId = instructor.getInstructor().getExternalUniqueId();
        this.iInstructor = instructor;
    }

    public Long getId() {
        return this.iId;
    }

    public String getName() {
        return this.iName;
    }

    public boolean isLead() {
        return this.iIsLead;
    }

    public int getShare() {
        return this.iShare;
    }

    public String getExternalUniqueId() {
        if (this.iExternalUniqueId == null && this.iInstructor == null) {
            this.iExternalUniqueId = this.getInstructor().getInstructor().getExternalUniqueId();
        }
        return this.iExternalUniqueId;
    }

    public ClassInstructor getInstructor() {
        if (this.iInstructor == null) {
            this.iInstructor = (ClassInstructor)ClassInstructorDAO.getInstance().get(this.getId());
        }
        return this.iInstructor;
    }

    public ClassInstructor getInstructor(Session hibSession) {
        return (ClassInstructor)ClassInstructorDAO.getInstance().get(this.getId(), hibSession);
    }

    @Override
    public int compareTo(ClassInstructorInfo i) {
        int cmp = this.getName().compareTo(i.getName());
        if (cmp != 0) {
            return cmp;
        }
        return this.getId().compareTo(i.getId());
    }

    public int hashCode() {
        if (this.getExternalUniqueId() != null) {
            return this.getExternalUniqueId().hashCode();
        }
        return this.getId().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ClassInstructorInfo)) {
            return false;
        }
        ClassInstructorInfo i = (ClassInstructorInfo)o;
        if (this.getExternalUniqueId() != null && this.getExternalUniqueId().equals(i.getExternalUniqueId())) {
            return true;
        }
        return this.getId().equals(i.getId());
    }
}

