/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.sectioning;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Properties;
import org.cpsolver.ifs.util.CSVFile;
import org.cpsolver.ifs.util.DataProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.export.CSVPrinter;
import org.unitime.timetable.export.ExportHelper;
import org.unitime.timetable.export.Exporter;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.basic.GenerateSectioningReport;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.service.SolverServerService;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.solver.studentsct.StudentSolverProxy;

@Service(value="org.unitime.timetable.export.Exporter:sct-report.csv")
public class SectioningReportsExporter
implements Exporter {
    protected static GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    @Autowired
    SolverService<StudentSolverProxy> studentSectioningSolverService;
    @Autowired
    SolverServerService solverServerService;

    public String reference() {
        return "sct-report.csv";
    }

    public void export(ExportHelper helper) throws IOException {
        String sort;
        DataProperties parameters = new DataProperties();
        Enumeration<String> e = helper.getParameterNames();
        while (e.hasMoreElements()) {
            String name = e.nextElement();
            parameters.put((Object)name, (Object)helper.getParameter(name));
        }
        parameters.put((Object)"useAmPm", (Object)(CONSTANTS.useAmPm() ? "true" : "false"));
        Long sessionId = helper.getAcademicSessionId();
        if (sessionId == null && helper.getSessionContext().isAuthenticated()) {
            sessionId = helper.getSessionContext().getUser().getCurrentAcademicSessionId();
        }
        if (sessionId == null) {
            throw new GwtRpcException("No academic session provided.");
        }
        CSVFile csv = null;
        boolean online = parameters.getPropertyBoolean("online", true);
        SessionContext context = helper.getSessionContext();
        if (online) {
            context.checkPermissionAnyAuthority(sessionId, "Session", Right.SchedulingDashboard, new Qualifiable[0]);
            OnlineSectioningServer server = this.solverServerService.getOnlineStudentSchedulingContainer().getSolver(sessionId.toString());
            if (server == null) {
                throw new GwtRpcException("Online student scheduling is not enabled for session " + sessionId + ".");
            }
            OnlineSectioningLog.Entity user = OnlineSectioningLog.Entity.newBuilder().setExternalId(context.getUser().getExternalUserId()).setName(context.getUser().getName() == null ? context.getUser().getUsername() : context.getUser().getName()).setType(context.hasPermission(Right.StudentSchedulingAdvisor) ? OnlineSectioningLog.Entity.EntityType.MANAGER : OnlineSectioningLog.Entity.EntityType.STUDENT).build();
            csv = server.execute(server.createAction(GenerateSectioningReport.class).withParameters((Properties)parameters), user);
        } else {
            context.checkPermission(Right.StudentSectioningSolver);
            StudentSolverProxy solver = this.studentSectioningSolverService.getSolver();
            if (solver == null) {
                throw new GwtRpcException("No student solver is running.");
            }
            csv = solver.getReport(parameters);
        }
        if (csv == null) {
            throw new GwtRpcException("No report was created.");
        }
        CSVPrinter out = new CSVPrinter(helper.getWriter(), false);
        helper.setup(out.getContentType(), helper.getParameter("name").toLowerCase().replace('_', '-') + ".csv", false);
        String[] header = new String[csv.getHeader().getFields().size()];
        for (int i = 0; i < csv.getHeader().getFields().size(); ++i) {
            header[i] = csv.getHeader().getField(i).toString();
        }
        out.printHeader(header);
        DecimalFormat pf = new DecimalFormat("0.00%");
        ArrayList<Row> rows = new ArrayList<Row>();
        Row prev = null;
        if (csv.getLines() != null) {
            for (CSVFile.CSVLine line : csv.getLines()) {
                if (line.getFields().isEmpty()) continue;
                Row data = new Row(line);
                while (prev != null && data.getNrBlanks() <= prev.getNrBlanks()) {
                    prev = prev.getParent();
                }
                if (prev != null) {
                    data.setParent(prev);
                }
                rows.add(data);
                prev = data;
            }
        }
        if ((sort = helper.getParameter("sort")) != null && !"0".equals(sort)) {
            final boolean asc = Integer.parseInt(sort) > 0;
            final int col = Math.abs(Integer.parseInt(sort)) - 1;
            Collections.sort(rows, new Comparator<Row>(){

                @Override
                public int compare(Row o1, Row o2) {
                    return asc ? o1.compareTo(o2, col) : o2.compareTo(o1, col);
                }
            });
        }
        prev = null;
        for (Row row : rows) {
            boolean prevHide = true;
            String[] line = new String[csv.getHeader().size()];
            for (int x = 0; x < csv.getHeader().size(); ++x) {
                boolean hide = true;
                if (prev == null || !prevHide || !prev.getCell(x).equals(row.getCell(x))) {
                    hide = false;
                }
                String text = row.getCell(x);
                boolean number = false;
                if (csv.getHeader().getField(x).toString().contains("%")) {
                    if (x > 0) {
                        try {
                            Double.parseDouble(text);
                            number = true;
                        }
                        catch (Exception e2) {
                            // empty catch block
                        }
                    }
                    if (number) {
                        text = pf.format(Double.parseDouble(text));
                    }
                }
                line[x] = hide ? "" : text;
                prevHide = hide;
            }
            if (prev != null && !prev.getCell(0).equals(row.getCell(0))) {
                out.printLine(new String[0]);
            }
            out.printLine(line);
            prev = row;
        }
        out.flush();
        out.close();
    }

    private static class Row {
        CSVFile.CSVLine iLine;
        Row iParent;

        public Row(CSVFile.CSVLine line) {
            this.iLine = line;
        }

        public Row getParent() {
            return this.iParent;
        }

        public void setParent(Row parent) {
            this.iParent = parent;
        }

        public boolean isBlank(int col) {
            return this.iLine.getFields().size() <= col || this.iLine.getField(col).toString().isEmpty();
        }

        public String getCell(int col) {
            if (this.isBlank(col)) {
                if (this.getParent() != null) {
                    return this.getParent().getCell(col);
                }
                return "";
            }
            return this.iLine.getField(col).toString();
        }

        public int getLevel() {
            return this.getParent() == null ? 0 : this.getParent().getLevel() + 1;
        }

        public int getLength() {
            return this.getParent() == null ? this.iLine.getFields().size() : this.getParent().getLength();
        }

        public int getNrBlanks() {
            for (int i = 0; i < this.getLength(); ++i) {
                if (this.isBlank(i)) continue;
                return i;
            }
            return this.getLength();
        }

        public int compareTo(Row b, int col) {
            block5: {
                Row a = this;
                while (a.getLevel() > b.getLevel()) {
                    a = a.getParent();
                }
                while (b.getLevel() > a.getLevel()) {
                    b = b.getParent();
                }
                try {
                    int cmp = Double.valueOf(a.getCell(col) == null ? "0" : a.getCell(col)).compareTo(Double.valueOf(b.getCell(col) == null ? "0" : b.getCell(col)));
                    if (cmp != 0) {
                        return cmp;
                    }
                }
                catch (NumberFormatException e) {
                    int cmp = (a.getCell(col) == null ? "" : a.getCell(col)).compareTo(b.getCell(col) == null ? "" : b.getCell(col));
                    if (cmp == 0) break block5;
                    return cmp;
                }
            }
            return 0;
        }
    }
}

