/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.menu;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.ServletException;
import org.apache.log4j.Logger;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.hibernate.Session;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.PageNames;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.action.PersonalizedExamReportAction;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.MenuInterface;
import org.unitime.timetable.model.SavedHQL;
import org.unitime.timetable.model.SolverGroup;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.UserAuthority;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.qualifiers.SimpleQualifier;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.service.SolverServerService;
import org.unitime.timetable.util.RoomAvailability;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtRpcImplements(value=MenuInterface.MenuRpcRequest.class)
public class MenuBackend
implements GwtRpcImplementation<MenuInterface.MenuRpcRequest, GwtRpcResponseList<MenuInterface>>,
InitializingBean {
    private static Logger sLog = Logger.getLogger(MenuBackend.class);
    protected Element iRoot = null;
    private static PageNames sPageNames = Localization.create(PageNames.class);
    @Autowired
    private SolverServerService solverServerService;
    @Autowired
    private SessionContext sessionContext;

    public void afterPropertiesSet() throws Exception {
        try {
            String menu = ApplicationProperty.MenuFile.value();
            Document document = null;
            URL menuUrl = ApplicationProperties.class.getClassLoader().getResource(menu);
            SAXReader sax = new SAXReader();
            sax.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String publicId, String systemId) {
                    if (publicId.equals("-//UniTime//UniTime Menu DTD/EN")) {
                        return new InputSource(ApplicationProperties.class.getClassLoader().getResourceAsStream("menu.dtd"));
                    }
                    return null;
                }
            });
            if (menuUrl != null) {
                sLog.info((Object)("Reading menu from " + URLDecoder.decode(menuUrl.getPath(), "UTF-8") + " ..."));
                document = sax.read(menuUrl.openStream());
            } else if (new File(menu).exists()) {
                sLog.info((Object)("Reading menu from " + menu + " ..."));
                document = sax.read(new File(menu));
            }
            if (document == null) {
                throw new ServletException("Unable to create menu, reason: resource " + menu + " not found.");
            }
            if (!"unitime-menu".equals(document.getRootElement().getName())) {
                throw new ServletException("Menu has an unknown format.");
            }
            this.iRoot = document.getRootElement();
            String customMenu = ApplicationProperty.CustomMenuFile.value();
            Document customDocument = null;
            URL customMenuUrl = ApplicationProperties.class.getClassLoader().getResource(customMenu);
            if (customMenuUrl != null) {
                sLog.info((Object)("Reading custom menu from " + URLDecoder.decode(customMenuUrl.getPath(), "UTF-8") + " ..."));
                customDocument = sax.read(customMenuUrl.openStream());
            } else if (new File(customMenu).exists()) {
                sLog.info((Object)("Reading custom menu from " + customMenu + " ..."));
                customDocument = sax.read(new File(customMenu));
            }
            if (customDocument != null) {
                this.merge(this.iRoot, customDocument.getRootElement());
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException("Unable to initialize, reason: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public GwtRpcResponseList<MenuInterface> execute(MenuInterface.MenuRpcRequest request, SessionContext context) {
        try {
            GwtRpcResponseList<MenuInterface> gwtRpcResponseList;
            Session hibSession = SessionDAO.getInstance().getSession();
            try {
                GwtRpcResponseList<MenuInterface> menu = new GwtRpcResponseList<MenuInterface>();
                if (this.iRoot == null) {
                    throw new GwtRpcException("menu is not configured properly");
                }
                Iterator i = this.iRoot.elementIterator();
                while (i.hasNext()) {
                    Element element = (Element)i.next();
                    MenuInterface m = this.getMenu(element);
                    if (m == null) continue;
                    menu.add(m);
                }
                if (menu.isEmpty()) {
                    throw new GwtRpcException("no menu");
                }
                gwtRpcResponseList = menu;
                Object var9_10 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                hibSession.close();
                throw throwable;
            }
            hibSession.close();
            return gwtRpcResponseList;
        }
        catch (GwtRpcException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GwtRpcException(e.getMessage());
        }
    }

    private void merge(Element menu, Element custom) {
        if ("remove".equals(custom.getName())) {
            menu.getParent().remove(menu);
            return;
        }
        Iterator i = custom.attributeIterator();
        while (i.hasNext()) {
            Attribute a = (Attribute)i.next();
            menu.addAttribute(a.getName(), a.getValue());
        }
        i = custom.elementIterator();
        while (i.hasNext()) {
            Iterator j;
            Element e = (Element)i.next();
            if ("parameter".equals(e.getName())) {
                j = menu.elementIterator("parameter");
                while (j.hasNext()) {
                    menu.remove((Element)j.next());
                }
                menu.add(e.createCopy());
                continue;
            }
            if ("condition".equals(e.getName())) {
                menu.add(e.createCopy());
                continue;
            }
            if ("new-condition".equals(e.getName())) {
                j = menu.elementIterator("condition");
                while (j.hasNext()) {
                    menu.remove((Element)j.next());
                }
                Element f = e.createCopy();
                f.setName("condition");
                menu.add(f);
                continue;
            }
            String name = e.attributeValue("name");
            Element x = null;
            if (name != null) {
                Iterator j2 = menu.elementIterator();
                while (j2.hasNext()) {
                    Element f = (Element)j2.next();
                    if (!name.equals(f.attributeValue("name"))) continue;
                    x = f;
                    break;
                }
            }
            if (x != null) {
                this.merge(x, e);
                continue;
            }
            int pos = Integer.parseInt(e.attributeValue("position", "-1"));
            if (pos >= 0) {
                ArrayList<Element> after = new ArrayList<Element>();
                Iterator j3 = menu.elementIterator();
                while (j3.hasNext()) {
                    Element f = (Element)j3.next();
                    if ("condition".equals(f.getName())) continue;
                    if (pos > 0) {
                        --pos;
                        continue;
                    }
                    after.add(f);
                    menu.remove(f);
                }
                menu.add(e.createCopy());
                for (Element f : after) {
                    menu.add(f);
                }
                continue;
            }
            menu.add(e.createCopy());
        }
    }

    private MenuInterface getMenu(Element menuElement) {
        try {
            MenuInterface menu = new MenuInterface();
            String name = menuElement.attributeValue("name");
            String localizedName = name == null ? null : sPageNames.translateMessage(name.trim().replace(' ', '_').replace("(", "").replace(")", "").replace(':', '_'), null, new Object[0]);
            menu.setName(localizedName == null ? name : localizedName);
            menu.setTitle(menuElement.attributeValue("title"));
            menu.setTarget(menuElement.attributeValue("target"));
            menu.setPage(menuElement.attributeValue("page"));
            menu.setHash(menuElement.attributeValue("hash"));
            String type = menuElement.attributeValue("type");
            if ("gwt".equals(type)) {
                menu.setGWT(true);
            }
            if ("property".equals(type) && menu.getPage() != null) {
                menu.setPage(ApplicationProperties.getProperty(menu.getPage()));
                if (menu.getPage() == null) {
                    return null;
                }
            }
            boolean sep = true;
            Iterator i = menuElement.elementIterator();
            while (i.hasNext()) {
                Element element = (Element)i.next();
                if ("condition".equals(element.getName())) {
                    if (this.check(element)) continue;
                    return null;
                }
                if ("parameter".equals(element.getName())) {
                    menu.addParameter(element.attributeValue("name"), element.attributeValue("value", element.getText()));
                    continue;
                }
                MenuInterface m = this.getMenu(element);
                if (m == null || sep && m.isSeparator()) continue;
                menu.addSubMenu(m);
                sep = m.isSeparator();
            }
            while (menu.hasSubMenus() && menu.getSubMenus().get(menu.getSubMenus().size() - 1).isSeparator()) {
                menu.getSubMenus().remove(menu.getSubMenus().size() - 1);
            }
            return menu.isSeparator() || menu.hasPage() || menu.hasSubMenus() ? menu : null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean check(Element conditionElement) {
        String cond = conditionElement.getName();
        if ("and".equals(cond) || "condition".equals(cond)) {
            Iterator i = conditionElement.elementIterator();
            while (i.hasNext()) {
                Element element = (Element)i.next();
                if (this.check(element)) continue;
                return false;
            }
            return true;
        }
        if ("or".equals(cond)) {
            Iterator i = conditionElement.elementIterator();
            while (i.hasNext()) {
                Element element = (Element)i.next();
                if (!this.check(element)) continue;
                return true;
            }
            return false;
        }
        if ("not".equals(cond)) {
            Iterator i = conditionElement.elementIterator();
            while (i.hasNext()) {
                Element element = (Element)i.next();
                if (!this.check(element)) continue;
                return false;
            }
            return true;
        }
        if ("isAuthenticated".equals(cond)) {
            return this.sessionContext.isAuthenticated();
        }
        if ("hasRole".equals(cond)) {
            UserContext user = this.sessionContext.getUser();
            if (user == null) {
                return false;
            }
            String role = conditionElement.attributeValue("name");
            if (role == null) {
                return this.sessionContext.hasPermission(Right.HasRole);
            }
            if (user.getCurrentAuthority() == null) {
                return "Anonymous".equals(role);
            }
            return role.equalsIgnoreCase(user.getCurrentAuthority().getRole());
        }
        if ("propertyEquals".equals(cond)) {
            return conditionElement.attributeValue("value", "true").equalsIgnoreCase(ApplicationProperties.getProperty(conditionElement.attributeValue("name", "dummy"), conditionElement.attributeValue("defaultValue", "false")));
        }
        if ("hasProperty".equals(cond)) {
            return ApplicationProperties.getProperty(conditionElement.attributeValue("name", "dummy")) != null;
        }
        if ("hasPermission".equals(cond)) {
            Right right = null;
            try {
                right = Right.valueOf(conditionElement.attributeValue("name"));
            }
            catch (IllegalArgumentException e) {
                sLog.warn((Object)("Unknown right: " + conditionElement.attributeValue("name")));
            }
            if (right == null) {
                return false;
            }
            String authority = conditionElement.attributeValue("authority", "current");
            if ("session".equals(authority)) {
                Long sessionId = this.sessionContext.isAuthenticated() ? this.sessionContext.getUser().getCurrentAcademicSessionId() : null;
                return sessionId == null ? false : this.sessionContext.hasPermissionAnyAuthority(right, new SimpleQualifier("Session", sessionId));
            }
            if ("role".equals(authority)) {
                UserAuthority ua = this.sessionContext.isAuthenticated() ? this.sessionContext.getUser().getCurrentAuthority() : null;
                String role = ua != null ? ua.getRole() : null;
                return role == null ? false : this.sessionContext.hasPermissionAnyAuthority(right, new SimpleQualifier("Role", (Serializable)((Object)role)));
            }
            if ("any".equals(authority)) {
                return this.sessionContext.hasPermissionAnyAuthority(right, new Qualifiable[0]);
            }
            return this.sessionContext.hasPermission(right);
        }
        if ("hasRight".equals(cond)) {
            String right = conditionElement.attributeValue("name", "unknown");
            if ("canSeeEvents".equals(right)) {
                return this.sessionContext.hasPermissionAnyAuthority(Right.Events, new Qualifiable[0]);
            }
            if ("hasRoomAvailability".equals(right)) {
                return RoomAvailability.getInstance() != null;
            }
            if ("hasPersonalReport".equals(right)) {
                return this.sessionContext.isAuthenticated() && PersonalizedExamReportAction.hasPersonalReport(this.sessionContext.getUser().getExternalUserId());
            }
            if ("isChameleon".equals(right)) {
                return this.sessionContext.isAuthenticated() && (this.sessionContext.hasPermission(Right.Chameleon) || this.sessionContext.getUser() instanceof UserContext.Chameleon);
            }
            if ("isSectioningEnabled".equals(right)) {
                return this.solverServerService.isOnlineStudentSchedulingEnabled();
            }
            if ("isStudent".equals(right)) {
                return this.sessionContext.isAuthenticated() && this.sessionContext.getUser().hasRole("Student");
            }
            if ("isInstructor".equals(right)) {
                return this.sessionContext.isAuthenticated() && this.sessionContext.getUser().hasRole("Instructor");
            }
            if ("isRegistrationEnabled".equals(right)) {
                return this.solverServerService.isStudentRegistrationEnabled();
            }
            if ("canSeeCourses".equals(right)) {
                return this.sessionContext.hasPermission(Right.InstructionalOfferings) || this.sessionContext.hasPermission(Right.Classes);
            }
            if ("canSeeTimetable".equals(right)) {
                return this.sessionContext.hasPermission(Right.ClassAssignments);
            }
            if ("canDoTimetable".equals(right)) {
                return this.sessionContext.hasPermission(Right.CourseTimetabling);
            }
            if ("hasASolverGroup".equals(right)) {
                return this.sessionContext.isAuthenticated() && !SolverGroup.getUserSolverGroups(this.sessionContext.getUser()).isEmpty();
            }
            if ("canSectionStudents".equals(right)) {
                return this.sessionContext.hasPermission(Right.StudentScheduling);
            }
            if ("canSeeExams".equals(right)) {
                return this.sessionContext.hasPermission(Right.Examinations);
            }
            if ("canTimetableExams".equals(right)) {
                return this.sessionContext.hasPermission(Right.ExaminationTimetabling);
            }
            if ("canAudit".equals(right)) {
                return this.sessionContext.hasPermission(Right.CourseTimetablingAudit);
            }
            if ("hasCourseReports".equals(right)) {
                return this.sessionContext.hasPermission(Right.HQLReportsCourses) && SavedHQL.hasQueries(SavedHQL.Flag.APPEARANCE_COURSES, this.sessionContext.hasPermission(Right.HQLReportsAdminOnly));
            }
            if ("hasExamReports".equals(right)) {
                return this.sessionContext.hasPermission(Right.HQLReportsExaminations) && SavedHQL.hasQueries(SavedHQL.Flag.APPEARANCE_EXAMS, this.sessionContext.hasPermission(Right.HQLReportsAdminOnly));
            }
            if ("hasEventReports".equals(right)) {
                return this.sessionContext.hasPermission(Right.HQLReportsEvents) && SavedHQL.hasQueries(SavedHQL.Flag.APPEARANCE_EVENTS, this.sessionContext.hasPermission(Right.HQLReportsAdminOnly));
            }
            if ("hasStudentReports".equals(right)) {
                return this.sessionContext.hasPermission(Right.HQLReportsStudents) && SavedHQL.hasQueries(SavedHQL.Flag.APPEARANCE_SECTIONING, this.sessionContext.hasPermission(Right.HQLReportsAdminOnly));
            }
            sLog.warn((Object)("Unknown right " + right + "."));
            return true;
        }
        sLog.warn((Object)("Unknown condition " + cond + "."));
        return true;
    }
}

