/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server;

import java.text.DecimalFormat;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.timetable.gwt.client.solver.SolverAllocatedMemory;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.solver.service.SolverServerService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtRpcImplements(value=SolverAllocatedMemory.SolverAllocatedMemoryRpcRequest.class)
public class SolverAllocatedMemoryBackend
implements GwtRpcImplementation<SolverAllocatedMemory.SolverAllocatedMemoryRpcRequest, SolverAllocatedMemory.SolverAllocatedMemoryRpcResponse> {
    @Autowired
    SolverServerService solverServerService;

    @Override
    public SolverAllocatedMemory.SolverAllocatedMemoryRpcResponse execute(SolverAllocatedMemory.SolverAllocatedMemoryRpcRequest request, SessionContext context) {
        long memUsage = 0L;
        switch (request.getSolverId().charAt(0)) {
            case 'C': {
                memUsage = this.solverServerService.getCourseSolverContainer().getMemUsage(request.getSolverId().substring(1));
                break;
            }
            case 'X': {
                memUsage = this.solverServerService.getExamSolverContainer().getMemUsage(request.getSolverId().substring(1));
                break;
            }
            case 'S': {
                memUsage = this.solverServerService.getStudentSolverContainer().getMemUsage(request.getSolverId().substring(1));
                break;
            }
            case 'O': {
                if (request.getSolverId().indexOf(58) >= 0) {
                    String[] idHost = request.getSolverId().substring(1).split(":");
                    OnlineSectioningServer server = this.solverServerService.getServer(idHost[0]).getOnlineStudentSchedulingContainer().getSolver(idHost[1]);
                    if (server == null) break;
                    memUsage = server.getMemUsage();
                    break;
                }
                memUsage = this.solverServerService.getOnlineStudentSchedulingContainer().getMemUsage(request.getSolverId().substring(1));
            }
        }
        if (memUsage == 0L) {
            return null;
        }
        return new SolverAllocatedMemory.SolverAllocatedMemoryRpcResponse(new DecimalFormat("0.00").format((double)memUsage / 1048576.0) + "M");
    }
}

