/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.cpsolver.coursett.Constants;
import org.cpsolver.ifs.heuristics.RouletteWheelSelection;
import org.hibernate.Session;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.OnlineSectioningTestFwk;
import org.unitime.timetable.onlinesectioning.basic.GetRequest;
import org.unitime.timetable.onlinesectioning.solver.ComputeSuggestionsAction;
import org.unitime.timetable.onlinesectioning.solver.FindAssignmentAction;
import org.unitime.timetable.onlinesectioning.updates.EnrollStudent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OnlineSectioningTest
extends OnlineSectioningTestFwk {
    private static String[] sDays = new String[]{"M", "T", "W", "R", "F", "S", "X"};

    private static List<ClassAssignmentInterface.ClassAssignment> toClassAssignments(ClassAssignmentInterface assignment) {
        if (assignment == null) {
            return null;
        }
        ArrayList<ClassAssignmentInterface.ClassAssignment> ret = new ArrayList<ClassAssignmentInterface.ClassAssignment>();
        for (ClassAssignmentInterface.CourseAssignment course : assignment.getCourseAssignments()) {
            ret.addAll(course.getClassAssignments());
        }
        return ret;
    }

    private ClassAssignmentInterface.CourseAssignment course(CourseRequestInterface.Request request, ClassAssignmentInterface assignment) {
        if (assignment == null) {
            return null;
        }
        for (ClassAssignmentInterface.CourseAssignment course : assignment.getCourseAssignments()) {
            if (request.hasRequestedFreeTime() && course.isFreeTime()) {
                for (CourseRequestInterface.FreeTime ft : request.getRequestedFreeTime()) {
                    for (ClassAssignmentInterface.ClassAssignment clazz : course.getClassAssignments()) {
                        if (ft.getStart() != clazz.getStart() || ft.getLength() != clazz.getLength() || !ft.getDaysString(sDays, "").equals(clazz.getDaysString(sDays, ""))) continue;
                        return course;
                    }
                }
            }
            if (!request.hasRequestedCourse() || course.isFreeTime()) continue;
            if (course.getCourseName().equals(request.getRequestedCourse())) {
                return course;
            }
            if (request.hasFirstAlternative() && course.getCourseName().equals(request.getFirstAlternative())) {
                return course;
            }
            if (!request.hasSecondAlternative() || !course.getCourseName().equals(request.getSecondAlternative())) continue;
            return course;
        }
        return null;
    }

    private double penalty(StudentPreferencePenalties penalty, CourseRequestInterface request, ClassAssignmentInterface assignment) {
        ClassAssignmentInterface.CourseAssignment course;
        double ret = 0.0;
        int unassigned = 0;
        for (CourseRequestInterface.Request r : request.getCourses()) {
            course = this.course(r, assignment);
            if (course == null || !course.isAssigned()) {
                ret += 10.0;
                if (!r.hasRequestedCourse()) continue;
                ++unassigned;
                continue;
            }
            ret += penalty.getPenalty(course);
        }
        for (CourseRequestInterface.Request r : request.getAlternatives()) {
            if (unassigned <= 0) break;
            course = this.course(r, assignment);
            if (course == null || !course.isAssigned()) continue;
            --unassigned;
            ret += penalty.getPenalty(course);
        }
        return ret;
    }

    private boolean isBetter(StudentPreferencePenalties penalty, CourseRequestInterface request, ClassAssignmentInterface assignment, ClassAssignmentInterface suggestion) {
        return this.penalty(penalty, request, suggestion) < this.penalty(penalty, request, assignment);
    }

    private String toString(StudentPreferencePenalties penalty, CourseRequestInterface request, ClassAssignmentInterface assignment) {
        ClassAssignmentInterface.CourseAssignment course;
        String ret = sDF.format(this.penalty(penalty, request, assignment)) + "/{";
        int priority = 1;
        int unassigned = 0;
        for (CourseRequestInterface.Request r : request.getCourses()) {
            course = this.course(r, assignment);
            if (course == null || !course.isAssigned()) {
                ret = ret + "\n    " + priority + ". " + r + " NOT ASSIGNED";
                if (r.hasRequestedCourse()) {
                    ++unassigned;
                }
            } else {
                ret = ret + "\n   " + priority + ". " + r + ": " + sDF.format(penalty.getPenalty(course)) + "/" + course.getCourseName();
                for (ClassAssignmentInterface.ClassAssignment clazz : course.getClassAssignments()) {
                    ret = ret + "\n       " + sDF.format(penalty.getPenalty(clazz)) + "/" + clazz.toString();
                }
            }
            ++priority;
        }
        priority = 1;
        for (CourseRequestInterface.Request r : request.getAlternatives()) {
            if (unassigned <= 0) break;
            course = this.course(r, assignment);
            if (course != null && course.isAssigned()) {
                --unassigned;
                ret = ret + "\n  A" + priority + ". " + r + ": " + sDF.format(penalty.getPenalty(course)) + "/" + course.getCourseName();
                for (ClassAssignmentInterface.ClassAssignment clazz : course.getClassAssignments()) {
                    ret = ret + "\n       " + sDF.format(penalty.getPenalty(clazz)) + "/" + clazz.toString();
                }
            }
            ++priority;
        }
        return ret + "\n}";
    }

    @Override
    public List<OnlineSectioningTestFwk.Operation> operations() {
        this.getServer().getAcademicSession().setSectioningEnabled(true);
        Session hibSession = new _RootDAO().getSession();
        ArrayList<OnlineSectioningTestFwk.Operation> operations = new ArrayList<OnlineSectioningTestFwk.Operation>();
        final boolean suggestions = "true".equals(System.getProperty("suggestions", "false"));
        for (final Long studentId : hibSession.createQuery("select s.uniqueId from Student s where s.session.uniqueId = :sessionId").setLong("sessionId", this.getServer().getAcademicSession().getUniqueId().longValue()).list()) {
            CourseRequestInterface request = this.getServer().execute(this.createAction(GetRequest.class).forStudent(studentId), this.user());
            if (request == null || request.getCourses().isEmpty()) continue;
            operations.add(new OnlineSectioningTestFwk.Operation(){

                public double execute(OnlineSectioningServer s) {
                    StudentPreferencePenalties penalties = new StudentPreferencePenalties(StudentPreferencePenalties.DistType.Preference);
                    CourseRequestInterface request = s.execute(OnlineSectioningTest.this.createAction(GetRequest.class).forStudent(studentId), OnlineSectioningTest.this.user());
                    if (request != null && !request.getCourses().isEmpty()) {
                        FindAssignmentAction action = null;
                        double value = 0.0;
                        for (int i = 1; i <= 5; ++i) {
                            try {
                                action = s.createAction(FindAssignmentAction.class).forRequest(request).withAssignment(new ArrayList<ClassAssignmentInterface.ClassAssignment>());
                                List<ClassAssignmentInterface> ret = s.execute(action, OnlineSectioningTest.this.user());
                                ClassAssignmentInterface assignment = ret == null || ret.isEmpty() ? null : ret.get(0);
                                List classes = OnlineSectioningTest.toClassAssignments(assignment);
                                if (assignment != null) {
                                    value = assignment.getValue();
                                }
                                if (suggestions) {
                                    for (int x = 0; x < (classes == null ? 0 : classes.size()); ++x) {
                                        List<ClassAssignmentInterface> suggestions2 = s.execute(((ComputeSuggestionsAction)s.createAction(ComputeSuggestionsAction.class).forRequest(request).withAssignment((Collection)classes)).withSelection((ClassAssignmentInterface.ClassAssignment)classes.get(x)), OnlineSectioningTest.this.user());
                                        if (suggestions2 == null || suggestions2.isEmpty()) continue;
                                        for (ClassAssignmentInterface suggestion : suggestions2) {
                                            if (!OnlineSectioningTest.this.isBetter(penalties, request, assignment, suggestion)) continue;
                                            assignment = suggestion;
                                            classes = OnlineSectioningTest.toClassAssignments(assignment);
                                        }
                                    }
                                }
                                if (classes == null) break;
                                s.execute(s.createAction(EnrollStudent.class).forStudent(studentId).withRequest(request).withAssignment(classes), OnlineSectioningTest.this.user());
                                break;
                            }
                            catch (SectioningException e) {
                                if (!e.getMessage().contains("the class is no longer available")) continue;
                                sLog.warn((Object)("Enrollment failed: " + e.getMessage() + " become unavailable (" + i + ". attempt)"));
                                continue;
                            }
                        }
                        return value;
                    }
                    return 1.0;
                }
            });
        }
        hibSession.close();
        Collections.shuffle(operations);
        return operations;
    }

    public static void main(String[] args) {
        new OnlineSectioningTest().test(Integer.valueOf(System.getProperty("nrTasks", "-1")), Integer.valueOf(System.getProperty("nrConcurrent", "10")));
    }

    public static class StudentPreferencePenalties {
        public static int[][] sStudentRequestDistribution = new int[][]{{1, 1, 4, 7, 10, 10, 5, 8, 8, 6, 3, 1}, {1, 2, 4, 7, 10, 10, 5, 8, 8, 6, 3, 1}, {1, 2, 4, 7, 10, 10, 5, 8, 8, 6, 3, 1}, {1, 2, 4, 7, 10, 10, 5, 8, 8, 6, 3, 1}, {1, 2, 4, 7, 10, 10, 5, 4, 3, 2, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}};
        private HashMap<String, Double> iWeight = new HashMap();

        public StudentPreferencePenalties(DistType disributionType) {
            RouletteWheelSelection roulette = new RouletteWheelSelection();
            for (int d = 0; d < sStudentRequestDistribution.length; ++d) {
                block7: for (int t = 0; t < sStudentRequestDistribution[d].length; ++t) {
                    switch (disributionType) {
                        case Uniform: {
                            roulette.add((Object)new int[]{d, t}, 1.0);
                            continue block7;
                        }
                        case Preference: {
                            roulette.add((Object)new int[]{d, t}, (double)sStudentRequestDistribution[d][t]);
                            continue block7;
                        }
                        case PreferenceQuadratic: {
                            roulette.add((Object)new int[]{d, t}, (double)(sStudentRequestDistribution[d][t] * sStudentRequestDistribution[d][t]));
                            continue block7;
                        }
                        case PreferenceReverse: {
                            roulette.add((Object)new int[]{d, t}, (double)(11 - sStudentRequestDistribution[d][t]));
                            continue block7;
                        }
                        default: {
                            roulette.add((Object)new int[]{d, t}, 1.0);
                        }
                    }
                }
            }
            int idx = 0;
            while (roulette.hasMoreElements()) {
                int[] dt = (int[])roulette.nextElement();
                this.iWeight.put(dt[0] + "." + dt[1], new Double((double)idx / (double)(roulette.size() - 1)));
                ++idx;
            }
        }

        public String toString(int day, int time) {
            if (time == 0) {
                return Constants.DAY_NAMES_SHORT[day] + " morning";
            }
            if (time == 11) {
                return Constants.DAY_NAMES_SHORT[day] + " evening";
            }
            return Constants.DAY_NAMES_SHORT[day] + " " + (6 + time) + ":30";
        }

        public static int time(int slot) {
            int s = slot % 288;
            int min = s * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN;
            if (min < 450) {
                return 0;
            }
            int idx = 1 + (min - 450) / 60;
            return idx > 11 ? 11 : idx;
        }

        public double getPenalty(ClassAssignmentInterface.ClassAssignment assignment) {
            if (!assignment.isAssigned()) {
                return 1.0;
            }
            int nrSlots = 0;
            double penalty = 0.0;
            for (int day : assignment.getDays()) {
                for (int idx = 0; idx < assignment.getLength(); ++idx) {
                    int slot = assignment.getStart() + idx;
                    ++nrSlots;
                    penalty += this.iWeight.get(day + "." + StudentPreferencePenalties.time(slot)).doubleValue();
                }
            }
            return penalty / (double)nrSlots;
        }

        public double getPenalty(ClassAssignmentInterface.CourseAssignment assignment) {
            if (assignment.getClassAssignments().isEmpty()) {
                return 1.0;
            }
            double penalty = 0.0;
            for (ClassAssignmentInterface.ClassAssignment clazz : assignment.getClassAssignments()) {
                penalty += this.getPenalty(clazz);
            }
            return penalty / (double)assignment.getClassAssignments().size();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum DistType {
            Uniform,
            Preference,
            PreferenceQuadratic,
            PreferenceReverse;

        }
    }
}

