/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.basic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.AssignmentMap;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.util.CSVFile;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.extension.DistanceConflict;
import org.cpsolver.studentsct.extension.TimeOverlapsCounter;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.Subpart;
import org.cpsolver.studentsct.online.OnlineSectioningModel;
import org.cpsolver.studentsct.report.SectionConflictTable;
import org.cpsolver.studentsct.report.StudentSectioningReport;
import org.cpsolver.studentsct.reservation.CourseReservation;
import org.cpsolver.studentsct.reservation.CurriculumReservation;
import org.cpsolver.studentsct.reservation.DummyReservation;
import org.cpsolver.studentsct.reservation.GroupReservation;
import org.cpsolver.studentsct.reservation.IndividualReservation;
import org.cpsolver.studentsct.reservation.Reservation;
import org.cpsolver.studentsct.reservation.ReservationOverride;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.match.AnyCourseMatcher;
import org.unitime.timetable.onlinesectioning.match.AnyStudentMatcher;
import org.unitime.timetable.onlinesectioning.model.XConfig;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XCourseReservation;
import org.unitime.timetable.onlinesectioning.model.XCurriculumReservation;
import org.unitime.timetable.onlinesectioning.model.XDistribution;
import org.unitime.timetable.onlinesectioning.model.XDistributionType;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XFreeTimeRequest;
import org.unitime.timetable.onlinesectioning.model.XGroupReservation;
import org.unitime.timetable.onlinesectioning.model.XIndividualReservation;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XReservation;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XStudentId;
import org.unitime.timetable.onlinesectioning.model.XSubpart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateSectioningReport
implements OnlineSectioningAction<CSVFile> {
    private static final long serialVersionUID = 1L;
    private DataProperties iParameters = null;

    public GenerateSectioningReport withParameters(Properties parameters) {
        this.iParameters = parameters instanceof DataProperties ? (DataProperties)parameters : new DataProperties(parameters);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CSVFile execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        Iterator<Comparable<XCourseId>> iterator;
        OnlineSectioningServer.Lock lock;
        block42: {
            lock = server.readLock();
            try {
                block41: {
                    try {
                        OnlineSectioningModel model = new OnlineSectioningModel(server.getConfig(), server.getOverExpectedCriterion());
                        model.setDistanceConflict(new DistanceConflict(server.getDistanceMetric(), model.getProperties()));
                        model.setTimeOverlaps(new TimeOverlapsCounter(null, model.getProperties()));
                        HashMap<Long, Offering> offerings = new HashMap<Long, Offering>();
                        Hashtable<Long, Course> courses = new Hashtable<Long, Course>();
                        HashMap<String, ArrayList<GroupReservation>> groups = new HashMap<String, ArrayList<GroupReservation>>();
                        Hashtable<Long, Config> configs = new Hashtable<Long, Config>();
                        Hashtable<Long, Subpart> subparts = new Hashtable<Long, Subpart>();
                        Hashtable<Long, Section> sections = new Hashtable<Long, Section>();
                        Hashtable<Long, DummyReservation> reservations = new Hashtable<Long, DummyReservation>();
                        HashSet<XDistribution> linkedSections = new HashSet<XDistribution>();
                        for (XCourseId xCourseId : server.findCourses(new AnyCourseMatcher())) {
                            XOffering offering = server.getOffering(xCourseId.getOfferingId());
                            if (offering == null || offerings.containsKey(offering.getOfferingId())) continue;
                            Offering offering2 = new Offering(offering.getOfferingId().longValue(), offering.getName());
                            offering2.setModel((Model)model);
                            Long courseId = null;
                            for (XCourse xCourse : offering.getCourses()) {
                                Course clonedCourse = new Course(xCourse.getCourseId().longValue(), xCourse.getSubjectArea(), xCourse.getCourseNumber(), offering2, xCourse.getLimit(), xCourse.getProjected());
                                clonedCourse.setNote(xCourse.getNote());
                                courses.put(xCourse.getCourseId(), clonedCourse);
                                if (!offering.getName().equals(xCourse.getCourseName())) continue;
                                courseId = xCourse.getCourseId();
                            }
                            for (XConfig xConfig : offering.getConfigs()) {
                                Config clonedConfig = new Config(xConfig.getConfigId().longValue(), xConfig.getLimit(), xConfig.getName(), offering2);
                                configs.put(xConfig.getConfigId(), clonedConfig);
                                for (XSubpart xSubpart : xConfig.getSubparts()) {
                                    Subpart clonedSubpart = new Subpart(xSubpart.getSubpartId().longValue(), xSubpart.getInstructionalType(), xSubpart.getName(), clonedConfig, xSubpart.getParentId() == null ? null : (Subpart)subparts.get(xSubpart.getParentId()));
                                    clonedSubpart.setAllowOverlap(xSubpart.isAllowOverlap());
                                    clonedSubpart.setCredit(xSubpart.getCredit(courseId));
                                    subparts.put(xSubpart.getSubpartId(), clonedSubpart);
                                    for (XSection section : xSubpart.getSections()) {
                                        Section clonedSection = new Section(section.getSectionId().longValue(), section.getLimit(), section.getName(), clonedSubpart, section.toPlacement(), section.getInstructorIds(), section.getInstructorNames(), section.getParentId() == null ? null : (Section)sections.get(section.getParentId()));
                                        clonedSection.setName(-1L, section.getName(-1L));
                                        clonedSection.setNote(section.getNote());
                                        for (XDistribution distribution : offering.getDistributions()) {
                                            if (distribution.getDistributionType() == XDistributionType.IngoreConflicts && distribution.hasSection(section.getSectionId())) {
                                                for (Long id : distribution.getSectionIds()) {
                                                    if (id.equals(section.getSectionId())) continue;
                                                    clonedSection.addIgnoreConflictWith(id.longValue());
                                                }
                                                continue;
                                            }
                                            if (distribution.getDistributionType() != XDistributionType.LinkedSections) continue;
                                            linkedSections.add(distribution);
                                        }
                                        sections.put(section.getSectionId(), clonedSection);
                                    }
                                }
                            }
                            for (XReservation xReservation : offering.getReservations()) {
                                DummyReservation clonedReservation = null;
                                switch (xReservation.getType()) {
                                    case Course: {
                                        Iterator<Map.Entry<Long, Set<Long>>> courseR = (XCourseReservation)xReservation;
                                        clonedReservation = new CourseReservation(xReservation.getReservationId().longValue(), (Course)courses.get(((XCourseReservation)((Object)courseR)).getCourseId()));
                                        break;
                                    }
                                    case Curriculum: {
                                        XCurriculumReservation xCurriculumReservation = (XCurriculumReservation)xReservation;
                                        clonedReservation = new CurriculumReservation(xReservation.getReservationId().longValue(), (double)xReservation.getLimit(), offering2, xCurriculumReservation.getAcademicArea(), xCurriculumReservation.getClassifications(), xCurriculumReservation.getMajors());
                                        break;
                                    }
                                    case Group: {
                                        XIndividualReservation indR;
                                        if (xReservation instanceof XIndividualReservation) {
                                            indR = (XIndividualReservation)xReservation;
                                            clonedReservation = new GroupReservation(xReservation.getReservationId().longValue(), (double)xReservation.getLimit(), offering2, indR.getStudentIds());
                                            break;
                                        }
                                        XGroupReservation groupR = (XGroupReservation)xReservation;
                                        clonedReservation = new GroupReservation(xReservation.getReservationId().longValue(), (double)xReservation.getLimit(), offering2, new Long[0]);
                                        ArrayList<GroupReservation> list = (ArrayList<GroupReservation>)groups.get(groupR.getGroup());
                                        if (list == null) {
                                            list = new ArrayList<GroupReservation>();
                                            groups.put(groupR.getGroup(), list);
                                        }
                                        list.add((GroupReservation)clonedReservation);
                                        break;
                                    }
                                    case Individual: {
                                        XIndividualReservation indR = (XIndividualReservation)xReservation;
                                        clonedReservation = new IndividualReservation(xReservation.getReservationId().longValue(), offering2, indR.getStudentIds());
                                        break;
                                    }
                                    case Override: {
                                        XIndividualReservation ovrR = (XIndividualReservation)xReservation;
                                        clonedReservation = new ReservationOverride(xReservation.getReservationId().longValue(), offering2, ovrR.getStudentIds());
                                        ((ReservationOverride)clonedReservation).setMustBeUsed(ovrR.mustBeUsed());
                                        ((ReservationOverride)clonedReservation).setAllowOverlap(ovrR.isAllowOverlap());
                                        ((ReservationOverride)clonedReservation).setCanAssignOverLimit(ovrR.canAssignOverLimit());
                                        break;
                                    }
                                    default: {
                                        clonedReservation = new DummyReservation(offering2);
                                    }
                                }
                                for (Long l : xReservation.getConfigsIds()) {
                                    clonedReservation.addConfig((Config)configs.get(l));
                                }
                                for (Map.Entry<Long, Set<Long>> entry : xReservation.getSections().entrySet()) {
                                    HashSet clonedSections = new HashSet();
                                    for (Long sectionId : entry.getValue()) {
                                        clonedSections.add(sections.get(sectionId));
                                    }
                                    clonedReservation.getSections().put(subparts.get(entry.getKey()), clonedSections);
                                }
                                reservations.put(xReservation.getReservationId(), clonedReservation);
                            }
                            offerings.put(offering.getOfferingId(), offering2);
                            model.addOffering(offering2);
                        }
                        HashMap<Long, Student> students = new HashMap<Long, Student>();
                        AssignmentMap assignmentMap = new AssignmentMap();
                        for (XStudentId xStudentId : server.findStudents(new AnyStudentMatcher())) {
                            XStudent student;
                            XStudent xStudent = student = xStudentId instanceof XStudent ? (XStudent)xStudentId : server.getStudent(xStudentId.getStudentId());
                            if (student == null) {
                                iterator = null;
                                Object var32_54 = null;
                                break block41;
                            }
                            Student clonnedStudent = new Student(student.getStudentId().longValue());
                            clonnedStudent.setExternalId(student.getExternalId());
                            clonnedStudent.setName(student.getName());
                            for (String g : student.getGroups()) {
                                List list = (List)groups.get(g);
                                if (list == null) continue;
                                for (Object gr : list) {
                                    gr.getStudentIds().add(student.getStudentId());
                                }
                            }
                            for (XRequest r : student.getRequests()) {
                                if (r instanceof XFreeTimeRequest) {
                                    XFreeTimeRequest ft = (XFreeTimeRequest)r;
                                    new FreeTimeRequest(r.getRequestId().longValue(), r.getPriority(), r.isAlternative(), clonnedStudent, new TimeLocation(ft.getTime().getDays(), ft.getTime().getSlot(), ft.getTime().getLength(), 0, 0.0, Long.valueOf(-1L), "Free Time", server.getAcademicSession().getFreeTimePattern(), 0));
                                } else {
                                    Object gr;
                                    XCourseRequest cr = (XCourseRequest)r;
                                    ArrayList<Course> arrayList = new ArrayList<Course>();
                                    gr = cr.getCourseIds().iterator();
                                    while (gr.hasNext()) {
                                        XCourseId c = (XCourseId)gr.next();
                                        Course course = (Course)courses.get(c.getCourseId());
                                        if (course == null) continue;
                                        arrayList.add(course);
                                    }
                                    if (!arrayList.isEmpty()) {
                                        CourseRequest clonnedRequest = new CourseRequest(r.getRequestId().longValue(), r.getPriority(), r.isAlternative(), clonnedStudent, arrayList, cr.isWaitlist(), cr.getTimeStamp() == null ? null : Long.valueOf(cr.getTimeStamp().getTime()));
                                        XEnrollment enrollment = cr.getEnrollment();
                                        if (enrollment != null) {
                                            Reservation reservation;
                                            Config config = (Config)configs.get(enrollment.getConfigId());
                                            HashSet<Section> assignments = new HashSet<Section>();
                                            for (Long sectionId : enrollment.getSectionIds()) {
                                                Section section = (Section)sections.get(sectionId);
                                                if (section == null) continue;
                                                assignments.add(section);
                                            }
                                            Reservation reservation2 = reservation = enrollment.getReservation() == null ? null : (Reservation)reservations.get(enrollment.getReservation().getReservationId());
                                            if (config != null && !sections.isEmpty()) {
                                                assignmentMap.assign(0L, (Value)new Enrollment((Request)clonnedRequest, 0, (Course)courses.get(enrollment.getCourseId()), config, assignments, reservation));
                                            }
                                        }
                                    }
                                }
                                students.put(student.getStudentId(), clonnedStudent);
                                model.addStudent(clonnedStudent);
                            }
                        }
                        for (XDistribution xDistribution : linkedSections) {
                            ArrayList<Section> linked = new ArrayList<Section>();
                            for (Long l : xDistribution.getSectionIds()) {
                                Section section = (Section)sections.get(l);
                                if (section == null) continue;
                                linked.add(section);
                            }
                            if (linked.size() <= 1) continue;
                            model.addLinkedSections(linked);
                        }
                        String name = this.iParameters.getProperty("report", SectionConflictTable.class.getName());
                        Class<?> clazz = Class.forName(name);
                        StudentSectioningReport report = (StudentSectioningReport)clazz.getConstructor(StudentSectioningModel.class).newInstance(model);
                        iterator = report.create((Assignment)assignmentMap, this.iParameters);
                        break block42;
                    }
                    catch (SectioningException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new SectioningException(e.getMessage(), e);
                    }
                }
                lock.release();
                return iterator;
            }
            catch (Throwable throwable) {
                Object var32_56 = null;
                lock.release();
                throw throwable;
            }
        }
        Object var32_55 = null;
        lock.release();
        return iterator;
    }

    @Override
    public String name() {
        return "report";
    }
}

