/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jgroups.JChannel;
import org.jgroups.UpHandler;
import org.jgroups.blocks.locking.LockService;
import org.jgroups.blocks.mux.MuxUpHandler;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.commons.jgroups.JGroupsUtils;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLogger;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServerContext;
import org.unitime.timetable.onlinesectioning.server.InMemoryServer;
import org.unitime.timetable.onlinesectioning.updates.PersistExpectedSpacesAction;
import org.unitime.timetable.solver.jgroups.DummySolverServer;
import org.unitime.timetable.solver.jgroups.SolverServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OnlineSectioningTestFwk {
    protected static Logger sLog = Logger.getLogger(OnlineSectioningTestFwk.class);
    protected static DecimalFormat sDF = new DecimalFormat("0.000");
    private OnlineSectioningServer iServer = null;
    private Pool iTasks;
    private List<Runner> iRunners;
    private Counter iFinished = new Counter();
    private Counter iExec = new Counter();
    private Counter iQuality = new Counter();
    private double iT0 = 0.0;
    private double iRunTime = 0.0;
    private JChannel iChannel = null;
    private SolverServer iSolverServer = null;
    private Long iSessionId = null;

    protected void configureLogging() {
        Properties props = new Properties();
        props.setProperty("log4j.rootLogger", "DEBUG, A1");
        props.setProperty("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
        props.setProperty("log4j.appender.A1.layout", "org.apache.log4j.PatternLayout");
        props.setProperty("log4j.appender.A1.layout.ConversionPattern", "%-5p %c{2}: %m%n");
        props.setProperty("log4j.logger.org.hibernate", "INFO");
        props.setProperty("log4j.logger.org.hibernate.cfg", "WARN");
        props.setProperty("log4j.logger.org.hibernate.cache.EhCacheProvider", "ERROR");
        props.setProperty("log4j.logger.org.unitime.commons.hibernate", "INFO");
        props.setProperty("log4j.logger.net", "INFO");
        props.setProperty("log4j.logger.org.unitime.timetable.onlinesectioning", "WARN");
        props.setProperty("log4j.logger.org.unitime.timetable.onlinesectioning.test", "INFO");
        props.setProperty("log4j.logger." + OnlineSectioningTestFwk.class.getName(), "INFO");
        props.setProperty("log4j.logger.org.cpsolver.ifs.util.JProf", "INFO");
        props.setProperty("log4j.logger.org.jgroups", "INFO");
        props.setProperty("log4j.logger.net.sf.ehcache.distribution.jgroups", "WARN");
        props.setProperty("log4j.logger.org.hibernate.cache.ehcache.AbstractEhcacheRegionFactory", "ERROR");
        props.setProperty("log4j.logger.net.sf.ehcache.distribution.jgroups.JGroupsCacheReceiver", "ERROR");
        props.setProperty("log4j.logger.org.unitime.timetable.solver.jgroups.DummySolverServer", "INFO");
        PropertyConfigurator.configure((Properties)props);
    }

    public <X extends OnlineSectioningAction> X createAction(Class<X> clazz) {
        return this.getServer().createAction(clazz);
    }

    protected void startServer() {
        final Session session = Session.getSessionUsingInitiativeYearTerm(ApplicationProperties.getProperty("initiative", "woebegon"), ApplicationProperties.getProperty("year", "2010"), ApplicationProperties.getProperty("term", "Fal"));
        boolean remote = "true".equalsIgnoreCase(ApplicationProperties.getProperty("remote", "true"));
        if (session == null) {
            sLog.error((Object)"Academic session not found, use properties initiative, year, and term to set academic session.");
            System.exit(0);
        } else {
            sLog.info((Object)("Session: " + session));
        }
        this.iSessionId = session.getUniqueId();
        OnlineSectioningLogger.getInstance().setEnabled(false);
        if (remote) {
            try {
                this.iChannel = new JChannel(JGroupsUtils.getConfigurator(ApplicationProperty.SolverClusterConfiguration.value()));
                this.iChannel.setUpHandler((UpHandler)new MuxUpHandler());
                this.iSolverServer = new DummySolverServer(this.iChannel);
                this.iChannel.connect("UniTime:rpc");
                this.iChannel.getState(null, 0L);
                if (this.getServer() == null) {
                    throw new Exception(session.getLabel() + " is not available");
                }
            }
            catch (Exception e) {
                sLog.error((Object)("Failed to access the solver server: " + e.getMessage()), (Throwable)e);
                if (this.iChannel != null && this.iChannel.isConnected()) {
                    this.iChannel.disconnect();
                }
                if (this.iChannel != null && this.iChannel.isOpen()) {
                    this.iChannel.close();
                }
                System.exit(0);
            }
        } else {
            this.iServer = new InMemoryServer(new OnlineSectioningServerContext(){

                public boolean isWaitTillStarted() {
                    return true;
                }

                public EmbeddedCacheManager getCacheManager() {
                    return null;
                }

                public Long getAcademicSessionId() {
                    return session.getUniqueId();
                }

                public LockService getLockService() {
                    return null;
                }
            });
        }
    }

    protected void stopServer() {
        if (this.iChannel == null && this.iServer != null) {
            List<Long> offeringIds = this.iServer.getOfferingsToPersistExpectedSpaces(0L);
            if (!offeringIds.isEmpty()) {
                this.iServer.execute(this.iServer.createAction(PersistExpectedSpacesAction.class).forOfferings(offeringIds), this.user());
            }
            this.iServer.unload();
        }
        this.iServer = null;
    }

    protected void close() {
        if (this.iChannel != null && this.iChannel.isConnected()) {
            this.iChannel.disconnect();
        }
        if (this.iChannel != null && this.iChannel.isOpen()) {
            this.iChannel.close();
        }
        OnlineSectioningLogger.stopLogger();
        HibernateUtil.closeHibernate();
    }

    public OnlineSectioningServer getServer() {
        if (this.iServer != null) {
            return this.iServer;
        }
        return this.iSolverServer.getOnlineStudentSchedulingContainer().getSolver(this.iSessionId.toString());
    }

    public int nrFinished() {
        return this.iFinished.count();
    }

    public double testRunTimeInSeconds() {
        return this.iRunTime;
    }

    public int nrConcurrent() {
        return this.iRunners.size();
    }

    public double totalExecutionTimeInSeconds() {
        return this.iExec.value() / 1000.0;
    }

    public double averageQuality() {
        return this.iQuality.value() / (double)this.iQuality.count();
    }

    public String toString() {
        return this.nrFinished() + " tasks finished (" + this.nrConcurrent() + " in parallel)." + " Running took " + sDF.format(this.testRunTimeInSeconds()) + " s," + " throughput " + sDF.format((double)this.nrFinished() / this.testRunTimeInSeconds()) + " tasks / s," + " wait " + sDF.format(this.totalExecutionTimeInSeconds() / (double)this.nrFinished()) + " s / task," + " quality " + sDF.format(100.0 * this.averageQuality()) + "% on average";
    }

    public synchronized void run(List<Operation> operations, int nrConcurrent) {
        sLog.info((Object)("Running " + operations.size() + " tasks..."));
        this.iRunners = new ArrayList<Runner>();
        this.iTasks = new Pool(operations);
        this.iFinished.clear();
        this.iExec.clear();
        this.iQuality.clear();
        this.iT0 = System.currentTimeMillis();
        for (int i = 0; i < nrConcurrent; ++i) {
            Runner r = new Runner();
            Thread t = new Thread(r);
            t.setDaemon(true);
            t.setName("Runner #" + (1 + i));
            t.start();
            this.iRunners.add(r);
        }
        do {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                break;
            }
            sLog.info((Object)this.toString());
        } while (this.nrFinished() < operations.size());
        sLog.info((Object)("All " + this.toString()));
    }

    public abstract List<Operation> operations();

    public OnlineSectioningLog.Entity user() {
        return OnlineSectioningLog.Entity.newBuilder().setExternalId(StudentClassEnrollment.SystemChange.TEST.name()).setName(StudentClassEnrollment.SystemChange.TEST.getName()).setType(OnlineSectioningLog.Entity.EntityType.OTHER).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test(int nrTasks, int ... nrConcurrent) {
        try {
            try {
                this.configureLogging();
                HibernateUtil.configureHibernate(ApplicationProperties.getProperties());
                this.startServer();
                List<Operation> operations = this.operations();
                Collections.shuffle(operations);
                for (int c : nrConcurrent) {
                    this.run(nrTasks <= 0 || operations.size() <= nrTasks ? operations : operations.subList(0, nrTasks), c);
                }
                this.stopServer();
            }
            catch (Exception e) {
                sLog.fatal((Object)("Test failed: " + e.getMessage()), (Throwable)e);
                Object var9_10 = null;
                this.close();
            }
            Object var9_9 = null;
            this.close();
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            this.close();
            throw throwable;
        }
    }

    public static class Counter {
        private double iValue = 0.0;
        private int iCount = 0;

        public synchronized void inc(double val) {
            this.iValue += val;
            ++this.iCount;
        }

        public synchronized int count() {
            return this.iCount;
        }

        public synchronized double value() {
            return this.iValue;
        }

        public synchronized void clear() {
            this.iValue = 0.0;
            this.iCount = 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Pool {
        private Iterator<Operation> iIterator;
        private int iCount;

        public Pool(List<Operation> operations) {
            this.iIterator = operations.iterator();
            this.iCount = 0;
        }

        public synchronized Operation next() {
            if (this.iIterator.hasNext()) {
                ++this.iCount;
                return this.iIterator.next();
            }
            return null;
        }

        public synchronized int count() {
            return this.iCount;
        }
    }

    public class Runner
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Operation op = null;
            while ((op = OnlineSectioningTestFwk.this.iTasks.next()) != null) {
                Object var7_6;
                long t0 = System.currentTimeMillis();
                try {
                    try {
                        double val = op.execute(OnlineSectioningTestFwk.this.getServer());
                        OnlineSectioningTestFwk.this.iQuality.inc(val);
                    }
                    catch (Throwable t) {
                        sLog.warn((Object)("Task failed: " + t.getMessage()), t);
                        var7_6 = null;
                        OnlineSectioningTestFwk.this.iFinished.inc(1.0);
                    }
                    var7_6 = null;
                    OnlineSectioningTestFwk.this.iFinished.inc(1.0);
                }
                catch (Throwable throwable) {
                    var7_6 = null;
                    OnlineSectioningTestFwk.this.iFinished.inc(1.0);
                    throw throwable;
                }
                long t1 = System.currentTimeMillis();
                OnlineSectioningTestFwk.this.iRunTime = ((double)t1 - OnlineSectioningTestFwk.this.iT0) / 1000.0;
                OnlineSectioningTestFwk.this.iExec.inc(t1 - t0);
            }
        }
    }

    public static interface Operation {
        public double execute(OnlineSectioningServer var1);
    }
}

