/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.Iterator;
import java.util.TreeSet;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.unitime.timetable.model.base.BaseDepartmentStatusType;
import org.unitime.timetable.model.dao.DepartmentStatusTypeDAO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DepartmentStatusType
extends BaseDepartmentStatusType
implements Comparable {
    private static final long serialVersionUID = 1L;

    public DepartmentStatusType() {
    }

    public DepartmentStatusType(Long uniqueId) {
        super(uniqueId);
    }

    public static DepartmentStatusType findById(Integer uid) throws Exception {
        if (uid == null) {
            return null;
        }
        return (DepartmentStatusType)new DepartmentStatusTypeDAO().getSession().createCriteria(DepartmentStatusType.class).add((Criterion)Restrictions.eq((String)"uniqueId", (Object)uid)).uniqueResult();
    }

    public static TreeSet findAll() {
        return new TreeSet(new DepartmentStatusTypeDAO().findAll());
    }

    public static TreeSet<DepartmentStatusType> findAll(int apply) {
        TreeSet ret = DepartmentStatusType.findAll();
        Iterator i = ret.iterator();
        while (i.hasNext()) {
            DepartmentStatusType t = (DepartmentStatusType)i.next();
            if (t.apply(apply)) continue;
            i.remove();
        }
        return ret;
    }

    public static TreeSet<DepartmentStatusType> findAllForSession(boolean includeTestSessions) {
        TreeSet<DepartmentStatusType> ret = DepartmentStatusType.findAll(Apply.Session.toInt());
        if (!includeTestSessions) {
            Iterator<DepartmentStatusType> i = ret.iterator();
            while (i.hasNext()) {
                if (!i.next().isTestSession()) continue;
                i.remove();
            }
        }
        return ret;
    }

    public static TreeSet<DepartmentStatusType> findAllForDepartment() {
        return DepartmentStatusType.findAll(Apply.Department.toInt());
    }

    public static DepartmentStatusType findByRef(String ref) {
        if (ref == null) {
            return null;
        }
        return (DepartmentStatusType)new DepartmentStatusTypeDAO().getSession().createCriteria(DepartmentStatusType.class).add((Criterion)Restrictions.eq((String)"reference", (Object)ref)).uniqueResult();
    }

    public int compareTo(Object o) {
        if (o == null || !(o instanceof DepartmentStatusType)) {
            return -1;
        }
        DepartmentStatusType t = (DepartmentStatusType)o;
        int cmp = this.getOrd().compareTo(t.getOrd());
        if (cmp != 0) {
            return cmp;
        }
        return (this.getUniqueId() == null ? new Long(-1L) : this.getUniqueId()).compareTo(t.getUniqueId() == null ? -1L : t.getUniqueId());
    }

    public boolean can(int operation) {
        return (this.getStatus() & operation) == operation;
    }

    public boolean can(Status status) {
        return this.can(status.toInt());
    }

    public boolean canManagerEdit() {
        return this.can(Status.ManagerEdit);
    }

    public boolean canManagerLimitedEdit() {
        return this.can(Status.ManagerLimitedEdit);
    }

    public boolean canManagerView() {
        return this.can(Status.ManagerView);
    }

    public boolean canOwnerEdit() {
        return this.can(Status.OwnerEdit);
    }

    public boolean canOwnerLimitedEdit() {
        return this.can(Status.OwnerLimitedEdit);
    }

    public boolean canOwnerView() {
        return this.can(Status.OwnerView);
    }

    public boolean canAudit() {
        return this.can(Status.Audit);
    }

    public boolean canTimetable() {
        return this.can(Status.Timetable);
    }

    public boolean canCommit() {
        return this.can(Status.Commit);
    }

    public boolean canExamView() {
        return this.can(Status.ExamView);
    }

    public boolean canExamEdit() {
        return this.can(Status.ExamEdit);
    }

    public boolean canExamTimetable() {
        return this.can(Status.ExamTimetable);
    }

    public boolean canNoRoleReportExamFinal() {
        return this.can(Status.ReportExamsFinal);
    }

    public boolean canNoRoleReportExamMidterm() {
        return this.can(Status.ReportExamsMidterm);
    }

    public boolean canNoRoleReportClass() {
        return this.can(Status.ReportClasses);
    }

    public boolean canSectionAssistStudents() {
        return this.can(Status.StudentsAssistant);
    }

    public boolean canPreRegisterStudents() {
        return this.can(Status.StudentsPreRegister);
    }

    public boolean canOnlineSectionStudents() {
        return this.can(Status.StudentsOnline);
    }

    public boolean isTestSession() {
        return this.can(Status.TestSession);
    }

    public boolean canNoRoleReportExam() {
        return this.canNoRoleReportExamFinal() || this.canNoRoleReportExamMidterm();
    }

    public boolean canNoRoleReport() {
        return this.canNoRoleReportClass() || this.canNoRoleReportExam();
    }

    public boolean apply(int apply) {
        return (this.getApply() & apply) == apply;
    }

    public boolean applySession() {
        return this.apply(Apply.Session.toInt());
    }

    public boolean applyDepartment() {
        return this.apply(Apply.Department.toInt());
    }

    public boolean isAllowNoRole() {
        return this.can(Status.AllowNoRole);
    }

    public boolean isAllowRollForward() {
        return this.can(Status.AllowRollForward);
    }

    public boolean isActive() {
        return this.canTimetable() || this.canCommit() || this.canManagerEdit() || this.canOwnerEdit() || this.canManagerLimitedEdit() || this.canOwnerLimitedEdit() || this.canExamEdit() || this.canExamTimetable() || this.canNoRoleReport();
    }

    public boolean canLockOfferings() {
        return !this.isTestSession() && (this.canOnlineSectionStudents() || this.canSectionAssistStudents());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Apply {
        Session,
        Department;


        public int toInt() {
            return 1 << this.ordinal();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        ManagerView,
        ManagerEdit,
        ManagerLimitedEdit,
        OwnerView,
        OwnerEdit,
        OwnerLimitedEdit,
        Audit,
        Timetable,
        Commit,
        ExamView,
        ExamEdit,
        ExamTimetable,
        ReportExamsFinal,
        ReportExamsMidterm,
        ReportClasses,
        StudentsAssistant,
        StudentsPreRegister,
        StudentsOnline,
        TestSession,
        AllowNoRole,
        AllowRollForward;


        public int toInt() {
            return 1 << this.ordinal();
        }

        public boolean has(int rights) {
            return (rights & this.toInt()) == this.toInt();
        }
    }
}

