/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.coursett.preference.MinMaxPreferenceCombination;
import org.hibernate.FlushMode;
import org.hibernate.Transaction;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.interfaces.ExternalClassEditAction;
import org.unitime.timetable.interfaces.ExternalClassNameHelperInterface;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.AssignmentInfo;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.BuildingPref;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.ClassEvent;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.ConstraintInfo;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentRoomFeature;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.DistributionObject;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.EventNote;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.GlobalRoomFeature;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Meeting;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Reservation;
import org.unitime.timetable.model.RoomDept;
import org.unitime.timetable.model.RoomFeature;
import org.unitime.timetable.model.RoomFeaturePref;
import org.unitime.timetable.model.RoomGroup;
import org.unitime.timetable.model.RoomGroupPref;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.SectioningInfo;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Solution;
import org.unitime.timetable.model.SolverGroup;
import org.unitime.timetable.model.SolverInfoDef;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.base.BaseClass_;
import org.unitime.timetable.model.comparators.InstructorComparator;
import org.unitime.timetable.model.comparators.NavigationComparator;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.DatePatternDAO;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.model.dao.SectioningInfoDAO;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.solver.CommitedClassAssignmentProxy;
import org.unitime.timetable.solver.course.ui.ClassAssignmentInfo;
import org.unitime.timetable.solver.course.ui.ClassInstructorInfo;
import org.unitime.timetable.solver.course.ui.ClassRoomInfo;
import org.unitime.timetable.solver.ui.AssignmentPreferenceInfo;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.DefaultExternalClassNameHelper;
import org.unitime.timetable.webutil.Navigation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Class_
extends BaseClass_ {
    private static final long serialVersionUID = 1L;
    private static ExternalClassNameHelperInterface externalClassNameHelper = null;
    private static CourseMessages MSG = Localization.create(CourseMessages.class);
    protected static GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    private ClassEvent iEvent = null;

    public Class_() {
    }

    public Class_(Long uniqueId) {
        super(uniqueId);
    }

    public String getCourseName() {
        return this.getSchedulingSubpart().getCourseName();
    }

    public String getCourseNameWithTitle() {
        return this.getSchedulingSubpart().getCourseNameWithTitle();
    }

    public String getItypeDesc() {
        return this.getSchedulingSubpart().getItypeDesc();
    }

    @Override
    public Department getManagingDept() {
        if (super.getManagingDept() == null) {
            return this.getControllingDept();
        }
        return super.getManagingDept();
    }

    @Override
    public void setManagingDept(Department dept) {
        Department oldDept = this.getManagingDept();
        super.setManagingDept(dept);
        if (dept == null) {
            return;
        }
        if (oldDept != null && !oldDept.equals(dept) && this.getAssignments() != null && !this.getAssignments().isEmpty()) {
            Iterator<Assignment> i = this.getAssignments().iterator();
            while (i.hasNext()) {
                Assignment a = i.next();
                if (a.getSolution().getOwner().getDepartments().contains(dept)) continue;
                Class_DAO.getInstance().getSession().delete((Object)a);
                i.remove();
            }
            ClassEvent event = this.getEvent();
            if (event != null) {
                Class_DAO.getInstance().getSession().delete((Object)event);
            }
        }
    }

    public Department getDepartmentForSubjectArea() {
        Department dept = this.getSchedulingSubpart().getInstrOfferingConfig().getControllingCourseOffering().getSubjectArea().getDepartment();
        return dept;
    }

    @Override
    public Session getSession() {
        return this.getSchedulingSubpart().getSession();
    }

    public Long getSessionId() {
        return this.getSchedulingSubpart().getSessionId();
    }

    public Set classInstructorPrefsOfType(Class type) {
        List<DepartmentalInstructor> instructors = this.getLeadInstructors();
        if (instructors.isEmpty()) {
            return null;
        }
        Set<Preference> ret = null;
        for (DepartmentalInstructor instructor : instructors) {
            if (ret == null) {
                ret = instructor.getPreferences(type);
                continue;
            }
            ret = this.combinePreferences(ret, instructor.getPreferences(type));
        }
        return ret;
    }

    private Set weakenHardPreferences(Set prefs) {
        if (prefs == null || prefs.isEmpty()) {
            return prefs;
        }
        TreeSet<Preference> ret = new TreeSet<Preference>();
        Iterator i = prefs.iterator();
        while (i.hasNext()) {
            Preference pref = (Preference)((Preference)i.next()).clone();
            if (!pref.weakenHardPreferences()) continue;
            ret.add(pref);
        }
        return ret;
    }

    private Set removeNeutralPreferences(Set prefs) {
        if (prefs == null) {
            return new TreeSet();
        }
        if (prefs.isEmpty()) {
            return prefs;
        }
        TreeSet ret = new TreeSet(prefs);
        Iterator i = ret.iterator();
        while (i.hasNext()) {
            Preference pref = (Preference)i.next();
            if (!PreferenceLevel.sNeutral.equals(pref.getPrefLevel().getPrefProlog())) continue;
            i.remove();
        }
        return ret;
    }

    private Set removeDepartmentalPreferences(Set prefs) {
        if (prefs == null) {
            return new TreeSet();
        }
        if (prefs.isEmpty()) {
            return prefs;
        }
        TreeSet<Preference> ret = new TreeSet<Preference>();
        block0: for (Preference pref : prefs) {
            if (pref instanceof RoomPref) {
                Location loc = ((RoomPref)pref).getRoom();
                for (RoomDept rd : loc.getRoomDepts()) {
                    if (!rd.getDepartment().equals(this.getManagingDept())) continue;
                    ret.add(pref);
                    continue block0;
                }
                continue;
            }
            if (pref instanceof BuildingPref) {
                Building b = ((BuildingPref)pref).getBuilding();
                if (!this.getAvailableBuildings().contains(b)) continue;
                ret.add(pref);
                continue;
            }
            if (pref instanceof RoomFeaturePref) {
                RoomFeature rf = ((RoomFeaturePref)pref).getRoomFeature();
                if (rf instanceof GlobalRoomFeature) {
                    ret.add(pref);
                    continue;
                }
                if (!(rf instanceof DepartmentRoomFeature) || !((DepartmentRoomFeature)rf).getDepartment().equals(this.getManagingDept())) continue;
                ret.add(pref);
                continue;
            }
            if (pref instanceof RoomGroupPref) {
                RoomGroup rg = ((RoomGroupPref)pref).getRoomGroup();
                if (!rg.isGlobal().booleanValue() && !this.getManagingDept().equals(rg.getDepartment())) continue;
                ret.add(pref);
                continue;
            }
            ret.add(pref);
        }
        return ret;
    }

    private Set<Preference> combinePreferences(Set<Preference> instrPrefs1, Set<Preference> instrPrefs2) {
        if (instrPrefs1 == null || instrPrefs1.isEmpty()) {
            return instrPrefs2;
        }
        if (instrPrefs2 == null || instrPrefs2.isEmpty()) {
            return instrPrefs1;
        }
        TreeSet<Preference> ret = new TreeSet<Preference>();
        TimePref tp = null;
        for (Preference p1 : instrPrefs1) {
            if (p1 instanceof TimePref) {
                if (tp == null) {
                    tp = (TimePref)p1.clone();
                    continue;
                }
                tp.combineWith((TimePref)p1, false);
                continue;
            }
            ret.add(p1);
        }
        for (Preference p2 : instrPrefs2) {
            if (!(p2 instanceof TimePref)) continue;
            if (tp == null) {
                tp = (TimePref)p2.clone();
                continue;
            }
            tp.combineWith((TimePref)p2, false);
        }
        for (Preference p2 : instrPrefs2) {
            Preference p1 = null;
            Iterator j = ret.iterator();
            while (j.hasNext()) {
                Preference p = (Preference)j.next();
                if (!p.isSame(p2)) continue;
                p1 = p;
                j.remove();
                break;
            }
            if (p1 == null) {
                ret.add(p2);
                continue;
            }
            Preference combPref = (Preference)p1.clone();
            MinMaxPreferenceCombination com = new MinMaxPreferenceCombination();
            com.addPreferenceProlog(p1.getPrefLevel().getPrefProlog());
            com.addPreferenceProlog(p2.getPrefLevel().getPrefProlog());
            combPref.setPrefLevel(PreferenceLevel.getPreferenceLevel(com.getPreferenceProlog()));
            ret.add(combPref);
        }
        if (tp != null) {
            ret.add(tp);
        }
        return ret;
    }

    private Set combinePreferences(Class type, Set subpartPrefs, Set instrPrefs) {
        if (TimePref.class.equals((Object)type)) {
            if (subpartPrefs == null || subpartPrefs.isEmpty() || instrPrefs == null || instrPrefs.isEmpty()) {
                return subpartPrefs;
            }
            TimePref instrPref = (TimePref)instrPrefs.iterator().next();
            TreeSet<TimePref> ret = new TreeSet<TimePref>();
            Iterator i = subpartPrefs.iterator();
            while (i.hasNext()) {
                TimePref pref = (TimePref)((TimePref)i.next()).clone();
                pref.combineWith(instrPref, false);
                ret.add(pref);
            }
            return ret;
        }
        if (subpartPrefs == null || subpartPrefs.isEmpty()) {
            return instrPrefs;
        }
        if (instrPrefs == null || instrPrefs.isEmpty()) {
            return subpartPrefs;
        }
        TreeSet<Preference> ret = new TreeSet<Preference>(subpartPrefs);
        for (Preference instrPref : instrPrefs) {
            Preference subpartPref = null;
            Iterator j = ret.iterator();
            while (j.hasNext()) {
                Preference p = (Preference)j.next();
                if (!p.isSame(instrPref)) continue;
                subpartPref = p;
                j.remove();
                break;
            }
            if (subpartPref == null) {
                ret.add(instrPref);
                continue;
            }
            Preference combPref = (Preference)subpartPref.clone();
            MinMaxPreferenceCombination com = new MinMaxPreferenceCombination();
            com.addPreferenceProlog(instrPref.getPrefLevel().getPrefProlog());
            com.addPreferenceProlog(subpartPref.getPrefLevel().getPrefProlog());
            combPref.setPrefLevel(PreferenceLevel.getPreferenceLevel(com.getPreferenceProlog()));
            ret.add(combPref);
        }
        return ret;
    }

    private Set combinePreferences(Class type, Set classPrefs, Set subpartPrefs, Set instrPrefs) {
        TreeSet<Preference> ret = new TreeSet<Preference>(classPrefs);
        Set combined = this.combinePreferences(type, subpartPrefs, instrPrefs);
        if (combined == null) {
            return ret;
        }
        for (Preference combPref : combined) {
            Preference classPref = null;
            for (Preference p : classPrefs) {
                if (!p.isSame(combPref)) continue;
                classPref = p;
                break;
            }
            if (classPref != null) continue;
            ret.add(combPref);
        }
        return ret;
    }

    @Override
    public Set getDistributionPreferences() {
        TreeSet<DistributionPref> prefs = new TreeSet<DistributionPref>();
        if (this.getDistributionObjects() != null) {
            for (DistributionObject distObj : this.getDistributionObjects()) {
                prefs.add(distObj.getDistributionPref());
            }
        }
        return prefs;
    }

    public Set effectiveDistributionPreferences(Department owningDept) {
        DistributionPref pref;
        TreeSet<DistributionPref> prefs = new TreeSet<DistributionPref>();
        if (this.getDistributionObjects() != null) {
            for (DistributionObject distObj : this.getDistributionObjects()) {
                pref = distObj.getDistributionPref();
                if (owningDept != null && !owningDept.equals(pref.getOwner())) continue;
                prefs.add(pref);
            }
        }
        if (this.getSchedulingSubpart().getDistributionObjects() != null) {
            for (DistributionObject distObj : this.getSchedulingSubpart().getDistributionObjects()) {
                pref = distObj.getDistributionPref();
                if (owningDept != null && !owningDept.equals(pref.getOwner())) continue;
                prefs.add(pref);
            }
        }
        return prefs;
    }

    @Override
    public Set effectivePreferences(Class type, Vector leadInstructors) {
        Set subpartPrefs;
        Department mngDept = this.getManagingDept();
        if (DistributionPref.class.equals((Object)type)) {
            return this.effectiveDistributionPreferences(mngDept);
        }
        if (leadInstructors == null || leadInstructors.isEmpty()) {
            return this.effectivePreferences(type);
        }
        Set instrPrefs = null;
        Enumeration e = leadInstructors.elements();
        while (e.hasMoreElements()) {
            DepartmentalInstructor leadInstructor = (DepartmentalInstructor)e.nextElement();
            instrPrefs = this.combinePreferences(instrPrefs, leadInstructor.prefsOfTypeForDepartment(type, this.getControllingDept()));
        }
        if (instrPrefs != null && !instrPrefs.isEmpty()) {
            if (TimePref.class.equals((Object)type)) {
                if (mngDept.isExternalManager().booleanValue() && !mngDept.isAllowReqTime().booleanValue()) {
                    instrPrefs = this.weakenHardPreferences(instrPrefs);
                }
            } else if (mngDept.isExternalManager().booleanValue() && !mngDept.isAllowReqRoom().booleanValue()) {
                instrPrefs = this.weakenHardPreferences(instrPrefs);
            }
        }
        if (mngDept.isExternalManager().booleanValue() && instrPrefs != null && !instrPrefs.isEmpty()) {
            instrPrefs = this.removeDepartmentalPreferences(instrPrefs);
        }
        Set set = subpartPrefs = this.getSchedulingSubpart().canInheritParentPreferences() ? this.getSchedulingSubpart().effectivePreferences(type, this) : this.getSchedulingSubpart().getPreferences(type, this);
        if (subpartPrefs != null && !subpartPrefs.isEmpty() && !mngDept.equals(this.getSchedulingSubpart().getManagingDept())) {
            if (TimePref.class.equals((Object)type)) {
                if (mngDept.isExternalManager().booleanValue() && !mngDept.isAllowReqTime().booleanValue()) {
                    subpartPrefs = this.weakenHardPreferences(subpartPrefs);
                }
            } else if (mngDept.isExternalManager().booleanValue() && !mngDept.isAllowReqRoom().booleanValue()) {
                subpartPrefs = this.weakenHardPreferences(subpartPrefs);
            }
            if (mngDept.isExternalManager().booleanValue() && instrPrefs != null && !instrPrefs.isEmpty()) {
                subpartPrefs = this.removeDepartmentalPreferences(subpartPrefs);
            }
        }
        return this.removeNeutralPreferences(this.combinePreferences(type, subpartPrefs, instrPrefs));
    }

    @Override
    public Set effectivePreferences(Class type) {
        Set subpartPrefs;
        Department mngDept = this.getManagingDept();
        if (DistributionPref.class.equals((Object)type)) {
            Set instPref;
            Set prefs = this.effectiveDistributionPreferences(mngDept);
            if (!mngDept.isExternalManager().booleanValue() && (instPref = this.classInstructorPrefsOfType(type)) != null) {
                prefs.addAll(instPref);
            }
            return prefs;
        }
        Set classPrefs = this.getPreferences(type, this);
        Set instrPrefs = null;
        if (mngDept.isInheritInstructorPreferences().booleanValue()) {
            instrPrefs = this.classInstructorPrefsOfType(type);
            if (instrPrefs != null && !instrPrefs.isEmpty()) {
                if (mngDept.isExternalManager().booleanValue() && TimePref.class.equals((Object)type)) {
                    if (!mngDept.isAllowReqTime().booleanValue()) {
                        instrPrefs = this.weakenHardPreferences(instrPrefs);
                    }
                } else if (mngDept.isExternalManager().booleanValue() && !mngDept.isAllowReqRoom().booleanValue()) {
                    instrPrefs = this.weakenHardPreferences(instrPrefs);
                }
            }
            if (mngDept.isExternalManager().booleanValue() && instrPrefs != null && !instrPrefs.isEmpty()) {
                instrPrefs = this.removeDepartmentalPreferences(instrPrefs);
            }
        }
        boolean hasExactTimePattern = false;
        if (TimePref.class.equals((Object)type) && classPrefs != null && !classPrefs.isEmpty()) {
            for (TimePref tp : classPrefs) {
                if (tp.getTimePattern() == null || tp.getTimePattern().getType() != 5) continue;
                hasExactTimePattern = true;
                break;
            }
        }
        Set set = hasExactTimePattern ? null : (subpartPrefs = this.getSchedulingSubpart().canInheritParentPreferences() ? this.getSchedulingSubpart().effectivePreferences(type, this) : this.getSchedulingSubpart().getPreferences(type, this));
        if (subpartPrefs != null && !subpartPrefs.isEmpty() && !mngDept.equals(this.getSchedulingSubpart().getManagingDept())) {
            if (TimePref.class.equals((Object)type)) {
                if (mngDept.isExternalManager().booleanValue() && !mngDept.isAllowReqTime().booleanValue()) {
                    subpartPrefs = this.weakenHardPreferences(subpartPrefs);
                }
            } else if (mngDept.isExternalManager().booleanValue() && !mngDept.isAllowReqRoom().booleanValue()) {
                subpartPrefs = this.weakenHardPreferences(subpartPrefs);
            }
            if (mngDept.isExternalManager().booleanValue() && instrPrefs != null && !instrPrefs.isEmpty()) {
                subpartPrefs = this.removeDepartmentalPreferences(subpartPrefs);
            }
        }
        return this.removeNeutralPreferences(this.combinePreferences(type, classPrefs, subpartPrefs, instrPrefs));
    }

    public String instructorHtml(String instructorNameFormat) {
        StringBuffer sb = new StringBuffer();
        if (this.getClassInstructors() == null) {
            return "";
        }
        TreeSet<ClassInstructor> sortedInstructors = new TreeSet<ClassInstructor>(new InstructorComparator());
        sortedInstructors.addAll(this.getClassInstructors());
        Iterator it = sortedInstructors.iterator();
        ClassInstructor ci = null;
        while (it.hasNext()) {
            ci = (ClassInstructor)it.next();
            String title = ci.getInstructor().getNameLastFirst();
            title = title + " (" + ci.getPercentShare() + "%" + (ci.isLead() != false ? ", lead" : "") + ")";
            if (!this.isDisplayInstructor().booleanValue()) {
                title = title + " - Do Not Display Instructor.";
            }
            if (ci.isLead().booleanValue()) {
                sb.append("<span style='font-weight:bold;" + (this.isDisplayInstructor() != false ? "" : "font-style:italic;") + "' title='" + title + "'>");
            } else {
                sb.append("<span title='" + title + "'>");
            }
            sb.append(ci.getInstructor().getName(instructorNameFormat));
            sb.append("</span>");
            if (it.hasNext()) {
                sb.append("<br>");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private String htmlForTimePatterns(Set patterns) {
        StringBuffer sb = new StringBuffer();
        if (patterns != null) {
            Iterator it = patterns.iterator();
            TimePattern t = null;
            while (it.hasNext()) {
                t = (TimePattern)it.next();
                sb.append(t.getName());
                if (!it.hasNext()) continue;
                sb.append("<BR>");
            }
        }
        if (patterns == null || patterns.isEmpty()) {
            if (this.getSchedulingSubpart().getMinutesPerWk() <= 0) {
                sb.append("<span title='Arrange Hours'>Arr Hrs</span>");
            } else {
                int nrHours = Math.round((float)this.getSchedulingSubpart().getMinutesPerWk().intValue() / 50.0f);
                sb.append("<span title='Arrange " + nrHours + " Hours'>Arr " + nrHours + " Hrs</span>");
            }
        }
        return sb.toString();
    }

    @Override
    public String effectiveTimePatternHtml() {
        return this.htmlForTimePatterns(this.effectiveTimePatterns());
    }

    public String timePatternHtml() {
        return this.htmlForTimePatterns(this.getTimePatterns());
    }

    public Integer getSectionNumber() {
        return this.getSectionNumber(null, true);
    }

    public Integer getSectionNumber(org.hibernate.Session hibSession) {
        return this.getSectionNumber(hibSession, true);
    }

    public Integer getSectionNumber(boolean save) {
        return this.getSectionNumber(null, save);
    }

    public Integer getSectionNumber(org.hibernate.Session hibSession, boolean save) {
        Integer sectionNumber = this.getSectionNumberCache();
        if (sectionNumber != null) {
            return sectionNumber;
        }
        Comparator cmp = new Comparator(){

            public int compare(Object o1, Object o2) {
                Class_ c1 = (Class_)o1;
                Class_ c2 = (Class_)o2;
                if (c1.getParentClass() == null || c2.getParentClass() == null || c1.getParentClass().equals(c2.getParentClass())) {
                    return c1.getUniqueId().compareTo(c2.getUniqueId());
                }
                return this.compare(c1.getParentClass(), c2.getParentClass());
            }
        };
        int idx = 0;
        for (Class_ clazz : this.getSchedulingSubpart().getClasses()) {
            if (cmp.compare(clazz, this) >= 0) continue;
            ++idx;
        }
        sectionNumber = new Integer(this.getSchedulingSubpart().getInstrOfferingConfig().getFirstSectionNumber(this.getSchedulingSubpart().getItype()) + idx);
        this.setSectionNumberCache(sectionNumber);
        if (save) {
            if (hibSession != null) {
                hibSession.saveOrUpdate((Object)this);
            } else {
                new Class_DAO().getSession().saveOrUpdate((Object)this);
                new Class_DAO().getSession().flush();
            }
        }
        return sectionNumber;
    }

    public String getSectionNumberString() {
        return this.getSectionNumber() + this.getSchedulingSubpart().getSchedulingSubpartSuffix();
    }

    public String getSectionNumberString(org.hibernate.Session hibSession) {
        return this.getSectionNumber(hibSession) + this.getSchedulingSubpart().getSchedulingSubpartSuffix(hibSession);
    }

    public List<DepartmentalInstructor> getLeadInstructors() {
        ArrayList<DepartmentalInstructor> ret = new ArrayList<DepartmentalInstructor>();
        if (this.getClassInstructors() == null) {
            return ret;
        }
        for (ClassInstructor classInstructor : this.getClassInstructors()) {
            if (!classInstructor.isLead().booleanValue()) continue;
            ret.add(classInstructor.getInstructor());
        }
        return ret;
    }

    public String getClassLabel() {
        return this.getCourseName() + " " + this.getItypeDesc().trim() + " " + this.getSectionNumberString();
    }

    public String getClassLabel(org.hibernate.Session hibSession) {
        return this.getCourseName() + " " + this.getItypeDesc().trim() + " " + this.getSectionNumberString(hibSession);
    }

    public String getClassLabelWithTitle() {
        return this.getCourseNameWithTitle() + " " + this.getItypeDesc().trim() + " " + this.getSectionNumberString();
    }

    @Override
    public String toString() {
        return this.getClassLabel();
    }

    @Override
    public Class getInstanceOf() {
        return Class_.class;
    }

    @Override
    public String htmlLabel() {
        return this.getItypeDesc() + " " + this.getSectionNumberString();
    }

    public boolean canBeDeleted() {
        if (this.getChildClasses() != null && this.getChildClasses().size() > 0) {
            return false;
        }
        if (this.getParentClass() != null) {
            int totalCapacity = 0;
            Class_ c2 = null;
            for (Class_ c2 : this.getParentClass().getChildClasses()) {
                totalCapacity += c2.getExpectedCapacity().intValue();
            }
            if ((totalCapacity -= this.getExpectedCapacity().intValue()) < this.getParentClass().getExpectedCapacity()) {
                return false;
            }
        }
        return true;
    }

    public void removeClassInstructor(ClassInstructor classInstr) {
        Set<ClassInstructor> s = this.getClassInstructors();
        for (ClassInstructor ci : s) {
            if (ci.getUniqueId().intValue() != classInstr.getUniqueId().intValue()) continue;
            s.remove(ci);
            break;
        }
    }

    @Override
    public DatePattern effectiveDatePattern() {
        if (this.getDatePattern() != null) {
            return this.getDatePattern();
        }
        return this.getSchedulingSubpart().effectiveDatePattern();
    }

    @Override
    public Set<Location> getAvailableRooms() {
        TreeSet<Location> rooms = new TreeSet<Location>();
        for (RoomDept roomDept : this.getManagingDept().getRoomDepts()) {
            rooms.add(roomDept.getRoom());
        }
        return rooms;
    }

    @Override
    public Set getAvailableRoomFeatures() {
        TreeSet<GlobalRoomFeature> features = new TreeSet<GlobalRoomFeature>(GlobalRoomFeature.getAllGlobalRoomFeatures(this.getSession()));
        Department dept = this.getManagingDept();
        if (dept != null) {
            features.addAll(DepartmentRoomFeature.getAllDepartmentRoomFeatures(dept));
        }
        return features;
    }

    @Override
    public Set getAvailableRoomGroups() {
        Set groups = super.getAvailableRoomGroups();
        Department dept = this.getManagingDept();
        if (dept != null) {
            groups.addAll(RoomGroup.getAllDepartmentRoomGroups(dept));
        }
        return groups;
    }

    public Class_ getNextClass(SessionContext context, Right right) {
        return this.getNextClass(context, new NavigationComparator(), right);
    }

    public Class_ getPreviousClass(SessionContext context, Right right) {
        return this.getPreviousClass(context, new NavigationComparator(), right);
    }

    public Class_ getNextClass(SessionContext context, Comparator cmp, Right right) {
        Long nextId = Navigation.getNext(context, Navigation.sClassLevel, this.getUniqueId());
        if (nextId != null) {
            if (nextId < 0L) {
                return null;
            }
            Class_ next = (Class_)new Class_DAO().get(nextId);
            if (next == null) {
                return null;
            }
            if (right != null && !context.hasPermission(next, right)) {
                return next.getNextClass(context, cmp, right);
            }
            return next;
        }
        Class_ next = null;
        for (SchedulingSubpart subpart = this.getSchedulingSubpart(); next == null && subpart != null; subpart = subpart.getNextSchedulingSubpart(context, cmp, null)) {
            for (Class_ c : subpart.getClasses()) {
                if (right != null && !context.hasPermission(c, right) || subpart.equals(this.getSchedulingSubpart()) && cmp.compare(this, c) >= 0 || next != null && cmp.compare(next, c) <= 0) continue;
                next = c;
            }
        }
        return next;
    }

    public Class_ getPreviousClass(SessionContext context, Comparator cmp, Right right) {
        Long previosId = Navigation.getPrevious(context, Navigation.sClassLevel, this.getUniqueId());
        if (previosId != null) {
            if (previosId < 0L) {
                return null;
            }
            Class_ previos = (Class_)new Class_DAO().get(previosId);
            if (previos == null) {
                return null;
            }
            if (right != null && !context.hasPermission(previos, right)) {
                return previos.getPreviousClass(context, cmp, right);
            }
            return previos;
        }
        Class_ previous = null;
        for (SchedulingSubpart subpart = this.getSchedulingSubpart(); previous == null && subpart != null; subpart = subpart.getPreviousSchedulingSubpart(context, cmp, null)) {
            for (Class_ c : subpart.getClasses()) {
                if (right != null && !context.hasPermission(c, right) || subpart.equals(this.getSchedulingSubpart()) && cmp.compare(this, c) <= 0 || previous != null && cmp.compare(previous, c) >= 0) continue;
                previous = c;
            }
        }
        return previous;
    }

    public void deleteAllDistributionPreferences(org.hibernate.Session hibSession) {
        this.deleteAllDistributionPreferences(hibSession, true);
    }

    public void deleteAllDistributionPreferences(org.hibernate.Session hibSession, boolean updateClass) {
        boolean deleted = false;
        if (this.getDistributionObjects() == null) {
            return;
        }
        Iterator<DistributionObject> i = this.getDistributionObjects().iterator();
        while (i.hasNext()) {
            DistributionObject relatedObject = i.next();
            DistributionPref distributionPref = relatedObject.getDistributionPref();
            distributionPref.getDistributionObjects().remove(relatedObject);
            Integer seqNo = relatedObject.getSequenceNumber();
            hibSession.delete((Object)relatedObject);
            deleted = true;
            if (distributionPref.getDistributionObjects().isEmpty()) {
                PreferenceGroup owner = distributionPref.getOwner();
                owner.getPreferences().remove(distributionPref);
                this.getPreferences().remove(distributionPref);
                hibSession.saveOrUpdate((Object)owner);
                hibSession.delete((Object)distributionPref);
            } else {
                if (seqNo != null) {
                    for (DistributionObject dObj : distributionPref.getDistributionObjects()) {
                        if (seqNo.compareTo(dObj.getSequenceNumber()) >= 0) continue;
                        dObj.setSequenceNumber(new Integer(dObj.getSequenceNumber() - 1));
                        hibSession.saveOrUpdate((Object)dObj);
                    }
                }
                if (updateClass) {
                    hibSession.saveOrUpdate((Object)distributionPref);
                }
            }
            i.remove();
        }
        if (deleted && updateClass) {
            hibSession.saveOrUpdate((Object)this);
        }
    }

    public Integer getMinRoomLimit() {
        int expCap = this.getExpectedCapacity() == null ? 0 : this.getExpectedCapacity();
        float roomRatio = this.getRoomRatio() == null ? 0.0f : this.getRoomRatio().floatValue();
        return new Integer(Math.round(expCap <= 0 ? roomRatio : (float)expCap * roomRatio));
    }

    public static List findAll(Long sessionId) {
        return Class_.findAll(Class_DAO.getInstance().getSession(), sessionId);
    }

    public static List findAll(org.hibernate.Session hibSession, Long sessionId) {
        return hibSession.createQuery("select distinct c from Class_ c where c.schedulingSubpart.instrOfferingConfig.instructionalOffering.session.uniqueId=:sessionId").setLong("sessionId", sessionId.longValue()).list();
    }

    public static List findAllForControllingSubjectArea(String subjectAreaAbbv, Long sessionId) {
        return Class_.findAllForControllingSubjectArea(subjectAreaAbbv, sessionId, new Class_DAO().getSession());
    }

    public static List findAllForControllingSubjectArea(String subjectAreaAbbv, Long sessionId, org.hibernate.Session hibSession) {
        return hibSession.createQuery("select distinct c from Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings as co where co.subjectArea.subjectAreaAbbreviation=:subjectAreaAbbv and c.schedulingSubpart.instrOfferingConfig.instructionalOffering.session.uniqueId=:sessionId and co.isControl=1").setString("subjectAreaAbbv", subjectAreaAbbv).setLong("sessionId", sessionId.longValue()).setFlushMode(FlushMode.MANUAL).list();
    }

    public String getDivSecNumber() {
        if (this.getParentClass() != null && this.getSchedulingSubpart().getItype().equals(this.getParentClass().getSchedulingSubpart().getItype())) {
            return this.getParentClass().getDivSecNumber();
        }
        String suffix = this.getClassSuffix();
        if (suffix != null && suffix.length() == 6) {
            return suffix.substring(0, 3) + "-" + suffix.substring(3, 6);
        }
        return suffix;
    }

    public int getClassLimit() {
        return this.getClassLimit(new CommitedClassAssignmentProxy());
    }

    public int getClassLimit(Assignment assignment) {
        int maxLimit;
        int minLimit = this.getExpectedCapacity();
        int limit = maxLimit = this.getMaxExpectedCapacity().intValue();
        if (minLimit < maxLimit && assignment != null) {
            int roomLimit = (int)Math.floor((float)assignment.getPlacement().getRoomSize() / (this.getRoomRatio() == null ? 1.0f : this.getRoomRatio().floatValue()));
            limit = Math.min(Math.max(minLimit, roomLimit), maxLimit);
        }
        return limit;
    }

    public int getClassLimit(ClassAssignmentProxy proxy) {
        int roomLimit;
        int maxLimit;
        int minLimit = this.getExpectedCapacity();
        if (minLimit == (maxLimit = this.getMaxExpectedCapacity().intValue())) {
            return maxLimit;
        }
        Assignment assignment = null;
        try {
            assignment = proxy == null ? null : proxy.getAssignment(this);
        }
        catch (Exception e) {
            Debug.error(e);
        }
        if (assignment != null && (roomLimit = (int)Math.floor((float)assignment.getPlacement().getRoomSize() / (this.getRoomRatio() == null ? 1.0f : this.getRoomRatio().floatValue()))) < maxLimit) {
            maxLimit = roomLimit;
        }
        for (SchedulingSubpart childSubpart : this.getSchedulingSubpart().getChildSubparts()) {
            int childrenLimit = 0;
            for (Class_ childClass : this.getChildClasses()) {
                if (!childClass.getSchedulingSubpart().equals(childSubpart)) continue;
                childrenLimit += childClass.getClassLimit(proxy);
            }
            if (childrenLimit >= maxLimit) continue;
            maxLimit = childrenLimit;
        }
        return Math.max(minLimit, maxLimit);
    }

    public int getClassLimit(CourseOffering offering) {
        return this.getClassLimit(new CommitedClassAssignmentProxy());
    }

    private boolean hasChildClass(Reservation r) {
        if (r.getClasses().contains(this)) {
            return true;
        }
        for (Class_ child : this.getChildClasses()) {
            if (!child.hasChildClass(r)) continue;
            return true;
        }
        return false;
    }

    public boolean hasClass(Reservation r) {
        if (r.getClasses().isEmpty()) {
            return false;
        }
        for (Class_ c = this; c != null; c = c.getParentClass()) {
            if (!r.getClasses().contains(c)) continue;
            return true;
        }
        for (Class_ child : this.getChildClasses()) {
            if (!child.hasChildClass(r)) continue;
            return true;
        }
        return false;
    }

    public void deleteAllDependentObjects(org.hibernate.Session hibSession, boolean updateClass) {
        this.deleteAllDistributionPreferences(hibSession, updateClass);
        this.deleteClassInstructors(hibSession);
        this.deleteAssignments(hibSession);
        Exam.deleteFromExams(hibSession, this);
        Event.deleteFromEvents(hibSession, this);
        if (updateClass) {
            hibSession.saveOrUpdate((Object)this);
        }
    }

    public void deleteClassInstructors(org.hibernate.Session hibSession) {
        Set<ClassInstructor> s = this.getClassInstructors();
        if (s == null || s.size() == 0) {
            return;
        }
        Iterator<ClassInstructor> i = s.iterator();
        while (i.hasNext()) {
            ClassInstructor ci = i.next();
            DepartmentalInstructor di = (DepartmentalInstructor)new DepartmentalInstructorDAO().get(ci.getInstructor().getUniqueId());
            di.getClasses().remove(ci);
            ci.setInstructor(null);
            ci.setClassInstructing(null);
            hibSession.saveOrUpdate((Object)di);
            hibSession.delete((Object)ci);
            i.remove();
        }
    }

    public void deleteAssignments(org.hibernate.Session hibSession) {
        Set<Assignment> s = this.getAssignments();
        this.deleteObjectsFromCollection(hibSession, s);
    }

    private void deleteObjectsFromCollection(org.hibernate.Session hibSession, Collection s) {
        if (s == null || s.size() == 0) {
            return;
        }
        Iterator i = s.iterator();
        while (i.hasNext()) {
            hibSession.delete(i.next());
            i.remove();
        }
    }

    public boolean isOddOrEvenWeeksOnly() {
        return this.effectiveDatePattern() != null && this.effectiveDatePattern().getType().equals(new Integer(1));
    }

    public Object clone() {
        Class_ newClass = new Class_();
        newClass.setDatePattern(this.getDatePattern());
        newClass.setEnabledForStudentScheduling(this.isEnabledForStudentScheduling());
        newClass.setDisplayInstructor(this.isDisplayInstructor());
        newClass.setExpectedCapacity(this.getExpectedCapacity());
        newClass.setManagingDept(this.getManagingDept());
        newClass.setMaxExpectedCapacity(this.getMaxExpectedCapacity());
        newClass.setNbrRooms(this.getNbrRooms());
        newClass.setNotes(this.getNotes());
        newClass.setRoomRatio(this.getRoomRatio());
        newClass.setSchedulePrintNote(this.getSchedulePrintNote());
        newClass.setSchedulingSubpart(this.getSchedulingSubpart());
        return newClass;
    }

    public Object cloneWithPreferences() {
        Class_ newClass = (Class_)this.clone();
        if (this.getPreferences() != null) {
            Preference origPref2 = null;
            Preference newPref = null;
            for (Preference origPref2 : this.getPreferences()) {
                if (origPref2 instanceof DistributionPref) continue;
                newPref = (Preference)origPref2.clone();
                newPref.setOwner(newClass);
                newClass.addTopreferences(newPref);
            }
        }
        if (this.getClassInstructors() != null && !this.getClassInstructors().isEmpty()) {
            ClassInstructor ci2 = null;
            ClassInstructor newCi = null;
            for (ClassInstructor ci2 : this.getClassInstructors()) {
                newCi = new ClassInstructor();
                newCi.setClassInstructing(newClass);
                newCi.setInstructor(ci2.getInstructor());
                newCi.setLead(ci2.isLead());
                newCi.setPercentShare(ci2.getPercentShare());
                ci2.getInstructor().addToclasses(newCi);
                newClass.addToclassInstructors(newCi);
            }
        }
        return newClass;
    }

    public static Class_ findByExternalId(Long sessionId, String externalId) {
        return (Class_)new Class_DAO().getSession().createQuery("select c from Class_ c where c.schedulingSubpart.instrOfferingConfig.instructionalOffering.session.uniqueId=:sessionId and c.externalUniqueId=:externalId").setLong("sessionId", sessionId.longValue()).setString("externalId", externalId).setCacheable(true).uniqueResult();
    }

    public static Class_ findByIdRolledForwardFrom(Long sessionId, Long uniqueIdRolledForwardFrom) {
        return (Class_)new Class_DAO().getSession().createQuery("select c from Class_ c where c.schedulingSubpart.instrOfferingConfig.instructionalOffering.session.uniqueId=:sessionId and c.uniqueIdRolledForwardFrom=:uniqueIdRolledForwardFrom").setLong("sessionId", sessionId.longValue()).setLong("uniqueIdRolledForwardFrom", uniqueIdRolledForwardFrom.longValue()).setCacheable(true).uniqueResult();
    }

    public ClassEvent getEvent() {
        if (this.iEvent == null) {
            this.iEvent = (ClassEvent)new Class_DAO().getSession().createQuery("select e from ClassEvent e left join fetch e.meetings m where e.clazz.uniqueId=:classId").setLong("classId", this.getUniqueId().longValue()).setCacheable(true).uniqueResult();
        }
        return this.iEvent;
    }

    public void setEvent(ClassEvent event) {
        this.iEvent = event;
    }

    public ClassEvent getCachedEvent() {
        return this.iEvent;
    }

    public String unassignCommited(UserContext user, org.hibernate.Session hibSession) {
        Transaction tx = null;
        try {
            Assignment oldAssignment;
            if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                tx = hibSession.beginTransaction();
            }
            if ((oldAssignment = this.getCommittedAssignment()) == null) {
                throw new RuntimeException("Class " + this.getClassLabel() + " does not have an assignment.");
            }
            ClassEvent event = this.getEvent();
            if (event != null) {
                if (ApplicationProperty.ClassAssignmentChangePastMeetings.isTrue()) {
                    hibSession.delete((Object)event);
                } else {
                    Calendar cal = Calendar.getInstance(Locale.US);
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    Date today = cal.getTime();
                    Iterator<Meeting> i = event.getMeetings().iterator();
                    while (i.hasNext()) {
                        if (i.next().getMeetingDate().before(today)) continue;
                        i.remove();
                    }
                    if (event.getMeetings().isEmpty()) {
                        hibSession.delete((Object)event);
                    } else {
                        if (event.getNotes() == null) {
                            event.setNotes(new HashSet<EventNote>());
                        }
                        EventNote note = new EventNote();
                        note.setEvent(event);
                        note.setNoteType(4);
                        note.setTimeStamp(new Date());
                        note.setUser(user.getName());
                        note.setUserId(user.getExternalUserId());
                        note.setTextNote(MSG.classNoteUnassigned(oldAssignment.getPlacement().getName()));
                        note.setMeetings(MSG.classMeetingsNotApplicable());
                        event.getNotes().add(note);
                        hibSession.saveOrUpdate((Object)event);
                    }
                }
            }
            String old = oldAssignment.getPlacement().getName();
            oldAssignment.getSolution().getAssignments().remove(oldAssignment);
            for (ConstraintInfo ci : oldAssignment.getConstraintInfo()) {
                for (Assignment a : ci.getAssignments()) {
                    if (a.equals(oldAssignment)) continue;
                    a.getConstraintInfo().remove(ci);
                }
                hibSession.delete((Object)ci);
            }
            hibSession.delete((Object)oldAssignment);
            this.setCommittedAssignment(null);
            hibSession.update((Object)this);
            ChangeLog.addChange(hibSession, TimetableManager.findByExternalId(user.getExternalUserId()), this.getSession(), this, this.getClassLabel() + " (" + old + " &rarr; N/A)", ChangeLog.Source.CLASS_INFO, ChangeLog.Operation.UNASSIGN, this.getSchedulingSubpart().getControllingCourseOffering().getSubjectArea(), this.getManagingDept());
            if (tx != null) {
                tx.commit();
            }
            new _RootDAO().getSession().refresh((Object)this);
            String className = ApplicationProperty.ExternalActionClassEdit.value();
            if (className != null && className.trim().length() > 0) {
                ExternalClassEditAction editAction = (ExternalClassEditAction)Class.forName(className).newInstance();
                editAction.performExternalClassEditAction(this, hibSession);
            }
            return null;
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            e.printStackTrace();
            return "Unassignment of " + this.getClassLabel() + " failed, reason: " + e.getMessage();
        }
    }

    public String assignCommited(ClassAssignmentInfo assignment, UserContext user, org.hibernate.Session hibSession) {
        Transaction tx = null;
        try {
            SolverGroup group;
            if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                tx = hibSession.beginTransaction();
            }
            String old = "N/A";
            Assignment oldAssignment = this.getCommittedAssignment();
            if (oldAssignment != null) {
                old = oldAssignment.getPlacement().getName();
                oldAssignment.getSolution().getAssignments().remove(oldAssignment);
                for (ConstraintInfo ci : oldAssignment.getConstraintInfo()) {
                    for (Assignment a : ci.getAssignments()) {
                        if (a.equals(oldAssignment)) continue;
                        a.getConstraintInfo().remove(ci);
                    }
                    hibSession.delete((Object)ci);
                }
                hibSession.delete((Object)oldAssignment);
            }
            if ((group = this.getManagingDept().getSolverGroup()) == null) {
                throw new RuntimeException("Department " + this.getManagingDept().getLabel() + " has no solver group.");
            }
            Solution solution = group.getCommittedSolution();
            if (solution == null) {
                throw new RuntimeException("Solver group " + group.getName() + " has no commited solution.");
            }
            DatePattern dp = (DatePattern)DatePatternDAO.getInstance().get(assignment.getDate().getId(), hibSession);
            Assignment a2 = new Assignment();
            a2.setSolution(solution);
            a2.setSlotsPerMtg(assignment.getTime().getNrSlotsPerMeeting());
            a2.setBreakTime(assignment.getTime().getBreakTime());
            a2.setClazz(this);
            a2.setClassName(this.getClassLabel());
            a2.setClassId(this.getUniqueId());
            a2.setDays(assignment.getTime().getDayCode());
            a2.setRooms(new HashSet<Location>());
            a2.setInstructors(new HashSet<DepartmentalInstructor>());
            a2.setStartSlot(assignment.getTime().getStartSlot());
            a2.setTimePattern(assignment.getTime().getTimePattern(hibSession));
            a2.setDatePattern(dp != null ? dp : this.effectiveDatePattern());
            a2.setAssignmentInfo(new HashSet<AssignmentInfo>());
            for (ClassRoomInfo classRoomInfo : assignment.getRooms()) {
                a2.getRooms().add(classRoomInfo.getLocation(hibSession));
            }
            for (ClassInstructorInfo classInstructorInfo : assignment.getInstructors()) {
                if (!classInstructorInfo.isLead()) continue;
                a2.getInstructors().add(classInstructorInfo.getInstructor(hibSession).getInstructor());
            }
            hibSession.save((Object)a2);
            AssignmentPreferenceInfo pref = new AssignmentPreferenceInfo();
            pref.setTimePreference(assignment.getTime().getPreference());
            for (ClassRoomInfo room : assignment.getRooms()) {
                pref.setRoomPreference(room.getLocationId(), room.getPreference());
            }
            AssignmentInfo assignmentInfo = new AssignmentInfo();
            assignmentInfo.setAssignment(a2);
            assignmentInfo.setDefinition(SolverInfoDef.findByName(hibSession, "AssignmentInfo"));
            assignmentInfo.setOpt(null);
            assignmentInfo.setInfo(pref);
            hibSession.save((Object)assignmentInfo);
            a2.getAssignmentInfo().add(assignmentInfo);
            a2.cleastAssignmentInfoCache();
            ClassEvent event = this.getEvent();
            event = a2.generateCommittedEvent(event, true);
            if (event != null && !event.getMeetings().isEmpty()) {
                if (event.getNotes() == null) {
                    event.setNotes(new HashSet<EventNote>());
                }
                EventNote note = new EventNote();
                note.setEvent(event);
                note.setNoteType(event.getUniqueId() == null ? 0 : 5);
                note.setTimeStamp(new Date());
                note.setUser(user.getName());
                note.setUserId(user.getExternalUserId());
                if (oldAssignment == null) {
                    note.setTextNote(MSG.classNoteAssigned(a2.getPlacement().getName()));
                } else {
                    note.setTextNote(MSG.classNoteReassigned(oldAssignment.getPlacement().getName(), a2.getPlacement().getName()));
                }
                note.setMeetings(assignment.getTime().getLongName() + (assignment.getNrRooms() > 0 ? " " + assignment.getRoomNames(", ") : ""));
                event.getNotes().add(note);
                hibSession.saveOrUpdate((Object)event);
            }
            if (event != null && event.getMeetings().isEmpty() && event.getUniqueId() != null) {
                hibSession.delete((Object)event);
            }
            this.setCommittedAssignment(a2);
            hibSession.update((Object)this);
            ChangeLog.addChange(hibSession, TimetableManager.findByExternalId(user.getExternalUserId()), this.getSession(), this, this.getClassLabel() + " (" + old + " &rarr; " + assignment.getTime().getName() + " " + assignment.getRoomNames(", ") + ")", ChangeLog.Source.CLASS_INFO, ChangeLog.Operation.ASSIGN, this.getSchedulingSubpart().getControllingCourseOffering().getSubjectArea(), this.getManagingDept());
            if (tx != null) {
                tx.commit();
            }
            new _RootDAO().getSession().refresh((Object)this);
            String className = ApplicationProperty.ExternalActionClassEdit.value();
            if (className != null && className.trim().length() > 0) {
                ExternalClassEditAction editAction = (ExternalClassEditAction)Class.forName(className).newInstance();
                editAction.performExternalClassEditAction(this, hibSession);
            }
            return null;
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            e.printStackTrace();
            return "Assignment of " + this.getClassLabel() + " failed, reason: " + e.getMessage();
        }
    }

    public Collection<Long> getEnrolledStudentIds() {
        return Class_DAO.getInstance().getSession().createQuery("select e.student.uniqueId from StudentClassEnrollment e where e.clazz.uniqueId=:classId").setLong("classId", this.getUniqueId().longValue()).setCacheable(true).list();
    }

    public String buildAssignedTimeHtml(ClassAssignmentProxy proxy) {
        Assignment a = null;
        StringBuffer sb = new StringBuffer();
        try {
            a = proxy.getAssignment(this);
        }
        catch (Exception e) {
            Debug.error(e);
        }
        if (a != null) {
            TimeLocation.IntEnumeration e = a.getTimeLocation().getDays();
            while (e.hasMoreElements()) {
                sb.append(Constants.DAY_NAMES_SHORT[(Integer)e.nextElement()]);
            }
            sb.append(" ");
            sb.append(a.getTimeLocation().getStartTimeHeader(CONSTANTS.useAmPm()));
            sb.append("-");
            sb.append(a.getTimeLocation().getEndTimeHeader(CONSTANTS.useAmPm()));
        } else if (this.getEffectiveTimePreferences().isEmpty()) {
            if (this.getSchedulingSubpart().getMinutesPerWk() <= 0) {
                sb.append("Arr Hrs");
            } else {
                int nrHours = Math.round((float)this.getSchedulingSubpart().getMinutesPerWk().intValue() / 50.0f);
                sb.append("Arr " + nrHours + " Hrs");
            }
        }
        if (sb.length() == 0) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public String buildAssignedRoomHtml(ClassAssignmentProxy proxy) {
        Assignment a = null;
        StringBuffer sb = new StringBuffer();
        try {
            a = proxy.getAssignment(this);
        }
        catch (Exception e) {
            Debug.error(e);
        }
        if (a != null) {
            for (Location room : a.getRooms()) {
                sb.append(room.getLabel());
            }
        } else if (this.getEffectiveTimePreferences().isEmpty()) {
            boolean first = true;
            for (RoomPref rp : this.getEffectiveRoomPreferences()) {
                if (!rp.getPrefLevel().getPrefId().toString().equals(PreferenceLevel.PREF_LEVEL_REQUIRED)) continue;
                if (first) {
                    first = false;
                } else {
                    sb.append("<br>");
                }
                sb.append(rp.getRoom().getLabel());
            }
        }
        if (sb.length() == 0) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public String buildInstructorHtml(String nameFormat) {
        StringBuffer sb = new StringBuffer();
        if (this.getClassInstructors() != null && !this.getClassInstructors().isEmpty()) {
            boolean first = true;
            for (ClassInstructor ci : this.getClassInstructors()) {
                if (first) {
                    first = false;
                } else {
                    sb.append("<br>");
                }
                sb.append(ci.getInstructor().getName(nameFormat));
            }
        } else {
            sb.append(" ");
        }
        return sb.toString();
    }

    public static ExternalClassNameHelperInterface getExternalClassNameHelper() {
        if (externalClassNameHelper == null) {
            String className = ApplicationProperty.ClassNamingHelper.value();
            if (className != null && className.trim().length() > 0) {
                try {
                    externalClassNameHelper = (ExternalClassNameHelperInterface)Class.forName(className).newInstance();
                }
                catch (InstantiationException e) {
                    Debug.error("Failed to instantiate instance of: " + className + " using the default class name helper.");
                    e.printStackTrace();
                    externalClassNameHelper = new DefaultExternalClassNameHelper();
                }
                catch (IllegalAccessException e) {
                    Debug.error("Illegal Access Exception on: " + className + " using the default class name helper.");
                    e.printStackTrace();
                    externalClassNameHelper = new DefaultExternalClassNameHelper();
                }
                catch (ClassNotFoundException e) {
                    Debug.error("Failed to find class: " + className + " using the default class name helper.");
                    e.printStackTrace();
                    externalClassNameHelper = new DefaultExternalClassNameHelper();
                }
            } else {
                externalClassNameHelper = new DefaultExternalClassNameHelper();
            }
        }
        return externalClassNameHelper;
    }

    public String getClassLabel(CourseOffering courseOffering) {
        return Class_.getExternalClassNameHelper().getClassLabel(this, courseOffering);
    }

    public String getClassSuffix(CourseOffering courseOffering) {
        return Class_.getExternalClassNameHelper().getClassSuffix(this, courseOffering);
    }

    public String getClassLabelWithTitle(CourseOffering courseOffering) {
        return Class_.getExternalClassNameHelper().getClassLabelWithTitle(this, courseOffering);
    }

    public String getExternalId(CourseOffering courseOffering) {
        return Class_.getExternalClassNameHelper().getExternalId(this, courseOffering);
    }

    public SectioningInfo getSectioningInfo() {
        return (SectioningInfo)SectioningInfoDAO.getInstance().getSession().createQuery("select i from SectioningInfo i where i.clazz.uniqueId = :classId").setLong("classId", this.getUniqueId().longValue()).setCacheable(true).uniqueResult();
    }

    @Override
    public Department getDepartment() {
        return this.getManagingDept();
    }
}

