/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.unitime.timetable.gwt.command.client.GwtRpcRequest;
import org.unitime.timetable.gwt.command.client.GwtRpcResponse;

public class RoomInterface
implements IsSerializable {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RoomPictureResponse
    implements GwtRpcResponse {
        private String iName;
        private List<RoomPictureInterface> iPictures;
        private RoomPictureRequest.Apply iApply;

        public boolean hasPictures() {
            return this.iPictures != null && !this.iPictures.isEmpty();
        }

        public void addPicture(RoomPictureInterface picture) {
            if (this.iPictures == null) {
                this.iPictures = new ArrayList<RoomPictureInterface>();
            }
            this.iPictures.add(picture);
        }

        public List<RoomPictureInterface> getPictures() {
            return this.iPictures;
        }

        public void setName(String name) {
            this.iName = name;
        }

        public String getName() {
            return this.iName;
        }

        public RoomPictureRequest.Apply getApply() {
            return this.iApply;
        }

        public void setApply(RoomPictureRequest.Apply apply) {
            this.iApply = apply;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RoomPictureRequest
    implements GwtRpcRequest<RoomPictureResponse> {
        private Operation iOperation;
        private Apply iApply;
        private Long iLocationId;
        private List<RoomPictureInterface> iPictures;

        public Long getLocationId() {
            return this.iLocationId;
        }

        public void setLocationId(Long locationId) {
            this.iLocationId = locationId;
        }

        public List<RoomPictureInterface> getPictures() {
            return this.iPictures;
        }

        public void setPictures(List<RoomPictureInterface> pictures) {
            this.iPictures = pictures;
        }

        public Operation getOperation() {
            return this.iOperation;
        }

        public void setOperation(Operation operation) {
            this.iOperation = operation;
        }

        public Apply getApply() {
            return this.iApply;
        }

        public void setApply(Apply apply) {
            this.iApply = apply;
        }

        @Override
        public String toString() {
            return this.getOperation().name() + "[" + this.getLocationId() + "]";
        }

        public static RoomPictureRequest load(Long locationId) {
            RoomPictureRequest request = new RoomPictureRequest();
            request.setOperation(Operation.LOAD);
            request.setLocationId(locationId);
            return request;
        }

        public static RoomPictureRequest save(Long locationId, Apply apply, List<RoomPictureInterface> pictures) {
            RoomPictureRequest request = new RoomPictureRequest();
            request.setOperation(Operation.SAVE);
            request.setLocationId(locationId);
            request.setPictures(pictures);
            request.setApply(apply);
            return request;
        }

        public static RoomPictureRequest upload(Long locationId) {
            RoomPictureRequest request = new RoomPictureRequest();
            request.setOperation(Operation.UPLOAD);
            request.setLocationId(locationId);
            return request;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Apply implements IsSerializable
        {
            THIS_SESSION_ONLY,
            ALL_FUTURE_SESSIONS,
            ALL_SESSIONS;

        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Operation implements IsSerializable
        {
            LOAD,
            SAVE,
            UPLOAD;

        }
    }

    public static class RoomPictureInterface
    implements IsSerializable {
        private Long iUniqueId;
        private String iName;
        private String iType;

        public RoomPictureInterface() {
        }

        public RoomPictureInterface(Long uniqueId, String name, String type) {
            this.setUniqueId(uniqueId);
            this.setName(name);
            this.setType(type);
        }

        public Long getUniqueId() {
            return this.iUniqueId;
        }

        public void setUniqueId(Long uniqueId) {
            this.iUniqueId = uniqueId;
        }

        public String getName() {
            return this.iName;
        }

        public void setName(String name) {
            this.iName = name;
        }

        public String getType() {
            return this.iType;
        }

        public void setType(String type) {
            this.iType = type;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RoomHintRequest
    implements GwtRpcRequest<RoomHintResponse> {
        private Long iLocationId;

        public Long getLocationId() {
            return this.iLocationId;
        }

        public void setLocationId(Long locationId) {
            this.iLocationId = locationId;
        }

        @Override
        public String toString() {
            return "" + this.getLocationId();
        }

        public static RoomHintRequest load(Long locationId) {
            RoomHintRequest request = new RoomHintRequest();
            request.setLocationId(locationId);
            return request;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RoomHintResponse
    implements GwtRpcResponse {
        private Long iId = null;
        private String iLabel = null;
        private String iDisplayName = null;
        private String iRoomTypeLabel = null;
        private String iMiniMapUrl = null;
        private Integer iCapacity = null;
        private Integer iExamCapacity = null;
        private Integer iBreakTime = null;
        private String iExamType = null;
        private String iArea = null;
        private String iGroups = null;
        private String iEventStatus = null;
        private String iEventDepartment = null;
        private String iNote = null;
        private boolean iIgnoreRoomCheck = false;
        private Map<String, String> iFeatures = null;
        private List<RoomPictureInterface> iPictures = null;

        public Long getId() {
            return this.iId;
        }

        public void setId(Long id) {
            this.iId = id;
        }

        public String getLabel() {
            return this.iLabel;
        }

        public void setLabel(String label) {
            this.iLabel = label;
        }

        public String getDisplayName() {
            return this.iDisplayName;
        }

        public void setDisplayName(String displayName) {
            this.iDisplayName = displayName;
        }

        public boolean hasDisplayName() {
            return this.iDisplayName != null && !this.iDisplayName.isEmpty();
        }

        public String getRoomTypeLabel() {
            return this.iRoomTypeLabel;
        }

        public void setRoomTypeLabel(String roomTypeLabel) {
            this.iRoomTypeLabel = roomTypeLabel;
        }

        public boolean hasRoomTypeLabel() {
            return this.iRoomTypeLabel != null && !this.iRoomTypeLabel.isEmpty();
        }

        public String getMiniMapUrl() {
            return this.iMiniMapUrl;
        }

        public void setMiniMapUrl(String miniMapUrl) {
            this.iMiniMapUrl = miniMapUrl;
        }

        public boolean hasMiniMapUrl() {
            return this.iMiniMapUrl != null && !this.iMiniMapUrl.isEmpty();
        }

        public Integer getCapacity() {
            return this.iCapacity;
        }

        public void setCapacity(Integer capacity) {
            this.iCapacity = capacity;
        }

        public boolean hasCapacity() {
            return this.iCapacity != null && this.iCapacity != 0;
        }

        public Integer getExamCapacity() {
            return this.iExamCapacity;
        }

        public void setExamCapacity(Integer examCapacity) {
            this.iExamCapacity = examCapacity;
        }

        public boolean hasExamCapacity() {
            return this.iExamCapacity != null && this.iExamCapacity != 0;
        }

        public String getExamType() {
            return this.iExamType;
        }

        public void setExamType(String examType) {
            this.iExamType = examType;
        }

        public boolean hasExamType() {
            return this.iExamType != null && !this.iExamType.isEmpty();
        }

        public String getArea() {
            return this.iArea;
        }

        public void setArea(String area) {
            this.iArea = area;
        }

        public boolean hasArea() {
            return this.iArea != null && !this.iArea.isEmpty();
        }

        public boolean hasFeatures() {
            return this.iFeatures != null && !this.iFeatures.isEmpty();
        }

        public void addFeature(String type, String name) {
            String featuresThisType;
            if (this.iFeatures == null) {
                this.iFeatures = new HashMap<String, String>();
            }
            featuresThisType = (featuresThisType = this.iFeatures.get(type)) == null ? "" : featuresThisType + ", ";
            featuresThisType = featuresThisType + name;
            this.iFeatures.put(type, featuresThisType);
        }

        public Set<String> getFeatureNames() {
            return new TreeSet<String>(this.iFeatures.keySet());
        }

        public String getFeatures(String name) {
            return this.iFeatures.get(name);
        }

        public String getGroups() {
            return this.iGroups;
        }

        public void setGroups(String groups) {
            this.iGroups = groups;
        }

        public boolean hasGroups() {
            return this.iGroups != null && !this.iGroups.isEmpty();
        }

        public String getEventStatus() {
            return this.iEventStatus;
        }

        public void setEventStatus(String eventStatus) {
            this.iEventStatus = eventStatus;
        }

        public boolean hasEventStatus() {
            return this.iEventStatus != null && !this.iEventStatus.isEmpty();
        }

        public String getEventDepartment() {
            return this.iEventDepartment;
        }

        public void setEventDepartment(String eventDepartment) {
            this.iEventDepartment = eventDepartment;
        }

        public boolean hasEventDepartment() {
            return this.iEventDepartment != null && !this.iEventDepartment.isEmpty();
        }

        public String getNote() {
            return this.iNote;
        }

        public void setNote(String note) {
            this.iNote = note;
        }

        public boolean hasNote() {
            return this.iNote != null && !this.iNote.isEmpty();
        }

        public Integer getBreakTime() {
            return this.iBreakTime;
        }

        public void setBreakTime(Integer breakTime) {
            this.iBreakTime = breakTime;
        }

        public boolean hasBreakTime() {
            return this.iBreakTime != null && this.iBreakTime != 0;
        }

        public boolean isIgnoreRoomCheck() {
            return this.iIgnoreRoomCheck;
        }

        public void setIgnoreRoomCheck(boolean ignoreRoomCheck) {
            this.iIgnoreRoomCheck = ignoreRoomCheck;
        }

        public boolean hasPictures() {
            return this.iPictures != null && !this.iPictures.isEmpty();
        }

        public void addPicture(RoomPictureInterface picture) {
            if (this.iPictures == null) {
                this.iPictures = new ArrayList<RoomPictureInterface>();
            }
            this.iPictures.add(picture);
        }

        public List<RoomPictureInterface> getPictures() {
            return this.iPictures;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RoomSharingRequest
    implements GwtRpcRequest<RoomSharingModel> {
        private Operation iOperation;
        private Long iLocationId;
        private RoomSharingModel iModel;
        private boolean iEventAvailability = false;

        public Long getLocationId() {
            return this.iLocationId;
        }

        public void setLocationId(Long locationId) {
            this.iLocationId = locationId;
        }

        public RoomSharingModel getModel() {
            return this.iModel;
        }

        public void setModel(RoomSharingModel model) {
            this.iModel = model;
        }

        public Operation getOperation() {
            return this.iOperation;
        }

        public void setOperation(Operation operation) {
            this.iOperation = operation;
        }

        @Override
        public String toString() {
            return this.getOperation().name() + "[" + this.getLocationId() + "]";
        }

        public boolean isEventAvailability() {
            return this.iEventAvailability;
        }

        public void setEventAvailability(boolean availability) {
            this.iEventAvailability = availability;
        }

        public static RoomSharingRequest load(Long locationId, boolean eventAvailability) {
            RoomSharingRequest request = new RoomSharingRequest();
            request.setOperation(Operation.LOAD);
            request.setLocationId(locationId);
            request.setEventAvailability(eventAvailability);
            return request;
        }

        public static RoomSharingRequest save(Long locationId, RoomSharingModel model, boolean eventAvailability) {
            RoomSharingRequest request = new RoomSharingRequest();
            request.setOperation(Operation.SAVE);
            request.setLocationId(locationId);
            request.setModel(model);
            request.setEventAvailability(eventAvailability);
            return request;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Operation implements IsSerializable
        {
            LOAD,
            SAVE;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RoomSharingModel
    implements IsSerializable,
    GwtRpcResponse {
        private Long iId;
        private String iName;
        private Long iDefaultOption;
        private boolean iDefaultHorizontal;
        private List<RoomSharingDisplayMode> iModes;
        private List<RoomSharingOption> iOptions;
        private List<RoomSharingOption> iOtherOptions;
        private Map<Integer, Map<Integer, Long>> iModel;
        private Map<Integer, Map<Integer, Boolean>> iEditable;
        private int iDefaultMode = 0;
        private boolean iDefaultEditable = true;
        private String iNote = null;
        private boolean iNoteEditable = false;

        public Long getId() {
            return this.iId;
        }

        public void setId(Long id) {
            this.iId = id;
        }

        public String getName() {
            return this.iName;
        }

        public void setName(String name) {
            this.iName = name;
        }

        public void addMode(RoomSharingDisplayMode mode) {
            if (this.iModes == null) {
                this.iModes = new ArrayList<RoomSharingDisplayMode>();
            }
            this.iModes.add(mode);
        }

        public List<RoomSharingDisplayMode> getModes() {
            return this.iModes;
        }

        public void setDefaultOption(RoomSharingOption option) {
            this.iDefaultOption = option == null ? null : option.getId();
        }

        public RoomSharingOption getDefaultOption() {
            return this.getOption(this.iDefaultOption);
        }

        public RoomSharingOption getOption(Long id) {
            if (id == null) {
                id = this.iDefaultOption;
            }
            if (this.iOptions == null || id == null) {
                return null;
            }
            for (RoomSharingOption option : this.iOptions) {
                if (!option.getId().equals(id)) continue;
                return option;
            }
            return !id.equals(this.iDefaultOption) ? this.getOption(this.iDefaultOption) : null;
        }

        public void addOption(RoomSharingOption option) {
            if (this.iOptions == null) {
                this.iOptions = new ArrayList<RoomSharingOption>();
            }
            this.iOptions.add(option);
        }

        public void addOther(RoomSharingOption option) {
            if (this.iOtherOptions == null) {
                this.iOtherOptions = new ArrayList<RoomSharingOption>();
            }
            this.iOtherOptions.add(option);
        }

        public List<RoomSharingOption> getAdditionalOptions() {
            ArrayList<RoomSharingOption> other = new ArrayList<RoomSharingOption>();
            if (this.iOtherOptions == null || this.iOtherOptions.isEmpty()) {
                return other;
            }
            for (RoomSharingOption option : this.iOtherOptions) {
                if (this.iOptions.contains(option)) continue;
                other.add(option);
            }
            return other;
        }

        public List<RoomSharingOption> getOptions() {
            return this.iOptions;
        }

        public List<RoomSharingOption> getRemovableOptions() {
            ArrayList<RoomSharingOption> options = new ArrayList<RoomSharingOption>();
            if (this.iOptions == null) {
                return options;
            }
            for (RoomSharingOption option : this.iOptions) {
                if (!option.isEditable() || option.getId() < 0L) continue;
                options.add(option);
            }
            return options;
        }

        public boolean isEditable() {
            if (this.iOptions == null) {
                return false;
            }
            for (RoomSharingOption option : this.iOptions) {
                if (!option.isEditable()) continue;
                if (this.iDefaultEditable) {
                    return true;
                }
                if (this.iEditable == null || this.iEditable.isEmpty()) {
                    return false;
                }
                for (Map<Integer, Boolean> slot2ed : this.iEditable.values()) {
                    for (Boolean ed : slot2ed.values()) {
                        if (!ed.booleanValue()) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        public RoomSharingOption getOption(int day, int slot) {
            if (this.iModel == null) {
                return this.getOption(this.iDefaultOption);
            }
            Map<Integer, Long> slot2id = this.iModel.get(day);
            return this.getOption(slot2id == null ? null : slot2id.get(slot));
        }

        public void setOption(int day, int slot, Long optionId) {
            Map<Integer, Long> slot2id;
            if (this.iModel == null) {
                this.iModel = new HashMap<Integer, Map<Integer, Long>>();
            }
            if ((slot2id = this.iModel.get(day)) == null) {
                slot2id = new HashMap<Integer, Long>();
                this.iModel.put(day, slot2id);
            }
            if (optionId == null) {
                slot2id.remove(slot);
            } else {
                slot2id.put(slot, optionId);
            }
        }

        public void setOption(int day, int slot, int step, RoomSharingOption option) {
            for (int i = 0; i < step; ++i) {
                this.setOption(day, slot + i, option == null ? null : option.getId());
            }
        }

        public boolean isEditable(int day, int slot) {
            if (this.iEditable == null) {
                return this.iDefaultEditable;
            }
            Map<Integer, Boolean> slot2ed = this.iEditable.get(day);
            if (slot2ed == null) {
                return this.iDefaultEditable;
            }
            Boolean ed = slot2ed.get(slot);
            return ed == null ? this.iDefaultEditable : ed;
        }

        public boolean isEditable(int day, int slot, int step) {
            for (int i = 0; i < step; ++i) {
                if (this.isEditable(day, slot + i)) continue;
                return false;
            }
            return true;
        }

        public void setEditable(int day, int slot, boolean editable) {
            Map<Integer, Boolean> slot2ed;
            if (this.iEditable == null) {
                this.iEditable = new HashMap<Integer, Map<Integer, Boolean>>();
            }
            if ((slot2ed = this.iEditable.get(day)) == null) {
                slot2ed = new HashMap<Integer, Boolean>();
                this.iEditable.put(day, slot2ed);
            }
            slot2ed.put(slot, editable);
        }

        public void setDefaultEditable(boolean editable) {
            this.iDefaultEditable = editable;
        }

        public boolean isDefaultHorizontal() {
            return this.iDefaultHorizontal;
        }

        public void setDefaultHorizontal(boolean horizontal) {
            this.iDefaultHorizontal = horizontal;
        }

        public int getDefaultMode() {
            return this.iDefaultMode;
        }

        public void setDefaultMode(int mode) {
            this.iDefaultMode = mode;
        }

        public boolean hasNote() {
            return this.iNote != null && !this.iNote.isEmpty();
        }

        public String getNote() {
            return this.iNote;
        }

        public void setNote(String note) {
            this.iNote = note;
        }

        public boolean isNoteEditable() {
            return this.iNoteEditable;
        }

        public void setNoteEditable(boolean noteEditable) {
            this.iNoteEditable = noteEditable;
        }
    }

    public static class RoomSharingOption
    implements IsSerializable {
        private String iCode;
        private String iName;
        private String iColor;
        private Long iId;
        private boolean iEditable;

        public RoomSharingOption() {
        }

        public RoomSharingOption(Long id, String color, String code, String name, boolean editable) {
            this.iId = id;
            this.iColor = color;
            this.iCode = code;
            this.iName = name;
            this.iEditable = editable;
        }

        public String getColor() {
            return this.iColor;
        }

        public void setColor(String color) {
            this.iColor = color;
        }

        public String getCode() {
            return this.iCode;
        }

        public void setCode(String code) {
            this.iCode = code;
        }

        public String getName() {
            return this.iName;
        }

        public void setName(String name) {
            this.iName = name;
        }

        public Long getId() {
            return this.iId;
        }

        public void setId(Long id) {
            this.iId = id;
        }

        public void setEditable(boolean editable) {
            this.iEditable = editable;
        }

        public boolean isEditable() {
            return this.iEditable;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof RoomSharingOption)) {
                return false;
            }
            return this.getId().equals(((RoomSharingOption)o).getId());
        }

        public int hashCode() {
            return this.getId().hashCode();
        }
    }

    public static class RoomSharingDisplayMode
    implements IsSerializable {
        private String iName;
        private int iFirstDay = 0;
        private int iLastDay = 4;
        private int iFirstSlot = 90;
        private int iLastSlot = 210;
        private int iStep = 6;

        public RoomSharingDisplayMode() {
        }

        public RoomSharingDisplayMode(String m) {
            String[] model = m.split("\\|");
            this.iName = model[0];
            this.iFirstDay = Integer.parseInt(model[1]);
            this.iLastDay = Integer.parseInt(model[2]);
            this.iFirstSlot = Integer.parseInt(model[3]);
            this.iLastSlot = Integer.parseInt(model[4]);
            this.iStep = Integer.parseInt(model[5]);
        }

        public int getFirstDay() {
            return this.iFirstDay;
        }

        public void setFirstDay(int firstDay) {
            this.iFirstDay = firstDay;
        }

        public int getLastDay() {
            return this.iLastDay;
        }

        public void setLastDay(int lastDay) {
            this.iLastDay = lastDay;
        }

        public int getFirstSlot() {
            return this.iFirstSlot;
        }

        public void setFirstSlot(int firstSlot) {
            this.iFirstSlot = firstSlot;
        }

        public int getLastSlot() {
            return this.iLastSlot;
        }

        public void setLastSlot(int lastSlot) {
            this.iLastSlot = lastSlot;
        }

        public int getStep() {
            return this.iStep;
        }

        public void setStep(int step) {
            this.iStep = step;
        }

        public String getName() {
            return this.iName;
        }

        public void setName(String name) {
            this.iName = name;
        }

        public String toString() {
            return this.getFirstDay() + "|" + this.getLastDay() + "|" + this.getFirstSlot() + "|" + this.getLastSlot() + "|" + this.getStep();
        }
    }
}

