/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.shared;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.IsSerializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface AcademicSessionProvider {
    public Long getAcademicSessionId();

    public String getAcademicSessionName();

    public AcademicSessionInfo getAcademicSessionInfo();

    public void addAcademicSessionChangeHandler(AcademicSessionChangeHandler var1);

    public void selectSession(Long var1, AsyncCallback<Boolean> var2);

    public static class AcademicSessionInfo
    implements IsSerializable {
        private Long iSessionId;
        private String iYear;
        private String iTerm;
        private String iCampus;
        private String iName;

        public AcademicSessionInfo() {
        }

        public AcademicSessionInfo(Long sessionId, String year, String term, String campus, String name) {
            this.iSessionId = sessionId;
            this.iTerm = term;
            this.iYear = year;
            this.iCampus = campus;
            this.iName = name;
        }

        public Long getSessionId() {
            return this.iSessionId;
        }

        public void setSessionId(Long sessionId) {
            this.iSessionId = sessionId;
        }

        public String getYear() {
            return this.iYear;
        }

        public void setYear(String year) {
            this.iYear = year;
        }

        public String getCampus() {
            return this.iCampus;
        }

        public void setCampus(String campus) {
            this.iCampus = campus;
        }

        public String getTerm() {
            return this.iTerm;
        }

        public void setTerm(String term) {
            this.iTerm = term;
        }

        public String getName() {
            return this.iName == null || this.iName.isEmpty() ? this.iTerm + " " + this.iYear + " (" + this.iCampus + ")" : this.iName;
        }

        public void setname(String name) {
            this.iName = name;
        }

        public String toString() {
            return this.getName();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof AcademicSessionInfo)) {
                return false;
            }
            return this.getSessionId().equals(((AcademicSessionInfo)o).getSessionId());
        }
    }

    public static interface AcademicSessionChangeHandler {
        public void onAcademicSessionChange(AcademicSessionChangeEvent var1);
    }

    public static interface AcademicSessionChangeEvent {
        public Long getNewAcademicSessionId();

        public Long getOldAcademicSessionId();

        public boolean isChanged();
    }
}

