/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.command.server;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.ifs.util.JProf;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.filter.QueryLogFilter;
import org.unitime.timetable.gwt.command.client.GwtRpcCancelledException;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.client.GwtRpcRequest;
import org.unitime.timetable.gwt.command.client.GwtRpcResponse;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.server.GwtRpcHelper;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcLogging;
import org.unitime.timetable.gwt.shared.PageAccessException;
import org.unitime.timetable.model.QueryLog;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.context.HttpSessionContext;
import org.unitime.timetable.security.evaluation.PermissionCheck;
import org.unitime.timetable.util.Formats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GwtRpcServlet
extends RemoteServiceServlet
implements GwtRpcService {
    private static final long serialVersionUID = 1L;
    private static Log sLog = LogFactory.getLog(GwtRpcServlet.class);
    private QueryLogFilter.Saver iSaver = null;
    private static IdGenerator sIdGenerator = new IdGenerator();
    private static Map<Long, Execution> sExecutions = new Hashtable<Long, Execution>();

    protected SessionContext getSessionContext() {
        return HttpSessionContext.getSessionContext(this.getServletContext());
    }

    protected PermissionCheck getPermissionCheck() {
        WebApplicationContext applicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        return (PermissionCheck)applicationContext.getBean("unitimePermissionCheck");
    }

    public void init() throws ServletException {
        this.iSaver = new QueryLogFilter.Saver();
        this.iSaver.setName("GwtRpcLogSaver");
        this.iSaver.start();
    }

    public void destroy() {
        if (this.iSaver != null) {
            this.iSaver.interrupt();
        }
    }

    public static <T extends GwtRpcResponse> GwtRpcImplementation<GwtRpcRequest<T>, T> getImplementation(Class<? extends GwtRpcRequest<T>> requestClass, ApplicationContext applicationContext) throws BeansException {
        return (GwtRpcImplementation)applicationContext.getBean(requestClass.getName());
    }

    protected <T extends GwtRpcResponse> GwtRpcImplementation<GwtRpcRequest<T>, T> getImplementation(GwtRpcRequest<T> request) throws Exception {
        return GwtRpcServlet.getImplementation(request.getClass(), (ApplicationContext)WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext()));
    }

    public static <T extends GwtRpcResponse> T execute(GwtRpcRequest<T> request, ApplicationContext applicationContext, SessionContext sessionContext) throws GwtRpcException {
        try {
            GwtRpcImplementation<GwtRpcRequest<GwtRpcRequest<T>>, GwtRpcRequest<T>> implementation = GwtRpcServlet.getImplementation(request.getClass(), applicationContext);
            T response = implementation.execute(request, sessionContext);
            return response;
        }
        catch (Throwable t) {
            if (t instanceof GwtRpcException) {
                GwtRpcException e = (GwtRpcException)t;
                if (e.hasCause()) {
                    sLog.warn((Object)("Seen server exception: " + e.getMessage()), e.getCause());
                } else {
                    sLog.info((Object)("Seen server exception: " + e.getMessage()));
                }
                throw e;
            }
            if (t instanceof IsSerializable) {
                if (t.getCause() != null) {
                    sLog.error((Object)("Seen server exception: " + t.getMessage()), t);
                } else {
                    sLog.warn((Object)("Seen server exception: " + t.getMessage()), t);
                }
                throw new GwtRpcException(t.getMessage(), t);
            }
            sLog.error((Object)("Seen exception: " + t.getMessage()), t);
            throw new GwtRpcException(t.getMessage());
        }
    }

    @Override
    public <T extends GwtRpcResponse> T execute(GwtRpcRequest<T> request) throws GwtRpcException {
        long t0 = JProf.currentTimeMillis();
        GwtRpcLogging logging = null;
        try {
            GwtRpcImplementation<GwtRpcRequest<GwtRpcRequest<T>>, GwtRpcRequest<T>> implementation = this.getImplementation(request);
            logging = implementation.getClass().getAnnotation(GwtRpcLogging.class);
            T response = implementation.execute(request, this.getSessionContext());
            this.log(request, response, (Throwable)null, JProf.currentTimeMillis() - t0, this.getSessionContext(), logging);
            return response;
        }
        catch (Throwable t) {
            this.log(request, null, t, JProf.currentTimeMillis() - t0, this.getSessionContext(), logging);
            if (t instanceof GwtRpcException) {
                GwtRpcException e = (GwtRpcException)t;
                if (e.hasCause()) {
                    sLog.warn((Object)("Seen server exception: " + e.getMessage()), (Throwable)e);
                } else {
                    sLog.info((Object)("Seen server exception: " + e.getMessage()));
                }
                throw e;
            }
            if (t instanceof AccessDeniedException) {
                throw new PageAccessException(t.getMessage(), t);
            }
            if (t instanceof IsSerializable) {
                if (t.getCause() != null) {
                    sLog.error((Object)("Seen server exception: " + t.getMessage()), t);
                } else {
                    sLog.warn((Object)("Seen server exception: " + t.getMessage()), t);
                }
                throw new GwtRpcException(t.getMessage(), t);
            }
            sLog.error((Object)("Seen exception: " + t.getMessage()), t);
            throw new GwtRpcException(t.getMessage());
        }
    }

    private <T extends GwtRpcResponse> void log(GwtRpcRequest<T> request, T response, Throwable exception, long time, SessionContext context, GwtRpcLogging logging) {
        try {
            if (this.iSaver == null) {
                return;
            }
            if (logging != null) {
                switch (logging.value()) {
                    case DISABLED: {
                        return;
                    }
                    case ON_EXCEPTION: {
                        if (exception == null) break;
                        return;
                    }
                }
            }
            QueryLog q = new QueryLog();
            String requestName = request.getClass().getSimpleName();
            q.setUri("RPC:" + requestName);
            q.setType(QueryLog.Type.RPC.ordinal());
            q.setTimeStamp(new Date());
            q.setTimeSpent(time);
            q.setSessionId(context.getHttpSessionId());
            q.setUid(context.isAuthenticated() ? context.getUser().getExternalUserId() : null);
            q.setQuery(request.toString());
            if (exception != null) {
                String ex = "";
                for (Throwable t = exception; t != null; t = t.getCause()) {
                    String clazz = t.getClass().getName();
                    if (clazz.indexOf(46) >= 0) {
                        clazz = clazz.substring(1 + clazz.lastIndexOf(46));
                    }
                    if (!ex.isEmpty()) {
                        ex = ex + "\n";
                    }
                    ex = ex + clazz + ": " + t.getMessage();
                    if (t.getStackTrace() == null || t.getStackTrace().length <= 0) continue;
                    ex = ex + " (at " + t.getStackTrace()[0].getFileName() + ":" + t.getStackTrace()[0].getLineNumber() + ")";
                }
                if (!ex.isEmpty()) {
                    q.setException(ex);
                }
            }
            this.iSaver.add(q);
        }
        catch (Throwable t) {
            sLog.warn((Object)("Failed to log a request: " + t.getMessage()), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends GwtRpcResponse> Long executeAsync(GwtRpcRequest<T> request) throws GwtRpcException {
        try {
            Execution execution = new Execution(this, request);
            Map<Long, Execution> map = sExecutions;
            synchronized (map) {
                sExecutions.put(execution.getExecutionId(), execution);
            }
            execution.start();
            return execution.getExecutionId();
        }
        catch (Exception e) {
            sLog.warn((Object)("Execute async failed: " + e.getMessage()));
            throw new GwtRpcException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends GwtRpcResponse> T waitForResults(Long executionId) throws GwtRpcException {
        try {
            Execution execution = null;
            Map<Long, Execution> map = sExecutions;
            synchronized (map) {
                execution = sExecutions.get(executionId);
            }
            if (execution == null) {
                throw new GwtRpcException("No execution with given id found.");
            }
            try {
                execution.waitToFinish();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            map = sExecutions;
            synchronized (map) {
                sExecutions.remove(executionId);
            }
            if (execution.getException() != null) {
                throw execution.getException();
            }
            return execution.getResponse();
        }
        catch (GwtRpcCancelledException e) {
            throw e;
        }
        catch (GwtRpcException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.warn((Object)("Wait for results failed: " + e.getMessage()));
            throw new GwtRpcException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean cancelExecution(Long executionId) throws GwtRpcException {
        try {
            Execution execution = null;
            Map<Long, Execution> map = sExecutions;
            synchronized (map) {
                execution = sExecutions.get(executionId);
            }
            if (execution == null) {
                return false;
            }
            execution.cancelExecution();
            return true;
        }
        catch (Exception e) {
            sLog.warn((Object)("Cancel execution failed: " + e.getMessage()));
            throw new GwtRpcException(e.getMessage(), e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Execution<R extends GwtRpcRequest<T>, T extends GwtRpcResponse>
    extends Thread {
        R iRequest;
        T iResponse = null;
        SessionContext iContext = null;
        GwtRpcException iException = null;
        Thread iWaitingThread = null;
        long iExecutionId;
        boolean iRunning = false;
        String iLocale = null;
        final /* synthetic */ GwtRpcServlet this$0;

        Execution(R request) {
            this.this$0 = var1_1;
            this.setName("RPC:" + request);
            this.setDaemon(true);
            this.iRequest = request;
            this.iExecutionId = sIdGenerator.generatedId();
            this.iContext = new GwtRpcHelper(var1_1.getSessionContext(), var1_1.getPermissionCheck());
            this.iLocale = Localization.getLocale();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            block15: {
                this.iRunning = true;
                Localization.setLocale(this.iLocale);
                ApplicationProperties.setSessionId(this.iContext.getUser() == null ? null : this.iContext.getUser().getCurrentAcademicSessionId());
                long t0 = JProf.currentTimeMillis();
                GwtRpcLogging logging = null;
                try {
                    try {
                        GwtRpcImplementation<GwtRpcRequest<R>, R> implementation = this.this$0.getImplementation(this.iRequest);
                        logging = implementation.getClass().getAnnotation(GwtRpcLogging.class);
                        this.iResponse = implementation.execute((GwtRpcRequest<R>)this.iRequest, this.iContext);
                        this.this$0.log(this.iRequest, this.iResponse, null, JProf.currentTimeMillis() - t0, this.iContext, logging);
                    }
                    catch (Throwable t) {
                        this.this$0.log(this.iRequest, null, t, JProf.currentTimeMillis() - t0, this.iContext, logging);
                        if (t instanceof GwtRpcException) {
                            this.iException = (GwtRpcException)t;
                            if (this.iException.hasCause()) {
                                sLog.warn((Object)("Seen server exception: " + t.getMessage()), t.getCause());
                            } else {
                                sLog.info((Object)("Seen server exception: " + t.getMessage()));
                            }
                        } else if (t instanceof IsSerializable) {
                            if (t.getCause() != null) {
                                sLog.error((Object)("Seen server exception: " + t.getMessage()), t);
                            } else {
                                sLog.warn((Object)("Seen server exception: " + t.getMessage()), t);
                            }
                            this.iException = new GwtRpcException(t.getMessage(), t);
                        } else {
                            sLog.error((Object)("Seen exception: " + t.getMessage()), t);
                            this.iException = new GwtRpcException(t.getMessage());
                        }
                        Object var6_6 = null;
                        Localization.removeLocale();
                        Formats.removeFormats();
                        ApplicationProperties.setSessionId(null);
                        _RootDAO.closeCurrentThreadSessions();
                        break block15;
                    }
                    Object var6_5 = null;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    Localization.removeLocale();
                    Formats.removeFormats();
                    ApplicationProperties.setSessionId(null);
                    _RootDAO.closeCurrentThreadSessions();
                    throw throwable;
                }
                Localization.removeLocale();
                Formats.removeFormats();
                ApplicationProperties.setSessionId(null);
                _RootDAO.closeCurrentThreadSessions();
            }
            Execution execution = this;
            synchronized (execution) {
                this.iWaitingThread = null;
                this.iRunning = false;
                this.iContext = null;
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void waitToFinish() throws InterruptedException {
            Execution execution = this;
            synchronized (execution) {
                if (this.iRunning) {
                    this.iWaitingThread = Thread.currentThread();
                    this.join();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cancelExecution() {
            Execution execution = this;
            synchronized (execution) {
                this.iException = new GwtRpcCancelledException("Operation cancelled by the user.");
                if (this.iWaitingThread != null) {
                    this.iWaitingThread.interrupt();
                }
            }
            this.interrupt();
        }

        T getResponse() {
            return this.iResponse;
        }

        GwtRpcException getException() {
            return this.iException;
        }

        Long getExecutionId() {
            return this.iExecutionId;
        }
    }

    private static class IdGenerator {
        long iNextId = 0L;

        private IdGenerator() {
        }

        synchronized Long generatedId() {
            return this.iNextId++;
        }
    }
}

