/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.widgets;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.dom.client.HasAllFocusHandlers;
import com.google.gwt.event.dom.client.HasAllKeyHandlers;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.event.shared.HasHandlers;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.unitime.timetable.gwt.client.aria.AriaStatus;
import org.unitime.timetable.gwt.client.aria.AriaTextBox;
import org.unitime.timetable.gwt.resources.GwtAriaMessages;
import org.unitime.timetable.gwt.resources.GwtConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeSelector
extends Composite
implements HasValue<Integer>,
Focusable,
HasAllKeyHandlers,
HasAllFocusHandlers,
HasSelectionHandlers<Integer> {
    private static GwtAriaMessages ARIA = (GwtAriaMessages)GWT.create(GwtAriaMessages.class);
    private static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    private TimeSelector iStart;
    private TimeMenu iTimes;
    private ScrollPanel iTimeScroll;
    private PopupPanel iPopup;
    private AriaTextBox iText;
    private Integer iDiff = null;
    private String iLastSelected = null;
    TimeMenuItem iInsertedSuggestion = null;

    public TimeSelector() {
        this(null);
    }

    public TimeSelector(TimeSelector start) {
        this.iStart = start;
        this.iText = new AriaTextBox();
        this.iText.setStyleName("gwt-SuggestBox");
        this.iText.addStyleName("unitime-TimeSelector");
        this.iText.setAriaLabel(start == null ? ARIA.startTime() : ARIA.endTime());
        this.iTimes = new TimeMenu();
        this.iTimeScroll = new ScrollPanel((Widget)this.iTimes);
        this.iTimeScroll.addStyleName("scroll");
        this.iPopup = new PopupPanel(true, false);
        this.iPopup.setPreviewingAllNativeEvents(true);
        this.iPopup.setStyleName("unitime-TimeSelectorPopup");
        this.iPopup.setWidget((Widget)this.iTimeScroll);
        this.initWidget((Widget)this.iText);
        this.createSuggestions();
        this.iText.addKeyDownHandler(new KeyDownHandler(){

            public void onKeyDown(KeyDownEvent event) {
                if (TimeSelector.this.isSuggestionsShowing()) {
                    switch (event.getNativeEvent().getKeyCode()) {
                        case 40: {
                            TimeSelector.this.iTimes.selectItem(TimeSelector.this.iTimes.getSelectedItemIndex() + 1);
                            TimeSelector.this.updateSuggestionStatus();
                            break;
                        }
                        case 38: {
                            if (TimeSelector.this.iTimes.getSelectedItemIndex() == -1) {
                                TimeSelector.this.iTimes.selectItem(TimeSelector.this.iTimes.getNumItems() - 1);
                            } else {
                                TimeSelector.this.iTimes.selectItem(TimeSelector.this.iTimes.getSelectedItemIndex() - 1);
                            }
                            TimeSelector.this.updateSuggestionStatus();
                            break;
                        }
                        case 13: {
                            TimeSelector.this.iTimes.executeSelected();
                            TimeSelector.this.hideSuggestions();
                            break;
                        }
                        case 9: {
                            TimeSelector.this.hideSuggestions();
                            break;
                        }
                        case 27: {
                            TimeSelector.this.hideSuggestions();
                        }
                    }
                    switch (event.getNativeEvent().getKeyCode()) {
                        case 13: 
                        case 27: 
                        case 38: 
                        case 40: {
                            event.preventDefault();
                            event.stopPropagation();
                        }
                    }
                } else if (event.getNativeEvent().getKeyCode() == 40 && (event.getNativeEvent().getAltKey() || TimeSelector.this.iText.getCursorPos() == TimeSelector.this.iText.getText().length())) {
                    TimeSelector.this.showSuggestions();
                    TimeSelector.this.updateSuggestionStatus();
                    event.preventDefault();
                    event.stopPropagation();
                }
            }
        });
        this.iText.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                if (TimeSelector.this.selectASuggestion()) {
                    if (!TimeSelector.this.isSuggestionsShowing()) {
                        TimeSelector.this.showSuggestions();
                    }
                    TimeSelector.this.updateSuggestionStatus();
                }
            }
        });
        this.iText.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                TimeSelector.this.setValue(TimeSelector.this.parseTime((String)event.getValue()), true);
            }
        });
        if (this.iStart != null) {
            this.iStart.addValueChangeHandler(new ValueChangeHandler<Integer>(){

                public void onValueChange(ValueChangeEvent<Integer> event) {
                    TimeSelector.this.createSuggestions();
                    if (TimeSelector.this.iDiff != null && event.getValue() != null) {
                        TimeSelector.this.setValue(Math.min((Integer)event.getValue() + TimeSelector.this.iDiff, 288));
                    }
                }
            });
        }
        this.iText.addFocusHandler(new FocusHandler(){

            public void onFocus(FocusEvent event) {
                TimeSelector.this.showSuggestions();
            }
        });
    }

    private boolean selectASuggestion() {
        if (this.iText.getText().equals(this.iLastSelected)) {
            return false;
        }
        if (this.iInsertedSuggestion != null) {
            this.iTimes.removeItem(this.iInsertedSuggestion);
            this.iInsertedSuggestion = null;
        }
        this.iLastSelected = this.iText.getText();
        Integer slot = this.getValue();
        if (slot == null) {
            slot = this.iStart == null ? Integer.valueOf(CONSTANTS.eventStartDefault()) : (this.iStart.getValue() == null ? Integer.valueOf(CONSTANTS.eventStopDefault()) : Integer.valueOf(this.iStart.getValue() + CONSTANTS.eventLengthDefault()));
        }
        int select = -1;
        int diff = 0;
        for (int i = 0; i < this.iTimes.getNumItems(); ++i) {
            int suggestion = this.iTimes.getSlot(i);
            if (select >= 0 && (Math.abs(slot - suggestion) >= diff || slot < suggestion)) continue;
            diff = Math.abs(slot - suggestion);
            select = i;
        }
        if (this.getValue() != null && diff != 0) {
            this.iInsertedSuggestion = new TimeMenuItem(slot);
            if (select == 0 && this.iStart != null && slot < this.iTimes.getSlot(0)) {
                --select;
            }
            this.iTimes.insertItem(this.iInsertedSuggestion, select + 1);
            this.iTimes.selectItem(select + 1);
        } else {
            this.iTimes.selectItem(select);
        }
        return true;
    }

    private void createSuggestions() {
        this.iLastSelected = null;
        this.iTimes.clearItems();
        if (this.iStart == null) {
            for (int t = 0; t < 288; t += CONSTANTS.eventSlotIncrement()) {
                this.iTimes.addItem(new TimeMenuItem(t));
            }
            this.iTimeScroll.setWidth("77px");
        } else {
            Integer prev = this.iStart.getValue();
            for (int t = CONSTANTS.eventSlotIncrement() + (prev == null ? 0 : prev); t <= 288; t += CONSTANTS.eventSlotIncrement()) {
                this.iTimes.addItem(new TimeMenuItem(t));
            }
            this.iTimeScroll.setWidth(prev == null ? "77px" : "137px");
        }
        this.selectASuggestion();
    }

    private void hideSuggestions() {
        if (this.iPopup.isShowing()) {
            this.iPopup.hide();
        }
    }

    private void showSuggestions() {
        this.iPopup.showRelativeTo((UIObject)this.iText);
        Integer value = this.getValue();
        if (value != null && (this.iTimes.getSelectedItemIndex() < 0 || this.iTimes.getItem(this.iTimes.getSelectedItemIndex()).getSlot() != value.intValue())) {
            for (int i = 0; i < this.iTimes.getNumItems(); ++i) {
                if (this.iTimes.getItem(i).getSlot() != value.intValue()) continue;
                this.iTimes.selectItem(i);
                break;
            }
        }
        this.iTimes.scrollToView();
    }

    private boolean isSuggestionsShowing() {
        return this.iPopup.isShowing();
    }

    public TimeMenu getTimeMenu() {
        return this.iTimes;
    }

    public static String slot2time(int slot, int diff) {
        if (diff <= 0) {
            return TimeUtils.slot2time(slot);
        }
        if (diff < 24 && diff != 12) {
            return TimeUtils.slot2time(slot) + " (" + 5 * diff + " mins)";
        }
        if (diff == 12) {
            return TimeUtils.slot2time(slot) + " (1 hr)";
        }
        if (diff % 12 == 0) {
            return TimeUtils.slot2time(slot) + " (" + diff / 12 + " hrs)";
        }
        if (diff % 12 == 3) {
            return TimeUtils.slot2time(slot) + " (" + diff / 12 + "&frac14; hrs)";
        }
        if (diff % 12 == 6) {
            return TimeUtils.slot2time(slot) + " (" + diff / 12 + "&frac12; hrs)";
        }
        if (diff % 12 == 9) {
            return TimeUtils.slot2time(slot) + " (" + diff / 12 + "&frac34; hrs)";
        }
        return TimeUtils.slot2time(slot) + " (" + diff / 12 + ":" + (diff % 12 == 1 ? "0" : "") + 5 * (diff % 12) + ")";
    }

    public static String slot2aria(int slot, int diff) {
        if (diff <= 0) {
            return TimeUtils.slot2aria(slot);
        }
        if (diff < 24 && diff != 12) {
            return TimeUtils.slot2aria(slot) + " (" + 5 * diff + " minutes)";
        }
        if (diff == 12) {
            return TimeUtils.slot2aria(slot) + " (1 hour)";
        }
        if (diff % 12 == 0) {
            return TimeUtils.slot2aria(slot) + " (" + diff / 12 + " hours)";
        }
        if (diff % 12 == 3) {
            return TimeUtils.slot2aria(slot) + " (" + diff / 12 + "&frac14; hours)";
        }
        if (diff % 12 == 6) {
            return TimeUtils.slot2aria(slot) + " (" + diff / 12 + "&frac12; hours)";
        }
        if (diff % 12 == 9) {
            return TimeUtils.slot2aria(slot) + " (" + diff / 12 + "&frac34; hours)";
        }
        return TimeUtils.slot2aria(slot) + " (" + diff / 12 + ":" + (diff % 12 == 1 ? "0" : "") + 5 * (diff % 12) + ")";
    }

    public Integer parseTime(String text) {
        return TimeUtils.parseTime(CONSTANTS, text, this.iStart == null ? null : this.iStart.getValue());
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<Integer> handler) {
        return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }

    public Integer getValue() {
        return this.parseTime(this.iText.getText());
    }

    public void setValue(Integer value) {
        this.setValue(value, false);
    }

    public void setValue(Integer value, boolean fireEvents) {
        if (value == null) {
            this.iText.setText("");
        } else {
            if (this.iStart != null && this.iStart.getValue() != null) {
                this.iDiff = value - this.iStart.getValue();
            }
            this.iText.setText(TimeUtils.slot2time(value));
        }
        if (fireEvents) {
            ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)value);
        }
    }

    public void setDiff(Integer diff) {
        this.iDiff = diff;
    }

    public void setStatus(String text) {
        AriaStatus.getInstance().setText(text);
    }

    public void updateSuggestionStatus() {
        if (this.iPopup.isShowing()) {
            int index = this.iTimes.getSelectedItemIndex();
            if (index < 0) {
                this.setStatus(ARIA.showingMultipleSuggestionsNoQueryNoneSelected(this.iTimes.getNumItems()));
                return;
            }
            int slot = this.iTimes.getSlot(index);
            int count = this.iTimes.getNumItems();
            String text = this.iTimes.getItem(index).toAriaString();
            if (this.iInsertedSuggestion != null) {
                if (this.iInsertedSuggestion.getSlot() == slot) {
                    this.setStatus(ARIA.onSuggestionNoCount(text));
                    return;
                }
                if (this.iInsertedSuggestion.getSlot() < slot) {
                    --index;
                }
                --count;
            }
            this.setStatus(ARIA.onSuggestion(index + 1, count, text));
        }
    }

    public int getTabIndex() {
        return this.iText.getTabIndex();
    }

    public void setAccessKey(char key) {
        this.iText.setAccessKey(key);
    }

    public void setFocus(boolean focused) {
        this.iText.setFocus(focused);
    }

    public void setTabIndex(int index) {
        this.iText.setTabIndex(index);
    }

    public HandlerRegistration addKeyUpHandler(KeyUpHandler handler) {
        return this.iText.addKeyUpHandler(handler);
    }

    public HandlerRegistration addKeyDownHandler(KeyDownHandler handler) {
        return this.iText.addKeyDownHandler(handler);
    }

    public HandlerRegistration addKeyPressHandler(KeyPressHandler handler) {
        return this.iText.addKeyPressHandler(handler);
    }

    public HandlerRegistration addFocusHandler(FocusHandler handler) {
        return this.iText.addFocusHandler(handler);
    }

    public HandlerRegistration addBlurHandler(BlurHandler handler) {
        return this.iText.addBlurHandler(handler);
    }

    public HandlerRegistration addSelectionHandler(SelectionHandler<Integer> handler) {
        return this.addHandler((EventHandler)handler, SelectionEvent.getType());
    }

    private void fireSuggestionEvent(Integer selectedTimeSlot) {
        SelectionEvent.fire((HasSelectionHandlers)this, (Object)selectedTimeSlot);
    }

    public static class TimeUtils {
        public static Integer parseTime(GwtConstants constants, String text, Integer start) {
            if (!text.isEmpty()) {
                for (String noon : constants.parseTimeNoon()) {
                    if (!noon.startsWith(text.toLowerCase())) continue;
                    return 144;
                }
                for (String midnight : constants.parseTimeMidnight()) {
                    if (!midnight.startsWith(text.toLowerCase())) continue;
                    return start == null ? 0 : 288;
                }
            }
            if (start != null) {
                for (String h : constants.parseTimeHours()) {
                    if (!text.toLowerCase().endsWith(h)) continue;
                    try {
                        return start + Math.round(12.0f * Float.parseFloat(text.substring(0, text.length() - h.length()).trim()));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                for (String m : constants.parseTimeMinutes()) {
                    if (!text.toLowerCase().endsWith(m)) continue;
                    try {
                        return start + Integer.parseInt(text.substring(0, text.length() - m.length()).trim()) / 5;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            int startHour = 0;
            int startMin = 0;
            String token = text.trim();
            String number = "";
            boolean plus = false;
            if (token.startsWith("+")) {
                plus = true;
                token = token.substring(1).trim();
            }
            while (!token.isEmpty() && token.charAt(0) >= '0' && token.charAt(0) <= '9') {
                number = number + token.substring(0, 1);
                token = token.substring(1);
            }
            if (number.isEmpty()) {
                return null;
            }
            if (number.length() > 2) {
                startHour = Integer.parseInt(number) / 100;
                startMin = Integer.parseInt(number) % 100;
            } else {
                startHour = Integer.parseInt(number);
            }
            while (token.startsWith(" ")) {
                token = token.substring(1);
            }
            if (token.startsWith(":") || token.startsWith(".") || !token.isEmpty() && token.charAt(0) >= '0' && token.charAt(0) <= '9') {
                token = token.substring(1);
                while (token.startsWith(" ")) {
                    token = token.substring(1);
                }
                number = "";
                while (!token.isEmpty() && token.charAt(0) >= '0' && token.charAt(0) <= '9') {
                    number = number + token.substring(0, 1);
                    token = token.substring(1);
                }
                if (!number.isEmpty()) {
                    startMin = Integer.parseInt(number);
                }
            }
            while (token.startsWith(" ")) {
                token = token.substring(1);
            }
            boolean hasAmOrPm = false;
            if (token.isEmpty() && plus && start != null) {
                int slot = start + (60 * startHour + startMin) / 5;
                if (slot > start && slot <= 288) {
                    return slot;
                }
                if (startMin == 0 && (slot = start + startHour / 5) > start && slot <= 288) {
                    return slot;
                }
            }
            for (String am : constants.parseTimeAm()) {
                if (!token.toLowerCase().startsWith(am)) continue;
                token = token.substring(2);
                hasAmOrPm = true;
                if (startHour != 12) break;
                startHour = 24;
                break;
            }
            for (String pm : constants.parseTimePm()) {
                if (!token.toLowerCase().startsWith(pm)) continue;
                token = token.substring(2);
                hasAmOrPm = true;
                if (startHour >= 12) break;
                startHour += 12;
                break;
            }
            if (!token.isEmpty()) {
                return null;
            }
            if (startMin % 5 != 0) {
                startMin = 5 * ((startMin + 2) / 5);
            }
            int slot = (60 * startHour + startMin) / 5;
            if (start != null && slot <= start && slot <= 144 && !hasAmOrPm) {
                slot += 144;
            }
            if (start != null && slot <= start) {
                return null;
            }
            if (slot < 0 || slot > 288) {
                return TimeUtils.parseTime(constants, text + "0", start);
            }
            return slot;
        }

        public static String slot2time(int slot) {
            if (CONSTANTS.useAmPm()) {
                if (slot == 0 || slot == 288) {
                    return CONSTANTS.timeMidnight();
                }
                if (slot == 144) {
                    return CONSTANTS.timeNoon();
                }
            }
            int h = slot / 12;
            int m = 5 * (slot % 12);
            if (CONSTANTS.useAmPm()) {
                return (h > 12 ? h - 12 : h) + ":" + (m < 10 ? "0" : "") + m + " " + (h == 24 ? CONSTANTS.timeAm() : (h >= 12 ? CONSTANTS.timePm() : CONSTANTS.timeAm()));
            }
            return h + ":" + (m < 10 ? "0" : "") + m;
        }

        public static String slot2short(int slot) {
            if (CONSTANTS.useAmPm()) {
                if (slot == 0 || slot == 288) {
                    return CONSTANTS.timeMidnight();
                }
                if (slot == 144) {
                    return CONSTANTS.timeNoon();
                }
            }
            int h = slot / 12;
            int m = 5 * (slot % 12);
            if (CONSTANTS.useAmPm()) {
                return (h > 12 ? h - 12 : h) + ":" + (m < 10 ? "0" : "") + m + (h == 24 ? CONSTANTS.timeShortAm() : (h >= 12 ? CONSTANTS.timeShortPm() : CONSTANTS.timeShortAm()));
            }
            return h + ":" + (m < 10 ? "0" : "") + m;
        }

        public static String slot2aria(int slot) {
            if (CONSTANTS.useAmPm()) {
                if (slot == 0 || slot == 288) {
                    return CONSTANTS.timeMidnight();
                }
                if (slot == 144) {
                    return CONSTANTS.timeNoon();
                }
            }
            int h = slot / 12;
            int m = 5 * (slot % 12);
            if (CONSTANTS.useAmPm()) {
                return (h > 12 ? h - 12 : h) + (m == 0 ? "" : (m < 10 ? " 0" : " ") + m) + (h == 24 ? " " + CONSTANTS.timeAm() : (h >= 12 ? " " + CONSTANTS.timePm() : " " + CONSTANTS.timeAm()));
            }
            return h + (m == 0 ? "" : (m < 10 ? " 0" : " ") + m);
        }
    }

    private class TimeMenuItem
    extends MenuItem {
        private int iSlot;

        private TimeMenuItem(final int slot) {
            super(TimeSelector.slot2time(slot, TimeSelector.this.iStart == null || TimeSelector.this.iStart.getValue() == null ? 0 : slot - TimeSelector.this.iStart.getValue()), true, new Scheduler.ScheduledCommand(){

                public void execute() {
                    TimeSelector.this.hideSuggestions();
                    TimeSelector.this.setValue(slot, true);
                    TimeSelector.this.iLastSelected = TimeSelector.this.iText.getText();
                    TimeSelector.this.fireSuggestionEvent(slot);
                }
            });
            this.setStyleName("item");
            this.getElement().setAttribute("whiteSpace", "nowrap");
            this.iSlot = slot;
        }

        public int getSlot() {
            return this.iSlot;
        }

        public String toAriaString() {
            return TimeSelector.slot2aria(this.iSlot, TimeSelector.this.iStart == null || TimeSelector.this.iStart.getValue() == null ? 0 : this.iSlot - TimeSelector.this.iStart.getValue());
        }
    }

    public class TimeMenu
    extends MenuBar
    implements HasAllFocusHandlers {
        TimeMenu() {
            super(true);
            this.setStyleName("");
            this.setFocusOnHoverEnabled(false);
            this.setFocusOnHoverEnabled(false);
            this.sinkEvents(4096);
            this.sinkEvents(2048);
        }

        public void onBrowserEvent(Event event) {
            switch (DOM.eventGetType((Event)event)) {
                case 4096: {
                    BlurEvent.fireNativeEvent((NativeEvent)event, (HasHandlers)this);
                    break;
                }
                case 2048: {
                    FocusEvent.fireNativeEvent((NativeEvent)event, (HasHandlers)this);
                }
            }
            super.onBrowserEvent(event);
        }

        public int getNumItems() {
            return this.getItems().size();
        }

        public int getSelectedItemIndex() {
            MenuItem selectedItem = this.getSelectedItem();
            if (selectedItem != null) {
                return this.getItems().indexOf(selectedItem);
            }
            return -1;
        }

        public void selectItem(int index) {
            List items = this.getItems();
            if (index > -1 && index < items.size()) {
                this.selectItem((MenuItem)items.get(index));
                TimeSelector.this.iTimeScroll.ensureVisible((UIObject)items.get(index));
            }
        }

        public void scrollToView() {
            List items = this.getItems();
            int index = this.getSelectedItemIndex();
            if (index > -1 && index < items.size()) {
                TimeSelector.this.iTimeScroll.ensureVisible((UIObject)items.get(index));
            }
        }

        public void executeSelected() {
            MenuItem selected = this.getSelectedItem();
            if (selected != null) {
                selected.getScheduledCommand().execute();
                TimeSelector.this.setStatus(ARIA.suggestionSelected(((TimeMenuItem)selected).toAriaString()));
            }
        }

        public int getSlot(int index) {
            List items = this.getItems();
            if (index > -1 && index < items.size()) {
                return ((TimeMenuItem)((Object)items.get(index))).getSlot();
            }
            return -1;
        }

        public TimeMenuItem getItem(int index) {
            List items = this.getItems();
            if (index > -1 && index < items.size()) {
                return (TimeMenuItem)((Object)items.get(index));
            }
            return null;
        }

        public HandlerRegistration addBlurHandler(BlurHandler handler) {
            return this.addHandler((EventHandler)handler, (GwtEvent.Type)BlurEvent.getType());
        }

        public HandlerRegistration addFocusHandler(FocusHandler handler) {
            return this.addHandler((EventHandler)handler, (GwtEvent.Type)FocusEvent.getType());
        }
    }
}

