/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.sectioning;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.sectioning.SectioningCookie;
import org.unitime.timetable.gwt.client.sectioning.StudentSectioningPage;
import org.unitime.timetable.gwt.client.sectioning.StudentSectioningWidget;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeDialogBox;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.client.widgets.WebTable;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningResources;
import org.unitime.timetable.gwt.services.SectioningService;
import org.unitime.timetable.gwt.services.SectioningServiceAsync;
import org.unitime.timetable.gwt.shared.AcademicSessionProvider;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.gwt.shared.ReservationInterface;
import org.unitime.timetable.gwt.shared.UserAuthenticationProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnrollmentTable
extends Composite {
    public static final StudentSectioningMessages MESSAGES = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    public static final StudentSectioningResources RESOURCES = (StudentSectioningResources)GWT.create(StudentSectioningResources.class);
    public static final StudentSectioningConstants CONSTANTS = (StudentSectioningConstants)GWT.create(StudentSectioningConstants.class);
    private static DateTimeFormat sDF = DateTimeFormat.getFormat((String)CONSTANTS.requestDateFormat());
    private static DateTimeFormat sTSF = DateTimeFormat.getFormat((String)CONSTANTS.timeStampFormat());
    private Long iOfferingId = null;
    private final SectioningServiceAsync iSectioningService = (SectioningServiceAsync)GWT.create(SectioningService.class);
    private SimpleForm iEnrollmentPanel;
    private UniTimeTable<ClassAssignmentInterface.Enrollment> iEnrollments;
    private UniTimeHeaderPanel iHeader;
    private UniTimeTableHeader.Operation iApprove;
    private UniTimeTableHeader.Operation iReject;
    private boolean iOnline;
    private boolean iShowFilter = false;

    public EnrollmentTable(boolean showHeader, boolean online) {
        this(showHeader, online, false);
    }

    public EnrollmentTable(final boolean showHeader, boolean online, boolean showFilter) {
        this.iOnline = online;
        this.iEnrollmentPanel = new SimpleForm();
        this.iShowFilter = showFilter;
        this.iHeader = new UniTimeHeaderPanel(showHeader ? MESSAGES.enrollmentsTable() : "&nbsp;");
        this.iHeader.addCollapsibleHandler(new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                SectioningCookie.getInstance().setEnrollmentCoursesDetails((Boolean)event.getValue());
                if (EnrollmentTable.this.iEnrollments.getRowCount() > 2) {
                    for (int row = 1; row < EnrollmentTable.this.iEnrollments.getRowCount() - 1; ++row) {
                        EnrollmentTable.this.iEnrollments.getRowFormatter().setVisible(row, ((Boolean)event.getValue()).booleanValue());
                    }
                }
                if (EnrollmentTable.this.iEnrollments.getRowCount() == 0) {
                    EnrollmentTable.this.refresh();
                }
            }
        });
        this.iHeader.setCollapsible(showHeader ? Boolean.valueOf(SectioningCookie.getInstance().getEnrollmentCoursesDetails()) : null);
        this.iHeader.setTitleStyleName("unitime3-HeaderTitle");
        this.iEnrollmentPanel.removeStyleName("unitime-NotPrintableBottomLine");
        if (showHeader) {
            this.iEnrollmentPanel.addHeaderRow((Widget)this.iHeader);
            this.iHeader.getElement().getStyle().setMarginTop(10.0, Style.Unit.PX);
        }
        this.iEnrollments = new UniTimeTable();
        this.iEnrollmentPanel.addRow((Widget)this.iEnrollments);
        if (!showHeader) {
            this.iEnrollmentPanel.addBottomRow((Widget)this.iHeader);
        }
        this.iHeader.addButton("approve", MESSAGES.buttonApproveSelectedEnrollments(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (EnrollmentTable.this.iApprove != null && EnrollmentTable.this.iApprove.isApplicable()) {
                    EnrollmentTable.this.iApprove.execute();
                }
            }
        });
        this.iHeader.addButton("reject", MESSAGES.buttonRejectSelectedEnrollments(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (EnrollmentTable.this.iReject != null && EnrollmentTable.this.iReject.isApplicable()) {
                    EnrollmentTable.this.iReject.execute();
                }
            }
        });
        this.iHeader.setEnabled("approve", false);
        this.iHeader.setEnabled("reject", false);
        this.initWidget((Widget)this.iEnrollmentPanel);
        this.iEnrollments.addMouseClickListener(new UniTimeTable.MouseClickListener<ClassAssignmentInterface.Enrollment>(){

            @Override
            public void onMouseClick(UniTimeTable.TableEvent<ClassAssignmentInterface.Enrollment> event) {
                if (event.getData() == null) {
                    return;
                }
                LoadingWidget.getInstance().show(MESSAGES.loadingEnrollment(event.getData().getStudent().getName()));
                EnrollmentTable.this.iHeader.clearMessage();
                EnrollmentTable.this.showStudentSchedule(event.getData().getStudent(), new AsyncCallback<Boolean>(){

                    public void onFailure(Throwable caught) {
                        LoadingWidget.getInstance().hide();
                        if (showHeader) {
                            EnrollmentTable.this.iHeader.setErrorMessage(MESSAGES.failedToLoadEnrollments(caught.getMessage()));
                        } else {
                            UniTimeNotifications.error(MESSAGES.failedToLoadEnrollments(caught.getMessage()), caught);
                        }
                    }

                    public void onSuccess(Boolean result) {
                        LoadingWidget.getInstance().hide();
                    }
                });
            }
        });
    }

    public UniTimeTable<ClassAssignmentInterface.Enrollment> getTable() {
        return this.iEnrollments;
    }

    public UniTimeHeaderPanel getHeader() {
        return this.iHeader;
    }

    public void showStudentSchedule(final ClassAssignmentInterface.Student student, final AsyncCallback<Boolean> callback) {
        this.iSectioningService.getEnrollment(this.iOnline, student.getId(), new AsyncCallback<ClassAssignmentInterface>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(ClassAssignmentInterface result) {
                callback.onSuccess((Object)true);
                WebTable assignments = new WebTable();
                assignments.setHeader(new WebTable.Row(new WebTable.Cell(MESSAGES.colSubject(), 1, "75px"), new WebTable.Cell(MESSAGES.colCourse(), 1, "75px"), new WebTable.Cell(MESSAGES.colSubpart(), 1, "50px"), new WebTable.Cell(MESSAGES.colClass(), 1, "75px"), new WebTable.Cell(MESSAGES.colLimit(), 1, "60px"), new WebTable.Cell(MESSAGES.colDays(), 1, "50px"), new WebTable.Cell(MESSAGES.colStart(), 1, "75px"), new WebTable.Cell(MESSAGES.colEnd(), 1, "75px"), new WebTable.Cell(MESSAGES.colDate(), 1, "75px"), new WebTable.Cell(MESSAGES.colRoom(), 1, "100px"), new WebTable.Cell(MESSAGES.colInstructor(), 1, "100px"), new WebTable.Cell(MESSAGES.colParent(), 1, "75px"), new WebTable.Cell(MESSAGES.colNoteIcon(), 1, "10px"), new WebTable.Cell(MESSAGES.colCredit(), 1, "75px")));
                assignments.setEmptyMessage(MESSAGES.emptySchedule());
                ArrayList<WebTable.Row> rows = new ArrayList<WebTable.Row>();
                float totalCredit = 0.0f;
                for (ClassAssignmentInterface.CourseAssignment course : result.getCourseAssignments()) {
                    if (course.isAssigned()) {
                        boolean firstClazz = true;
                        for (ClassAssignmentInterface.ClassAssignment clazz : course.getClassAssignments()) {
                            String style = firstClazz && !rows.isEmpty() ? "top-border-dashed" : "";
                            WebTable.Cell[] cellArray = new WebTable.Cell[14];
                            cellArray[0] = new WebTable.Cell(firstClazz ? (course.isFreeTime() ? MESSAGES.freeTimeSubject() : course.getSubject()) : "");
                            cellArray[1] = new WebTable.Cell(firstClazz ? (course.isFreeTime() ? MESSAGES.freeTimeCourse() : course.getCourseNbr()) : "");
                            cellArray[2] = new WebTable.Cell(clazz.getSubpart());
                            cellArray[3] = new WebTable.Cell(clazz.getSection());
                            cellArray[4] = new WebTable.Cell(clazz.getLimitString());
                            cellArray[5] = new WebTable.Cell(clazz.getDaysString(CONSTANTS.shortDays()));
                            cellArray[6] = new WebTable.Cell(clazz.getStartString(CONSTANTS.useAmPm()));
                            cellArray[7] = new WebTable.Cell(clazz.getEndString(CONSTANTS.useAmPm()));
                            cellArray[8] = new WebTable.Cell(clazz.getDatePattern());
                            cellArray[9] = clazz.hasDistanceConflict() ? new WebTable.IconCell(RESOURCES.distantConflict(), MESSAGES.backToBackDistance(clazz.getBackToBackRooms(), clazz.getBackToBackDistance()), clazz.getRooms(", ")) : new WebTable.Cell(clazz.getRooms(", "));
                            cellArray[10] = new WebTable.InstructorCell(clazz.getInstructors(), clazz.getInstructorEmails(), ", ");
                            cellArray[11] = new WebTable.Cell(clazz.getParentSection());
                            cellArray[12] = clazz.hasNote() ? new WebTable.IconCell(RESOURCES.note(), clazz.getNote(), "") : new WebTable.Cell("");
                            cellArray[13] = new WebTable.AbbvTextCell(clazz.getCredit());
                            WebTable.Row row = new WebTable.Row(cellArray);
                            rows.add(row);
                            for (WebTable.Cell cell : row.getCells()) {
                                cell.setStyleName(style);
                            }
                            firstClazz = false;
                            totalCredit += clazz.guessCreditCount();
                        }
                        continue;
                    }
                    String style = "text-red" + (!rows.isEmpty() ? " top-border-dashed" : "");
                    WebTable.Row row = null;
                    String unassignedMessage = MESSAGES.courseNotAssigned();
                    if (course.hasEnrollmentMessage()) {
                        unassignedMessage = course.getEnrollmentMessage();
                    } else if (course.getOverlaps() != null && !course.getOverlaps().isEmpty()) {
                        unassignedMessage = "";
                        Iterator<String> i = course.getOverlaps().iterator();
                        while (i.hasNext()) {
                            String x = i.next();
                            unassignedMessage = unassignedMessage.isEmpty() ? unassignedMessage + MESSAGES.conflictWithFirst(x) : (!i.hasNext() ? unassignedMessage + MESSAGES.conflictWithLast(x) : unassignedMessage + MESSAGES.conflictWithMiddle(x));
                            if (!i.hasNext()) continue;
                            unassignedMessage = unassignedMessage + ", ";
                        }
                        if (course.getInstead() != null) {
                            unassignedMessage = unassignedMessage + MESSAGES.conflictAssignedAlternative(course.getInstead());
                        }
                        unassignedMessage = unassignedMessage + ".";
                    } else if (course.isNotAvailable()) {
                        unassignedMessage = MESSAGES.classNotAvailable();
                    } else if (course.isLocked()) {
                        unassignedMessage = MESSAGES.courseLocked(course.getSubject() + " " + course.getCourseNbr());
                    }
                    WebTable.Cell[] cellArray = course.getClassAssignments().iterator();
                    if (cellArray.hasNext()) {
                        ClassAssignmentInterface.ClassAssignment clazz = cellArray.next();
                        row = new WebTable.Row(new WebTable.Cell(course.isFreeTime() ? MESSAGES.freeTimeSubject() : course.getSubject()), new WebTable.Cell(course.isFreeTime() ? MESSAGES.freeTimeCourse() : course.getCourseNbr()), new WebTable.Cell(clazz.getSubpart()), new WebTable.Cell(clazz.getSection()), new WebTable.Cell(clazz.getLimitString()), new WebTable.Cell(clazz.getDaysString(CONSTANTS.shortDays())), new WebTable.Cell(clazz.getStartString(CONSTANTS.useAmPm())), new WebTable.Cell(clazz.getEndString(CONSTANTS.useAmPm())), new WebTable.Cell(clazz.getDatePattern()), new WebTable.Cell(unassignedMessage, 3, null), clazz.getNote() == null ? new WebTable.Cell("") : new WebTable.IconCell(RESOURCES.note(), clazz.getNote(), ""), new WebTable.AbbvTextCell(clazz.getCredit()));
                    }
                    if (row == null) {
                        row = new WebTable.Row(new WebTable.Cell(course.getSubject()), new WebTable.Cell(course.getCourseNbr()), new WebTable.Cell(unassignedMessage, 12, null));
                    }
                    for (WebTable.Cell cell : row.getCells()) {
                        cell.setStyleName(style);
                    }
                    row.getCell(row.getNrCells() - 1).setStyleName("text-gray" + (!rows.isEmpty() ? " top-border-dashed" : ""));
                    rows.add(row);
                }
                WebTable.Row[] rowArray = new WebTable.Row[rows.size()];
                int idx = 0;
                for (WebTable.Row row : rows) {
                    rowArray[idx++] = row;
                }
                assignments.setData(rowArray);
                SimpleForm form = new SimpleForm();
                form.addRow((Widget)assignments);
                UniTimeHeaderPanel buttons = new UniTimeHeaderPanel();
                form.addBottomRow((Widget)buttons);
                final UniTimeDialogBox dialog = new UniTimeDialogBox(true, false);
                dialog.setWidget((Widget)form);
                dialog.setText(MESSAGES.dialogEnrollments(student.getName()));
                dialog.setEscapeToHide(true);
                if (totalCredit > 0.0f) {
                    buttons.setMessage(MESSAGES.totalCredit(totalCredit));
                }
                buttons.addButton("assistant", MESSAGES.buttonAssistant(), new ClickHandler(){

                    public void onClick(ClickEvent e) {
                        EnrollmentTable.this.showStudentAssistant(student, new AsyncCallback<Boolean>(){

                            public void onFailure(Throwable caught) {
                                UniTimeNotifications.error(caught);
                            }

                            public void onSuccess(Boolean result) {
                                if (result.booleanValue()) {
                                    dialog.hide();
                                }
                            }
                        });
                    }
                });
                buttons.setEnabled("assistant", student.getSessionId() != null);
                if (EnrollmentTable.this.iOnline) {
                    buttons.addButton("log", MESSAGES.buttonChangeLog(), new ClickHandler(){

                        public void onClick(ClickEvent event) {
                            LoadingWidget.getInstance().show(MESSAGES.loadingChangeLog(student.getName()));
                            EnrollmentTable.this.showChangeLog(student, new AsyncCallback<Boolean>(){

                                public void onFailure(Throwable caught) {
                                    LoadingWidget.getInstance().hide();
                                    UniTimeNotifications.error(caught);
                                }

                                public void onSuccess(Boolean result) {
                                    LoadingWidget.getInstance().hide();
                                    if (result.booleanValue()) {
                                        dialog.hide();
                                    }
                                }
                            });
                        }
                    });
                }
                buttons.addButton("close", MESSAGES.buttonClose(), new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        dialog.hide();
                    }
                });
                dialog.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

                    public void onClose(CloseEvent<PopupPanel> event) {
                        EnrollmentTable.this.iEnrollments.clearHover();
                    }
                });
                dialog.center();
            }
        });
    }

    public void showStudentAssistant(final ClassAssignmentInterface.Student student, final AsyncCallback<Boolean> callback) {
        UserAuthenticationProvider user = new UserAuthenticationProvider(){

            @Override
            public String getUser() {
                return student.getName();
            }

            @Override
            public void setUser(String user, AsyncCallback<Boolean> callback) {
            }
        };
        AcademicSessionProvider session = new AcademicSessionProvider(){

            @Override
            public Long getAcademicSessionId() {
                return student.getSessionId();
            }

            @Override
            public String getAcademicSessionName() {
                return "Current Session";
            }

            @Override
            public void addAcademicSessionChangeHandler(AcademicSessionProvider.AcademicSessionChangeHandler handler) {
            }

            @Override
            public void selectSession(Long sessionId, AsyncCallback<Boolean> callback) {
            }

            @Override
            public AcademicSessionProvider.AcademicSessionInfo getAcademicSessionInfo() {
                return null;
            }
        };
        final StudentSectioningWidget widget = new StudentSectioningWidget(this.iOnline, session, user, StudentSectioningPage.Mode.SECTIONING, false);
        this.iSectioningService.logIn(this.iOnline ? "LOOKUP" : "BATCH", this.iOnline ? student.getExternalId() : String.valueOf(student.getId()), null, new AsyncCallback<String>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(String result) {
                widget.checkEligibility(student.getSessionId(), student.getId(), true, new AsyncCallback<OnlineSectioningInterface.EligibilityCheck>(){

                    public void onFailure(Throwable caught) {
                        callback.onFailure(caught);
                    }

                    public void onSuccess(OnlineSectioningInterface.EligibilityCheck result) {
                        final UniTimeDialogBox d = new UniTimeDialogBox(true, false);
                        d.setWidget((Widget)widget);
                        d.setText(MESSAGES.dialogAssistant(student.getName()));
                        d.setEscapeToHide(true);
                        callback.onSuccess((Object)true);
                        d.center();
                        widget.addResizeHandler(new ResizeHandler(){

                            public void onResize(ResizeEvent event) {
                                d.center();
                            }
                        });
                    }
                });
            }
        });
    }

    public void showChangeLog(final ClassAssignmentInterface.Student student, final AsyncCallback<Boolean> callback) {
        this.iSectioningService.changeLog("id:" + student.getExternalId(), new AsyncCallback<List<ClassAssignmentInterface.SectioningAction>>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(List<ClassAssignmentInterface.SectioningAction> logs) {
                if (logs == null || logs.isEmpty()) {
                    callback.onSuccess((Object)false);
                    return;
                }
                final UniTimeTable<ClassAssignmentInterface.SectioningAction> table = new UniTimeTable<ClassAssignmentInterface.SectioningAction>();
                table.addRow(null, new Widget[]{new UniTimeTableHeader(MESSAGES.colOperation()), new UniTimeTableHeader(MESSAGES.colTimeStamp()), new UniTimeTableHeader(MESSAGES.colResult()), new UniTimeTableHeader(MESSAGES.colUser()), new UniTimeTableHeader(MESSAGES.colMessage())});
                for (ClassAssignmentInterface.SectioningAction log : logs) {
                    table.addRow(log, new Widget[]{new TopCell(log.getOperation()), new TopCell(sTSF.format(log.getTimeStamp())), new TopCell(log.getResult()), new TopCell(log.getUser() == null ? "" : log.getUser()), new HTML(log.getMessage() == null ? "" : log.getMessage())});
                }
                table.addMouseClickListener(new UniTimeTable.MouseClickListener<ClassAssignmentInterface.SectioningAction>(){

                    @Override
                    public void onMouseClick(UniTimeTable.TableEvent<ClassAssignmentInterface.SectioningAction> event) {
                        if (event.getData() != null && event.getData().getProto() != null) {
                            final HTML widget = new HTML(event.getData().getProto());
                            final ScrollPanel scroll = new ScrollPanel((Widget)widget);
                            scroll.setHeight((int)(0.8 * (double)Window.getClientHeight()) + "px");
                            scroll.setStyleName("unitime-ScrollPanel");
                            final UniTimeDialogBox dialog = new UniTimeDialogBox(true, false);
                            dialog.setWidget((Widget)scroll);
                            dialog.setText(MESSAGES.dialogChangeMessage(student.getName()));
                            dialog.setEscapeToHide(true);
                            dialog.addOpenHandler(new OpenHandler<UniTimeDialogBox>(){

                                public void onOpen(OpenEvent<UniTimeDialogBox> event) {
                                    RootPanel.getBodyElement().getStyle().setOverflow(Style.Overflow.HIDDEN);
                                    scroll.setHeight(Math.min(widget.getElement().getScrollHeight(), Window.getClientHeight() * 80 / 100) + "px");
                                    dialog.setPopupPosition(Math.max(Window.getScrollLeft() + (Window.getClientWidth() - dialog.getOffsetWidth()) / 2, 0), Math.max(Window.getScrollTop() + (Window.getClientHeight() - dialog.getOffsetHeight()) / 2, 0));
                                }
                            });
                            dialog.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

                                public void onClose(CloseEvent<PopupPanel> event) {
                                    table.clearHover();
                                    RootPanel.getBodyElement().getStyle().setOverflow(Style.Overflow.AUTO);
                                }
                            });
                            dialog.center();
                        }
                    }
                });
                final UniTimeDialogBox dialog = new UniTimeDialogBox(true, false);
                final ScrollPanel scroll = new ScrollPanel(table);
                scroll.setHeight((int)(0.8 * (double)Window.getClientHeight()) + "px");
                scroll.setStyleName("unitime-ScrollPanel");
                dialog.setWidget((Widget)scroll);
                dialog.setText(MESSAGES.dialogChangeLog(student.getName()));
                dialog.setEscapeToHide(true);
                dialog.addOpenHandler(new OpenHandler<UniTimeDialogBox>(){

                    public void onOpen(OpenEvent<UniTimeDialogBox> event) {
                        RootPanel.getBodyElement().getStyle().setOverflow(Style.Overflow.HIDDEN);
                        scroll.setHeight(Math.min(table.getElement().getScrollHeight(), Window.getClientHeight() * 80 / 100) + "px");
                        dialog.setPopupPosition(Math.max(Window.getScrollLeft() + (Window.getClientWidth() - dialog.getOffsetWidth()) / 2, 0), Math.max(Window.getScrollTop() + (Window.getClientHeight() - dialog.getOffsetHeight()) / 2, 0));
                    }
                });
                dialog.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

                    public void onClose(CloseEvent<PopupPanel> event) {
                        table.clearHover();
                        RootPanel.getBodyElement().getStyle().setOverflow(Style.Overflow.AUTO);
                    }
                });
                callback.onSuccess((Object)true);
                dialog.center();
            }
        });
    }

    protected void refresh() {
        this.clear();
        this.iHeader.showLoading();
        this.iHeader.setEnabled("approve", false);
        this.iHeader.setEnabled("reject", false);
        if (this.iOfferingId != null) {
            this.iSectioningService.canApprove(this.iOfferingId, new AsyncCallback<List<Long>>(){

                public void onFailure(Throwable caught) {
                    EnrollmentTable.this.iHeader.setErrorMessage(MESSAGES.failedToLoadEnrollments(caught.getMessage()));
                }

                public void onSuccess(final List<Long> courseIdsToApprove) {
                    EnrollmentTable.this.iSectioningService.listEnrollments(EnrollmentTable.this.iOfferingId, new AsyncCallback<List<ClassAssignmentInterface.Enrollment>>(){

                        public void onFailure(Throwable caught) {
                            EnrollmentTable.this.iHeader.setErrorMessage(MESSAGES.failedToLoadEnrollments(caught.getMessage()));
                            EnrollmentTable.this.iHeader.setCollapsible(null);
                            SectioningCookie.getInstance().setEnrollmentCoursesDetails(false);
                        }

                        public void onSuccess(List<ClassAssignmentInterface.Enrollment> result) {
                            if (result.isEmpty()) {
                                EnrollmentTable.this.iHeader.setMessage(EnrollmentTable.this.iOfferingId >= 0L ? MESSAGES.offeringHasNoEnrollments() : MESSAGES.classHasNoEnrollments());
                                EnrollmentTable.this.iHeader.setCollapsible(null);
                            } else {
                                EnrollmentTable.this.iHeader.clearMessage();
                                EnrollmentTable.this.iHeader.setCollapsible(true);
                                EnrollmentTable.this.populate(result, courseIdsToApprove);
                                if (EnrollmentTable.this.iEnrollments.getRowCount() > 2) {
                                    for (int row = 1; row < EnrollmentTable.this.iEnrollments.getRowCount() - 1; ++row) {
                                        EnrollmentTable.this.iEnrollments.getRowFormatter().setVisible(row, SectioningCookie.getInstance().getEnrollmentCoursesDetails());
                                    }
                                }
                                EnrollmentTable.this.iHeader.setEnabled("approve", courseIdsToApprove != null && !courseIdsToApprove.isEmpty() && EnrollmentTable.this.iApprove != null && EnrollmentTable.this.iApprove.isApplicable());
                                EnrollmentTable.this.iHeader.setEnabled("reject", courseIdsToApprove != null && !courseIdsToApprove.isEmpty() && EnrollmentTable.this.iReject != null && EnrollmentTable.this.iReject.isApplicable());
                            }
                        }
                    });
                }
            });
        }
    }

    public void clear() {
        for (int row = this.iEnrollments.getRowCount() - 1; row >= 0; --row) {
            this.iEnrollments.removeRow(row);
        }
        this.iEnrollments.clear(true);
    }

    protected boolean filter(SectioningCookie.EnrollmentFilter f, ClassAssignmentInterface.Enrollment e) {
        switch (f) {
            case ALL: {
                return false;
            }
            case ENROLLED: {
                return !e.hasClasses();
            }
            case WAIT_LISTED: {
                return e.hasClasses() || !e.isWaitList();
            }
            case NOT_ENROLLED: {
                return e.hasClasses() || e.isWaitList();
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void populate(final List<ClassAssignmentInterface.Enrollment> enrollments, final List<Long> courseIdsCanApprove) {
        UniTimeTableHeader hTimeStamp;
        boolean showFilter;
        ArrayList<Object> header = new ArrayList<Object>();
        int enrolled = 0;
        int waitlisted = 0;
        int unassigned = 0;
        for (ClassAssignmentInterface.Enrollment enrollment : enrollments) {
            if (enrollment.hasClasses()) {
                ++enrolled;
                continue;
            }
            if (enrollment.isWaitList()) {
                ++waitlisted;
                continue;
            }
            ++unassigned;
        }
        SectioningCookie.EnrollmentFilter f = SectioningCookie.EnrollmentFilter.ALL;
        boolean bl = showFilter = this.iShowFilter && this.iOfferingId != null && this.iOfferingId > 0L;
        if (showFilter) {
            f = SectioningCookie.getInstance().getEnrollmentFilter();
            if (f == SectioningCookie.EnrollmentFilter.ALL) {
                this.iHeader.setHeaderTitle(MESSAGES.studentsTable());
            } else {
                this.iHeader.setHeaderTitle(MESSAGES.enrollmentTableFilter(CONSTANTS.enrollmentFilterValues()[f.ordinal()]));
            }
        }
        Collections.sort(enrollments, new Comparator<ClassAssignmentInterface.Enrollment>(){

            @Override
            public int compare(ClassAssignmentInterface.Enrollment e1, ClassAssignmentInterface.Enrollment e2) {
                int cmp = e1.getStudent().getName().compareTo(e2.getStudent().getName());
                if (cmp != 0) {
                    return cmp;
                }
                return e1.getStudent().getId() < e2.getStudent().getId() ? -1 : 1;
            }
        });
        boolean hasExtId = false;
        for (ClassAssignmentInterface.Enrollment e : enrollments) {
            if (this.filter(f, e) || !e.getStudent().isCanShowExternalId()) continue;
            hasExtId = true;
            break;
        }
        if (hasExtId) {
            final UniTimeTableHeader hExtId = new UniTimeTableHeader(MESSAGES.colStudentExternalId());
            header.add(hExtId);
            hExtId.addOperation(new UniTimeTableHeader.Operation(){

                public void execute() {
                    EnrollmentTable.this.iEnrollments.sort(hExtId, new Comparator<ClassAssignmentInterface.Enrollment>(){

                        @Override
                        public int compare(ClassAssignmentInterface.Enrollment e1, ClassAssignmentInterface.Enrollment e2) {
                            int cmp = (e1.getStudent().isCanShowExternalId() ? e1.getStudent().getExternalId() : "").compareTo(e2.getStudent().isCanShowExternalId() ? e2.getStudent().getExternalId() : "");
                            if (cmp != 0) {
                                return cmp;
                            }
                            cmp = e1.getStudent().getName().compareTo(e2.getStudent().getName());
                            if (cmp != 0) {
                                return cmp;
                            }
                            return e1.getStudent().getId() < e2.getStudent().getId() ? -1 : 1;
                        }
                    });
                }

                public boolean isApplicable() {
                    return true;
                }

                public boolean hasSeparator() {
                    return false;
                }

                public String getName() {
                    return MESSAGES.sortBy(MESSAGES.colStudentExternalId());
                }
            });
        }
        final UniTimeTableHeader hStudent = new UniTimeTableHeader(MESSAGES.colStudent());
        header.add(hStudent);
        hStudent.addOperation(new UniTimeTableHeader.Operation(){

            public void execute() {
                EnrollmentTable.this.iEnrollments.sort(hStudent, new Comparator<ClassAssignmentInterface.Enrollment>(){

                    @Override
                    public int compare(ClassAssignmentInterface.Enrollment e1, ClassAssignmentInterface.Enrollment e2) {
                        int cmp = e1.getStudent().getName().compareTo(e2.getStudent().getName());
                        if (cmp != 0) {
                            return cmp;
                        }
                        return e1.getStudent().getId() < e2.getStudent().getId() ? -1 : 1;
                    }
                });
            }

            public boolean isApplicable() {
                return true;
            }

            public boolean hasSeparator() {
                return false;
            }

            public String getName() {
                return MESSAGES.sortBy(MESSAGES.colStudent());
            }
        });
        boolean crosslist = false;
        Long courseId = null;
        for (ClassAssignmentInterface.Enrollment e : enrollments) {
            if (this.filter(f, e)) continue;
            if (courseId == null) {
                courseId = e.getCourseId();
                continue;
            }
            if (e.getCourseId() == courseId) continue;
            crosslist = true;
            break;
        }
        if (crosslist) {
            final UniTimeTableHeader hCourse = new UniTimeTableHeader(MESSAGES.colCourse());
            header.add(hCourse);
            hCourse.addOperation(new UniTimeTableHeader.Operation(){

                public void execute() {
                    EnrollmentTable.this.iEnrollments.sort(hCourse, new Comparator<ClassAssignmentInterface.Enrollment>(){

                        @Override
                        public int compare(ClassAssignmentInterface.Enrollment e1, ClassAssignmentInterface.Enrollment e2) {
                            int cmp = e1.getCourseName().compareTo(e2.getCourseName());
                            if (cmp != 0) {
                                return cmp;
                            }
                            cmp = e1.getStudent().getName().compareTo(e2.getStudent().getName());
                            if (cmp != 0) {
                                return cmp;
                            }
                            return e1.getStudent().getId() < e2.getStudent().getId() ? -1 : 1;
                        }
                    });
                }

                public boolean isApplicable() {
                    return true;
                }

                public boolean hasSeparator() {
                    return false;
                }

                public String getName() {
                    return MESSAGES.sortBy(MESSAGES.colCourse());
                }
            });
        }
        boolean hasPriority = false;
        boolean hasArea = false;
        boolean hasMajor = false;
        boolean hasGroup = false;
        boolean hasAcmd = false;
        boolean hasAlternative = false;
        boolean hasReservation = false;
        boolean hasRequestedDate = false;
        boolean hasEnrolledDate = false;
        boolean hasConflict = false;
        boolean hasMessage = false;
        for (ClassAssignmentInterface.Enrollment e : enrollments) {
            if (this.filter(f, e)) continue;
            if (e.getPriority() > 0) {
                hasPriority = true;
            }
            if (e.isAlternative()) {
                hasAlternative = true;
            }
            if (e.getStudent().hasArea()) {
                hasArea = true;
            }
            if (e.getStudent().hasMajor()) {
                hasMajor = true;
            }
            if (e.getStudent().hasGroup()) {
                hasGroup = true;
            }
            if (e.getStudent().hasAccommodation()) {
                hasAcmd = true;
            }
            if (e.getReservation() != null) {
                hasReservation = true;
            }
            if (e.getRequestedDate() != null) {
                hasRequestedDate = true;
            }
            if (e.getEnrolledDate() != null) {
                hasEnrolledDate = true;
            }
            if (e.hasConflict()) {
                hasConflict = true;
            }
            if (!e.hasEnrollmentMessage()) continue;
            hasMessage = true;
        }
        if (hasPriority) {
            final UniTimeTableHeader hPriority = new UniTimeTableHeader(MESSAGES.colPriority());
            hPriority.addOperation(new UniTimeTableHeader.Operation(){

                public void execute() {
                    EnrollmentTable.this.iEnrollments.sort(hPriority, new Comparator<ClassAssignmentInterface.Enrollment>(){

                        @Override
                        public int compare(ClassAssignmentInterface.Enrollment e1, ClassAssignmentInterface.Enrollment e2) {
                            int cmp = new Integer(e1.getPriority()).compareTo(e2.getPriority());
                            if (cmp != 0) {
                                return cmp;
                            }
                            cmp = e1.getAlternative().compareTo(e2.getAlternative());
                            if (cmp != 0) {
                                return cmp;
                            }
                            cmp = e1.getStudent().getName().compareTo(e2.getStudent().getName());
                            if (cmp != 0) {
                                return cmp;
                            }
                            return e1.getStudent().getId() < e2.getStudent().getId() ? -1 : 1;
                        }
                    });
                }

                public boolean isApplicable() {
                    return true;
                }

                public boolean hasSeparator() {
                    return false;
                }

                public String getName() {
                    return MESSAGES.sortBy(MESSAGES.colPriority());
                }
            });
            header.add(hPriority);
        }
        if (hasAlternative) {
            final UniTimeTableHeader hAlternative = new UniTimeTableHeader(MESSAGES.colAlternative());
            hAlternative.addOperation(new UniTimeTableHeader.Operation(){

                public void execute() {
                    EnrollmentTable.this.iEnrollments.sort(hAlternative, new Comparator<ClassAssignmentInterface.Enrollment>(){

                        @Override
                        public int compare(ClassAssignmentInterface.Enrollment e1, ClassAssignmentInterface.Enrollment e2) {
                            int cmp = e1.getAlternative().compareTo(e2.getAlternative());
                            if (cmp != 0) {
                                return cmp;
                            }
                            cmp = new Integer(e1.getPriority()).compareTo(e2.getPriority());
                            if (cmp != 0) {
                                return cmp;
                            }
                            cmp = e1.getStudent().getName().compareTo(e2.getStudent().getName());
                            if (cmp != 0) {
                                return cmp;
                            }
                            return e1.getStudent().getId() < e2.getStudent().getId() ? -1 : 1;
                        }
                    });
                }

                public boolean isApplicable() {
                    return true;
                }

                public boolean hasSeparator() {
                    return false;
                }

                public String getName() {
                    return MESSAGES.sortBy(MESSAGES.colAlternative());
                }
            });
            header.add(hAlternative);
        }
        if (hasArea) {
            final UniTimeTableHeader hArea = new UniTimeTableHeader(MESSAGES.colArea());
            header.add(hArea);
            hArea.addOperation(new UniTimeTableHeader.Operation(){

                public void execute() {
                    EnrollmentTable.this.iEnrollments.sort(hArea, new Comparator<ClassAssignmentInterface.Enrollment>(){

                        @Override
                        public int compare(ClassAssignmentInterface.Enrollment e1, ClassAssignmentInterface.Enrollment e2) {
                            int cmp = e1.getStudent().getAreaClasf("|").compareTo(e2.getStudent().getAreaClasf("|"));
                            if (cmp != 0) {
                                return cmp;
                            }
                            cmp = e1.getStudent().getMajor("|").compareTo(e2.getStudent().getMajor("|"));
                            if (cmp != 0) {
                                return cmp;
                            }
                            cmp = e1.getStudent().getName().compareTo(e2.getStudent().getName());
                            if (cmp != 0) {
                                return cmp;
                            }
                            return e1.getStudent().getId() < e2.getStudent().getId() ? -1 : 1;
                        }
                    });
                }

                public boolean isApplicable() {
                    return true;
                }

                public boolean hasSeparator() {
                    return false;
                }

                public String getName() {
                    return MESSAGES.sortBy(MESSAGES.colArea());
                }
            });
            final UniTimeTableHeader hClasf = new UniTimeTableHeader(MESSAGES.colClassification());
            header.add(hClasf);
            hClasf.addOperation(new UniTimeTableHeader.Operation(){

                public void execute() {
                    EnrollmentTable.this.iEnrollments.sort(hClasf, new Comparator<ClassAssignmentInterface.Enrollment>(){

                        @Override
                        public int compare(ClassAssignmentInterface.Enrollment e1, ClassAssignmentInterface.Enrollment e2) {
                            int cmp = e1.getStudent().getClassification("|").compareTo(e2.getStudent().getClassification("|"));
                            if (cmp != 0) {
                                return cmp;
                            }
                            cmp = e1.getStudent().getArea("|").compareTo(e2.getStudent().getArea("|"));
                            if (cmp != 0) {
                                return cmp;
                            }
                            cmp = e1.getStudent().getMajor("|").compareTo(e2.getStudent().getMajor("|"));
                            if (cmp != 0) {
                                return cmp;
                            }
                            cmp = e1.getStudent().getName().compareTo(e2.getStudent().getName());
                            if (cmp != 0) {
                                return cmp;
                            }
                            return e1.getStudent().getId() < e2.getStudent().getId() ? -1 : 1;
                        }
                    });
                }

                public boolean isApplicable() {
                    return true;
                }

                public boolean hasSeparator() {
                    return false;
                }

                public String getName() {
                    return MESSAGES.sortBy(MESSAGES.colClassification());
                }
            });
        }
        if (hasMajor) {
            final UniTimeTableHeader hMajor = new UniTimeTableHeader(MESSAGES.colMajor());
            header.add(hMajor);
            hMajor.addOperation(new UniTimeTableHeader.Operation(){

                public void execute() {
                    EnrollmentTable.this.iEnrollments.sort(hMajor, new Comparator<ClassAssignmentInterface.Enrollment>(){

                        @Override
                        public int compare(ClassAssignmentInterface.Enrollment e1, ClassAssignmentInterface.Enrollment e2) {
                            int cmp = e1.getStudent().getMajor("|").compareTo(e2.getStudent().getMajor("|"));
                            if (cmp != 0) {
                                return cmp;
                            }
                            cmp = e1.getStudent().getAreaClasf("|").compareTo(e2.getStudent().getAreaClasf("|"));
                            if (cmp != 0) {
                                return cmp;
                            }
                            cmp = e1.getStudent().getName().compareTo(e2.getStudent().getName());
                            if (cmp != 0) {
                                return cmp;
                            }
                            return e1.getStudent().getId() < e2.getStudent().getId() ? -1 : 1;
                        }
                    });
                }

                public boolean isApplicable() {
                    return true;
                }

                public boolean hasSeparator() {
                    return false;
                }

                public String getName() {
                    return MESSAGES.sortBy(MESSAGES.colMajor());
                }
            });
        }
        if (hasGroup) {
            final UniTimeTableHeader hGroup = new UniTimeTableHeader(MESSAGES.colGroup());
            header.add(hGroup);
            hGroup.addOperation(new UniTimeTableHeader.Operation(){

                public void execute() {
                    EnrollmentTable.this.iEnrollments.sort(hGroup, new Comparator<ClassAssignmentInterface.Enrollment>(){

                        @Override
                        public int compare(ClassAssignmentInterface.Enrollment e1, ClassAssignmentInterface.Enrollment e2) {
                            int cmp = e1.getStudent().getGroup("|").compareTo(e2.getStudent().getGroup("|"));
                            if (cmp != 0) {
                                return cmp;
                            }
                            cmp = e1.getStudent().getAreaClasf("|").compareTo(e2.getStudent().getAreaClasf("|"));
                            if (cmp != 0) {
                                return cmp;
                            }
                            cmp = e1.getStudent().getName().compareTo(e2.getStudent().getName());
                            if (cmp != 0) {
                                return cmp;
                            }
                            return e1.getStudent().getId() < e2.getStudent().getId() ? -1 : 1;
                        }
                    });
                }

                public boolean isApplicable() {
                    return true;
                }

                public boolean hasSeparator() {
                    return false;
                }

                public String getName() {
                    return MESSAGES.sortBy(MESSAGES.colGroup());
                }
            });
        }
        if (hasAcmd) {
            final UniTimeTableHeader hAccmd = new UniTimeTableHeader(MESSAGES.colAccommodation());
            header.add(hAccmd);
            hAccmd.addOperation(new UniTimeTableHeader.Operation(){

                public void execute() {
                    EnrollmentTable.this.iEnrollments.sort(hAccmd, new Comparator<ClassAssignmentInterface.Enrollment>(){

                        @Override
                        public int compare(ClassAssignmentInterface.Enrollment e1, ClassAssignmentInterface.Enrollment e2) {
                            int cmp = e1.getStudent().getAccommodation("|").compareTo(e2.getStudent().getAccommodation("|"));
                            if (cmp != 0) {
                                return cmp;
                            }
                            cmp = e1.getStudent().getAreaClasf("|").compareTo(e2.getStudent().getAreaClasf("|"));
                            if (cmp != 0) {
                                return cmp;
                            }
                            cmp = e1.getStudent().getName().compareTo(e2.getStudent().getName());
                            if (cmp != 0) {
                                return cmp;
                            }
                            return e1.getStudent().getId() < e2.getStudent().getId() ? -1 : 1;
                        }
                    });
                }

                public boolean isApplicable() {
                    return true;
                }

                public boolean hasSeparator() {
                    return false;
                }

                public String getName() {
                    return MESSAGES.sortBy(MESSAGES.colAccommodation());
                }
            });
        }
        if (hasReservation) {
            final UniTimeTableHeader hReservation = new UniTimeTableHeader(MESSAGES.colReservation());
            hReservation.addOperation(new UniTimeTableHeader.Operation(){

                public void execute() {
                    EnrollmentTable.this.iEnrollments.sort(hReservation, new Comparator<ClassAssignmentInterface.Enrollment>(){

                        @Override
                        public int compare(ClassAssignmentInterface.Enrollment e1, ClassAssignmentInterface.Enrollment e2) {
                            int cmp = (e1.getReservation() == null ? "" : e1.getReservation()).compareTo(e2.getReservation() == null ? "" : e2.getReservation());
                            if (cmp != 0) {
                                return cmp;
                            }
                            cmp = e1.getStudent().getName().compareTo(e2.getStudent().getName());
                            if (cmp != 0) {
                                return cmp;
                            }
                            return e1.getStudent().getId() < e2.getStudent().getId() ? -1 : 1;
                        }
                    });
                }

                public boolean isApplicable() {
                    return true;
                }

                public boolean hasSeparator() {
                    return false;
                }

                public String getName() {
                    return MESSAGES.sortBy(MESSAGES.colReservation());
                }
            });
            header.add(hReservation);
        }
        final TreeSet<String> subparts = new TreeSet<String>();
        for (ClassAssignmentInterface.Enrollment e : enrollments) {
            if (this.filter(f, e) || !e.hasClasses()) continue;
            for (ClassAssignmentInterface.ClassAssignment c : e.getClasses()) {
                subparts.add(c.getSubpart());
            }
        }
        for (final String subpart : subparts) {
            final UniTimeTableHeader hSubpart = new UniTimeTableHeader(subpart);
            final int col = 1 + (hasExtId ? 1 : 0) + (crosslist ? 1 : 0) + (hasPriority ? 1 : 0) + (hasAlternative ? 1 : 0) + (hasArea ? 2 : 0) + (hasMajor ? 1 : 0) + (hasGroup ? 1 : 0) + (hasAcmd ? 1 : 0) + (hasReservation ? 1 : 0);
            hSubpart.addOperation(new UniTimeTableHeader.Operation(){

                public void execute() {
                    SectioningCookie.getInstance().setShowClassNumbers(false);
                    for (int row = 0; row < EnrollmentTable.this.iEnrollments.getRowCount(); ++row) {
                        ClassAssignmentInterface.Enrollment e = (ClassAssignmentInterface.Enrollment)EnrollmentTable.this.iEnrollments.getData(row);
                        if (e == null || !e.hasClasses()) continue;
                        int idx = 0;
                        for (String subpart : subparts) {
                            ((HTML)EnrollmentTable.this.iEnrollments.getWidget(row, col + idx)).setHTML(e.getClasses(subpart, ", ", false));
                            ++idx;
                        }
                    }
                }

                public boolean isApplicable() {
                    return SectioningCookie.getInstance().getShowClassNumbers();
                }

                public boolean hasSeparator() {
                    return false;
                }

                public String getName() {
                    return MESSAGES.showExternalIds();
                }
            });
            hSubpart.addOperation(new UniTimeTableHeader.Operation(){

                public void execute() {
                    SectioningCookie.getInstance().setShowClassNumbers(true);
                    for (int row = 0; row < EnrollmentTable.this.iEnrollments.getRowCount(); ++row) {
                        ClassAssignmentInterface.Enrollment e = (ClassAssignmentInterface.Enrollment)EnrollmentTable.this.iEnrollments.getData(row);
                        if (e == null || !e.hasClasses()) continue;
                        int idx = 0;
                        for (String subpart : subparts) {
                            ((HTML)EnrollmentTable.this.iEnrollments.getWidget(row, col + idx)).setHTML(e.getClasses(subpart, ", ", true));
                            ++idx;
                        }
                    }
                }

                public boolean isApplicable() {
                    return !SectioningCookie.getInstance().getShowClassNumbers();
                }

                public boolean hasSeparator() {
                    return false;
                }

                public String getName() {
                    return MESSAGES.showClassNumbers();
                }
            });
            hSubpart.addOperation(new UniTimeTableHeader.Operation(){

                public void execute() {
                    final boolean showClassNumbers = SectioningCookie.getInstance().getShowClassNumbers();
                    EnrollmentTable.this.iEnrollments.sort(hSubpart, new Comparator<ClassAssignmentInterface.Enrollment>(){

                        @Override
                        public int compare(ClassAssignmentInterface.Enrollment e1, ClassAssignmentInterface.Enrollment e2) {
                            int cmp = e1.getClasses(subpart, "|", showClassNumbers).compareTo(e2.getClasses(subpart, "|", showClassNumbers));
                            if (cmp != 0) {
                                return cmp;
                            }
                            cmp = e1.getStudent().getName().compareTo(e2.getStudent().getName());
                            if (cmp != 0) {
                                return cmp;
                            }
                            return e1.getStudent().getId() < e2.getStudent().getId() ? -1 : 1;
                        }
                    });
                }

                public boolean isApplicable() {
                    return true;
                }

                public boolean hasSeparator() {
                    return true;
                }

                public String getName() {
                    return MESSAGES.sortBy(subpart);
                }
            });
            header.add(hSubpart);
        }
        if (hasRequestedDate) {
            hTimeStamp = new UniTimeTableHeader(MESSAGES.colRequestTimeStamp());
            hTimeStamp.addOperation(new UniTimeTableHeader.Operation(){

                public void execute() {
                    EnrollmentTable.this.iEnrollments.sort(hTimeStamp, new Comparator<ClassAssignmentInterface.Enrollment>(){

                        @Override
                        public int compare(ClassAssignmentInterface.Enrollment e1, ClassAssignmentInterface.Enrollment e2) {
                            int cmp = (e1.getRequestedDate() == null ? new Date(0L) : e1.getRequestedDate()).compareTo(e2.getRequestedDate() == null ? new Date(0L) : e2.getRequestedDate());
                            if (cmp != 0) {
                                return cmp;
                            }
                            cmp = e1.getStudent().getName().compareTo(e2.getStudent().getName());
                            if (cmp != 0) {
                                return cmp;
                            }
                            return e1.getStudent().getId() < e2.getStudent().getId() ? -1 : 1;
                        }
                    });
                }

                public boolean isApplicable() {
                    return true;
                }

                public boolean hasSeparator() {
                    return false;
                }

                public String getName() {
                    return MESSAGES.sortBy(MESSAGES.colRequestTimeStamp());
                }
            });
            header.add(hTimeStamp);
        }
        if (hasEnrolledDate) {
            hTimeStamp = new UniTimeTableHeader(MESSAGES.colEnrollmentTimeStamp());
            hTimeStamp.addOperation(new UniTimeTableHeader.Operation(){

                public void execute() {
                    EnrollmentTable.this.iEnrollments.sort(hTimeStamp, new Comparator<ClassAssignmentInterface.Enrollment>(){

                        @Override
                        public int compare(ClassAssignmentInterface.Enrollment e1, ClassAssignmentInterface.Enrollment e2) {
                            int cmp = (e1.getEnrolledDate() == null ? new Date(0L) : e1.getEnrolledDate()).compareTo(e2.getEnrolledDate() == null ? new Date(0L) : e2.getEnrolledDate());
                            if (cmp != 0) {
                                return cmp;
                            }
                            cmp = e1.getStudent().getName().compareTo(e2.getStudent().getName());
                            if (cmp != 0) {
                                return cmp;
                            }
                            return e1.getStudent().getId() < e2.getStudent().getId() ? -1 : 1;
                        }
                    });
                }

                public boolean isApplicable() {
                    return true;
                }

                public boolean hasSeparator() {
                    return false;
                }

                public String getName() {
                    return MESSAGES.sortBy(MESSAGES.colEnrollmentTimeStamp());
                }
            });
            header.add(hTimeStamp);
        }
        if (hasMessage) {
            final UniTimeTableHeader hMessage = new UniTimeTableHeader(MESSAGES.colMessage());
            hMessage.addOperation(new UniTimeTableHeader.Operation(){

                public void execute() {
                    EnrollmentTable.this.iEnrollments.sort(hMessage, new Comparator<ClassAssignmentInterface.Enrollment>(){

                        @Override
                        public int compare(ClassAssignmentInterface.Enrollment e1, ClassAssignmentInterface.Enrollment e2) {
                            int cmp = (e1.getEnrollmentMessage() == null ? "" : e1.getEnrollmentMessage()).compareTo(e2.getEnrollmentMessage() == null ? "" : e2.getEnrollmentMessage());
                            if (cmp != 0) {
                                return cmp;
                            }
                            cmp = e1.getStudent().getName().compareTo(e2.getStudent().getName());
                            if (cmp != 0) {
                                return cmp;
                            }
                            return e1.getStudent().getId() < e2.getStudent().getId() ? -1 : 1;
                        }
                    });
                }

                public boolean isApplicable() {
                    return true;
                }

                public boolean hasSeparator() {
                    return false;
                }

                public String getName() {
                    return MESSAGES.sortBy(MESSAGES.colMessage());
                }
            });
            header.add(hMessage);
        }
        if (hasConflict) {
            final UniTimeTableHeader hConflictType = new UniTimeTableHeader(MESSAGES.colConflictType());
            hConflictType.addOperation(new UniTimeTableHeader.Operation(){

                public void execute() {
                    EnrollmentTable.this.iEnrollments.sort(hConflictType, new Comparator<ClassAssignmentInterface.Enrollment>(){

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Override
                        public int compare(ClassAssignmentInterface.Enrollment e1, ClassAssignmentInterface.Enrollment e2) {
                            int cmp;
                            if (e1.hasConflict()) {
                                if (!e2.hasConflict()) return -1;
                                Iterator<ClassAssignmentInterface.Conflict> i1 = e1.getConflicts().iterator();
                                Iterator<ClassAssignmentInterface.Conflict> i2 = e2.getConflicts().iterator();
                                while (i1.hasNext() && i2.hasNext()) {
                                    ClassAssignmentInterface.Conflict c1 = i1.next();
                                    ClassAssignmentInterface.Conflict c2 = i2.next();
                                    int cmp2 = c1.getType().compareTo(c2.getType());
                                    if (cmp2 != 0) {
                                        return cmp2;
                                    }
                                    cmp2 = c1.getName().compareTo(c2.getName());
                                    if (cmp2 == 0) continue;
                                    return cmp2;
                                }
                                if (i1.hasNext()) {
                                    return -1;
                                }
                                if (i2.hasNext()) {
                                    return 1;
                                }
                            } else if (e2.hasConflict()) {
                                return 1;
                            }
                            if ((cmp = e1.getStudent().getName().compareTo(e2.getStudent().getName())) != 0) {
                                return cmp;
                            }
                            if (e1.getStudent().getId() >= e2.getStudent().getId()) return 1;
                            return -1;
                        }
                    });
                }

                public boolean isApplicable() {
                    return true;
                }

                public boolean hasSeparator() {
                    return false;
                }

                public String getName() {
                    return MESSAGES.sortBy(MESSAGES.colConflictType());
                }
            });
            header.add(hConflictType);
            final UniTimeTableHeader hConflictName = new UniTimeTableHeader(MESSAGES.colConflictName());
            hConflictName.addOperation(new UniTimeTableHeader.Operation(){

                public void execute() {
                    EnrollmentTable.this.iEnrollments.sort(hConflictName, new Comparator<ClassAssignmentInterface.Enrollment>(){

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Override
                        public int compare(ClassAssignmentInterface.Enrollment e1, ClassAssignmentInterface.Enrollment e2) {
                            int cmp;
                            if (e1.hasConflict()) {
                                if (!e2.hasConflict()) return -1;
                                Iterator<ClassAssignmentInterface.Conflict> i1 = e1.getConflicts().iterator();
                                Iterator<ClassAssignmentInterface.Conflict> i2 = e2.getConflicts().iterator();
                                while (i1.hasNext() && i2.hasNext()) {
                                    ClassAssignmentInterface.Conflict c1 = i1.next();
                                    ClassAssignmentInterface.Conflict c2 = i2.next();
                                    int cmp2 = c1.getName().compareTo(c2.getName());
                                    if (cmp2 == 0) continue;
                                    return cmp2;
                                }
                                if (i1.hasNext()) {
                                    return -1;
                                }
                                if (i2.hasNext()) {
                                    return 1;
                                }
                            } else if (e2.hasConflict()) {
                                return 1;
                            }
                            if ((cmp = e1.getStudent().getName().compareTo(e2.getStudent().getName())) != 0) {
                                return cmp;
                            }
                            if (e1.getStudent().getId() >= e2.getStudent().getId()) return 1;
                            return -1;
                        }
                    });
                }

                public boolean isApplicable() {
                    return true;
                }

                public boolean hasSeparator() {
                    return false;
                }

                public String getName() {
                    return MESSAGES.sortBy(MESSAGES.colConflictName());
                }
            });
            header.add(hConflictName);
            final UniTimeTableHeader hConflictDate = new UniTimeTableHeader(MESSAGES.colConflictDate());
            hConflictDate.addOperation(new UniTimeTableHeader.Operation(){

                public void execute() {
                    EnrollmentTable.this.iEnrollments.sort(hConflictDate, new Comparator<ClassAssignmentInterface.Enrollment>(){

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Override
                        public int compare(ClassAssignmentInterface.Enrollment e1, ClassAssignmentInterface.Enrollment e2) {
                            int cmp;
                            if (e1.hasConflict()) {
                                if (!e2.hasConflict()) return -1;
                                Iterator<ClassAssignmentInterface.Conflict> i1 = e1.getConflicts().iterator();
                                Iterator<ClassAssignmentInterface.Conflict> i2 = e2.getConflicts().iterator();
                                while (i1.hasNext() && i2.hasNext()) {
                                    ClassAssignmentInterface.Conflict c1 = i1.next();
                                    ClassAssignmentInterface.Conflict c2 = i2.next();
                                    int cmp2 = c1.getDate().compareTo(c2.getDate());
                                    if (cmp2 != 0) {
                                        return cmp2;
                                    }
                                    cmp2 = c1.getName().compareTo(c2.getName());
                                    if (cmp2 == 0) continue;
                                    return cmp2;
                                }
                                if (i1.hasNext()) {
                                    return -1;
                                }
                                if (i2.hasNext()) {
                                    return 1;
                                }
                            } else if (e2.hasConflict()) {
                                return 1;
                            }
                            if ((cmp = e1.getStudent().getName().compareTo(e2.getStudent().getName())) != 0) {
                                return cmp;
                            }
                            if (e1.getStudent().getId() >= e2.getStudent().getId()) return 1;
                            return -1;
                        }
                    });
                }

                public boolean isApplicable() {
                    return true;
                }

                public boolean hasSeparator() {
                    return false;
                }

                public String getName() {
                    return MESSAGES.sortBy(MESSAGES.colConflictDate());
                }
            });
            header.add(hConflictDate);
            final UniTimeTableHeader hConflictTime = new UniTimeTableHeader(MESSAGES.colConflictTime());
            hConflictTime.addOperation(new UniTimeTableHeader.Operation(){

                public void execute() {
                    EnrollmentTable.this.iEnrollments.sort(hConflictTime, new Comparator<ClassAssignmentInterface.Enrollment>(){

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Override
                        public int compare(ClassAssignmentInterface.Enrollment e1, ClassAssignmentInterface.Enrollment e2) {
                            int cmp;
                            if (e1.hasConflict()) {
                                if (!e2.hasConflict()) return -1;
                                Iterator<ClassAssignmentInterface.Conflict> i1 = e1.getConflicts().iterator();
                                Iterator<ClassAssignmentInterface.Conflict> i2 = e2.getConflicts().iterator();
                                while (i1.hasNext() && i2.hasNext()) {
                                    ClassAssignmentInterface.Conflict c1 = i1.next();
                                    ClassAssignmentInterface.Conflict c2 = i2.next();
                                    int cmp2 = c1.getTime().compareTo(c2.getTime());
                                    if (cmp2 != 0) {
                                        return cmp2;
                                    }
                                    cmp2 = c1.getName().compareTo(c2.getName());
                                    if (cmp2 == 0) continue;
                                    return cmp2;
                                }
                                if (i1.hasNext()) {
                                    return -1;
                                }
                                if (i2.hasNext()) {
                                    return 1;
                                }
                            } else if (e2.hasConflict()) {
                                return 1;
                            }
                            if ((cmp = e1.getStudent().getName().compareTo(e2.getStudent().getName())) != 0) {
                                return cmp;
                            }
                            if (e1.getStudent().getId() >= e2.getStudent().getId()) return 1;
                            return -1;
                        }
                    });
                }

                public boolean isApplicable() {
                    return true;
                }

                public boolean hasSeparator() {
                    return false;
                }

                public String getName() {
                    return MESSAGES.sortBy(MESSAGES.colConflictTime());
                }
            });
            header.add(hConflictTime);
            final UniTimeTableHeader uniTimeTableHeader = new UniTimeTableHeader(MESSAGES.colConflictRoom());
            uniTimeTableHeader.addOperation(new UniTimeTableHeader.Operation(){

                public void execute() {
                    EnrollmentTable.this.iEnrollments.sort(uniTimeTableHeader, new Comparator<ClassAssignmentInterface.Enrollment>(){

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Override
                        public int compare(ClassAssignmentInterface.Enrollment e1, ClassAssignmentInterface.Enrollment e2) {
                            int cmp;
                            if (e1.hasConflict()) {
                                if (!e2.hasConflict()) return -1;
                                Iterator<ClassAssignmentInterface.Conflict> i1 = e1.getConflicts().iterator();
                                Iterator<ClassAssignmentInterface.Conflict> i2 = e2.getConflicts().iterator();
                                while (i1.hasNext() && i2.hasNext()) {
                                    ClassAssignmentInterface.Conflict c1 = i1.next();
                                    ClassAssignmentInterface.Conflict c2 = i2.next();
                                    int cmp2 = c1.getRoom().compareTo(c2.getRoom());
                                    if (cmp2 != 0) {
                                        return cmp2;
                                    }
                                    cmp2 = c1.getName().compareTo(c2.getName());
                                    if (cmp2 == 0) continue;
                                    return cmp2;
                                }
                                if (i1.hasNext()) {
                                    return -1;
                                }
                                if (i2.hasNext()) {
                                    return 1;
                                }
                            } else if (e2.hasConflict()) {
                                return 1;
                            }
                            if ((cmp = e1.getStudent().getName().compareTo(e2.getStudent().getName())) != 0) {
                                return cmp;
                            }
                            if (e1.getStudent().getId() >= e2.getStudent().getId()) return 1;
                            return -1;
                        }
                    });
                }

                public boolean isApplicable() {
                    return true;
                }

                public boolean hasSeparator() {
                    return false;
                }

                public String getName() {
                    return MESSAGES.sortBy(MESSAGES.colConflictRoom());
                }
            });
            header.add(uniTimeTableHeader);
        }
        if (courseIdsCanApprove != null && !courseIdsCanApprove.isEmpty()) {
            final UniTimeTableHeader hApproved = new UniTimeTableHeader(MESSAGES.colApproved());
            hApproved.addOperation(new UniTimeTableHeader.Operation(){

                public void execute() {
                    for (int row = 0; row < EnrollmentTable.this.iEnrollments.getRowCount(); ++row) {
                        Widget w = EnrollmentTable.this.iEnrollments.getWidget(row, EnrollmentTable.this.iEnrollments.getCellCount(row) - 1);
                        if (!(w instanceof CheckBox)) continue;
                        ((CheckBox)w).setValue(Boolean.valueOf(true));
                    }
                    EnrollmentTable.this.iHeader.setEnabled("approve", EnrollmentTable.this.iApprove != null && EnrollmentTable.this.iApprove.isApplicable());
                    EnrollmentTable.this.iHeader.setEnabled("reject", EnrollmentTable.this.iReject != null && EnrollmentTable.this.iReject.isApplicable());
                }

                public boolean isApplicable() {
                    for (int row = 0; row < EnrollmentTable.this.iEnrollments.getRowCount(); ++row) {
                        Widget w = EnrollmentTable.this.iEnrollments.getWidget(row, EnrollmentTable.this.iEnrollments.getCellCount(row) - 1);
                        if (!(w instanceof CheckBox) || ((CheckBox)w).getValue().booleanValue()) continue;
                        return true;
                    }
                    return false;
                }

                public boolean hasSeparator() {
                    return false;
                }

                public String getName() {
                    return MESSAGES.selectAll();
                }
            });
            hApproved.addOperation(new UniTimeTableHeader.Operation(){

                public void execute() {
                    for (int row = 0; row < EnrollmentTable.this.iEnrollments.getRowCount(); ++row) {
                        Widget w = EnrollmentTable.this.iEnrollments.getWidget(row, EnrollmentTable.this.iEnrollments.getCellCount(row) - 1);
                        if (!(w instanceof CheckBox)) continue;
                        ((CheckBox)w).setValue(Boolean.valueOf(false));
                    }
                    EnrollmentTable.this.iHeader.setEnabled("approve", EnrollmentTable.this.iApprove != null && EnrollmentTable.this.iApprove.isApplicable());
                    EnrollmentTable.this.iHeader.setEnabled("reject", EnrollmentTable.this.iReject != null && EnrollmentTable.this.iReject.isApplicable());
                }

                public boolean isApplicable() {
                    for (int row = 0; row < EnrollmentTable.this.iEnrollments.getRowCount(); ++row) {
                        Widget w = EnrollmentTable.this.iEnrollments.getWidget(row, EnrollmentTable.this.iEnrollments.getCellCount(row) - 1);
                        if (!(w instanceof CheckBox) || !((CheckBox)w).getValue().booleanValue()) continue;
                        return true;
                    }
                    return false;
                }

                public boolean hasSeparator() {
                    return false;
                }

                public String getName() {
                    return MESSAGES.clearAll();
                }
            });
            this.iApprove = new UniTimeTableHeader.Operation(){

                public void execute() {
                    ArrayList<Long> studentIds = new ArrayList<Long>();
                    for (int row = 0; row < EnrollmentTable.this.iEnrollments.getRowCount(); ++row) {
                        Widget w = EnrollmentTable.this.iEnrollments.getWidget(row, EnrollmentTable.this.iEnrollments.getCellCount(row) - 1);
                        if (!(w instanceof CheckBox) || !((CheckBox)w).getValue().booleanValue()) continue;
                        studentIds.add(((ClassAssignmentInterface.Enrollment)EnrollmentTable.this.iEnrollments.getData(row)).getStudent().getId());
                    }
                    EnrollmentTable.this.iHeader.showLoading();
                    EnrollmentTable.this.iSectioningService.approveEnrollments(EnrollmentTable.this.iOfferingId, studentIds, new AsyncCallback<String>(){

                        public void onSuccess(String result) {
                            EnrollmentTable.this.iHeader.clearMessage();
                            String[] approval = result.split(":");
                            for (int row = 0; row < EnrollmentTable.this.iEnrollments.getRowCount(); ++row) {
                                Widget w = EnrollmentTable.this.iEnrollments.getWidget(row, EnrollmentTable.this.iEnrollments.getCellCount(row) - 1);
                                if (!(w instanceof CheckBox) || !((CheckBox)w).getValue().booleanValue()) continue;
                                EnrollmentTable.this.iEnrollments.replaceWidget(row, EnrollmentTable.this.iEnrollments.getCellCount(row) - 1, (Widget)new HTML(MESSAGES.approval(sDF.format(new Date(Long.valueOf(approval[0]))), approval[2]), false));
                            }
                            EnrollmentTable.this.iHeader.setEnabled("approve", EnrollmentTable.this.iApprove != null && EnrollmentTable.this.iApprove.isApplicable());
                            EnrollmentTable.this.iHeader.setEnabled("reject", EnrollmentTable.this.iReject != null && EnrollmentTable.this.iReject.isApplicable());
                        }

                        public void onFailure(Throwable caught) {
                            EnrollmentTable.this.iHeader.setErrorMessage(MESSAGES.failedToApproveEnrollments(caught.getMessage()));
                        }
                    });
                }

                public boolean isApplicable() {
                    for (int row = 0; row < EnrollmentTable.this.iEnrollments.getRowCount(); ++row) {
                        Widget w = EnrollmentTable.this.iEnrollments.getWidget(row, EnrollmentTable.this.iEnrollments.getCellCount(row) - 1);
                        if (!(w instanceof CheckBox) || !((CheckBox)w).getValue().booleanValue()) continue;
                        return true;
                    }
                    return false;
                }

                public boolean hasSeparator() {
                    return true;
                }

                public String getName() {
                    return MESSAGES.approveSelectedEnrollments();
                }
            };
            hApproved.addOperation(this.iApprove);
            this.iReject = new UniTimeTableHeader.Operation(){

                public void execute() {
                    ArrayList<Long> studentIds = new ArrayList<Long>();
                    for (int row = 0; row < EnrollmentTable.this.iEnrollments.getRowCount(); ++row) {
                        Widget w = EnrollmentTable.this.iEnrollments.getWidget(row, EnrollmentTable.this.iEnrollments.getCellCount(row) - 1);
                        if (!(w instanceof CheckBox) || !((CheckBox)w).getValue().booleanValue()) continue;
                        studentIds.add(((ClassAssignmentInterface.Enrollment)EnrollmentTable.this.iEnrollments.getData(row)).getStudent().getId());
                    }
                    EnrollmentTable.this.iHeader.showLoading();
                    EnrollmentTable.this.iSectioningService.rejectEnrollments(EnrollmentTable.this.iOfferingId, studentIds, new AsyncCallback<Boolean>(){

                        public void onSuccess(Boolean result) {
                            EnrollmentTable.this.iHeader.clearMessage();
                            int row = 0;
                            while (row < EnrollmentTable.this.iEnrollments.getRowCount()) {
                                Widget w = EnrollmentTable.this.iEnrollments.getWidget(row, EnrollmentTable.this.iEnrollments.getCellCount(row) - 1);
                                if (w instanceof CheckBox && ((CheckBox)w).getValue().booleanValue()) {
                                    EnrollmentTable.this.iEnrollments.removeRow(row);
                                    continue;
                                }
                                ++row;
                            }
                            EnrollmentTable.this.iHeader.setEnabled("approve", EnrollmentTable.this.iApprove != null && EnrollmentTable.this.iApprove.isApplicable());
                            EnrollmentTable.this.iHeader.setEnabled("reject", EnrollmentTable.this.iReject != null && EnrollmentTable.this.iReject.isApplicable());
                        }

                        public void onFailure(Throwable caught) {
                            EnrollmentTable.this.iHeader.setErrorMessage(MESSAGES.failedToApproveEnrollments(caught.getMessage()));
                        }
                    });
                }

                public boolean isApplicable() {
                    for (int row = 0; row < EnrollmentTable.this.iEnrollments.getRowCount(); ++row) {
                        Widget w = EnrollmentTable.this.iEnrollments.getWidget(row, EnrollmentTable.this.iEnrollments.getCellCount(row) - 1);
                        if (!(w instanceof CheckBox) || !((CheckBox)w).getValue().booleanValue()) continue;
                        return true;
                    }
                    return false;
                }

                public boolean hasSeparator() {
                    return false;
                }

                public String getName() {
                    return MESSAGES.rejectSelectedEnrollments();
                }
            };
            hApproved.addOperation(this.iReject);
            hApproved.addOperation(new UniTimeTableHeader.Operation(){

                public void execute() {
                    EnrollmentTable.this.iEnrollments.sort(hApproved, new Comparator<ClassAssignmentInterface.Enrollment>(){

                        @Override
                        public int compare(ClassAssignmentInterface.Enrollment e1, ClassAssignmentInterface.Enrollment e2) {
                            int cmp = new Long(e1.getApprovedDate() == null ? 0L : e1.getApprovedDate().getTime()).compareTo(e2.getApprovedDate() == null ? 0L : e2.getApprovedDate().getTime());
                            if (cmp != 0) {
                                return cmp;
                            }
                            cmp = e1.getStudent().getName().compareTo(e2.getStudent().getName());
                            if (cmp != 0) {
                                return cmp;
                            }
                            return e1.getStudent().getId() < e2.getStudent().getId() ? -1 : 1;
                        }
                    });
                }

                public boolean isApplicable() {
                    return true;
                }

                public boolean hasSeparator() {
                    return true;
                }

                public String getName() {
                    return MESSAGES.sortBy(MESSAGES.colApproved());
                }
            });
            header.add(hApproved);
        } else {
            this.iApprove = null;
            this.iReject = null;
        }
        this.iEnrollments.addRow(null, header);
        boolean suffix = SectioningCookie.getInstance().getShowClassNumbers();
        for (ClassAssignmentInterface.Enrollment enrollment : enrollments) {
            if (this.filter(f, enrollment)) continue;
            ArrayList<Object> line = new ArrayList<Object>();
            if (hasExtId) {
                line.add(new Label(enrollment.getStudent().isCanShowExternalId() ? enrollment.getStudent().getExternalId() : "", false));
            }
            line.add(new Label(enrollment.getStudent().getName(), false));
            if (crosslist) {
                line.add(new Label(enrollment.getCourseName(), false));
            }
            if (hasPriority) {
                line.add(new Number(enrollment.getPriority() <= 0 ? "&nbsp;" : MESSAGES.priority(enrollment.getPriority())));
            }
            if (hasAlternative) {
                line.add(new Label(enrollment.getAlternative(), false));
            }
            if (hasArea) {
                line.add(new HTML(enrollment.getStudent().getArea("<br>"), false));
                line.add(new HTML(enrollment.getStudent().getClassification("<br>"), false));
            }
            if (hasMajor) {
                line.add(new HTML(enrollment.getStudent().getMajor("<br>"), false));
            }
            if (hasGroup) {
                line.add(new HTML(enrollment.getStudent().getGroup("<br>"), false));
            }
            if (hasAcmd) {
                line.add(new HTML(enrollment.getStudent().getAccommodation("<br>"), false));
            }
            if (hasReservation) {
                line.add(new HTML(enrollment.getReservation() == null ? "&nbsp;" : enrollment.getReservation(), false));
            }
            if (!subparts.isEmpty()) {
                if (!enrollment.hasClasses()) {
                    line.add(new WarningLabel(enrollment.isWaitList() ? MESSAGES.courseWaitListed() : MESSAGES.courseNotEnrolled(), subparts.size()));
                } else {
                    for (String subpart : subparts) {
                        line.add(new HTML(enrollment.getClasses(subpart, ", ", suffix), false));
                    }
                }
            }
            if (hasRequestedDate) {
                line.add(new HTML(enrollment.getRequestedDate() == null ? "&nbsp;" : sDF.format(enrollment.getRequestedDate()), false));
            }
            if (hasEnrolledDate) {
                line.add(new HTML(enrollment.getEnrolledDate() == null ? "&nbsp;" : sDF.format(enrollment.getEnrolledDate()), false));
            }
            if (hasMessage) {
                line.add(new HTML(enrollment.hasEnrollmentMessage() ? enrollment.getEnrollmentMessage().replace("\n", "<br>") : "&nbsp;", true));
            }
            if (hasConflict) {
                if (enrollment.hasConflict()) {
                    void var31_63;
                    void var29_47;
                    String string = "";
                    String type = "";
                    String string2 = "";
                    String time = "";
                    String room = "";
                    for (ClassAssignmentInterface.Conflict conflict : enrollment.getConflicts()) {
                        void var31_68;
                        void var29_51;
                        if (!var29_47.isEmpty()) {
                            String string3 = (String)var29_47 + "<br>";
                            type = type + "<br>";
                            String string4 = (String)var31_63 + "<br>";
                            time = time + "<br>";
                            room = room + "<br>";
                        }
                        if (conflict.hasStyle()) {
                            void var31_66;
                            void var29_49;
                            String string5 = (String)var29_49 + "<span class='" + conflict.getStyle() + "'>";
                            type = type + "<span class='" + conflict.getStyle() + "'>";
                            String string6 = (String)var31_66 + "<span class='" + conflict.getStyle() + "'>";
                            time = time + "<span class='" + conflict.getStyle() + "'>";
                            room = room + "<span class='" + conflict.getStyle() + "'>";
                        }
                        String string7 = (String)var29_51 + conflict.getName();
                        type = type + conflict.getType();
                        String string8 = (String)var31_68 + conflict.getDate();
                        time = time + conflict.getTime();
                        room = room + conflict.getRoom();
                        if (!conflict.hasStyle()) continue;
                        String string9 = string7 + "</span>";
                        type = type + "</span>";
                        String string10 = string8 + "</span>";
                        time = time + "</span>";
                        room = room + "</span>";
                    }
                    HTML html = new HTML(type, false);
                    html.addStyleName("conflict");
                    line.add(html);
                    html = new HTML((String)var29_47, false);
                    html.addStyleName("conflict");
                    line.add(html);
                    html = new HTML((String)var31_63, false);
                    html.addStyleName("conflict");
                    line.add(html);
                    html = new HTML(time, false);
                    html.addStyleName("conflict");
                    line.add(html);
                    html = new HTML(room, false);
                    html.addStyleName("conflict");
                    line.add(html);
                } else {
                    line.add(new HTML("&nbsp;", false));
                    line.add(new HTML("&nbsp;", false));
                    line.add(new HTML("&nbsp;", false));
                    line.add(new HTML("&nbsp;", false));
                    line.add(new HTML("&nbsp;", false));
                }
            }
            if (courseIdsCanApprove != null && !courseIdsCanApprove.isEmpty()) {
                if (!enrollment.hasClasses()) {
                    line.add(new HTML("&nbsp;"));
                } else if (!courseIdsCanApprove.contains(enrollment.getCourseId())) {
                    line.add(new HTML("&nbsp;"));
                } else if (enrollment.getApprovedDate() == null) {
                    CheckBox checkBox = new CheckBox();
                    checkBox.addClickHandler(new ClickHandler(){

                        public void onClick(ClickEvent event) {
                            event.stopPropagation();
                            EnrollmentTable.this.iHeader.setEnabled("approve", EnrollmentTable.this.iApprove != null && EnrollmentTable.this.iApprove.isApplicable());
                            EnrollmentTable.this.iHeader.setEnabled("reject", EnrollmentTable.this.iReject != null && EnrollmentTable.this.iReject.isApplicable());
                        }
                    });
                    line.add(checkBox);
                } else {
                    line.add(new HTML(MESSAGES.approval(sDF.format(enrollment.getApprovedDate()), enrollment.getApprovedBy()), false));
                }
            }
            this.iEnrollments.addRow(enrollment, line);
            this.iEnrollments.getRowFormatter().setVerticalAlign(this.iEnrollments.getRowCount() - 1, HasVerticalAlignment.ALIGN_TOP);
        }
        ArrayList<UniTimeTable.HasStyleName> footer = new ArrayList<UniTimeTable.HasStyleName>();
        if (enrolled > 0) {
            footer.add(new TotalLabel(MESSAGES.totalEnrolled(enrolled), header.size()));
        }
        if (waitlisted > 0) {
            footer.add(new TotalLabel(MESSAGES.totalWaitListed(waitlisted), header.size()));
        }
        if (unassigned > 0) {
            footer.add(new TotalLabel(MESSAGES.totalNotEnrolled(unassigned + waitlisted), header.size()));
        }
        if (showFilter) {
            void var29_57;
            FilterRow filter = new FilterRow(header.size());
            filter.add((Widget)new Label(MESSAGES.filter()));
            final ListBox box = new ListBox();
            boolean bl2 = false;
            while (var29_57 < SectioningCookie.EnrollmentFilter.values().length) {
                SectioningCookie.EnrollmentFilter x = SectioningCookie.EnrollmentFilter.values()[var29_57];
                box.addItem(CONSTANTS.enrollmentFilterValues()[var29_57], x.name());
                ++var29_57;
            }
            box.setSelectedIndex(f.ordinal());
            box.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    EnrollmentTable.this.iHeader.setCollapsible(true);
                    SectioningCookie.getInstance().setEnrollmentCoursesDetails(true);
                    SectioningCookie.getInstance().setEnrollmentFilter(SectioningCookie.EnrollmentFilter.valueOf(box.getValue(box.getSelectedIndex())));
                    EnrollmentTable.this.clear();
                    EnrollmentTable.this.populate(enrollments, courseIdsCanApprove);
                }
            });
            filter.add((Widget)box);
            footer.add(filter);
            if (this.iEnrollments.getRowCount() == 1) {
                if (f == SectioningCookie.EnrollmentFilter.ALL) {
                    this.iEnrollments.addRow(null, new Widget[]{new EmptyLabel(MESSAGES.offeringHasNoEnrollments(), Math.max(header.size(), footer.size()))});
                } else {
                    this.iEnrollments.addRow(null, new Widget[]{new EmptyLabel(MESSAGES.offeringHasNoEnrollmentsOfType(CONSTANTS.enrollmentFilterValues()[f.ordinal()]), Math.max(header.size(), footer.size()))});
                }
            }
        }
        if (!footer.isEmpty()) {
            if (footer.size() > 1) {
                int span = Math.max(1, header.size() / footer.size());
                for (Widget widget : footer) {
                    ((SetColSpan)widget).setColSpan(span);
                }
                ((SetColSpan)footer.get(footer.size() - 1)).setColSpan(Math.max(1, header.size() - (footer.size() - 1) * span));
            }
            int row = this.iEnrollments.addRow(null, footer);
            if (showFilter) {
                this.iEnrollments.getCellFormatter().setHorizontalAlignment(row, footer.size() - 1, HasHorizontalAlignment.ALIGN_RIGHT);
            }
        }
        if (showFilter) {
            for (int i = 0; i < SectioningCookie.EnrollmentFilter.values().length; ++i) {
                final SectioningCookie.EnrollmentFilter x = SectioningCookie.EnrollmentFilter.values()[i];
                UniTimeTableHeader.Operation operation = new UniTimeTableHeader.Operation(){

                    public void execute() {
                        SectioningCookie.getInstance().setEnrollmentFilter(x);
                        EnrollmentTable.this.clear();
                        EnrollmentTable.this.populate(enrollments, courseIdsCanApprove);
                    }

                    public boolean isApplicable() {
                        return true;
                    }

                    public boolean hasSeparator() {
                        return x.ordinal() == 0;
                    }

                    public String getName() {
                        return MESSAGES.enrollmentTableFilter(CONSTANTS.enrollmentFilterValues()[x.ordinal()]);
                    }
                };
                for (UniTimeTableHeader uniTimeTableHeader : header) {
                    uniTimeTableHeader.addOperation(operation);
                }
            }
        }
    }

    public void insert(RootPanel panel) {
        this.iOfferingId = Long.valueOf(panel.getElement().getInnerText());
        if (this.iOfferingId >= 0L && this.iShowFilter) {
            this.iHeader.setHeaderTitle(MESSAGES.studentsTable());
        }
        if (SectioningCookie.getInstance().getEnrollmentCoursesDetails()) {
            this.refresh();
        } else {
            this.clear();
            this.iHeader.clearMessage();
            this.iHeader.setCollapsible(false);
        }
        panel.getElement().setInnerText(null);
        panel.add((Widget)this);
        panel.setVisible(true);
    }

    public void setId(Long id) {
        this.iOfferingId = id;
    }

    public Long getId() {
        return this.iOfferingId;
    }

    public void scrollIntoView(Long studentId) {
        for (int r = 1; r < this.iEnrollments.getRowCount(); ++r) {
            if (this.iEnrollments.getData(r) == null || this.iEnrollments.getData(r).getStudent().getId() != studentId.longValue()) continue;
            this.iEnrollments.getRowFormatter().getElement(r).scrollIntoView();
        }
    }

    public void select(Long studentId) {
        for (int i = 0; i < this.iEnrollments.getRowCount(); ++i) {
            ClassAssignmentInterface.Enrollment e = this.iEnrollments.getData(i);
            if (e == null) continue;
            if (e.getStudent().getId() == studentId.longValue()) {
                this.iEnrollments.getRowFormatter().setStyleName(i, "unitime-TableRowSelected");
                continue;
            }
            if (!"unitime-TableRowSelected".equals(this.iEnrollments.getRowFormatter().getStyleName(i))) continue;
            this.iEnrollments.getRowFormatter().removeStyleName(i, "unitime-TableRowSelected");
        }
    }

    public static class TopCell
    extends Label
    implements UniTimeTable.HasVerticalCellAlignment {
        TopCell(String cell) {
            super(cell);
        }

        public HasVerticalAlignment.VerticalAlignmentConstant getVerticalCellAlignment() {
            return HasVerticalAlignment.ALIGN_TOP;
        }
    }

    public static interface ReservationClickHandler {
        public void onClick(ReservationClickedEvent var1);
    }

    public static class ReservationClickedEvent {
        private ReservationInterface iReservation;

        public ReservationClickedEvent(ReservationInterface reservation) {
            this.iReservation = reservation;
        }

        public ReservationInterface getReservation() {
            return this.iReservation;
        }
    }

    private static class FilterRow
    extends HorizontalPanel
    implements SetColSpan,
    UniTimeTable.HasStyleName {
        private int iColSpan;

        public FilterRow(int colspan) {
            this.iColSpan = colspan;
        }

        public void setColSpan(int colSpan) {
            this.iColSpan = colSpan;
        }

        public int getColSpan() {
            return this.iColSpan;
        }

        public String getStyleName() {
            return "unitime-TotalRow";
        }
    }

    private static class EmptyLabel
    extends HTML
    implements SetColSpan,
    UniTimeTable.HasStyleName {
        private int iColSpan;

        public EmptyLabel(String text, int colspan) {
            super(text, false);
            this.iColSpan = colspan;
        }

        public void setColSpan(int colSpan) {
            this.iColSpan = colSpan;
        }

        public int getColSpan() {
            return this.iColSpan;
        }

        public String getStyleName() {
            return "text-gray";
        }
    }

    private static class WarningLabel
    extends HTML
    implements SetColSpan,
    UniTimeTable.HasStyleName {
        private int iColSpan;

        public WarningLabel(String text, int colspan) {
            super(text, false);
            this.iColSpan = colspan;
        }

        public void setColSpan(int colSpan) {
            this.iColSpan = colSpan;
        }

        public int getColSpan() {
            return this.iColSpan;
        }

        public String getStyleName() {
            return "text-red";
        }
    }

    private static class TotalLabel
    extends HTML
    implements SetColSpan,
    UniTimeTable.HasStyleName {
        private int iColSpan;

        public TotalLabel(String text, int colspan) {
            super(text, false);
            this.iColSpan = colspan;
        }

        public int getColSpan() {
            return this.iColSpan;
        }

        public void setColSpan(int colSpan) {
            this.iColSpan = colSpan;
        }

        public String getStyleName() {
            return "unitime-TotalRow";
        }
    }

    private static interface SetColSpan
    extends UniTimeTable.HasColSpan {
        public void setColSpan(int var1);
    }

    private static class Number
    extends HTML
    implements UniTimeTable.HasCellAlignment {
        public Number(String text) {
            super(text, false);
        }

        public HasHorizontalAlignment.HorizontalAlignmentConstant getCellAlignment() {
            return HasHorizontalAlignment.ALIGN_RIGHT;
        }
    }
}

