/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.page;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import org.unitime.timetable.gwt.client.page.InfoPanel;
import org.unitime.timetable.gwt.client.page.InfoPanelDisplay;
import org.unitime.timetable.gwt.client.page.PageHeader;
import org.unitime.timetable.gwt.client.page.PageHeaderDisplay;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.MenuInterface;

public class UniTimePageHeader
implements PageHeaderDisplay {
    protected static final GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private PageHeader iHeader = new PageHeader();
    private static UniTimePageHeader sInstance = null;

    private UniTimePageHeader() {
        this.getLeft().setCallback(new InfoPanelDisplay.Callback(){

            public void execute(InfoPanelDisplay.Callback callback) {
                UniTimePageHeader.this.reloadSolverInfo(true, callback);
            }
        });
        this.reloadSessionInfo();
        this.reloadUserInfo();
        this.reloadSolverInfo(false, null);
    }

    public void insert(RootPanel panel) {
        if (panel.getWidgetCount() > 0) {
            return;
        }
        panel.add((Widget)this.iHeader);
        panel.setVisible(true);
    }

    public static synchronized UniTimePageHeader getInstance() {
        if (sInstance == null) {
            sInstance = new UniTimePageHeader();
        }
        return sInstance;
    }

    public void reloadSessionInfo() {
        if (this.getRight().isPreventDefault()) {
            return;
        }
        RPC.execute(new MenuInterface.SessionInfoRpcRequest(), new AsyncCallback<MenuInterface.SessionInfoInterface>(){

            public void onSuccess(MenuInterface.SessionInfoInterface result) {
                if (UniTimePageHeader.this.getRight().isPreventDefault()) {
                    return;
                }
                if (result == null || result.getSession() == null) {
                    UniTimePageHeader.this.getRight().setVisible(false);
                } else {
                    UniTimePageHeader.this.getRight().setText(result.getSession());
                    UniTimePageHeader.this.getRight().setInfo(result);
                    UniTimePageHeader.this.getRight().setHint(MESSAGES.hintClickToChangeSession());
                    UniTimePageHeader.this.getRight().setUrl("selectPrimaryRole.do?list=Y");
                    UniTimePageHeader.this.getRight().setVisible(true);
                }
            }

            public void onFailure(Throwable caught) {
                if (UniTimePageHeader.this.getRight().isPreventDefault()) {
                    return;
                }
                UniTimePageHeader.this.getRight().setVisible(false);
            }
        });
    }

    public void reloadUserInfo() {
        if (this.getMiddle().isPreventDefault()) {
            return;
        }
        RPC.execute(new MenuInterface.UserInfoRpcRequest(), new AsyncCallback<MenuInterface.UserInfoInterface>(){

            public void onSuccess(MenuInterface.UserInfoInterface result) {
                if (UniTimePageHeader.this.getMiddle().isPreventDefault()) {
                    return;
                }
                if (result == null || result.getName() == null) {
                    UniTimePageHeader.this.getMiddle().setVisible(false);
                } else {
                    UniTimePageHeader.this.getMiddle().setText(result.getName());
                    UniTimePageHeader.this.getMiddle().setHint(result.getRole());
                    UniTimePageHeader.this.getMiddle().setInfo(result);
                    if (result.isChameleon()) {
                        UniTimePageHeader.this.getMiddle().setUrl("chameleon.do");
                    } else {
                        UniTimePageHeader.this.getMiddle().setUrl("selectPrimaryRole.do?list=Y");
                    }
                    UniTimePageHeader.this.getMiddle().setVisible(true);
                }
            }

            public void onFailure(Throwable caught) {
                if (UniTimePageHeader.this.getMiddle().isPreventDefault()) {
                    return;
                }
                UniTimePageHeader.this.getMiddle().setVisible(false);
            }
        });
    }

    public void reloadSolverInfo(boolean includeSolutionInfo, final InfoPanelDisplay.Callback callback) {
        if (this.getLeft().isPreventDefault()) {
            return;
        }
        RPC.execute(new MenuInterface.SolverInfoRpcRequest(includeSolutionInfo), new AsyncCallback<MenuInterface.SolverInfoInterface>(){

            public void onSuccess(MenuInterface.SolverInfoInterface result) {
                if (UniTimePageHeader.this.getLeft().isPreventDefault()) {
                    return;
                }
                try {
                    if (result != null && result.getSolver() != null) {
                        UniTimePageHeader.this.getLeft().setText(result.getSolver());
                        UniTimePageHeader.this.getLeft().setHint(result.getType());
                        UniTimePageHeader.this.getLeft().setInfo(result);
                        UniTimePageHeader.this.getLeft().setUrl(result.getUrl());
                        UniTimePageHeader.this.getLeft().setVisible(true);
                    } else {
                        UniTimePageHeader.this.getLeft().setVisible(false);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                Timer t = new Timer(){

                    public void run() {
                        UniTimePageHeader.this.reloadSolverInfo(UniTimePageHeader.this.getLeft().isPopupShowing(), null);
                    }
                };
                t.schedule(result != null ? 1000 : 60000);
                if (callback != null) {
                    callback.execute(null);
                }
            }

            public void onFailure(Throwable caught) {
                if (UniTimePageHeader.this.getLeft().isPreventDefault()) {
                    return;
                }
                Timer t = new Timer(){

                    public void run() {
                        UniTimePageHeader.this.reloadSolverInfo(UniTimePageHeader.this.getLeft().isPopupShowing(), null);
                    }
                };
                t.schedule(5000);
                if (callback != null) {
                    callback.execute(null);
                }
            }
        });
    }

    public InfoPanel getLeft() {
        return this.iHeader.getLeft();
    }

    public InfoPanel getMiddle() {
        return this.iHeader.getMiddle();
    }

    public InfoPanel getRight() {
        return this.iHeader.getRight();
    }

    public Widget asWidget() {
        return this.iHeader;
    }
}

