/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.Element;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;
import org.unitime.timetable.gwt.client.Client;

public class GwtHint
extends PopupPanel {
    private static GwtHint sInstance;

    public GwtHint(String html) {
        this.setStyleName("unitime-PopupHint");
    }

    public static GwtHint getInstance() {
        if (sInstance == null) {
            sInstance = new GwtHint("");
            Client.addGwtPageChangedHandler(new Client.GwtPageChangedHandler(){

                public void onChange(Client.GwtPageChangeEvent event) {
                    GwtHint.hideHint();
                }
            });
        }
        return sInstance;
    }

    public static native void createTriggers();

    public static void _showHint(JavaScriptObject source, String content) {
        GwtHint.showHint((Element)source.cast(), content);
    }

    public static void showHint(Element relativeObject, String content) {
        GwtHint.showHint(relativeObject, (Widget)new HTML(content, false));
    }

    public static void showHint(Element relativeObject, Widget content) {
        GwtHint.showHint(relativeObject, content, true);
    }

    public static void showHint(final Element relativeObject, Widget content, final boolean showRelativeToTheObject) {
        GwtHint.getInstance().setWidget(content);
        GwtHint.getInstance().setPopupPositionAndShow(new PopupPanel.PositionCallback(){

            public void setPosition(int offsetWidth, int offsetHeight) {
                if (relativeObject != null && showRelativeToTheObject) {
                    int left;
                    int textBoxOffsetWidth = relativeObject.getOffsetWidth();
                    int offsetWidthDiff = offsetWidth - textBoxOffsetWidth;
                    if (LocaleInfo.getCurrentLocale().isRTL()) {
                        int textBoxAbsoluteLeft = relativeObject.getAbsoluteLeft();
                        left = textBoxAbsoluteLeft - offsetWidthDiff;
                        if (offsetWidthDiff > 0) {
                            int windowRight = Window.getClientWidth() + Window.getScrollLeft();
                            int windowLeft = Window.getScrollLeft();
                            int textBoxLeftValForRightEdge = textBoxAbsoluteLeft + textBoxOffsetWidth;
                            int distanceToWindowRight = windowRight - textBoxLeftValForRightEdge;
                            int distanceFromWindowLeft = textBoxLeftValForRightEdge - windowLeft;
                            if (distanceFromWindowLeft < offsetWidth && distanceToWindowRight >= offsetWidthDiff) {
                                left = textBoxAbsoluteLeft;
                            }
                        }
                    } else {
                        left = relativeObject.getAbsoluteLeft();
                        if (offsetWidthDiff > 0) {
                            int windowRight = Window.getClientWidth() + Window.getScrollLeft();
                            int windowLeft = Window.getScrollLeft();
                            int distanceToWindowRight = windowRight - left;
                            int distanceFromWindowLeft = left - windowLeft;
                            if (distanceToWindowRight < offsetWidth && distanceFromWindowLeft >= offsetWidthDiff) {
                                left -= offsetWidthDiff;
                            }
                        }
                    }
                    int top = relativeObject.getAbsoluteTop();
                    int windowTop = Window.getScrollTop();
                    int windowBottom = Window.getScrollTop() + Window.getClientHeight();
                    int distanceFromWindowTop = top - windowTop;
                    int distanceToWindowBottom = windowBottom - (top + relativeObject.getOffsetHeight());
                    top = distanceToWindowBottom < offsetHeight && distanceFromWindowTop >= offsetHeight ? (top -= offsetHeight) : (top += relativeObject.getOffsetHeight());
                    GwtHint.getInstance().setPopupPosition(left, top);
                } else {
                    int left = Window.getScrollLeft() + 10;
                    int top = Window.getScrollTop() + Window.getClientHeight() - offsetHeight - 10;
                    if (relativeObject != null && left + offsetWidth >= relativeObject.getAbsoluteLeft() && top <= relativeObject.getAbsoluteBottom()) {
                        left = Window.getScrollLeft() + Window.getClientWidth() - offsetWidth - 10;
                    }
                    GwtHint.getInstance().setPopupPosition(left, top);
                }
            }
        });
    }

    public static void hideHint() {
        GwtHint.getInstance().hide();
    }
}

