/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.unitime.timetable.form.PreferencesForm;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamOwner;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.comparators.InstrOfferingConfigComparator;
import org.unitime.timetable.model.comparators.SchedulingSubpartComparator;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.model.dao.InstrOfferingConfigDAO;
import org.unitime.timetable.model.dao.SchedulingSubpartDAO;
import org.unitime.timetable.security.context.HttpSessionContext;
import org.unitime.timetable.util.DynamicList;
import org.unitime.timetable.util.DynamicListObjectFactory;
import org.unitime.timetable.util.IdValue;

public class ExamEditForm
extends PreferencesForm {
    private static final long serialVersionUID = -5083087578026654516L;
    private String examId;
    private String label;
    private String name;
    private String note;
    private Integer maxNbrRooms;
    private Integer length;
    private String size;
    private String sizeNote;
    private String seatingType;
    private String printOffset;
    private List instructors;
    private List subjectArea;
    private List courseNbr;
    private List itype;
    private List classNumber;
    private Collection subjectAreas;
    private Long examType;
    private String avgPeriod;
    private boolean clone;
    private String accommodation;
    protected DynamicListObjectFactory factory = new DynamicListObjectFactory(){

        public Object create() {
            return new String("-");
        }
    };
    protected DynamicListObjectFactory idfactory = new DynamicListObjectFactory(){

        public Object create() {
            return new Long(-1L);
        }
    };

    public String getExamId() {
        return this.examId;
    }

    public void setExamId(String examId) {
        this.examId = examId;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public Integer getMaxNbrRooms() {
        return this.maxNbrRooms;
    }

    public void setMaxNbrRooms(Integer maxNbrRooms) {
        this.maxNbrRooms = maxNbrRooms;
    }

    public Integer getLength() {
        return this.length;
    }

    public void setLength(Integer length) {
        this.length = length;
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public String getSizeNote() {
        return this.sizeNote;
    }

    public void setSizeNote(String sizeNote) {
        this.sizeNote = sizeNote;
    }

    public String getPrintOffset() {
        return this.printOffset;
    }

    public void setPrintOffset(String printOffset) {
        this.printOffset = printOffset;
    }

    public String getSeatingType() {
        return this.seatingType;
    }

    public void setSeatingType(String seatingType) {
        this.seatingType = seatingType;
    }

    public String[] getSeatingTypes() {
        return Exam.sSeatingTypes;
    }

    public int getSeatingTypeIdx() {
        for (int i = 0; i < Exam.sSeatingTypes.length; ++i) {
            if (!Exam.sSeatingTypes[i].equals(this.seatingType)) continue;
            return i;
        }
        return 1;
    }

    public String[] getObjectTypes() {
        return ExamOwner.sOwnerTypes;
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        TreeSet<ExamType> types;
        this.examId = null;
        this.name = null;
        this.note = null;
        this.maxNbrRooms = 1;
        this.length = null;
        this.size = null;
        this.sizeNote = null;
        this.printOffset = null;
        this.avgPeriod = null;
        this.seatingType = Exam.sSeatingTypes[1];
        this.instructors = DynamicList.getInstance(new ArrayList(), this.factory);
        this.subjectArea = DynamicList.getInstance(new ArrayList(), this.idfactory);
        this.courseNbr = DynamicList.getInstance(new ArrayList(), this.idfactory);
        this.itype = DynamicList.getInstance(new ArrayList(), this.idfactory);
        this.classNumber = DynamicList.getInstance(new ArrayList(), this.idfactory);
        this.examType = null;
        if (request.getSession().getAttribute("Exam.Type") != null) {
            this.examType = (Long)request.getSession().getAttribute("Exam.Type");
        }
        if (this.examType == null && !(types = ExamType.findAllUsed(HttpSessionContext.getSessionContext(request.getSession().getServletContext()).getUser().getCurrentAcademicSessionId())).isEmpty()) {
            this.examType = types.first().getUniqueId();
        }
        this.clone = false;
        this.accommodation = null;
        super.reset(mapping, request);
    }

    public List getInstructors() {
        return this.instructors;
    }

    public String getInstructors(int key) {
        return this.instructors.get(key).toString();
    }

    public void setInstructors(int key, Object value) {
        this.instructors.set(key, value);
    }

    public void setInstructors(List instructors) {
        this.instructors = instructors;
    }

    public List getSubjectAreaList() {
        return this.subjectArea;
    }

    public List getSubjectArea() {
        return this.subjectArea;
    }

    public Long getSubjectArea(int key) {
        try {
            return (Long)this.subjectArea.get(key);
        }
        catch (ClassCastException e) {
            return Long.valueOf(this.subjectArea.get(key).toString());
        }
    }

    public void setSubjectArea(int key, Long value) {
        this.subjectArea.set(key, value);
    }

    public void setSubjectArea(List subjectArea) {
        this.subjectArea = subjectArea;
    }

    public List getCourseNbr() {
        return this.courseNbr;
    }

    public Long getCourseNbr(int key) {
        try {
            return (Long)this.courseNbr.get(key);
        }
        catch (ClassCastException e) {
            return Long.valueOf(this.courseNbr.get(key).toString());
        }
    }

    public void setCourseNbr(int key, Long value) {
        this.courseNbr.set(key, value);
    }

    public void setCourseNbr(List courseNbr) {
        this.courseNbr = courseNbr;
    }

    public List getItype() {
        return this.itype;
    }

    public Long getItype(int key) {
        try {
            return (Long)this.itype.get(key);
        }
        catch (ClassCastException e) {
            return Long.valueOf(this.itype.get(key).toString());
        }
    }

    public void setItype(int key, Long value) {
        this.itype.set(key, value);
    }

    public void setItype(List itype) {
        this.itype = itype;
    }

    public List getClassNumber() {
        return this.classNumber;
    }

    public Long getClassNumber(int key) {
        try {
            return (Long)this.classNumber.get(key);
        }
        catch (ClassCastException e) {
            return Long.valueOf(this.classNumber.get(key).toString());
        }
    }

    public void setClassNumber(int key, Long value) {
        this.classNumber.set(key, value);
    }

    public void setClassNumber(List classNumber) {
        this.classNumber = classNumber;
    }

    public void deleteExamOwner(int idx) {
        this.getSubjectArea().remove(idx);
        this.getCourseNbr().remove(idx);
        this.getItype().remove(idx);
        this.getClassNumber().remove(idx);
    }

    public void addExamOwner(ExamOwner owner) {
        if (owner == null) {
            this.getSubjectArea().add(new Long(-1L));
            this.getCourseNbr().add(new Long(-1L));
            this.getItype().add(new Long(-1L));
            this.getClassNumber().add(new Long(-1L));
        } else {
            switch (owner.getOwnerType()) {
                case 3: {
                    Class_ clazz = (Class_)owner.getOwnerObject();
                    this.getSubjectArea().add(clazz.getSchedulingSubpart().getControllingCourseOffering().getSubjectArea().getUniqueId());
                    this.getCourseNbr().add(clazz.getSchedulingSubpart().getControllingCourseOffering().getUniqueId());
                    this.getItype().add(clazz.getSchedulingSubpart().getUniqueId());
                    this.getClassNumber().add(clazz.getUniqueId());
                    break;
                }
                case 2: {
                    InstrOfferingConfig config = (InstrOfferingConfig)owner.getOwnerObject();
                    this.getSubjectArea().add(config.getControllingCourseOffering().getSubjectArea().getUniqueId());
                    this.getCourseNbr().add(config.getControllingCourseOffering().getUniqueId());
                    this.getItype().add(-config.getUniqueId().longValue());
                    this.getClassNumber().add(new Long(-1L));
                    break;
                }
                case 1: {
                    CourseOffering course = (CourseOffering)owner.getOwnerObject();
                    this.getSubjectArea().add(course.getSubjectArea().getUniqueId());
                    this.getCourseNbr().add(course.getUniqueId());
                    this.getItype().add(Long.MIN_VALUE);
                    this.getClassNumber().add(new Long(-1L));
                    break;
                }
                case 0: {
                    InstructionalOffering offering = (InstructionalOffering)owner.getOwnerObject();
                    this.getSubjectArea().add(offering.getControllingCourseOffering().getSubjectArea().getUniqueId());
                    this.getCourseNbr().add(offering.getControllingCourseOffering().getUniqueId());
                    this.getItype().add(-9223372036854775807L);
                    this.getClassNumber().add(new Long(-1L));
                }
            }
        }
    }

    public Collection getSubjectAreas() {
        return this.subjectAreas;
    }

    public void setSubjectAreas(Collection subjectAreas) {
        this.subjectAreas = subjectAreas;
    }

    public Collection getCourseNbrs(int idx) {
        Vector<IdValue> ret = new Vector<IdValue>();
        boolean contains = false;
        if (this.getSubjectArea(idx) >= 0L) {
            Iterator i = new CourseOfferingDAO().getSession().createQuery("select co.uniqueId, co.courseNbr, co.title from CourseOffering co where co.subjectArea.uniqueId = :subjectAreaId and co.instructionalOffering.notOffered = false order by co.courseNbr ").setFetchSize(200).setCacheable(true).setLong("subjectAreaId", this.getSubjectArea(idx).longValue()).iterate();
            while (i.hasNext()) {
                Object[] o = (Object[])i.next();
                ret.add(new IdValue((Long)o[0], (String)o[1] + " - " + (String)o[2]));
                if (!o[0].equals(this.getCourseNbr(idx))) continue;
                contains = true;
            }
        }
        if (!contains) {
            this.setCourseNbr(idx, -1L);
        }
        if (ret.size() == 1) {
            this.setCourseNbr(idx, ((IdValue)ret.firstElement()).getId());
        } else {
            ret.insertElementAt(new IdValue(-1L, "-"), 0);
        }
        return ret;
    }

    public Collection getItypes(int idx) {
        Vector<IdValue> ret = new Vector<IdValue>();
        boolean contains = false;
        if (this.getCourseNbr(idx) >= 0L) {
            CourseOffering course = (CourseOffering)new CourseOfferingDAO().get(this.getCourseNbr(idx));
            if (course.isIsControl().booleanValue()) {
                ret.add(new IdValue(-9223372036854775807L, "Offering"));
            }
            ret.add(new IdValue(Long.MIN_VALUE, "Course"));
            if (!course.isIsControl().booleanValue()) {
                this.setItype(idx, Long.MIN_VALUE);
                return ret;
            }
            TreeSet configs = new TreeSet(new InstrOfferingConfigComparator(null));
            configs.addAll(new InstrOfferingConfigDAO().getSession().createQuery("select distinct c from InstrOfferingConfig c inner join c.instructionalOffering.courseOfferings co where co.uniqueId = :courseOfferingId").setFetchSize(200).setCacheable(true).setLong("courseOfferingId", course.getUniqueId().longValue()).list());
            if (!configs.isEmpty()) {
                ret.add(new IdValue(-9223372036854775806L, "-- Configurations --"));
                for (InstrOfferingConfig c : configs) {
                    if (c.getUniqueId().equals(this.getItype(idx))) {
                        contains = true;
                    }
                    ret.add(new IdValue(-c.getUniqueId().longValue(), c.getName()));
                }
            }
            TreeSet subparts = new TreeSet(new SchedulingSubpartComparator(null));
            subparts.addAll(new SchedulingSubpartDAO().getSession().createQuery("select distinct s from SchedulingSubpart s inner join s.instrOfferingConfig.instructionalOffering.courseOfferings co where co.uniqueId = :courseOfferingId").setFetchSize(200).setCacheable(true).setLong("courseOfferingId", course.getUniqueId().longValue()).list());
            if (!configs.isEmpty() && !subparts.isEmpty()) {
                ret.add(new IdValue(-9223372036854775806L, "-- Subparts --"));
            }
            for (SchedulingSubpart s : subparts) {
                Long sid = s.getUniqueId();
                String name = s.getItype().getAbbv();
                String sufix = s.getSchedulingSubpartSuffix();
                while (s.getParentSubpart() != null) {
                    name = "&nbsp;&nbsp;&nbsp;&nbsp;" + name;
                    s = s.getParentSubpart();
                }
                if (s.getInstrOfferingConfig().getInstructionalOffering().getInstrOfferingConfigs().size() > 1) {
                    name = name + " [" + s.getInstrOfferingConfig().getName() + "]";
                }
                if (sid.equals(this.getItype(idx))) {
                    contains = true;
                }
                ret.add(new IdValue(sid, name + (sufix == null || sufix.length() == 0 ? "" : " (" + sufix + ")")));
            }
        } else {
            ret.addElement(new IdValue(0L, "N/A"));
        }
        if (!contains) {
            this.setItype(idx, ((IdValue)ret.firstElement()).getId());
        }
        return ret;
    }

    public ExamOwner getExamOwner(int idx) {
        if (this.getSubjectArea(idx) < 0L || this.getCourseNbr(idx) < 0L) {
            return null;
        }
        CourseOffering course = (CourseOffering)new CourseOfferingDAO().get(this.getCourseNbr(idx));
        if (course == null) {
            return null;
        }
        if (this.getItype(idx) == Long.MIN_VALUE) {
            ExamOwner owner = new ExamOwner();
            owner.setOwner(course);
            return owner;
        }
        if (this.getItype(idx) == -9223372036854775807L || this.getItype(idx) == -9223372036854775806L) {
            ExamOwner owner = new ExamOwner();
            owner.setOwner(course.getInstructionalOffering());
            return owner;
        }
        if (this.getItype(idx) < 0L) {
            InstrOfferingConfig config = (InstrOfferingConfig)new InstrOfferingConfigDAO().get(-this.getItype(idx).longValue());
            if (config == null) {
                return null;
            }
            ExamOwner owner = new ExamOwner();
            owner.setOwner(config);
            return owner;
        }
        if (this.getClassNumber(idx) >= 0L) {
            Class_ clazz = (Class_)new Class_DAO().get(this.getClassNumber(idx));
            if (clazz == null) {
                return null;
            }
            ExamOwner owner = new ExamOwner();
            owner.setOwner(clazz);
            return owner;
        }
        return null;
    }

    public void setExamOwners(Exam exam) {
        if (exam.getOwners() == null) {
            exam.setOwners(new HashSet<ExamOwner>());
        }
        exam.getOwners().clear();
        for (int idx = 0; idx < this.getSubjectAreaList().size(); ++idx) {
            ExamOwner owner = this.getExamOwner(idx);
            if (owner == null) continue;
            exam.getOwners().add(owner);
            owner.setExam(exam);
        }
    }

    public Collection getClassNumbers(int idx) {
        CourseOffering co;
        Vector<IdValue> ret = new Vector<IdValue>();
        boolean contains = false;
        SchedulingSubpart subpart = this.getItype(idx) > 0L ? (SchedulingSubpart)new SchedulingSubpartDAO().get(this.getItype(idx)) : null;
        CourseOffering courseOffering = co = this.getItype(idx) > 0L ? (CourseOffering)new CourseOfferingDAO().get(this.getCourseNbr(idx)) : null;
        if (subpart != null) {
            TreeSet<Class_> classes = new TreeSet<Class_>(new ClassComparator(5));
            classes.addAll(new Class_DAO().getSession().createQuery("select distinct c from Class_ c where c.schedulingSubpart.uniqueId=:schedulingSubpartId").setFetchSize(200).setCacheable(true).setLong("schedulingSubpartId", this.getItype(idx).longValue()).list());
            for (Class_ c : classes) {
                if (c.getUniqueId().equals(this.getClassNumber(idx))) {
                    contains = true;
                }
                String extId = c.getClassSuffix(co);
                ret.add(new IdValue(c.getUniqueId(), c.getSectionNumberString() + (extId == null || extId.isEmpty() || extId.equalsIgnoreCase(c.getSectionNumberString()) ? "" : " - " + extId)));
            }
        }
        if (ret.isEmpty()) {
            ret.add(new IdValue(-1L, "N/A"));
        }
        if (!contains) {
            this.setClassNumber(idx, -1L);
        }
        if (ret.size() == 1) {
            this.setClassNumber(idx, ((IdValue)ret.firstElement()).getId());
        } else {
            ret.insertElementAt(new IdValue(-1L, "-"), 0);
        }
        return ret;
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        if (this.maxNbrRooms != null && this.maxNbrRooms < 0) {
            errors.add("maxNbrRooms", new ActionMessage("errors.integerGtEq", (Object)"Maximal Number of Rooms", (Object)"0"));
        }
        if (this.length == null || this.length < 0) {
            errors.add("length", new ActionMessage("errors.integerGtEq", (Object)"Length", (Object)"0"));
        }
        if (this.size != null && this.size.length() > 0) {
            try {
                Integer.parseInt(this.size);
            }
            catch (NumberFormatException e) {
                errors.add("size", new ActionMessage("errors.numeric", (Object)"Size"));
            }
        }
        if (this.printOffset != null && this.printOffset.length() > 0) {
            try {
                Integer.parseInt(this.printOffset);
            }
            catch (NumberFormatException e) {
                errors.add("printOffset", new ActionMessage("errors.numeric", (Object)"Print Offset"));
            }
        }
        if (this.note != null && this.note.length() > 999) {
            errors.add("note", new ActionMessage("errors.maxlength", (Object)"Note", (Object)"999"));
        }
        if (this.instructors.size() > 0) {
            super.checkPrefs(this.instructors);
        }
        boolean hasOwner = false;
        for (int idx = 0; idx < this.getSubjectAreaList().size(); ++idx) {
            ExamOwner owner = this.getExamOwner(idx);
            if (owner == null) continue;
            hasOwner = true;
            break;
        }
        if (!hasOwner) {
            errors.add("owners", new ActionMessage("errors.generic", (Object)"At least one class/course has to be specified."));
        }
        errors.add((ActionMessages)super.validate(mapping, request));
        return errors;
    }

    public void addBlankPrefRows() {
        super.addBlankPrefRows();
    }

    public Long getExamType() {
        return this.examType;
    }

    public void setExamType(Long examType) {
        this.examType = examType;
    }

    public String getAvgPeriod() {
        return this.avgPeriod;
    }

    public void setAvgPeriod(String avgPeriod) {
        this.avgPeriod = avgPeriod;
    }

    public String getEmail(String instructorId) {
        DepartmentalInstructor instructor = (DepartmentalInstructor)new DepartmentalInstructorDAO().get(Long.valueOf(instructorId));
        return instructor.getEmail() == null ? "" : instructor.getEmail();
    }

    public boolean getClone() {
        return this.clone;
    }

    public void setClone(boolean clone) {
        this.clone = clone;
    }

    public String getAccommodation() {
        return this.accommodation;
    }

    public void setAccommodation(String accommodation) {
        this.accommodation = accommodation;
    }
}

