/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.filter;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Date;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.unitime.timetable.filter.QueryLogFilter;

public class NoCacheFilter
implements Filter {
    private Pattern iUserAgent = null;

    public void init(FilterConfig cfg) throws ServletException {
        this.iUserAgent = Pattern.compile(cfg.getInitParameter("user-agent"));
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        String agent;
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse && (agent = ((HttpServletRequest)request).getHeader("user-agent")) != null && this.iUserAgent.matcher(agent).find()) {
            response = new HttpServletResponseWrapper((HttpServletResponse)response).createResponse();
        }
        chain.doFilter(request, response);
    }

    private static class HttpServletResponseWrapper
    implements InvocationHandler {
        private HttpServletResponse iResponse;

        public HttpServletResponseWrapper(HttpServletResponse r) {
            this.iResponse = r;
        }

        public HttpServletResponse createResponse() {
            return (HttpServletResponse)Proxy.newProxyInstance(QueryLogFilter.class.getClassLoader(), new Class[]{HttpServletResponse.class}, (InvocationHandler)this);
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("sendRedirect".equals(method.getName())) {
                String location = (String)args[0];
                String hash = null;
                int hashIdx = location.lastIndexOf(35);
                if (hashIdx >= 0) {
                    hash = location.substring(hashIdx);
                    location = location.substring(0, hashIdx);
                }
                String redirect = location + (location.indexOf(63) >= 0 ? "&" : "?") + "noCacheTS=" + new Date().getTime() + (hash == null ? "" : hash);
                this.iResponse.setHeader("Pragma", "no-cache");
                this.iResponse.addHeader("Cache-Control", "must-revalidate");
                this.iResponse.addHeader("Cache-Control", "no-cache");
                this.iResponse.addHeader("Cache-Control", "no-store");
                this.iResponse.setDateHeader("Expires", 0L);
                this.iResponse.sendRedirect(redirect);
                return null;
            }
            return this.iResponse.getClass().getMethod(method.getName(), method.getParameterTypes()).invoke((Object)this.iResponse, args);
        }
    }
}

