/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.defaults;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unitime.timetable.ApplicationProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ApplicationProperty {
    DatabaseDialect("dialect"),
    ConnectionUrl("connection.url"),
    ConnectionUser("connection.username"),
    ConnectionPassword("connection.password"),
    ConnectionDriver("connection.driver_class"),
    ConnectionLogging("connection.logging"),
    DatabaseSchema("default_schema"),
    DatabaseUniqueIdGenerator("tmtbl.uniqueid.generator"),
    DatabaseVersion("tmtbl.db.version"),
    DatabaseUpdateFile("tmtbl.db.update"),
    Locale("unitime.locale"),
    DataDir("unitime.data.dir"),
    CustomProperties("tmtbl.custom.properties"),
    LoginPage("tmtbl.login_url"),
    LoginMethod("tmtbl.login_method"),
    LoginPageHeader("tmtbl.header.external"),
    LoginPageFooter("tmtbl.footer.external"),
    SystemMessage("tmtbl.system_message"),
    GlobalWarningMessage("tmtbl.global.warn"),
    DisclaimerMessage("tmtbl.page.disclaimer"),
    CustomStyleSheet("tmtbl.custom.css"),
    MenuStyle("unitime.menu.style"),
    LoginFailedLockout("tmtbl.login.failed.lockout.minutes"),
    LoginMaxFailedAttempts("tmtbl.login.max.failed.attempts"),
    LoginFailedAttemptDelay("tmtbl.login.failed.delay.milliseconds"),
    AccessLevel("tmtbl.access_level"),
    ApplicationPropertiesDynamicReload("tmtbl.properties.dynamic_reload"),
    ApplicationPropertiesDynamicReloadInterval("tmtbl.properties.dynamic_reload_interval"),
    PasswordReset("unitime.password.reset"),
    RegistrationPopupObtrusiveness("unitime.registration.obtrusiveness"),
    UrlEncoderSecret("unitime.encode.secret"),
    AuthenticationModules("tmtbl.authenticate.modules"),
    AuthenticationLdapUrl("unitime.authentication.ldap.url"),
    AuthenticationLdapAuthenticate("unitime.authentication.ldap.user-dn-pattern"),
    AuthenticationLdapAuthorize("unitime.authentication.ldap.group-search-base"),
    AuthenitcationLdapFilter("unitime.authentication.ldap.group-search-filter"),
    AuthorizationLdapUpCase("unitime.authentication.ldap.group-convert-to-uppercase"),
    AuthenticationLdapIdentify("unitime.authentication.ldap.identify"),
    AuthenticationLdapIdAttribute("unitime.authentication.ldap.group-role-attribute"),
    AuthenticationLdapLogin2UserId("unitime.authentication.ldap.uid2ext"),
    AuthenticationLdapUserId2Login("unitime.authentication.ldap.ext2uid"),
    MenuFile("unitime.menu"),
    CustomMenuFile("unitime.menu.custom"),
    PageHelpEnabled("tmtbl.wiki.help"),
    PageHelpUrl("tmtbl.wiki.url"),
    PageWarning("tmtbl.page.warn.%"),
    PageInfo("tmtbl.page.info.%"),
    UniTimeUrl("unitime.url"),
    MaxUploadSize("unitime.upload.max_size_in_bytes"),
    KeepLastUsedAcademicSession("tmtbl.keeplastused.session"),
    DistanceEllipsoid("unitime.distance.ellipsoid"),
    EventDistanceSpeed("tmtbl.events.distanceSpeed"),
    EventNearByDistance("tmtbl.events.nearByDistance"),
    RoomDefaultBreakTime("unitime.events.breakTime.%"),
    SolverLocalEnabled("tmtbl.solver.local.enabled"),
    SolverMemoryLimit("tmtbl.solver.mem_limit"),
    SolverLogLevel("unitime.solver.log.level.%"),
    RoomAreaUnitsFormat("unitime.room.area.units.format"),
    ClassAssignmentChangePastMeetings("tmtbl.classAssign.changePastMeetings"),
    ClassAssignmentIgnorePastMeetings("tmtbl.classAssign.ignorePastMeetings"),
    ClassAssignmentShowStudentConflicts("tmtbl.classAssign.showStudentConflicts"),
    ClassAssignmentAllowUnassignments("tmtbl.classAssign.allowUnassignment"),
    ClassSetupShowExternalIds("tmtbl.class_setup.show_display_external_ids"),
    ClassSetupEditExternalIds("tmtbl.class_setup.edit_external_ids"),
    ClassSetupDisplayInstructorFlags("tmtbl.class_setup.show_display_instructor_flags"),
    ClassSetupEnabledForStudentScheduling("tmtbl.class_setup.show_enabled_for_student_scheduling"),
    CourseOfferingNumberMustBeUnique("tmtbl.courseNumber.unique"),
    CourseOfferingNumberUpperCase("tmtbl.courseNumber.upperCase"),
    CourseOfferingNumberPattern("tmtbl.courseNumber.pattern"),
    CourseOfferingNumberPatternInfo("tmtbl.courseNumber.patternInfo"),
    NonUniversityLocationPattern("tmtbl.nonUniversityLocation.pattern"),
    NonUniversityLocationPatternInfo("tmtbl.nonUniversityLocation.patternInfo"),
    DataExchangeTrimLeadingZerosFromExternalIds("tmtbl.data.exchange.trim.externalId"),
    DataExchangeIncludeDefaultDatePattern("tmtbl.export.defaultDatePattern"),
    DataExchangeXmlManager("unitime.xml.manager"),
    DataExchangeUpdateStudentConflictsFinal("tmtbl.data.import.studentEnrl.finalExam.updateConflicts"),
    DataExchangeUpdateStudentConflictsMidterm("tmtbl.data.import.studentEnrl.midtermExam.updateConflicts"),
    TimePatternEditableDuringInitialDataLoad("tmtbl.time_pattern.initial_data_load.editable"),
    BuildingsExternalUpdateExistingRooms("unitime.external.room.update.existing"),
    BuildingsExternalUpdateExistingRoomFeatures("unitime.external.room.update.existing.features"),
    BuildingsExternalUpdateExistingRoomDepartments("unitime.external.room.update.existing.departments"),
    BuildingsExternalUpdateClassification("unitime.external.room.update.classifications"),
    RoomSharingMode("unitime.room.sharingMode%"),
    OnlineSchedulingCheckDeadlines("unitime.enrollment.deadline"),
    OnlineSchedulingStudentNameFormat("unitime.enrollment.student.name"),
    OnlineSchedulingInstructorNameFormat("unitime.enrollment.instructor.name"),
    OnlineSchedulingSaveRequests("unitime.enrollment.requests.save"),
    OnlineSchedulingEmailConfirmation("unitime.enrollment.email"),
    OnlineSchedulingAllowOverExpected("unitime.sectioning.allowOverExpected"),
    OnlineSchedulingLoggingEnabled("unitime.sectioning.log"),
    OnlineSchedulingLogLimit("unitime.sectioning.log.limit"),
    OnlineSchedulingLogFile("unitime.sectioning.log.file"),
    OnlineSchedulingParameter("unitime.sectioning.config.%"),
    RoomAvailabilityImplementation("tmtbl.room.availability.class"),
    RoomAvailabilityClassBreakTimeStart("tmtbl.room.availability.class.breakTime.start"),
    RoomAvailabilityClassBreakTimeStop("tmtbl.room.availability.class.breakTime.stop"),
    RoomAvailabilityMidtermExamType("tmtbl.room.availability.eventType.midtermExam"),
    RoomAvailabilityFinalExamType("tmtbl.room.availability.eventType.finalExam"),
    RoomAvailabilityClassType("tmtbl.room.availability.eventType.class"),
    BlobRoomAvailabilityRequestSQL("tmtbl.room.availability.request"),
    BlobRoomAvailabilityResponseSQL("tmtbl.room.availability.response"),
    RoomAvailabilityIncludeInstructors("unitime.events.instructorUnavailability"),
    RoomAvailabilitySolverWaitForSync("tmtbl.room.availability.solver.waitForSync"),
    ClassNamingHelper("tmtbl.class.naming.helper"),
    ClassesMessage("tmtbl.classes.message"),
    ExamsMessage("tmtbl.exams.message"),
    MakeNotOfferedStaysOnDetail("unitime.offering.makeNotOfferedStaysOnDetail"),
    ConfigEditCheckLimits("unitime.instrOfferingConfig.checkConfigLimit"),
    SubpartCreditEditable("tmtbl.subpart.credit.editable"),
    InstructorExternalIdLookup("tmtbl.instructor.external_id.lookup.enabled"),
    InstructorExternalIdLookupClass("tmtbl.instructor.external_id.lookup.class"),
    ManagerExternalIdLookup("tmtbl.manager.external_id.lookup.enabled"),
    ManagerExternalIdLookupClass("tmtbl.manager.external_id.lookup.class"),
    ExternalActionClassEdit("tmtbl.external.class.edit_action.class"),
    ExternalActionInstrOfferingConfigAssignInstructors("tmtbl.external.instr_offr_config.assign_instructors_action.class"),
    ExternalActionCourseOfferingEdit("tmtbl.external.course_offering.edit_action.class"),
    ExternalActionInstructionalOfferingAdd("tmtbl.external.instr_offr.add_action.class"),
    ExternalActionCourseOfferingRemove("tmtbl.external.course_offering.remove_action.class"),
    ExternalActionInstructionalOfferingInCrosslistAdd("tmtbl.external.instr_offr_in_crosslist.add_action.class"),
    ExternalActionCourseCrosslist("tmtbl.external.instr_offr.crosslist_action.class"),
    ExternalActionInstrOffrConfigChange("tmtbl.external.instr_offr_config.change_action.class"),
    ExternalActionInstructionalOfferingDelete("tmtbl.external.instr_offr.delete_action.class"),
    ExternalActionInstructionalOfferingNotOffered("tmtbl.external.instr_offr.not_offered_action.class"),
    ExternalActionInstructionalOfferingOffered("tmtbl.external.instr_offr.offered_action.class"),
    ExternalActionSolutionCommit("tmtbl.external.solution.commit_action.class"),
    ExternalActionSchedulingSubpartEdit("tmtbl.external.sched_subpart.edit_action.class"),
    ExternalActionCourseOfferingReservationEdit("tmtbl.external.reservation.edit_action.class"),
    ExternalUserIdTranslation("tmtbl.externalUid.translation"),
    CustomSQLUidToExternalTranslation("unitime.custom.sql.uid2ext"),
    CustomSQLExternalToUidTranslation("unitime.custom.sql.ext2uid"),
    DatabaseUpdateAddonClass("tmtbl.db.addon.update.class"),
    ExaminationReportsClassSufix("tmtbl.exam.report.suffix"),
    ExaminationsNoRoomText("tmtbl.exam.report.noroom"),
    ExaminationRoomCode("tmtbl.exam.report.roomcode"),
    ExaminationReportsExternalId("tmtbl.exam.report.external"),
    ExaminationReportsExternalIdName("tmtbl.exam.report.external.name"),
    ExaminationReportsShowInstructionalType("tmtbl.exam.report.itype"),
    ExaminationReportsStudentBackToBacks("tmtbl.exams.reports.student.btb"),
    ExaminationReportsInstructorBackToBacks("tmtbl.exams.reports.instructor.btb"),
    ExaminationPdfReportsCanUseSolution("tmtbl.exam.pdfReports.canUseSolution"),
    ExaminationPdfReportsPreloadCrosslistedExams("tmtbl.exam.pdfReports.useSolution.preloadCrosslistedExams"),
    ExaminationPdfReportsSkipSuffixSubpart("tmtbl.exam.report.verification.skipSuffixSubparts"),
    ExaminationPdfReportTitle("tmtbl.exam.report.%"),
    ExaminationPdfReportsIncludeClassSchedule("tmtbl.exam.report.cschedule"),
    ExaminationPdfReportsFullTermCheckDatePattern("tmtbl.exam.report.fullterm.checkdp"),
    ExaminationPdfReportsUseEventsForMeetingTimes("tmtbl.exam.report.meeting_time.use_events"),
    ExaminationPeriodDefaultStartOffset("tmtbl.exam.defaultStartOffset.%"),
    ExaminationPeriodDefaultStopOffset("tmtbl.exam.defaultStopOffset.%"),
    ExaminationCacheConflicts("tmtbl.exams.conflicts.cache"),
    ExaminationTravelTimeClass("tmtbl.exam.eventConflicts.travelTime.classEvent"),
    ExaminationTravelTimeCourse("tmtbl.exam.eventConflicts.travelTime.courseEvent"),
    ExaminationSizeUseLimitInsteadOfEnrollment("tmtbl.exam.useLimit.%"),
    ExaminationConsiderEventConflicts("tmtbl.exam.eventConflicts.%"),
    ExaminationCreateSameRoomConstraints("tmtbl.exam.sameRoom.%"),
    ExaminationNameExpandCrossListedOfferingsToCourses("tmtbl.exam.name.expandCrosslistedOfferingToCourses"),
    ExamNameMaxLength("tmtbl.exam.name.maxLength"),
    ExamNameType("tmtbl.exam.name.type.%"),
    ExamNameSuffix("tmtbl.exam.name.suffix"),
    ExamNameSeparator("tmtbl.exam.name.diffSubject.separator"),
    ExamNameCourse("tmtbl.exam.name.Course"),
    ExamNameOffering("tmtbl.exam.name.Offering"),
    ExamNameConfig("tmtbl.exam.name.Config"),
    ExamNameClass("tmtbl.exam.name.Class"),
    ExamNameSameSubjectCourse("tmtbl.exam.name.sameSubject.Course"),
    ExamNameSameSubjectOffering("tmtbl.exam.name.sameSubject.Offering"),
    ExamNameSameSubjectConfig("tmtbl.exam.name.sameSubject.Config"),
    ExamNameSameSubjectClass("tmtbl.exam.name.sameSubject.Class"),
    ExamNameSameCourseConfig("tmtbl.exam.name.sameCourse.Config"),
    ExamNameSameCourseClass("tmtbl.exam.name.sameCourse.Class"),
    ExamNameSameSubpartClass("tmtbl.exam.name.sameSubpart.Class"),
    ExamDefaultsEveningClassPreference("tmtbl.exam.defaultPrefs.%.eveningClasses.pref"),
    ExamDefaultsEveningClassStart("tmtbl.exam.defaultPrefs.%.eveningClasses.firstEveningPeriod"),
    ExamDefaultsOriginalRoomPreference("tmtbl.exam.defaultPrefs.%.originalRoom.pref"),
    ExamDefaultsOriginalBuildingPreference("tmtbl.exam.defaultPrefs.%.originalBuilding.pref"),
    ExamDefaultsOriginalBuildingOnlyForExamRooms("tmtbl.exam.defaultPrefs.%.originalBuilding.onlyForExaminationRooms"),
    CustomizationCourseDetails("unitime.custom.CourseDetailsProvider"),
    CustomizationCourseLink("unitime.custom.CourseUrlProvider"),
    CustomizationStudentEnrollments("unitime.custom.StudentEnrollmentProvider"),
    CustomizationExternalTerm("unitime.custom.ExternalTermProvider"),
    CourseCatalogLinkProvider("tmtbl.catalogLink.lookup.class"),
    CustomizationSectionUrl("unitime.custom.SectionUrlProvider"),
    CustomizationSectionLimit("unitime.custom.SectionLimitProvider"),
    CurriculumConvertNamesToInitialCase("tmtbl.toInitialCase.curriculum"),
    CurriculumLastLikeDemandsTotalShareLimit("tmtbl.curriculum.lldemands.totalShareLimit"),
    CurriculumLastLikeDemandsShareLimit("tmtbl.curriculum.lldemands.shareLimit"),
    CurriculumLastLikeDemandsEnrollmentLimit("tmtbl.curriculum.lldemands.enrlLimit"),
    EventTooEarlySlot("unitime.event.tooEarly"),
    EventExpirationServiceUpdateInterval("unitime.events.expiration.updateIntervalInMinutes"),
    EventFilterSkipConflictCounts("unitime.events.eventFilter.skipConflictCounts"),
    EventRoomTimetableAllRooms("unitime.event_timetable.event_rooms_only"),
    EventGridDisplayTitle("unitime.events.grid_display_title"),
    EventCalendarDisplayInstructorsInDescription("unitime.events.ics_instructors_in_description"),
    EmailProvider("unitime.email.class"),
    EmailSmtpHost("mail.smtp.host"),
    EmailSmtpPort("mail.smtp.port"),
    EmailSmtpUser("mail.smtp.user"),
    EmailSmtpPassword("mail.smtp.password"),
    EmailSmtpSSL("mail.smtp.ssl.enable"),
    EmailSenderAddress("unitime.email.sender"),
    EmailSenderName("unitime.email.sender.name"),
    EmailReplyToAddress("unitime.email.replyto"),
    EmailReplyToName("unitime.email.replyto.name"),
    EmailNotificationAddress("unitime.email.notif"),
    EmailNotificationAddressName("unitime.email.notif.name"),
    EmailNotificationSolutionCommits("unitime.email.notif.commit"),
    EmailNotificationErrorReports("unitime.email.notif.error"),
    EmailNotificationDataExchange("unitime.email.notif.data"),
    EmailInquiryAddress("unitime.email.inquiry"),
    EmailInquiryAddressName("unitime.email.inquiry.name"),
    EmailInquiryAddressSuffix("unitime.email.inquiry.suffix"),
    EmailInquiryAutoreply("unitime.email.inquiry.autoreply"),
    EmailConfirmationEvents("unitime.email.confirm.event"),
    EmailConfirmationEventsDefault("unitime.email.confirm.default"),
    EmailConfirmationEventInstructors("unitime.email.event.instructor"),
    EmailConfirmationEventCoordinators("unitime.email.event.coordinator"),
    EmailConfirmationEventManagers("unitime.email.event.managers"),
    EmailDefaultAddressSuffix("unitime.email.event.suffix"),
    InboundEmailsEnabled("unitime.email.inbound.enabled"),
    InboundEmailsAddress("unitime.email.inbound.uri"),
    InboundEmailsReplyToAddress("unitime.email.inbound.address"),
    InboundEmailsReplyToAddressName("unitime.email.inbound.name"),
    JGroupsBindAddress("jgroups.bind_addr"),
    HibernateClusterEnabled("unitime.hibernate.cluster"),
    HibernateClusterConfiguration("unitime.hibernate.jgroups.config"),
    HibernateClusterPort("unitime.hibernate.port"),
    HibernateClusterInitialHosts("unitime.hibernate.initial_hosts"),
    OnlineSchedulingClusterForkChannel("unitime.enrollment.jgroups.fork_channel"),
    OnlineSchedulingClusterConfiguration("unitime.enrollment.jgroups.config"),
    OnlineSchedulingClusterPort("unitime.enrollment.port"),
    OnlineSchedulingClusterInitialHosts("unitime.enrollment.initial_hosts"),
    SolverClusterEnabled("unitime.solver.cluster"),
    SolverClusterConfiguration("unitime.solver.jgroups.config"),
    SolverClusterPort("unitime.solver.port"),
    SolverClusterInitialHosts("unitime.solver.initial_hosts"),
    SolverClusterTimeout("unitime.solver.timeout"),
    TestHQLMaxLines("tmtbl.test_hql.max_line"),
    QueryLogLimit("unitime.query.log.limit"),
    PreferencesHierarchicalInheritance("unitime.preferences.hierarchicalInheritance"),
    PreferencesHighlighClassPreferences("unitime.preferences.highlightClassPrefs"),
    SessionNrExcessDays("unitime.session.nrExcessDays"),
    DatePatternNrExessMonth("unitime.pattern.nrExcessMoths"),
    PeopleLookupLimit("tmtbl.lookup.limit"),
    PeopleLookupLdapUrl("tmtbl.lookup.ldap"),
    PeopleLookupLdapBase("tmtbl.lookup.ldap.name"),
    PeopleLookupLdapUser("tmtbl.lookup.ldap.user"),
    PeopleLookupLdapPassword("tmtbl.lookup.ldap.password"),
    PeopleLookupLdapLimit("tmtbl.lookup.ldap.countLimit"),
    PeopleLookupLdapQuery("tmtbl.lookup.ldap.query"),
    PeopleLookupLdapEmailAttribute("tmtbl.lookup.ldap.email"),
    PeopleLookupLdapPhoneAttribute("tmtbl.lookup.ldap.phone"),
    PeopleLookupLdapDepartmentAttribute("tmtbl.lookup.ldap.department"),
    PeopleLookupLdapPositionAttribute("tmtbl.lookup.ldap.position"),
    PeopleLookupLdapAcademicTitleAttribute("tmtbl.lookup.ldap.title"),
    ReservationExpirationDateGlobal("unitime.reservations.expiration_date"),
    ReservationExpirationDate("unitime.reservations.%.expiration_date"),
    ReservationExpirationInDaysGlobal("unitime.reservations.expires_in_days"),
    ReservationExpirationInDays("unitime.reservations.%.expires_in_days"),
    RoomMapStatic("unitime.minimap.url"),
    RoomHintMinimapUrl("unitime.minimap.hint"),
    RoomUseGoogleMap("unitime.coordinates.googlemap"),
    RoomHintShowBreakTime("unitime.roomHint.showBreakTime"),
    LastChangesLimit("unitime.changelog.limit"),
    SolverXMLExportNames("unitime.solution.export.names"),
    SolverXMLExportConvertIds("unitime.solution.export.id-conv"),
    SolverPasivationTime("unitime.solver.passivation.time"),
    OnlineSchedulingQueueLoadInterval("unitime.sectioning.queue.loadInterval"),
    OnlineSchedulingQueueUpdateInterval("unitime.sectioning.queue.updateInterval"),
    OnlineSchedulingAcademicYear("unitime.enrollment.year"),
    OnlineSchedulingAcademicTerm("unitime.enrollment.term"),
    OnlineSchedulingAcademicCampus("unitime.enrollment.campus"),
    OnlineSchedulingServerClass("unitime.enrollment.server.class"),
    OnlineSchedulingServerReplicated("unitime.enrollment.server.replicated"),
    LogCleanupChangeLog("unitime.cleanup.changeLog"),
    LogCleanupQueryLog("unitime.cleanup.queryLog"),
    LogCleanupOnlineSchedulingLog("unitime.cleanup.sectioningLog"),
    LogCleanupMessageLog("unitime.message.log.cleanup.days"),
    LogCleanupOnlineSchedulingQueue("unitime.cleanup.sectioningQueue"),
    MessageLogLevel("unitime.message.log.level"),
    MessageLogLimit("unitime.message.log.limit"),
    MessageLogCleanupInterval("unitime.message.log.cleanup.interval"),
    PdfFontNormal("unitime.pdf.font"),
    PdfFontItalic("unitime.pdf.font.italic"),
    PdfFontBold("unitime.pdf.font.bold"),
    PdfFontBoldItalic("unitime.pdf.font.bolditalic"),
    PdfFontFixed("unitime.pdf.font.fixed"),
    PdfFontSizeSmall("unitime.pdf.fontsize.small"),
    PdfFontSizeNormal("unitime.pdf.fontsize.normal"),
    PdfFontSizeFixed("unitime.pdf.fontsize.fixed"),
    PdfFontSizeBig("unitime.pdf.fontsize.big"),
    PdfFontCache("unitime.pdf.fontcache"),
    WorksheetPdfEnabled("tmtbl.pdf.worksheet"),
    WorksheetPdfUseCommittedAssignments("tmtbl.pdf.worksheet.useCommitedAssignments"),
    WorksheetPdfAuthor("tmtbl.pdf.worksheet.author"),
    WorksheetPdfTitle("tmtbl.pdf.worksheet.title"),
    TimetableGridSlotsPerPeriod("tmtbl.timeGrid.slotsPerPeriod"),
    TimetableGridFirstDaySlot("tmtbl.timeGrid.firstDaySlot"),
    TimetableGridLastDaySlot("tmtbl.timeGrid.lastDaySlot"),
    TimetableGridLastEveningSlot("tmtbl.timeGrid.lastEveningSlot"),
    TimetableGridMaxCellWidth("tmtbl.timeGrid.maxCellWidth"),
    TimetableGridMaxCellWidthVertical("tmtbl.timeGrid.maxCellWidthVertical"),
    ContactUsAddress("tmtbl.contact.address"),
    ContactUsPhone("tmtbl.contact.phone"),
    ContactUsOfficeHours("tmtbl.contact.office_hours"),
    ContactUsEmail("tmtbl.contact.email"),
    ContactUsMailTo("tmtbl.contact.email_mailto"),
    ApplicationConfigPattern("tmtbl.appConfig.pattern"),
    EventAllowEditPast("tmtbl.event.allowEditPast"),
    ExamsLoginMessage("tmtbl.exams.login.message"),
    HelpFAQ("tmtbl.help.faq"),
    ManualEvents("tmtbl.help.manual.events"),
    ManualCourseDataEntry("tmtbl.help.manual.input_data"),
    ManualCourseSolver("tmtbl.help.manual.solver"),
    HelpReleaseNotes("tmtbl.help.release_notes"),
    HelpMain("tmtbl.help.root"),
    HelpTricks("tmtbl.help.tricks"),
    RollForwardAllowClassPreferences("unitime.rollforward.allowClassPrefs"),
    ChromeFrameWarning("unitime.warn.chromeframe"),
    LoggingLevel("log4j.logger.%"),
    InstructorAllowEditExternalId("tmtbl.instructor.allowExternalIdEdit"),
    SessionBackupInterface("unitime.session_backup.class"),
    SessionRestoreInterface("unitime.session_restore.class"),
    CustomizationDefaultCourseUrl("unitime.custom.default.course_url"),
    CustomizationDefaultCourseDetailsDownload("unitime.custom.default.course_download"),
    CustomizationDefaultCourseDetailsContent("unitime.custom.default.course_regexp"),
    CustomizationDefaultCourseDetailsModifiers("unitime.custom.default.course_modifiers"),
    SchedulingSubpartAutoSpreadInTimeDefault("unitime.defaults.subpartSpreadInTime"),
    SchedulingSubpartStudentOverlapsDefault("unitime.defaults.subpartStudentOverlaps"),
    ReservationPriorityIndividual("unitime.reservation.priority.individual"),
    ReservationPriorityGroup("unitime.reservation.priority.group"),
    ReservationPriorityOverride("unitime.reservation.priority.override"),
    ReservationPriorityCourse("unitime.reservation.priority.course"),
    ReservationPriorityCurriculum("unitime.reservation.priority.curriculum"),
    ReservationPriorityDummy("unitime.reservation.priority.dummy"),
    ReservationMustBeUsedIndividual("unitime.reservation.mustBeUsed.individual"),
    ReservationMustBeUsedGroup("unitime.reservation.mustBeUsed.group"),
    ReservationMustBeUsedCourse("unitime.reservation.mustBeUsed.course"),
    ReservationMustBeUsedCurriculum("unitime.reservation.mustBeUsed.curriculum"),
    ReservationCanOverLimitIndividual("unitime.reservation.canOverLimit.individual"),
    ReservationCanOverLimitGroup("unitime.reservation.canOverLimit.group"),
    ReservationCanOverLimitCourse("unitime.reservation.canOverLimit.course"),
    ReservationCanOverLimitCurriculum("unitime.reservation.canOverLimit.curriculum"),
    ReservationAllowOverlapIndividual("unitime.reservation.allowOverlap.individual"),
    ReservationAllowOverlapGroup("unitime.reservation.allowOverlap.group"),
    ReservationAllowOverlapCourse("unitime.reservation.allowOverlap.course"),
    ReservationAllowOverlapCurriculum("unitime.reservation.allowOverlap.curriculum"),
    AuthenticationCasIdAttribute("unitime.authentication.cas.id-attribute"),
    AuthenticationCasIdAlwaysTranslate("unitime.authentication.cas.id-translate"),
    AuthenticationCasIdTrimLeadingZerosFrom("unitime.authentication.cas.id-trim"),
    AuthenticationCasNameAttribute("unitime.authentication.cas.name-attribute"),
    ConflictStatisticsSaveToFile("unitime.cbs.saveToFile"),
    ApiCanUseAPIToken("unitime.api.canUseToken"),
    ApiCacheMode("unitime.api.%.cacheMode"),
    ApiTrimLeadingZerosFromUserExternalIds("unitime.api.user.id-trim"),
    OnlineSchedulingCustomEligibilityRecheck("unitime.enrollment.recheckCustomEligibility"),
    SubpartMaxNumClasses("unitime.subpart.max_num_classes");

    String iKey;

    private ApplicationProperty(String key) {
        this.iKey = key;
    }

    public String key() {
        return this.iKey;
    }

    public String key(String reference) {
        return reference == null ? this.iKey : this.iKey.replace("%", reference);
    }

    public String defaultValue() {
        try {
            DefaultValue defaultValue = ApplicationProperty.class.getField(this.name()).getAnnotation(DefaultValue.class);
            return defaultValue == null ? null : defaultValue.value();
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        catch (SecurityException e) {
            return null;
        }
    }

    public String description() {
        try {
            Description description = ApplicationProperty.class.getField(this.name()).getAnnotation(Description.class);
            return description == null ? null : description.value();
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        catch (SecurityException e) {
            return null;
        }
    }

    public Class type() {
        try {
            Type type = ApplicationProperty.class.getField(this.name()).getAnnotation(Type.class);
            return type == null ? String.class : type.value();
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        catch (SecurityException e) {
            return null;
        }
    }

    public Class implementation() {
        try {
            Implements impl = ApplicationProperty.class.getField(this.name()).getAnnotation(Implements.class);
            return impl == null ? null : impl.value();
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        catch (SecurityException e) {
            return null;
        }
    }

    public String[] availableValues() {
        try {
            Values type = ApplicationProperty.class.getField(this.name()).getAnnotation(Values.class);
            return type == null ? null : type.value();
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        catch (SecurityException e) {
            return null;
        }
    }

    public Double since() {
        try {
            Since since = ApplicationProperty.class.getField(this.name()).getAnnotation(Since.class);
            return since == null ? null : Double.valueOf(since.value());
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        catch (SecurityException e) {
            return null;
        }
    }

    public String value() {
        return this.value(null, null);
    }

    public String value(String reference) {
        return this.value(reference, null);
    }

    public String value(String reference, String defaultValueOverride) {
        String value = ApplicationProperties.getProperty(this.key(reference));
        if (value != null) {
            return value;
        }
        String[] oldKeys = this.replaces();
        if (oldKeys != null) {
            for (String key : oldKeys) {
                value = ApplicationProperties.getProperty(reference == null ? key : key.replace("%", reference));
                if (value == null) continue;
                return value;
            }
        }
        return defaultValueOverride != null ? defaultValueOverride : this.defaultValue();
    }

    public boolean isTrue() {
        return "true".equalsIgnoreCase(this.value());
    }

    public boolean isTrue(String reference) {
        return "true".equalsIgnoreCase(this.value(reference));
    }

    public boolean isTrue(String reference, boolean defaultValueOverride) {
        return "true".equalsIgnoreCase(this.value(reference, defaultValueOverride ? "true" : "false"));
    }

    public boolean isFalse() {
        return !this.isTrue();
    }

    public Integer intValue() {
        try {
            return Integer.valueOf(this.value());
        }
        catch (Exception e) {
            return null;
        }
    }

    public Integer intValue(String reference) {
        try {
            return Integer.valueOf(this.value(reference));
        }
        catch (Exception e) {
            return null;
        }
    }

    public Float floatValue() {
        try {
            return Float.valueOf(this.value());
        }
        catch (Exception e) {
            return null;
        }
    }

    public Double doubleValue() {
        try {
            return Double.valueOf(this.value());
        }
        catch (Exception e) {
            return null;
        }
    }

    private String[] replaces() {
        try {
            Replaces replaces = ApplicationProperty.class.getField(this.name()).getAnnotation(Replaces.class);
            return replaces == null ? null : replaces.value();
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        catch (SecurityException e) {
            return null;
        }
    }

    public boolean matches(String key) {
        if (key.matches(this.key().replace(".", "\\.").replace("%", "(.+)"))) {
            return true;
        }
        String[] oldKeys = this.replaces();
        if (oldKeys != null) {
            for (String old : oldKeys) {
                if (!key.matches(old.replace(".", "\\.").replace("%", "(.+)"))) continue;
                return true;
            }
        }
        return false;
    }

    public String reference() {
        try {
            Parameter reference = ApplicationProperty.class.getField(this.name()).getAnnotation(Parameter.class);
            return reference == null ? null : reference.value();
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        catch (SecurityException e) {
            return null;
        }
    }

    public String reference(String key) {
        Matcher m = Pattern.compile(this.key().replace(".", "\\.").replace("%", "(.+)")).matcher(key);
        if (m.matches() && m.groupCount() > 0) {
            return m.group(1);
        }
        String[] oldKeys = this.replaces();
        if (oldKeys != null) {
            for (String old : oldKeys) {
                m = Pattern.compile(old.replace(".", "\\.").replace("%", "(.+)")).matcher(key);
                if (!m.matches() || m.groupCount() <= 0) continue;
                return m.group(1);
            }
        }
        return null;
    }

    public static ApplicationProperty fromKey(String key) {
        for (ApplicationProperty property : ApplicationProperty.values()) {
            if (!property.key().equals(key)) continue;
            return property;
        }
        for (ApplicationProperty property : ApplicationProperty.values()) {
            if (!property.matches(key)) continue;
            return property;
        }
        return null;
    }

    public static String getDescription(String key) {
        ApplicationProperty property = ApplicationProperty.fromKey(key);
        if (property != null) {
            String reference = property.reference(key);
            String description = property.description();
            if (reference != null) {
                return description.replace("%", reference);
            }
            return description;
        }
        return null;
    }

    public boolean isDeprecated() {
        try {
            return ApplicationProperty.class.getField(this.name()).getAnnotation(Deprecated.class) != null;
        }
        catch (NoSuchFieldException e) {
            return false;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public boolean isSecret() {
        try {
            return ApplicationProperty.class.getField(this.name()).getAnnotation(Secret.class) != null;
        }
        catch (NoSuchFieldException e) {
            return false;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public boolean isReadOnly() {
        try {
            return ApplicationProperty.class.getField(this.name()).getAnnotation(ReadOnly.class) != null;
        }
        catch (NoSuchFieldException e) {
            return false;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public String toString() {
        String description = this.description();
        String defaultValue = this.defaultValue();
        return (description == null ? "" : "# " + description + "\n") + this.key() + "=" + (defaultValue == null ? "" : defaultValue);
    }

    public static void main(String[] args) {
        for (ApplicationProperty p : ApplicationProperty.values()) {
            System.out.println();
            if (p.description() != null) {
                System.out.println("# " + p.description());
            }
            if (p.implementation() != null) {
                System.out.println("# Implements: " + p.implementation().getName());
            } else if (p.type() != null && !p.type().equals(String.class)) {
                System.out.println("# Type: " + p.type().getSimpleName().toLowerCase());
            }
            if (p.reference() != null) {
                System.out.println("# Parameter: " + p.reference());
            }
            if (p.replaces() != null) {
                for (String r : p.replaces()) {
                    System.out.println("# Replaces: " + r);
                }
            }
            if (p.since() != null) {
                System.out.println("# Since " + p.since());
            }
            if (p.isDeprecated()) {
                System.out.println("# Deprecated");
            }
            String value = p.value();
            if (p.defaultValue() != null && !p.isSecret() && !p.defaultValue().equals(value)) {
                System.out.println("# Default: " + p.defaultValue());
            }
            if (value == null) {
                System.out.println("#" + p.key() + "=" + (p.isSecret() ? "****" : ""));
                continue;
            }
            System.out.println(p.key() + "=" + (p.isSecret() ? "****" : value));
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    static @interface Implements {
        public Class value();
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    static @interface Parameter {
        public String value();
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    static @interface Replaces {
        public String[] value();
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    static @interface Values {
        public String[] value();
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    static @interface Type {
        public Class value() default String.class;
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    static @interface DefaultValue {
        public String value();
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    static @interface Description {
        public String value();
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    static @interface Since {
        public double value();
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface ReadOnly {
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Secret {
    }
}

