/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.springframework.stereotype.Service;
import org.unitime.timetable.dataexchange.DataExchangeHelper;
import org.unitime.timetable.defaults.ApplicationProperty;

@Service(value="dataExchangeHelper")
public class DataExchangeIntegrationHelper {
    public Document file2document(File file) throws DocumentException {
        return new SAXReader().read(file);
    }

    public String exception2message(Exception exception) throws IOException {
        StringWriter out = new StringWriter();
        exception.printStackTrace(new PrintWriter(out));
        out.flush();
        out.close();
        return out.toString();
    }

    public String importDocument(Document document) throws Exception {
        final StringBuffer log = new StringBuffer("<html><header><title>XML Import Log</title></header><body>\n");
        DataExchangeHelper.LogWriter logger = new DataExchangeHelper.LogWriter(){

            public void println(String message) {
                log.append(message + "<br>\n");
            }
        };
        String manager = document.getRootElement().attributeValue("manager", ApplicationProperty.DataExchangeXmlManager.value());
        DataExchangeHelper.importDocument(document, manager, logger);
        log.append("</body></html>");
        return log.toString();
    }
}

