/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.TreeSet;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.util.ToolBox;
import org.dom4j.Document;
import org.dom4j.Element;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.dataexchange.BaseExport;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.ArrangeCreditUnitConfig;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseCreditUnitConfig;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamOwner;
import org.unitime.timetable.model.FixedCreditUnitConfig;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Meeting;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.VariableFixedCreditUnitConfig;
import org.unitime.timetable.model.VariableRangeCreditUnitConfig;
import org.unitime.timetable.model.comparators.SchedulingSubpartComparator;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.DateUtils;
import org.unitime.timetable.util.Formats;

public class CourseOfferingExport
extends BaseExport {
    protected static Formats.Format<Number> sTwoNumbersDF = Formats.getNumberFormat("00");
    protected static Formats.Format<Date> sDateFormat = Formats.getDateFormat("yyyy/M/d");
    protected static Formats.Format<Date> sTimeFormat = Formats.getDateFormat("HHmm");
    protected Hashtable<Long, TreeSet<Exam>> iExams = null;
    protected boolean iExportAssignments = true;

    public void saveXml(Document document, Session session, Properties parameters) throws Exception {
        try {
            this.beginTransaction();
            this.iExportAssignments = "true".equals(parameters.getProperty("tmtbl.export.timetable", "true"));
            boolean examsOnly = "true".equals(parameters.getProperty("tmtbl.export.exam"));
            Element root = document.addElement(examsOnly ? "exams" : "offerings");
            root.addAttribute("campus", session.getAcademicInitiative());
            root.addAttribute("year", session.getAcademicYear());
            root.addAttribute("term", session.getAcademicTerm());
            root.addAttribute("dateFormat", sDateFormat.toPattern());
            root.addAttribute("timeFormat", sTimeFormat.toPattern());
            root.addAttribute("created", new Date().toString());
            if (examsOnly) {
                root.addAttribute("type", parameters.getProperty("tmtbl.export.exam.type", "all"));
            }
            document.addDocType(examsOnly ? "exams" : "offerings", "-//UniTime//DTD University Course Timetabling/EN", "http://www.unitime.org/interface/CourseOfferingExport.dtd");
            if (examsOnly) {
                if ("all".equals(parameters.getProperty("tmtbl.export.exam.type", "all")) || "final".equals(parameters.getProperty("tmtbl.export.exam.type", "all"))) {
                    for (Exam exam : new TreeSet(Exam.findAllFinal(session.getUniqueId()))) {
                        this.exportExam(root, null, exam, session);
                    }
                }
                if ("all".equals(parameters.getProperty("tmtbl.export.exam.type", "all")) || "midterm".equals(parameters.getProperty("tmtbl.export.exam.type", "all"))) {
                    for (Exam exam : new TreeSet(Exam.findAllMidterm(session.getUniqueId()))) {
                        this.exportExam(root, null, exam, session);
                    }
                }
            } else {
                this.info("Loading offerings...");
                List offerings = this.getHibSession().createQuery("select distinct io from InstructionalOffering io inner join fetch io.courseOfferings as co inner join fetch co.subjectArea sa left join fetch io.instrOfferingConfigs as ioc left join fetch ioc.schedulingSubparts as ss left join fetch ss.classes as c where io.session.uniqueId=:sessionId order by sa.subjectAreaAbbreviation, co.courseNbr").setLong("sessionId", session.getUniqueId().longValue()).setFetchSize(1000).list();
                if (!"none".equals(parameters.getProperty("tmtbl.export.exam.type", "all"))) {
                    this.info("Loading exams...");
                    List allExams = this.getHibSession().createQuery("select x from Exam x left join fetch x.owners o where x.session.uniqueId=:sessionId" + ("midterm".equals(parameters.getProperty("tmtbl.export.exam.type", "all")) ? " and x.examType.type=1" : "") + ("final".equals(parameters.getProperty("tmtbl.export.exam.type", "all")) ? " and x.examType.type=0" : "")).setLong("sessionId", session.getUniqueId().longValue()).setFetchSize(1000).list();
                    this.iExams = new Hashtable();
                    this.info("Checking exams...");
                    for (Exam exam : allExams) {
                        for (ExamOwner owner : exam.getOwners()) {
                            Long offeringId = owner.getCourse().getInstructionalOffering().getUniqueId();
                            TreeSet<Exam> exams = this.iExams.get(offeringId);
                            if (exams == null) {
                                exams = new TreeSet();
                                this.iExams.put(offeringId, exams);
                            }
                            exams.add(exam);
                        }
                    }
                }
                this.info("Exporting " + offerings.size() + " offerings ...");
                for (InstructionalOffering io : offerings) {
                    this.exportInstructionalOffering(root, io, session);
                }
            }
            this.commitTransaction();
        }
        catch (Exception e) {
            this.fatal("Exception: " + e.getMessage(), e);
            this.rollbackTransaction();
        }
    }

    protected void exportInstructionalOffering(Element offeringsElement, InstructionalOffering offering, Session session) {
        TreeSet<Exam> exams;
        Element offeringElement = offeringsElement.addElement("offering");
        offeringElement.addAttribute("id", offering.getExternalUniqueId() != null ? offering.getExternalUniqueId() : offering.getUniqueId().toString());
        offeringElement.addAttribute("offered", offering.isNotOffered() != false ? "false" : "true");
        offeringElement.addAttribute("action", "insert");
        for (CourseOffering course : offering.getCourseOfferings()) {
            this.exportCourse(offeringElement.addElement("course"), course, session);
        }
        if (!offering.isNotOffered().booleanValue()) {
            for (InstrOfferingConfig config : offering.getInstrOfferingConfigs()) {
                this.exportConfig(offeringElement.addElement("config"), config, session);
            }
        }
        if (this.iExams != null && (exams = this.iExams.get(offering.getUniqueId())) != null) {
            for (Exam exam : exams) {
                this.exportExam(offeringElement, offering, exam, session);
            }
        }
    }

    protected void exportCredit(Element creditElement, CourseCreditUnitConfig credit, Session session) {
        if (credit.getCreditType() != null) {
            creditElement.addAttribute("creditType", credit.getCreditType().getReference());
        }
        if (credit.getCreditUnitType() != null) {
            creditElement.addAttribute("creditUnitType", credit.getCreditUnitType().getReference());
        }
        if (credit.getCreditFormat() != null) {
            creditElement.addAttribute("creditFormat", credit.getCreditFormat());
        }
        if (!(credit instanceof ArrangeCreditUnitConfig)) {
            if (credit instanceof FixedCreditUnitConfig) {
                FixedCreditUnitConfig fixedCredit = (FixedCreditUnitConfig)credit;
                creditElement.addAttribute("fixedCredit", fixedCredit.getFixedUnits().toString());
            } else if (credit instanceof VariableRangeCreditUnitConfig) {
                VariableRangeCreditUnitConfig variableCredit = (VariableRangeCreditUnitConfig)credit;
                creditElement.addAttribute("minimumCredit", variableCredit.getMinUnits().toString());
                creditElement.addAttribute("maximumCredit", variableCredit.getMaxUnits().toString());
                if (variableCredit.isFractionalIncrementsAllowed() != null) {
                    creditElement.addAttribute("fractionalCreditAllowed", variableCredit.isFractionalIncrementsAllowed() != false ? "true" : "false");
                }
            } else if (credit instanceof VariableFixedCreditUnitConfig) {
                VariableFixedCreditUnitConfig variableCredit = (VariableFixedCreditUnitConfig)credit;
                creditElement.addAttribute("minimumCredit", variableCredit.getMinUnits().toString());
                creditElement.addAttribute("maximumCredit", variableCredit.getMaxUnits().toString());
            }
        }
    }

    protected void exportCourse(Element courseElement, CourseOffering course, Session session) {
        courseElement.addAttribute("id", course.getExternalUniqueId() != null ? course.getExternalUniqueId() : course.getUniqueId().toString());
        courseElement.addAttribute("subject", course.getSubjectArea().getSubjectAreaAbbreviation());
        courseElement.addAttribute("courseNbr", course.getCourseNbr());
        if (course.getReservation() != null) {
            courseElement.addAttribute("reserved", course.getReservation().toString());
        }
        courseElement.addAttribute("controlling", course.isIsControl() != false ? "true" : "false");
        if (course.getConsentType() != null) {
            courseElement.addElement("consent").addAttribute("type", course.getConsentType().getReference());
        }
        if (course.getTitle() != null) {
            courseElement.addAttribute("title", course.getTitle());
        }
        if (course.getScheduleBookNote() != null) {
            courseElement.addAttribute("scheduleBookNote", course.getScheduleBookNote());
        }
        for (CourseCreditUnitConfig credit : course.getCreditConfigs()) {
            this.exportCredit(courseElement.addElement("courseCredit"), credit, session);
        }
    }

    protected void exportConfig(Element configElement, InstrOfferingConfig config, Session session) {
        configElement.addAttribute("name", config.getName());
        configElement.addAttribute("limit", config.isUnlimitedEnrollment() != false ? "inf" : config.getLimit().toString());
        for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
            if (subpart.getParentSubpart() != null) continue;
            this.exportSubpart(configElement.addElement("subpart"), subpart, session);
        }
        for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
            if (subpart.getParentSubpart() != null) continue;
            Iterator<Class_> j = subpart.getClasses().iterator();
            while (j.hasNext()) {
                this.exportClass(configElement.addElement("class"), j.next(), session);
            }
        }
    }

    protected void exportSubpart(Element subpartElement, SchedulingSubpart subpart, Session session) {
        subpartElement.addAttribute("type", subpart.getItypeDesc().trim());
        subpartElement.addAttribute("suffix", subpart.getSchedulingSubpartSuffix());
        subpartElement.addAttribute("minPerWeek", subpart.getMinutesPerWk().toString());
        for (CourseCreditUnitConfig credit : subpart.getCreditConfigs()) {
            this.exportCredit(subpartElement.addElement("subpartCredit"), credit, session);
        }
        for (SchedulingSubpart childSubpart : subpart.getChildSubparts()) {
            this.exportSubpart(subpartElement.addElement("subpart"), childSubpart, session);
        }
    }

    protected void exportClass(Element classElement, Class_ clazz, Session session) {
        if (clazz.getExternalUniqueId() != null) {
            classElement.addAttribute("id", clazz.getExternalUniqueId());
        } else {
            classElement.addAttribute("id", clazz.getUniqueId().toString());
        }
        classElement.addAttribute("type", clazz.getItypeDesc().trim());
        classElement.addAttribute("suffix", clazz.getClassSuffix() != null ? clazz.getClassSuffix() : clazz.getSectionNumberString());
        if (clazz.getSchedulingSubpart().getInstrOfferingConfig().isUnlimitedEnrollment().booleanValue()) {
            classElement.addAttribute("limit", "inf");
        } else {
            classElement.addAttribute("limit", String.valueOf(clazz.getClassLimit()));
        }
        if (clazz.getSchedulePrintNote() != null) {
            classElement.addAttribute("scheduleNote", clazz.getSchedulePrintNote());
        }
        classElement.addAttribute("studentScheduling", clazz.isEnabledForStudentScheduling() != false ? "true" : "false");
        classElement.addAttribute("displayInScheduleBook", clazz.isEnabledForStudentScheduling() != false ? "true" : "false");
        for (Class_ childClazz : clazz.getChildClasses()) {
            this.exportClass(classElement.addElement("class"), childClazz, session);
        }
        if (this.iExportAssignments) {
            if (clazz.getCommittedAssignment() != null) {
                this.exportAssignment(classElement, clazz.getCommittedAssignment(), session);
            } else if (clazz.getManagingDept().getSolverGroup() != null && clazz.getManagingDept().getSolverGroup().getCommittedSolution() != null) {
                this.exportArrHours(classElement, clazz, session);
            }
        }
        if (clazz.isDisplayInstructor().booleanValue()) {
            for (ClassInstructor instructor : clazz.getClassInstructors()) {
                if (instructor.getInstructor().getExternalUniqueId() == null) continue;
                this.exportInstructor(classElement.addElement("instructor"), instructor, session);
            }
        }
    }

    protected void exportInstructor(Element instructorElement, ClassInstructor instructor, Session session) {
        this.exportInstructor(instructorElement, instructor.getInstructor(), session);
        if (instructor.getPercentShare() != null) {
            instructorElement.addAttribute("share", instructor.getPercentShare().toString());
        }
        instructorElement.addAttribute("lead", instructor.isLead() != false ? "true" : "false");
    }

    protected void exportInstructor(Element instructorElement, DepartmentalInstructor instructor, Session session) {
        if (instructor.getExternalUniqueId() != null) {
            instructorElement.addAttribute("id", instructor.getExternalUniqueId());
        }
        if (instructor.getFirstName() != null) {
            instructorElement.addAttribute("fname", instructor.getFirstName());
        }
        if (instructor.getMiddleName() != null) {
            instructorElement.addAttribute("mname", instructor.getMiddleName());
        }
        if (instructor.getLastName() != null) {
            instructorElement.addAttribute("lname", instructor.getLastName());
        }
        if (instructor.getAcademicTitle() != null) {
            instructorElement.addAttribute("title", instructor.getAcademicTitle());
        }
    }

    private static String dayCode2days(int dayCode) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
            if ((dayCode & Constants.DAY_CODES[i]) == 0) continue;
            sb.append(Constants.DAY_NAMES_SHORT[i]);
        }
        return sb.toString();
    }

    private static String startSlot2startTime(int startSlot) {
        int minHrs = startSlot * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN;
        return sTwoNumbersDF.format(minHrs / 60) + sTwoNumbersDF.format(minHrs % 60);
    }

    private static String timeLocation2endTime(TimeLocation time) {
        int minHrs = (time.getStartSlot() + time.getLength()) * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN - time.getBreakTime();
        return sTwoNumbersDF.format(minHrs / 60) + sTwoNumbersDF.format(minHrs % 60);
    }

    protected void exportAssignment(Element classElement, Assignment assignment, Session session) {
        this.exportDatePattern(classElement, assignment.getDatePattern(), session);
        this.exportTimeLocation(classElement, assignment, session);
        this.exportRooms(classElement, assignment, session);
    }

    protected void exportTimeLocation(Element classElement, Assignment assignment, Session session) {
        TimeLocation time = assignment.getTimeLocation();
        if (time != null) {
            Element timeElement = classElement.addElement("time");
            timeElement.addAttribute("days", CourseOfferingExport.dayCode2days(time.getDayCode()));
            timeElement.addAttribute("startTime", CourseOfferingExport.startSlot2startTime(time.getStartSlot()));
            timeElement.addAttribute("endTime", CourseOfferingExport.timeLocation2endTime(time));
            DatePattern dp = assignment.getDatePattern();
            if (dp != null && (!dp.isDefault() || ApplicationProperty.DataExchangeIncludeDefaultDatePattern.isTrue())) {
                timeElement.addAttribute("datePattern", dp.getName());
            }
            if (assignment.getTimePattern() != null) {
                timeElement.addAttribute("timePattern", assignment.getTimePattern().getName());
            }
        }
    }

    protected void exportRooms(Element classElement, Assignment assignment, Session session) {
        for (Location location : assignment.getRooms()) {
            if (location instanceof Room) {
                Room room = (Room)location;
                Element roomElement = classElement.addElement("room");
                if (room.getExternalUniqueId() != null) {
                    roomElement.addAttribute("id", room.getExternalUniqueId());
                }
                roomElement.addAttribute("building", room.getBuildingAbbv());
                roomElement.addAttribute("roomNbr", room.getRoomNumber());
                continue;
            }
            Element roomElement = classElement.addElement("location");
            if (location.getExternalUniqueId() != null) {
                roomElement.addAttribute("id", location.getExternalUniqueId());
            }
            roomElement.addAttribute("name", location.getLabel());
        }
    }

    protected void exportArrHours(Element classElement, Class_ clazz, Session session) {
        this.exportDatePattern(classElement, clazz.effectiveDatePattern(), session);
        this.exportRequiredRooms(classElement, clazz, session);
    }

    protected void exportDatePattern(Element classElement, DatePattern dp, Session session) {
        if (dp != null && (!dp.equals(session.getDefaultDatePattern()) || ApplicationProperty.DataExchangeIncludeDefaultDatePattern.isTrue())) {
            Calendar startDate = Calendar.getInstance(Locale.US);
            startDate.setTime(dp.getStartDate());
            Calendar endDate = Calendar.getInstance(Locale.US);
            endDate.setTime(dp.getEndDate());
            int startMonth = startDate.get(2);
            int endMonth = endDate.get(2);
            int startYear = startDate.get(1);
            int endYear = endDate.get(1);
            if (endYear > startYear) {
                endMonth += 12 * (endYear - startYear);
            }
            String first = null;
            String previous = null;
            char[] ptrn = dp.getPattern().toCharArray();
            int charPosition = 0;
            int dayOfWeek = startDate.get(7);
            for (int m = startMonth; m <= endMonth; ++m) {
                int d;
                int daysOfMonth = DateUtils.getNrDaysOfMonth(m, startYear);
                int n = d = m == startMonth ? startDate.get(5) : 1;
                while (d <= daysOfMonth && charPosition < ptrn.length) {
                    if (ptrn[charPosition] == '1') {
                        if (first == null) {
                            first = (m < 0 ? startYear - 1 : (m >= 12 ? startYear + 1 : startYear)) + "/" + ((m < 0 ? 12 + m : m % 12) + 1) + "/" + d;
                        }
                    } else if (first != null) {
                        Element dateElement = classElement.addElement("date");
                        dateElement.addAttribute("startDate", first);
                        dateElement.addAttribute("endDate", previous);
                        first = null;
                    }
                    previous = (m < 0 ? startYear - 1 : (m >= 12 ? startYear + 1 : startYear)) + "/" + ((m < 0 ? 12 + m : m % 12) + 1) + "/" + d;
                    ++charPosition;
                    if (++dayOfWeek > 7) {
                        dayOfWeek = 1;
                    }
                    ++d;
                }
            }
            if (first != null) {
                Element dateElement = classElement.addElement("date");
                dateElement.addAttribute("startDate", first);
                dateElement.addAttribute("endDate", previous);
                first = null;
            }
        }
    }

    protected void exportRequiredRooms(Element classElement, Class_ clazz, Session session) {
        for (RoomPref rp : clazz.getEffectiveRoomPreferences()) {
            if (!PreferenceLevel.sRequired.equals(rp.getPrefLevel().getPrefProlog())) continue;
            if (rp.getRoom() instanceof Room) {
                Room room = (Room)rp.getRoom();
                Element roomElement = classElement.addElement("room");
                if (room.getExternalUniqueId() != null) {
                    roomElement.addAttribute("id", room.getExternalUniqueId());
                }
                roomElement.addAttribute("building", room.getBuildingAbbv());
                roomElement.addAttribute("roomNbr", room.getRoomNumber());
                continue;
            }
            Element roomElement = classElement.addElement("location");
            if (rp.getRoom().getExternalUniqueId() != null) {
                roomElement.addAttribute("id", rp.getRoom().getExternalUniqueId());
            }
            roomElement.addAttribute("name", rp.getRoom().getLabel());
        }
    }

    protected void exportExam(Element offeringElement, InstructionalOffering offering, Exam exam, Session session) {
        Element examElement = offeringElement.addElement("exam");
        examElement.addAttribute("id", exam.getUniqueId().toString());
        examElement.addAttribute("name", exam.getName() == null ? exam.generateName() : exam.getName());
        examElement.addAttribute("size", String.valueOf(exam.getSize()));
        if (exam.getNote() != null) {
            examElement.addAttribute("note", exam.getNote());
        }
        examElement.addAttribute("seatingType", exam.getSeatingType() == 1 ? "exam" : "normal");
        examElement.addAttribute("type", exam.getExamType().getReference());
        Element courseElement = null;
        CourseOffering lastCourse = null;
        for (Object owner : exam.getOwnerObjects()) {
            if (owner instanceof Class_) {
                Class_ clazz = (Class_)owner;
                if (offering == null) {
                    if (lastCourse == null || !lastCourse.equals(clazz.getSchedulingSubpart().getControllingCourseOffering())) {
                        lastCourse = clazz.getSchedulingSubpart().getControllingCourseOffering();
                        courseElement = examElement.addElement("course");
                        courseElement.addAttribute("id", lastCourse.getExternalUniqueId() != null ? lastCourse.getExternalUniqueId() : lastCourse.getUniqueId().toString());
                        courseElement.addAttribute("subject", lastCourse.getSubjectArea().getSubjectAreaAbbreviation());
                        courseElement.addAttribute("courseNbr", lastCourse.getCourseNbr());
                    }
                    courseElement.addElement("class").addAttribute("id", clazz.getExternalUniqueId() != null ? clazz.getExternalUniqueId() : clazz.getUniqueId().toString()).addAttribute("type", clazz.getItypeDesc().trim()).addAttribute("suffix", clazz.getClassSuffix() != null ? clazz.getClassSuffix() : clazz.getSectionNumberString());
                    continue;
                }
                if (!clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().equals(offering)) continue;
                examElement.addElement("class").addAttribute("id", clazz.getExternalUniqueId() != null ? clazz.getExternalUniqueId() : clazz.getUniqueId().toString()).addAttribute("type", clazz.getItypeDesc().trim()).addAttribute("suffix", clazz.getClassSuffix() != null ? clazz.getClassSuffix() : clazz.getSectionNumberString());
                continue;
            }
            if (owner instanceof InstrOfferingConfig) {
                TreeSet<SchedulingSubpart> subparts;
                InstrOfferingConfig config = (InstrOfferingConfig)owner;
                if (offering == null) {
                    if (lastCourse == null || !lastCourse.equals(config.getControllingCourseOffering())) {
                        lastCourse = config.getControllingCourseOffering();
                        courseElement = examElement.addElement("course");
                        courseElement.addAttribute("id", lastCourse.getExternalUniqueId() != null ? lastCourse.getExternalUniqueId() : lastCourse.getUniqueId().toString());
                        courseElement.addAttribute("subject", lastCourse.getSubjectArea().getSubjectAreaAbbreviation());
                        courseElement.addAttribute("courseNbr", lastCourse.getCourseNbr());
                    }
                    subparts = new TreeSet<SchedulingSubpart>(new SchedulingSubpartComparator());
                    subparts.addAll(config.getSchedulingSubparts());
                    for (Class_ clazz : ((SchedulingSubpart)subparts.first()).getClasses()) {
                        courseElement.addElement("class").addAttribute("id", clazz.getExternalUniqueId() != null ? clazz.getExternalUniqueId() : clazz.getUniqueId().toString()).addAttribute("type", clazz.getItypeDesc().trim()).addAttribute("suffix", clazz.getClassSuffix() != null ? clazz.getClassSuffix() : clazz.getSectionNumberString());
                    }
                    continue;
                }
                if (!config.getInstructionalOffering().equals(offering) || config.getSchedulingSubparts().isEmpty()) continue;
                subparts = new TreeSet(new SchedulingSubpartComparator());
                subparts.addAll(config.getSchedulingSubparts());
                for (Class_ clazz : ((SchedulingSubpart)subparts.first()).getClasses()) {
                    examElement.addElement("class").addAttribute("id", clazz.getExternalUniqueId() != null ? clazz.getExternalUniqueId() : clazz.getUniqueId().toString()).addAttribute("type", clazz.getItypeDesc().trim()).addAttribute("suffix", clazz.getClassSuffix() != null ? clazz.getClassSuffix() : clazz.getSectionNumberString());
                }
                continue;
            }
            if (owner instanceof CourseOffering) {
                CourseOffering course = (CourseOffering)owner;
                if (offering != null && !course.getInstructionalOffering().equals(offering) || offering != null && offering.getCourseOfferings().size() == 1) continue;
                courseElement = examElement.addElement("course");
                lastCourse = course;
                courseElement.addAttribute("id", course.getExternalUniqueId() != null ? course.getExternalUniqueId() : course.getUniqueId().toString());
                courseElement.addAttribute("subject", course.getSubjectArea().getSubjectAreaAbbreviation());
                courseElement.addAttribute("courseNbr", course.getCourseNbr());
                continue;
            }
            if (!(owner instanceof CourseOffering)) continue;
            InstructionalOffering o = (InstructionalOffering)owner;
            if (offering != null) continue;
            for (CourseOffering course : o.getCourseOfferings()) {
                courseElement = examElement.addElement("course");
                lastCourse = course;
                courseElement.addAttribute("id", course.getExternalUniqueId() != null ? course.getExternalUniqueId() : course.getUniqueId().toString());
                courseElement.addAttribute("subject", course.getSubjectArea().getSubjectAreaAbbreviation());
                courseElement.addAttribute("courseNbr", course.getCourseNbr());
            }
        }
        for (DepartmentalInstructor instructor : exam.getInstructors()) {
            if (instructor.getExternalUniqueId() == null) continue;
            this.exportInstructor(examElement.addElement("instructor"), instructor, session);
        }
        if (exam.getAssignedPeriod() != null) {
            Element periodElement = examElement.addElement("period");
            periodElement.addAttribute("date", sDateFormat.format(exam.getAssignedPeriod().getStartDate()));
            periodElement.addAttribute("startTime", sTimeFormat.format(exam.getStartTime(exam.getAssignedPeriod())));
            periodElement.addAttribute("endTime", sTimeFormat.format(exam.getEndTime(exam.getAssignedPeriod())));
            for (Location location : exam.getAssignedRooms()) {
                if (location instanceof Room) {
                    Room room = (Room)location;
                    Element roomElement = examElement.addElement("room");
                    if (room.getExternalUniqueId() != null) {
                        roomElement.addAttribute("id", room.getExternalUniqueId());
                    }
                    roomElement.addAttribute("building", room.getBuildingAbbv());
                    roomElement.addAttribute("roomNbr", room.getRoomNumber());
                    continue;
                }
                Element roomElement = examElement.addElement("location");
                if (location.getExternalUniqueId() != null) {
                    roomElement.addAttribute("id", location.getExternalUniqueId());
                }
                roomElement.addAttribute("name", location.getLabel());
            }
        }
    }

    protected void exportEvent(Element classElement, Event event, Session session) {
        for (Meeting meeting : event.getMeetings()) {
            Element meetingElement = classElement.addElement("meeting");
            meetingElement.addAttribute("startDate", sDateFormat.format(meeting.getMeetingDate()));
            meetingElement.addAttribute("endDate", sDateFormat.format(meeting.getMeetingDate()));
            meetingElement.addAttribute("startTime", sDateFormat.format(meeting.getStartTime()));
            meetingElement.addAttribute("endTime", sDateFormat.format(meeting.getStopTime()));
            Calendar c = Calendar.getInstance(Locale.US);
            c.setTime(meeting.getMeetingDate());
            switch (c.get(7)) {
                case 2: {
                    meetingElement.addAttribute("days", "M");
                    break;
                }
                case 3: {
                    meetingElement.addAttribute("days", "T");
                    break;
                }
                case 4: {
                    meetingElement.addAttribute("days", "W");
                    break;
                }
                case 5: {
                    meetingElement.addAttribute("days", "R");
                    break;
                }
                case 6: {
                    meetingElement.addAttribute("days", "F");
                    break;
                }
                case 7: {
                    meetingElement.addAttribute("days", "S");
                    break;
                }
                case 1: {
                    meetingElement.addAttribute("days", "U");
                }
            }
            if (meeting.getLocation() == null) continue;
            if (meeting.getLocation() instanceof Room) {
                meetingElement.addAttribute("building", ((Room)meeting.getLocation()).getBuildingAbbv());
                meetingElement.addAttribute("room", ((Room)meeting.getLocation()).getRoomNumber());
                continue;
            }
            meetingElement.addAttribute("location", meeting.getLocation().getLabel());
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                args = new String[]{"c:\\test\\courseOfferings.xml", "puWestLafayetteTrdtn", "2007", "Fal"};
            }
            ToolBox.configureLogging();
            HibernateUtil.configureHibernate(ApplicationProperties.getProperties());
            Session session = Session.getSessionUsingInitiativeYearTerm(args[1], args[2], args[3]);
            if (session == null) {
                throw new Exception("Session " + args[1] + " " + args[2] + args[3] + " not found!");
            }
            new CourseOfferingExport().saveXml(args[0], session, ApplicationProperties.getProperties());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

