/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.unitime.timetable.dataexchange.DataExchangeHelper;
import org.unitime.timetable.model.TimetableManager;

public abstract class BaseImport
extends DataExchangeHelper {
    protected static Log sLog = LogFactory.getLog(BaseImport.class);
    private TimetableManager iManager = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadXml(String fileName) throws Exception {
        this.debug("Loading " + fileName);
        FileInputStream fis = null;
        try {
            try {
                fis = new FileInputStream(fileName);
                this.loadXml(fis);
            }
            catch (IOException e) {
                this.fatal("Unable to read file " + fileName + ", reason:" + e.getMessage(), e);
                throw e;
            }
            Object var5_3 = null;
            if (fis == null) return;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (fis == null) throw throwable;
            try {
                fis.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        fis.close();
        return;
    }

    public void loadXml(InputStream inputStream) throws Exception {
        try {
            Document document = new SAXReader().read(inputStream);
            this.loadXml(document.getRootElement());
        }
        catch (DocumentException e) {
            this.fatal("Unable to parse given XML, reason:" + e.getMessage(), e);
        }
    }

    public abstract void loadXml(Element var1) throws Exception;

    protected String getRequiredStringAttribute(Element element, String attributeName, String elementName) throws Exception {
        String attributeValue = element.attributeValue(attributeName);
        if (attributeValue == null || attributeValue.trim().length() == 0) {
            throw new Exception("For element '" + elementName + "' a '" + attributeName + "' is required");
        }
        attributeValue = attributeValue.trim().replace('\u0096', ' ').replace('\u0097', ' ');
        return attributeValue;
    }

    protected String getOptionalStringAttribute(Element element, String attributeName) {
        String attributeValue = element.attributeValue(attributeName);
        attributeValue = attributeValue == null || attributeValue.trim().length() == 0 ? null : attributeValue.trim().replace('\u0096', ' ').replace('\u0097', ' ');
        return attributeValue;
    }

    protected Integer getRequiredIntegerAttribute(Element element, String attributeName, String elementName) throws Exception {
        String attributeStr = this.getRequiredStringAttribute(element, attributeName, elementName);
        return new Integer(attributeStr);
    }

    protected Integer getOptionalIntegerAttribute(Element element, String attributeName) {
        String attributeStr = this.getOptionalStringAttribute(element, attributeName);
        if (attributeStr != null) {
            return new Integer(attributeStr);
        }
        return null;
    }

    protected Boolean getRequiredBooleanAttribute(Element element, String attributeName, String elementName) throws Exception {
        String attributeStr = this.getRequiredStringAttribute(element, attributeName, elementName);
        return new Boolean(attributeStr);
    }

    protected Boolean getOptionalBooleanAttribute(Element element, String attributeName) {
        String attributeStr = this.getOptionalStringAttribute(element, attributeName);
        if (attributeStr != null) {
            return new Boolean(attributeStr);
        }
        return null;
    }

    protected boolean getOptionalBooleanAttribute(Element element, String attributeName, boolean defaultValue) {
        String attributeStr = this.getOptionalStringAttribute(element, attributeName);
        if (attributeStr != null) {
            return Boolean.parseBoolean(attributeStr);
        }
        return defaultValue;
    }

    protected TimetableManager getManager() {
        if (this.iManager == null) {
            this.iManager = this.findDefaultManager();
        }
        return this.iManager;
    }

    public void setManager(TimetableManager manager) {
        this.iManager = manager;
    }

    protected TimetableManager findDefaultManager() {
        return (TimetableManager)this.getHibSession().createQuery("from TimetableManager as m where m.uniqueId = (select min(tm.uniqueId) from TimetableManager as tm inner join tm.managerRoles as mr inner join mr.role as r where r.reference = 'Administrator')").uniqueResult();
    }
}

