/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.api;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.unitime.timetable.api.ApiConnector;
import org.unitime.timetable.gwt.shared.PageAccessException;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.context.AnonymousUserContext;
import org.unitime.timetable.security.context.HttpSessionContext;

public class ApiServlet
extends HttpServlet {
    private static Log sLog = LogFactory.getLog(ApiServlet.class);
    private static final long serialVersionUID = 1L;

    protected SessionContext getSessionContext() {
        return HttpSessionContext.getSessionContext(this.getServletContext());
    }

    protected String getReference(HttpServletRequest request) {
        return request.getServletPath() + request.getPathInfo();
    }

    protected ApiConnector getConnector(HttpServletRequest request) {
        WebApplicationContext applicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        return (ApiConnector)applicationContext.getBean(this.getReference(request));
    }

    protected void checkError(HttpServletRequest request, HttpServletResponse response, Throwable t) throws IOException {
        if (t instanceof NoSuchBeanDefinitionException) {
            sLog.info((Object)("Service " + this.getReference(request) + " not known."));
            response.sendError(400, "Service " + this.getReference(request) + " not known, please check the request path.");
        } else if (t instanceof IllegalArgumentException) {
            sLog.info((Object)t.getMessage());
            response.sendError(400, t.getMessage());
        } else if (t instanceof PageAccessException || t instanceof AccessDeniedException) {
            sLog.info((Object)t.getMessage());
            if (!this.getSessionContext().isAuthenticated() || this.getSessionContext().getUser() instanceof AnonymousUserContext) {
                response.setHeader("WWW-Authenticate", "Basic");
                response.sendError(401, t.getMessage());
            } else {
                response.sendError(403, t.getMessage());
            }
        } else {
            sLog.warn((Object)t.getMessage(), t);
            response.sendError(500, t.getMessage());
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.getConnector(request).doGet(request, response);
        }
        catch (Throwable t) {
            this.checkError(request, response, t);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.getConnector(request).doPost(request, response);
        }
        catch (Throwable t) {
            this.checkError(request, response, t);
        }
    }

    public void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.getConnector(request).doPut(request, response);
        }
        catch (Throwable t) {
            this.checkError(request, response, t);
        }
    }

    public void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.getConnector(request).doDelete(request, response);
        }
        catch (Throwable t) {
            this.checkError(request, response, t);
        }
    }
}

