/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.web.WebTable;
import org.unitime.timetable.form.SponsoringOrgListForm;
import org.unitime.timetable.model.SponsoringOrganization;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;

@Service(value="/sponsoringOrgList")
public class SponsoringOrgListAction
extends Action {
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SponsoringOrgListForm myForm = (SponsoringOrgListForm)form;
        String op = myForm.getOp();
        this.sessionContext.checkPermission(Right.SponsoringOrganizations);
        if ("Add Organization".equals(op)) {
            request.setAttribute("op", (Object)"add");
            return mapping.findForward("add");
        }
        request.setAttribute("table", (Object)this.getTable());
        return mapping.findForward("show");
    }

    public String getTable() {
        WebTable table = new WebTable(2, null, new String[]{"Name", "Email"}, new String[]{"left", "left"}, new boolean[]{true, true});
        for (SponsoringOrganization spor : SponsoringOrganization.findAll()) {
            table.addLine(this.sessionContext.hasPermission(spor, Right.SponsoringOrganizationEdit) ? "onclick=\"document.location='sponsoringOrgEdit.do?op=Edit&id=" + spor.getUniqueId() + "';\"" : null, new String[]{spor.getName(), spor.getEmail()}, new Comparable[]{null, null});
        }
        return table.getLines().isEmpty() ? "" : table.printTable();
    }
}

