/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.commons.MultiComparable;
import org.unitime.commons.web.WebTable;
import org.unitime.timetable.form.RoomAvailabilityForm;
import org.unitime.timetable.interfaces.RoomAvailabilityInterface;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.ExamDAO;
import org.unitime.timetable.model.dao.ExamTypeDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.WebSolver;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.exam.ui.ExamAssignment;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.ExportUtils;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.LookupTables;
import org.unitime.timetable.util.RoomAvailability;
import org.unitime.timetable.webutil.PdfWebTable;

@Service(value="/roomAvailability")
public class RoomAvailabilityAction
extends Action {
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String op;
        RoomAvailabilityForm myForm = (RoomAvailabilityForm)form;
        this.sessionContext.checkPermission(Right.RoomAvailability);
        String string = op = myForm.getOp() != null ? myForm.getOp() : request.getParameter("op");
        if ("Export PDF".equals(op) || "Apply".equals(op)) {
            myForm.save(this.sessionContext);
        } else if ("Refresh".equals(op)) {
            myForm.reset(mapping, request);
        }
        myForm.load(this.sessionContext);
        Session session = (Session)SessionDAO.getInstance().get(this.sessionContext.getUser().getCurrentAcademicSessionId());
        if (myForm.getExamType() != null && myForm.getExamType() >= 0L) {
            PdfWebTable table;
            String exclude;
            Date[] bounds = ExamPeriod.getBounds(session, myForm.getExamType());
            String string2 = myForm.getIncludeExams() ? null : (exclude = ((ExamType)ExamTypeDAO.getInstance().get(myForm.getExamType())).getType() == 0 ? RoomAvailabilityInterface.sFinalExamType : RoomAvailabilityInterface.sMidtermExamType);
            if (bounds != null && RoomAvailability.getInstance() != null) {
                RoomAvailability.getInstance().activate(session, bounds[0], bounds[1], exclude, "Refresh".equals(op));
            }
            WebTable.setOrder(this.sessionContext, myForm.getCompare() ? "roomAvailability.cord" : "roomAvailability.ord", request.getParameter("ord"), 1);
            PdfWebTable pdfWebTable = table = myForm.getCompare() ? this.getCompareTable(request, session.getUniqueId(), true, myForm) : this.getTable(request, session.getUniqueId(), true, myForm);
            if ("Export PDF".equals(op) && table != null) {
                ExportUtils.exportPDF(myForm.getCompare() ? this.getCompareTable(request, session.getUniqueId(), false, myForm) : this.getTable(request, session.getUniqueId(), false, myForm), WebTable.getOrder(this.sessionContext, myForm.getCompare() ? "roomAvailability.cord" : "roomAvailability.ord"), response, "roomavail");
                return null;
            }
            if (table != null) {
                myForm.setTable(table.printTable(WebTable.getOrder(this.sessionContext, myForm.getCompare() ? "roomAvailability.cord" : "roomAvailability.ord")), 6, table.getLines().size());
            }
            RoomAvailability.setAvailabilityWarning(request, session, myForm.getExamType(), false, true);
        }
        if (request.getParameter("backId") != null) {
            request.setAttribute("hash", (Object)request.getParameter("backId"));
        }
        LookupTables.setupExamTypes(request, this.sessionContext.getUser().getCurrentAcademicSessionId());
        return mapping.findForward("showReport");
    }

    public boolean match(RoomAvailabilityForm form, String name) {
        if (form.getFilter() == null || form.getFilter().trim().length() == 0) {
            return true;
        }
        String n = name.toUpperCase();
        StringTokenizer stk1 = new StringTokenizer(form.getFilter().toUpperCase(), ";");
        while (stk1.hasMoreTokens()) {
            StringTokenizer stk2 = new StringTokenizer(stk1.nextToken(), " ,");
            boolean match = true;
            while (match && stk2.hasMoreTokens()) {
                String token = stk2.nextToken().trim();
                if (token.length() == 0) continue;
                if (token.indexOf(42) >= 0 || token.indexOf(63) >= 0) {
                    try {
                        String tokenRegExp = "\\s+" + token.replaceAll("\\.", "\\.").replaceAll("\\?", ".+").replaceAll("\\*", ".*") + "\\s";
                        if (Pattern.compile(tokenRegExp).matcher(" " + n + " ").find()) continue;
                        match = false;
                    }
                    catch (PatternSyntaxException e) {
                        match = false;
                    }
                    continue;
                }
                if (n.indexOf(token) >= 0) continue;
                match = false;
            }
            if (!match) continue;
            return true;
        }
        return false;
    }

    public PdfWebTable getTable(HttpServletRequest request, Long sessionId, boolean html, RoomAvailabilityForm form) {
        RoomAvailabilityInterface ra = RoomAvailability.getInstance();
        if (ra == null) {
            return null;
        }
        String nl = html ? "<br>" : "\n";
        PdfWebTable table = new PdfWebTable(8, "Room Availability", "roomAvailability.do?ord=%%", new String[]{"Room", "Capacity", "Examination" + nl + "Capacity", "Event", "Event Type", "Date", "Start Time", "End Time"}, new String[]{"left", "right", "right", "left", "left", "left", "left", "left"}, new boolean[]{true, true, true, true, true, true, true, true});
        table.setBlankWhenSame(true);
        TreeSet periods = ExamPeriod.findAll(sessionId, form.getExamType());
        if (periods.isEmpty()) {
            table.addLine(new String[]{"<font color='orange'>WARN: No examination periods.</font>"}, null);
            return table;
        }
        Date[] bounds = ExamPeriod.getBounds((Session)new SessionDAO().get(sessionId), form.getExamType());
        Formats.Format<Date> dateFormat = Formats.getDateFormat(Formats.Pattern.DATE_MEETING);
        Formats.Format<Date> timeFormat = Formats.getDateFormat(Formats.Pattern.TIME_SHORT);
        String ts = null;
        try {
            for (Location location : Location.findAllExamLocations(sessionId, form.getExamType())) {
                String exclude;
                if (!this.match(form, location.getLabel())) continue;
                String string = form.getIncludeExams() ? null : (exclude = ((ExamType)ExamTypeDAO.getInstance().get(form.getExamType())).getType() == 0 ? RoomAvailabilityInterface.sFinalExamType : RoomAvailabilityInterface.sMidtermExamType);
                Collection<RoomAvailabilityInterface.TimeBlock> events = ra.getRoomAvailability(location.getUniqueId(), bounds[0], bounds[1], exclude);
                if (events == null) continue;
                if (ts == null) {
                    ts = ra.getTimeStamp(bounds[0], bounds[1], exclude);
                }
                for (RoomAvailabilityInterface.TimeBlock event : events) {
                    boolean overlaps = false;
                    for (ExamPeriod period : periods) {
                        if (!period.overlap(event)) continue;
                        overlaps = true;
                        break;
                    }
                    if (!overlaps) continue;
                    table.addLine(null, new String[]{location.getLabel(), location.getCapacity().toString(), location.getExamCapacity().toString(), event.getEventName(), event.getEventType(), dateFormat.format(event.getStartTime()), timeFormat.format(event.getStartTime()).replaceAll("AM", "a").replaceAll("PM", "p"), timeFormat.format(event.getEndTime()).replaceAll("AM", "a").replaceAll("PM", "p")}, new Comparable[]{new MultiComparable((Comparable)((Object)location.getLabel()), event.getStartTime()), new MultiComparable(Integer.valueOf(-location.getCapacity().intValue()), (Comparable)((Object)location.getLabel()), event.getStartTime()), new MultiComparable(Integer.valueOf(-location.getExamCapacity().intValue()), (Comparable)((Object)location.getLabel()), event.getStartTime()), new MultiComparable((Comparable)((Object)event.getEventName()), (Comparable)((Object)location.getLabel()), event.getStartTime()), new MultiComparable((Comparable)((Object)event.getEventType()), (Comparable)((Object)event.getEventName()), (Comparable)((Object)location.getLabel()), event.getStartTime()), new MultiComparable(event.getStartTime(), (Comparable)((Object)location.getLabel())), new MultiComparable(Long.valueOf(event.getStartTime().getTime() % 86400000L), (Comparable)((Object)location.getLabel())), new MultiComparable(Long.valueOf(event.getEndTime().getTime() % 86400000L), (Comparable)((Object)location.getLabel()))}, location.getUniqueId().toString());
                }
            }
            if (ts != null) {
                request.setAttribute("timestamp", ts);
            }
        }
        catch (Exception e) {
            Debug.error(e);
            table.addLine(new String[]{"<font color='red'>ERROR:" + e.getMessage() + "</font>"}, null);
        }
        return table;
    }

    public PdfWebTable getCompareTable(HttpServletRequest request, Long sessionId, boolean html, RoomAvailabilityForm form) {
        RoomAvailabilityInterface ra = RoomAvailability.getInstance();
        if (ra == null) {
            return null;
        }
        String nl = html ? "<br>" : "\n";
        PdfWebTable table = new PdfWebTable(9, "Examination Comparison", "roomAvailability.do?ord=%%", new String[]{"Room", "Capacity", "Examination" + nl + "Capacity", "Examination", "Examination" + nl + "Date", "Examination" + nl + "Time", "Event", "Event" + nl + "Date", "Event" + nl + "Time"}, new String[]{"left", "right", "right", "left", "left", "left", "left", "left", "left"}, new boolean[]{true, true, true, true, true, true, true, true, true});
        table.setBlankWhenSame(true);
        TreeSet periods = ExamPeriod.findAll(sessionId, form.getExamType());
        if (periods.isEmpty()) {
            table.addLine(new String[]{"<font color='orange'>WARN: No examination periods.</font>"}, null);
            return table;
        }
        Date[] bounds = ExamPeriod.getBounds((Session)new SessionDAO().get(sessionId), form.getExamType());
        Formats.Format<Date> dateFormat = Formats.getDateFormat(Formats.Pattern.DATE_EXAM_PERIOD);
        Formats.Format<Date> timeFormat = Formats.getDateFormat(Formats.Pattern.TIME_SHORT);
        String ts = null;
        String eventType = ((ExamType)ExamTypeDAO.getInstance().get(form.getExamType())).getType() == 0 ? RoomAvailabilityInterface.sFinalExamType : RoomAvailabilityInterface.sMidtermExamType;
        ExamSolverProxy examAssignment = WebSolver.getExamSolver(request.getSession());
        if (examAssignment != null && !examAssignment.getExamTypeId().equals(form.getExamType())) {
            examAssignment = null;
        }
        try {
            for (Location location : Location.findAllExamLocations(sessionId, form.getExamType())) {
                ExamAssignment match;
                if (!this.match(form, location.getLabel())) continue;
                Collection<RoomAvailabilityInterface.TimeBlock> events = ra.getRoomAvailability(location.getUniqueId(), bounds[0], bounds[1], null);
                if (ts == null) {
                    ts = ra.getTimeStamp(bounds[0], bounds[1], null);
                }
                TreeSet<Object> exams = null;
                if (examAssignment != null) {
                    exams = examAssignment.getExamsOfRoom(location.getUniqueId());
                } else {
                    exams = new TreeSet();
                    Iterator j = new ExamDAO().getSession().createQuery("select x from Exam x inner join x.assignedRooms r where x.examType.uniqueId=:examTypeId and r.uniqueId=:locationId").setLong("examTypeId", form.getExamType().longValue()).setLong("locationId", location.getUniqueId().longValue()).setCacheable(true).list().iterator();
                    while (j.hasNext()) {
                        exams.add(new ExamAssignment((Exam)j.next()));
                    }
                }
                if (exams == null) {
                    exams = new TreeSet();
                }
                if (events == null) {
                    events = new TreeSet<RoomAvailabilityInterface.TimeBlock>();
                }
                Hashtable<RoomAvailabilityInterface.TimeBlock, ExamAssignment> mapping = new Hashtable<RoomAvailabilityInterface.TimeBlock, ExamAssignment>();
                for (RoomAvailabilityInterface.TimeBlock timeBlock : events) {
                    if (!eventType.equals(timeBlock.getEventType())) continue;
                    match = null;
                    for (ExamAssignment examAssignment2 : exams) {
                        if (!timeBlock.getEventName().trim().equalsIgnoreCase(examAssignment2.getExamName().trim()) || !examAssignment2.getPeriod().overlap(timeBlock)) continue;
                        match = examAssignment2;
                        break;
                    }
                    if (match == null) continue;
                    mapping.put(timeBlock, match);
                    exams.remove(match);
                }
                for (RoomAvailabilityInterface.TimeBlock timeBlock : events) {
                    if (!eventType.equals(timeBlock.getEventType())) continue;
                    match = null;
                    for (ExamAssignment examAssignment3 : exams) {
                        if (!timeBlock.getEventName().trim().equalsIgnoreCase(examAssignment3.getExamName().trim())) continue;
                        match = examAssignment3;
                        break;
                    }
                    if (match == null) continue;
                    mapping.put(timeBlock, match);
                    exams.remove(match);
                }
                for (RoomAvailabilityInterface.TimeBlock timeBlock : events) {
                    if (!eventType.equals(timeBlock.getEventType())) continue;
                    match = null;
                    for (ExamAssignment examAssignment4 : exams) {
                        if (!examAssignment4.getPeriod().overlap(timeBlock)) continue;
                        match = examAssignment4;
                        break;
                    }
                    if (match == null) continue;
                    mapping.put(timeBlock, match);
                    exams.remove(match);
                }
                for (RoomAvailabilityInterface.TimeBlock timeBlock : events) {
                    if (!eventType.equals(timeBlock.getEventType())) continue;
                    match = (ExamAssignment)mapping.get(timeBlock);
                    if (match == null) {
                        table.addLine(null, new String[]{location.getLabel(), location.getCapacity().toString(), location.getExamCapacity().toString(), "", "", "", (html ? "<span style='background-color:yellow;'>" : "@@BGCOLOR FFFF00 ") + timeBlock.getEventName() + (html ? "</span>" : " @@END_BGCOLOR "), (html ? "<span style='background-color:yellow;'>" : "@@BGCOLOR FFFF00 ") + (html ? dateFormat.format(timeBlock.getStartTime()).replaceAll(" ", "&nbsp;") : dateFormat.format(timeBlock.getStartTime())) + (html ? "</span>" : " @@END_BGCOLOR "), (html ? "<span style='background-color:yellow;'>" : "@@BGCOLOR FFFF00 ") + timeFormat.format(timeBlock.getStartTime()).replaceAll("AM", "a").replaceAll("PM", "p") + (html ? "</span>" : " @@END_BGCOLOR ") + (html ? "&nbsp;-&nbsp;" : " - ") + (html ? "<span style='background-color:yellow;'>" : "@@BGCOLOR FFFF00 ") + timeFormat.format(timeBlock.getEndTime()).replaceAll("AM", "a").replaceAll("PM", "p") + (html ? "</span>" : " @@END_BGCOLOR ")}, new Comparable[]{new MultiComparable((Comparable)((Object)location.getLabel()), timeBlock.getStartTime()), new MultiComparable(Integer.valueOf(-location.getCapacity().intValue()), (Comparable)((Object)location.getLabel()), timeBlock.getStartTime()), new MultiComparable(Integer.valueOf(-location.getExamCapacity().intValue()), (Comparable)((Object)location.getLabel()), timeBlock.getStartTime()), new MultiComparable((Comparable)((Object)""), (Comparable)((Object)location.getLabel()), new Date(0L)), new MultiComparable(new Date(0L), (Comparable)((Object)location.getLabel())), new MultiComparable(Integer.valueOf(0), (Comparable)((Object)location.getLabel())), new MultiComparable((Comparable)((Object)timeBlock.getEventName()), (Comparable)((Object)location.getLabel()), timeBlock.getStartTime()), new MultiComparable(timeBlock.getStartTime(), (Comparable)((Object)location.getLabel())), new MultiComparable(Long.valueOf(timeBlock.getStartTime().getTime() % 86400000L), (Comparable)((Object)location.getLabel()))}, location.getUniqueId().toString());
                        continue;
                    }
                    Calendar c = Calendar.getInstance();
                    c.setTime(match.getPeriod().getStartTime());
                    c.add(12, match.getPrintOffset());
                    Date date = c.getTime();
                    c.add(12, match.getLength());
                    Date endTime = c.getTime();
                    boolean nameMatch = timeBlock.getEventName().trim().equalsIgnoreCase(match.getExamName().trim());
                    boolean dateMatch = dateFormat.format(timeBlock.getStartTime()).equals(dateFormat.format(match.getPeriod().getStartDate()));
                    Date start = timeBlock.getStartTime();
                    int breakTimeStart = match.getPeriod().getEventStartOffset() * Constants.SLOT_LENGTH_MIN;
                    c = Calendar.getInstance(Locale.US);
                    c.setTime(start);
                    c.add(12, breakTimeStart);
                    start = c.getTime();
                    Date stop = timeBlock.getEndTime();
                    int breakTimeStop = match.getPeriod().getEventStopOffset() * Constants.SLOT_LENGTH_MIN;
                    c = Calendar.getInstance(Locale.US);
                    c.setTime(stop);
                    c.add(12, -breakTimeStop);
                    stop = c.getTime();
                    boolean startMatch = start.equals(date);
                    boolean endMatch = stop.equals(endTime);
                    if (nameMatch && dateMatch && startMatch && endMatch) continue;
                    table.addLine(null, new String[]{location.getLabel(), location.getCapacity().toString(), location.getExamCapacity().toString(), (nameMatch ? "" : (html ? "<span style='background-color:yellow;'>" : "@@BGCOLOR FFFF00 ")) + match.getExamName() + (nameMatch ? "" : (html ? "</span>" : " @@END_BGCOLOR ")), (dateMatch ? "" : (html ? "<span style='background-color:yellow;'>" : "@@BGCOLOR FFFF00 ")) + (html ? dateFormat.format(match.getPeriod().getStartDate()).replaceAll(" ", "&nbsp;") : dateFormat.format(match.getPeriod().getStartDate())) + (dateMatch ? "" : (html ? "</span>" : " @@END_BGCOLOR ")), (startMatch ? "" : (html ? "<span style='background-color:yellow;'>" : "@@BGCOLOR FFFF00 ")) + timeFormat.format(date).replaceAll("AM", "a").replaceAll("PM", "p") + (startMatch ? "" : (html ? "</span>" : " @@END_BGCOLOR ")) + (html ? "&nbsp;-&nbsp;" : " - ") + (endMatch ? "" : (html ? "<span style='background-color:yellow;'>" : "@@BGCOLOR FFFF00 ")) + timeFormat.format(endTime).replaceAll("AM", "a").replaceAll("PM", "p") + (endMatch ? "" : (html ? "</span>" : " @@END_BGCOLOR ")), (nameMatch ? "" : (html ? "<span style='background-color:yellow;'>" : "@@BGCOLOR FFFF00 ")) + timeBlock.getEventName() + (nameMatch ? "" : (html ? "</span>" : " @@END_BGCOLOR ")), (dateMatch ? "" : (html ? "<span style='background-color:yellow;'>" : "@@BGCOLOR FFFF00 ")) + (html ? dateFormat.format(timeBlock.getStartTime()).replaceAll(" ", "&nbsp;") : dateFormat.format(timeBlock.getStartTime())) + (dateMatch ? "" : (html ? "</span>" : " @@END_BGCOLOR ")), (startMatch ? "" : (html ? "<span style='background-color:yellow;'>" : "@@BGCOLOR FFFF00 ")) + timeFormat.format(timeBlock.getStartTime()).replaceAll("AM", "a").replaceAll("PM", "p") + (startMatch ? "" : (html ? "</span>" : " @@END_BGCOLOR ")) + (html ? "&nbsp;-&nbsp;" : " - ") + (endMatch ? "" : (html ? "<span style='background-color:yellow;'>" : "@@BGCOLOR FFFF00 ")) + timeFormat.format(timeBlock.getEndTime()).replaceAll("AM", "a").replaceAll("PM", "p") + (endMatch ? "" : (html ? "</span>" : " @@END_BGCOLOR "))}, new Comparable[]{new MultiComparable((Comparable)((Object)location.getLabel()), timeBlock.getStartTime()), new MultiComparable(Integer.valueOf(-location.getCapacity().intValue()), (Comparable)((Object)location.getLabel()), timeBlock.getStartTime()), new MultiComparable(Integer.valueOf(-location.getExamCapacity().intValue()), (Comparable)((Object)location.getLabel()), timeBlock.getStartTime()), new MultiComparable((Comparable)((Object)match.getExamName()), (Comparable)((Object)location.getLabel()), match.getPeriod().getStartTime()), new MultiComparable(match.getPeriod().getStartTime(), (Comparable)((Object)location.getLabel())), new MultiComparable(Long.valueOf(match.getPeriod().getStartTime().getTime() % 86400000L), (Comparable)((Object)location.getLabel())), new MultiComparable((Comparable)((Object)timeBlock.getEventName()), (Comparable)((Object)location.getLabel()), timeBlock.getStartTime()), new MultiComparable(timeBlock.getStartTime(), (Comparable)((Object)location.getLabel())), new MultiComparable(Long.valueOf(timeBlock.getStartTime().getTime() % 86400000L), (Comparable)((Object)location.getLabel()))}, location.getUniqueId().toString());
                }
                for (ExamAssignment examAssignment5 : exams) {
                    Calendar c = Calendar.getInstance();
                    c.setTime(examAssignment5.getPeriod().getStartTime());
                    c.add(12, examAssignment5.getLength());
                    Date endTime = c.getTime();
                    table.addLine(null, new String[]{location.getLabel(), location.getCapacity().toString(), location.getExamCapacity().toString(), (html ? "<span style='background-color:yellow;'>" : "@@BGCOLOR FFFF00 ") + examAssignment5.getExamName() + (html ? "</span>" : " @@END_BGCOLOR "), (html ? "<span style='background-color:yellow;'>" : "@@BGCOLOR FFFF00 ") + (html ? dateFormat.format(examAssignment5.getPeriod().getStartDate()).replaceAll(" ", "&nbsp;") : dateFormat.format(examAssignment5.getPeriod().getStartDate())) + (html ? "</span>" : " @@END_BGCOLOR "), (html ? "<span style='background-color:yellow;'>" : "@@BGCOLOR FFFF00 ") + timeFormat.format(examAssignment5.getPeriod().getStartTime()).replaceAll("AM", "a").replaceAll("PM", "p") + (html ? "</span>" : " @@END_BGCOLOR ") + (html ? "&nbsp;-&nbsp;" : " - ") + (html ? "<span style='background-color:yellow;'>" : "@@BGCOLOR FFFF00 ") + timeFormat.format(endTime).replaceAll("AM", "a").replaceAll("PM", "p") + (html ? "</span>" : " @@END_BGCOLOR "), "", "", ""}, new Comparable[]{new MultiComparable((Comparable)((Object)location.getLabel()), examAssignment5.getPeriod().getStartTime()), new MultiComparable(Integer.valueOf(-location.getCapacity().intValue()), (Comparable)((Object)location.getLabel()), examAssignment5.getPeriod().getStartTime()), new MultiComparable(Integer.valueOf(-location.getExamCapacity().intValue()), (Comparable)((Object)location.getLabel()), examAssignment5.getPeriod().getStartTime()), new MultiComparable((Comparable)((Object)examAssignment5.getExamName()), (Comparable)((Object)location.getLabel()), examAssignment5.getPeriod().getStartTime()), new MultiComparable(examAssignment5.getPeriod().getStartTime(), (Comparable)((Object)location.getLabel())), new MultiComparable(Long.valueOf(examAssignment5.getPeriod().getStartTime().getTime() % 86400000L), (Comparable)((Object)location.getLabel())), new MultiComparable((Comparable)((Object)""), (Comparable)((Object)location.getLabel()), new Date(0L)), new MultiComparable(new Date(0L), (Comparable)((Object)location.getLabel())), new MultiComparable(Integer.valueOf(0), (Comparable)((Object)location.getLabel()))}, location.getUniqueId().toString());
                }
            }
            if (ts != null) {
                request.setAttribute("timestamp", ts);
            }
        }
        catch (Exception e) {
            Debug.error(e);
            table.addLine(new String[]{"<font color='red'>ERROR:" + e.getMessage() + "</font>"}, null);
        }
        return table;
    }
}

