/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.LabelValueBean;
import org.apache.struts.util.MessageResources;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.form.EditRoomPrefForm;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.NonUniversityLocation;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.RoomDept;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.dao.LocationDAO;
import org.unitime.timetable.model.dao.PreferenceLevelDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;

@Service(value="/editRoomPref")
public class EditRoomPrefAction
extends Action {
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Long id;
        LocationDAO ldao;
        Location location;
        EditRoomPrefForm editRoomPrefForm = (EditRoomPrefForm)form;
        MessageResources rsc = this.getResources(request);
        String doit = editRoomPrefForm.getDoit();
        if (doit != null && doit.equals(rsc.getMessage("button.returnToRoomDetail"))) {
            response.sendRedirect("roomDetail.do?id=" + editRoomPrefForm.getId());
            return null;
        }
        if (doit != null && doit.equals(rsc.getMessage("button.update"))) {
            ActionMessages errors = new ActionMessages();
            errors = editRoomPrefForm.validate(mapping, request);
            if (errors != null && errors.size() != 0) {
                this.saveErrors(request, errors);
            } else {
                this.doUpdate(editRoomPrefForm, request);
                return mapping.findForward("showRoomDetail");
            }
        }
        if ((location = (Location)(ldao = new LocationDAO()).get(id = Long.valueOf(request.getParameter("id")))) instanceof Room) {
            Room r = (Room)location;
            editRoomPrefForm.setName(r.getLabel());
        } else if (location instanceof NonUniversityLocation) {
            NonUniversityLocation nonUnivLocation = (NonUniversityLocation)location;
            editRoomPrefForm.setName(nonUnivLocation.getName());
        } else {
            ActionMessages errors = new ActionMessages();
            errors.add("editRoomGroup", new ActionMessage("errors.lookup.notFound", (Object)"Room Group"));
            this.saveErrors(request, errors);
        }
        this.sessionContext.checkPermission(location, Right.RoomEditPreference);
        TreeSet<Department> departments = Department.getUserDepartments(this.sessionContext.getUser());
        TreeSet<Department> availableDepts = new TreeSet<Department>();
        for (RoomDept rd : location.getRoomDepts()) {
            if (!departments.contains(rd.getDepartment())) continue;
            availableDepts.add(rd.getDepartment());
        }
        editRoomPrefForm.setDepts(new ArrayList(availableDepts));
        ArrayList<LabelValueBean> depts = new ArrayList<LabelValueBean>();
        ArrayList<String> selectedPrefs = new ArrayList<String>();
        for (Department dept : availableDepts) {
            RoomPref roomPref = location.getRoomPreference(dept);
            if (roomPref != null) {
                selectedPrefs.add(roomPref.getPrefLevel().getUniqueId().toString());
            } else {
                selectedPrefs.add(PreferenceLevel.PREF_LEVEL_NEUTRAL);
            }
            depts.add(new LabelValueBean(dept.getDeptCode() + "-" + dept.getAbbreviation(), dept.getDeptCode()));
        }
        editRoomPrefForm.setRoomPrefLevels(selectedPrefs);
        request.setAttribute(Department.DEPT_ATTR_NAME, depts);
        if (departments.size() == 1) {
            editRoomPrefForm.setDeptCode(departments.first().getDeptCode());
        } else if (this.sessionContext.getAttribute(SessionAttribute.DepartmentCodeRoom) != null) {
            editRoomPrefForm.setDeptCode((String)this.sessionContext.getAttribute(SessionAttribute.DepartmentCodeRoom));
        }
        Vector<PreferenceLevel> prefs = new Vector<PreferenceLevel>();
        for (PreferenceLevel pref : PreferenceLevel.getPreferenceLevelList()) {
            if (pref.getPrefProlog().equalsIgnoreCase(PreferenceLevel.sRequired)) continue;
            prefs.addElement(pref);
        }
        request.setAttribute(PreferenceLevel.PREF_LEVEL_ATTR_NAME, prefs);
        return mapping.findForward("showEditRoomPref");
    }

    private void doUpdate(EditRoomPrefForm editRoomPrefForm, HttpServletRequest request) throws Exception {
        Long id = Long.valueOf(request.getParameter("id"));
        LocationDAO ldao = new LocationDAO();
        Location location = (Location)ldao.get(id);
        this.sessionContext.checkPermission(location, Right.RoomEditPreference);
        TreeSet<Department> departments = Department.getUserDepartments(this.sessionContext.getUser());
        TreeSet<Department> availableDepts = new TreeSet<Department>();
        for (RoomDept rd : location.getRoomDepts()) {
            if (!departments.contains(rd.getDepartment())) continue;
            availableDepts.add(rd.getDepartment());
        }
        List selectedId = editRoomPrefForm.getRoomPrefLevels();
        int i = 0;
        for (Department dept : availableDepts) {
            PreferenceLevel seletedPL = (PreferenceLevel)PreferenceLevelDAO.getInstance().get(Long.valueOf((String)selectedId.get(i++)));
            RoomPref selectedRP = new RoomPref();
            selectedRP.setRoom(location);
            selectedRP.setPrefLevel(seletedPL);
            selectedRP.setOwner(dept);
            Set<Preference> prefs = dept.getPreferences();
            Iterator<Preference> iter = prefs.iterator();
            while (iter.hasNext()) {
                Preference p = iter.next();
                if (!(p instanceof RoomPref) || !((RoomPref)p).getRoom().equals(location)) continue;
                PreferenceLevelDAO.getInstance().getSession().delete((Object)p);
                iter.remove();
            }
            prefs.add(selectedRP);
            PreferenceLevelDAO.getInstance().getSession().saveOrUpdate((Object)dept);
            ChangeLog.addChange(null, this.sessionContext, location, ChangeLog.Source.ROOM_PREF_EDIT, ChangeLog.Operation.UPDATE, null, dept);
        }
    }
}

