/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.commons.hibernate.stats;

import java.util.Date;
import org.hibernate.SessionFactory;
import org.hibernate.stat.CollectionStatistics;
import org.hibernate.stat.EntityStatistics;
import org.hibernate.stat.QueryStatistics;
import org.hibernate.stat.SecondLevelCacheStatistics;
import org.hibernate.stat.Statistics;
import org.unitime.commons.web.htmlgen.Table;
import org.unitime.commons.web.htmlgen.TableCell;
import org.unitime.commons.web.htmlgen.TableHeaderCell;
import org.unitime.commons.web.htmlgen.TableRow;
import org.unitime.timetable.model.dao._RootDAO;

public class StatsProvider {
    public static String getStatsHtml(boolean summaryOnly) {
        return new StatsProvider().getStatsHtml(new _RootDAO().getSession().getSessionFactory(), summaryOnly);
    }

    public String getStatsHtml(SessionFactory sessionFactory, boolean summaryOnly) {
        StringBuffer hibStats = new StringBuffer();
        try {
            int i;
            Table subTable;
            Statistics stats = sessionFactory.getStatistics();
            if (!stats.isStatisticsEnabled()) {
                return "<font color='red'><b>Hibernate statistics is not enabled.</b></font>";
            }
            String evenRowColor = "#FAFAFA";
            Table table = new Table();
            table.setWidth("100%");
            table.setBorder(0);
            table.setCellSpacing(0);
            table.setCellPadding(3);
            StringBuffer links = new StringBuffer("");
            links.append("<A class=\"l7\" href=\"#Entity\">Entity</A>");
            if (!summaryOnly) {
                links.append(" - <A class=\"l7\" href=\"#EntityDetail\">Detail</A>");
            }
            links.append(" | <A class=\"l7\" href=\"#Collection\">Collection</A>");
            if (!summaryOnly) {
                links.append(" - <A class=\"l7\" href=\"#CollectionDetail\">Detail</A>");
            }
            links.append(" | <A class=\"l7\" href=\"#SecondLevelCache\">Second Level Cache</A>");
            if (!summaryOnly) {
                links.append(" - <A class=\"l7\" href=\"#SecondLevelCacheDetail\">Detail</A>");
            }
            links.append(" | <A class=\"l7\" href=\"#Query\">Query</A>");
            if (!summaryOnly) {
                links.append(" - <A class=\"l7\" href=\"#QueryDetail\">Detail</A>");
            }
            TableRow row = new TableRow();
            row.addContent(this.cell(links.toString(), 1, 2, true, "center", "middle"));
            table.addContent(row);
            TableRow linkToTop = new TableRow();
            linkToTop.addContent(this.cell("<A class=\"l7\" href=\"#BackToTop\">Back to Top</A>", 1, 2, true, "right", "middle"));
            row = new TableRow();
            row.addContent(this.headerCell("<A name=\"BackToTop\">Metric</A>", 1, 1));
            row.addContent(this.headerCell("Value", 1, 1));
            table.addContent(row);
            row = new TableRow();
            row.addContent(this.cell(" &nbsp; Start Time", 1, 1, true));
            row.addContent(this.cell(new Date(stats.getStartTime()).toString(), 1, 1, false));
            table.addContent(row);
            row = new TableRow();
            row.addContent(this.cell(" &nbsp; Connect Count", 1, 1, true));
            row.addContent(this.cell(stats.getConnectCount() + "", 1, 1, false));
            table.addContent(row);
            row = new TableRow();
            row.addContent(this.cell(" &nbsp; Flush Count", 1, 1, true));
            row.addContent(this.cell(stats.getFlushCount() + "", 1, 1, false));
            table.addContent(row);
            row = new TableRow();
            row.addContent(this.cell(" &nbsp; Session Open Count", 1, 1, true));
            row.addContent(this.cell(stats.getSessionOpenCount() + "", 1, 1, false));
            table.addContent(row);
            row = new TableRow();
            row.addContent(this.cell(" &nbsp; Session Close Count", 1, 1, true));
            row.addContent(this.cell(stats.getSessionCloseCount() + "", 1, 1, false));
            table.addContent(row);
            row = new TableRow();
            row.addContent(this.cell(" &nbsp; Transaction Count", 1, 1, true));
            row.addContent(this.cell(stats.getTransactionCount() + "", 1, 1, false));
            table.addContent(row);
            row = new TableRow();
            row.addContent(this.cell(" &nbsp; Successful Transaction Count", 1, 1, true));
            row.addContent(this.cell(stats.getSuccessfulTransactionCount() + "", 1, 1, false));
            table.addContent(row);
            row = new TableRow();
            row.addContent(this.cell(" &nbsp; Prepare Statement Count", 1, 1, true));
            row.addContent(this.cell(stats.getPrepareStatementCount() + "", 1, 1, false));
            table.addContent(row);
            row = new TableRow();
            row.addContent(this.cell(" &nbsp; Close Statement Count", 1, 1, true));
            row.addContent(this.cell(stats.getCloseStatementCount() + "", 1, 1, false));
            table.addContent(row);
            row = new TableRow();
            row.addContent(this.cell(" &nbsp; Optimistic Failure Count", 1, 1, true));
            row.addContent(this.cell(stats.getOptimisticFailureCount() + "", 1, 1, false));
            table.addContent(row);
            row = new TableRow();
            row.addContent(this.cell("<hr>", 1, 2, false));
            table.addContent(row);
            row = new TableRow();
            row.addContent(this.headerCell("<A name=\"Entity\">Entity</A>:", 1, 2));
            table.addContent(row);
            row = new TableRow();
            row.addContent(this.cell(" &nbsp; Fetch Count", 1, 1, true));
            row.addContent(this.cell(stats.getEntityFetchCount() + "", 1, 1, false));
            table.addContent(row);
            row = new TableRow();
            row.addContent(this.cell(" &nbsp; Load Count", 1, 1, true));
            row.addContent(this.cell(stats.getEntityLoadCount() + "", 1, 1, false));
            table.addContent(row);
            row = new TableRow();
            row.addContent(this.cell(" &nbsp; Insert Count", 1, 1, true));
            row.addContent(this.cell(stats.getEntityInsertCount() + "", 1, 1, false));
            table.addContent(row);
            row = new TableRow();
            row.addContent(this.cell(" &nbsp; Update Count", 1, 1, true));
            row.addContent(this.cell(stats.getEntityUpdateCount() + "", 1, 1, false));
            table.addContent(row);
            row = new TableRow();
            row.addContent(this.cell(" &nbsp; Delete Count", 1, 1, true));
            row.addContent(this.cell(stats.getEntityDeleteCount() + "", 1, 1, false));
            table.addContent(row);
            row = new TableRow();
            row.addContent(this.cell("<hr>", 1, 2, false));
            table.addContent(row);
            table.addContent(linkToTop);
            if (!summaryOnly) {
                row = new TableRow();
                row.addContent(this.headerCell("<A name=\"EntityDetail\">Entity Statistics Detail</A>:", 1, 2));
                table.addContent(row);
                String[] cEntityNames = stats.getEntityNames();
                if (cEntityNames == null || cEntityNames.length == 0) {
                    row = new TableRow();
                    row.addContent(this.cell("No entity names found", 1, 2, false));
                    table.addContent(row);
                } else {
                    subTable = new Table();
                    subTable.setCellSpacing(1);
                    subTable.setCellPadding(3);
                    row = new TableRow();
                    row.addContent(this.headerCell(" &nbsp; ", 1, 1));
                    row.addContent(this.headerCell(" Fetches ", 1, 1));
                    row.addContent(this.headerCell(" Loads ", 1, 1));
                    row.addContent(this.headerCell(" Inserts ", 1, 1));
                    row.addContent(this.headerCell(" Updates ", 1, 1));
                    row.addContent(this.headerCell(" Deletes ", 1, 1));
                    subTable.addContent(row);
                    for (i = 0; i < cEntityNames.length; ++i) {
                        String entityName = cEntityNames[i];
                        EntityStatistics eStats = stats.getEntityStatistics(entityName);
                        row = new TableRow();
                        if (i % 2 == 0) {
                            row.setBgColor(evenRowColor);
                        }
                        row.addContent(this.cell(entityName + " &nbsp;", 1, 1, true));
                        row.addContent(this.cell(eStats.getFetchCount() + "", 1, 1, false));
                        row.addContent(this.cell(eStats.getLoadCount() + "", 1, 1, false));
                        row.addContent(this.cell(eStats.getInsertCount() + "", 1, 1, false));
                        row.addContent(this.cell(eStats.getUpdateCount() + "", 1, 1, false));
                        row.addContent(this.cell(eStats.getDeleteCount() + "", 1, 1, false));
                        subTable.addContent(row);
                    }
                    row = new TableRow();
                    row.addContent(this.cell(subTable.toHtml(), 1, 2, true));
                    table.addContent(row);
                }
                row = new TableRow();
                row.addContent(this.cell("<hr>", 1, 2, false));
                table.addContent(row);
                table.addContent(linkToTop);
            }
            row = new TableRow();
            row.addContent(this.headerCell("<A name=\"Collection\">Collection</A>:", 1, 2));
            table.addContent(row);
            row = new TableRow();
            row.addContent(this.cell(" &nbsp; Fetch Count", 1, 1, true));
            row.addContent(this.cell(stats.getCollectionFetchCount() + "", 1, 1, false));
            table.addContent(row);
            row = new TableRow();
            row.addContent(this.cell(" &nbsp; Load Count", 1, 1, true));
            row.addContent(this.cell(stats.getCollectionLoadCount() + "", 1, 1, false));
            table.addContent(row);
            row = new TableRow();
            row.addContent(this.cell(" &nbsp; Update Count", 1, 1, true));
            row.addContent(this.cell(stats.getCollectionUpdateCount() + "", 1, 1, false));
            table.addContent(row);
            row = new TableRow();
            row.addContent(this.cell(" &nbsp; Remove Count", 1, 1, true));
            row.addContent(this.cell(stats.getCollectionRemoveCount() + "", 1, 1, false));
            table.addContent(row);
            row = new TableRow();
            row.addContent(this.cell(" &nbsp; Recreate Count", 1, 1, true));
            row.addContent(this.cell(stats.getCollectionRecreateCount() + "", 1, 1, false));
            table.addContent(row);
            row = new TableRow();
            row.addContent(this.cell("<hr>", 1, 2, false));
            table.addContent(row);
            table.addContent(linkToTop);
            if (!summaryOnly) {
                row = new TableRow();
                row.addContent(this.headerCell("<A name=\"CollectionDetail\">Collection Statistics Detail</A>:", 1, 2));
                table.addContent(row);
                String[] cRoleNames = stats.getCollectionRoleNames();
                if (cRoleNames == null || cRoleNames.length == 0) {
                    row = new TableRow();
                    row.addContent(this.cell("No collection roles found", 1, 2, false));
                    table.addContent(row);
                } else {
                    subTable = new Table();
                    subTable.setCellSpacing(1);
                    subTable.setCellPadding(3);
                    row = new TableRow();
                    row.addContent(this.headerCell(" &nbsp; ", 1, 1));
                    row.addContent(this.headerCell(" Fetches ", 1, 1));
                    row.addContent(this.headerCell(" Loads ", 1, 1));
                    row.addContent(this.headerCell(" Updates ", 1, 1));
                    row.addContent(this.headerCell(" Removes ", 1, 1));
                    row.addContent(this.headerCell(" Recreates ", 1, 1));
                    subTable.addContent(row);
                    for (i = 0; i < cRoleNames.length; ++i) {
                        String roleName = cRoleNames[i];
                        CollectionStatistics cStats = stats.getCollectionStatistics(roleName);
                        row = new TableRow();
                        if (i % 2 == 0) {
                            row.setBgColor(evenRowColor);
                        }
                        row.addContent(this.cell(roleName + " &nbsp;", 1, 1, true));
                        row.addContent(this.cell(cStats.getFetchCount() + "", 1, 1, false));
                        row.addContent(this.cell(cStats.getLoadCount() + "", 1, 1, false));
                        row.addContent(this.cell(cStats.getUpdateCount() + "", 1, 1, false));
                        row.addContent(this.cell(cStats.getRemoveCount() + "", 1, 1, false));
                        row.addContent(this.cell(cStats.getRecreateCount() + "", 1, 1, false));
                        subTable.addContent(row);
                    }
                    row = new TableRow();
                    row.addContent(this.cell(subTable.toHtml(), 1, 2, true));
                    table.addContent(row);
                }
                row = new TableRow();
                row.addContent(this.cell("<hr>", 1, 2, false));
                table.addContent(row);
                table.addContent(linkToTop);
            }
            row = new TableRow();
            row.addContent(this.headerCell("<A name=\"SecondLevelCache\">Second Level Cache</A>:", 1, 2));
            table.addContent(row);
            row = new TableRow();
            row.addContent(this.cell(" &nbsp; Hit Count", 1, 1, true));
            row.addContent(this.cell(stats.getSecondLevelCacheHitCount() + "", 1, 1, false));
            table.addContent(row);
            row = new TableRow();
            row.addContent(this.cell(" &nbsp; Miss Count", 1, 1, true));
            row.addContent(this.cell(stats.getSecondLevelCacheMissCount() + "", 1, 1, false));
            table.addContent(row);
            row = new TableRow();
            row.addContent(this.cell(" &nbsp; Put Count", 1, 1, true));
            row.addContent(this.cell(stats.getSecondLevelCachePutCount() + "", 1, 1, false));
            table.addContent(row);
            row = new TableRow();
            row.addContent(this.cell("<hr>", 1, 2, false));
            table.addContent(row);
            table.addContent(linkToTop);
            if (!summaryOnly) {
                row = new TableRow();
                row.addContent(this.headerCell("<A name=\"SecondLevelCacheDetail\">Second Level Cache Statistics Detail</A>:", 1, 2));
                table.addContent(row);
                String[] cRegionNames = stats.getSecondLevelCacheRegionNames();
                if (cRegionNames == null || cRegionNames.length == 0) {
                    row = new TableRow();
                    row.addContent(this.cell("No region names found", 1, 2, false));
                    table.addContent(row);
                } else {
                    subTable = new Table();
                    subTable.setCellSpacing(1);
                    subTable.setCellPadding(3);
                    row = new TableRow();
                    row.addContent(this.headerCell(" &nbsp; ", 1, 1));
                    row.addContent(this.headerCell(" Entities ", 1, 1));
                    row.addContent(this.headerCell(" Hits ", 1, 1));
                    row.addContent(this.headerCell(" Misses ", 1, 1));
                    row.addContent(this.headerCell(" Puts ", 1, 1));
                    row.addContent(this.headerCell(" In Memory ", 1, 1));
                    row.addContent(this.headerCell(" On Disk ", 1, 1));
                    row.addContent(this.headerCell(" Memory ", 1, 1));
                    subTable.addContent(row);
                    long elementsInMem = 0L;
                    long elementsOnDisk = 0L;
                    long putCnt = 0L;
                    long missCnt = 0L;
                    long hitCnt = 0L;
                    long size = 0L;
                    for (int i2 = 0; i2 < cRegionNames.length; ++i2) {
                        String cRegionName = cRegionNames[i2];
                        SecondLevelCacheStatistics sStats = stats.getSecondLevelCacheStatistics(cRegionName);
                        row = new TableRow();
                        if (i2 % 2 == 0) {
                            row.setBgColor(evenRowColor);
                        }
                        row.addContent(this.cell(cRegionName + " &nbsp;", 1, 1, true));
                        row.addContent(this.cell(String.valueOf(sStats.getElementCountInMemory() + sStats.getElementCountOnDisk()), 1, 1, false));
                        row.addContent(this.cell(sStats.getHitCount() + "", 1, 1, false));
                        row.addContent(this.cell(sStats.getMissCount() + "", 1, 1, false));
                        row.addContent(this.cell(sStats.getPutCount() + "", 1, 1, false));
                        row.addContent(this.cell(sStats.getElementCountInMemory() + "", 1, 1, false));
                        row.addContent(this.cell(sStats.getElementCountOnDisk() + "", 1, 1, false));
                        row.addContent(this.cell(sStats.getSizeInMemory() + " bytes", 1, 1, false));
                        elementsInMem += sStats.getElementCountInMemory();
                        elementsOnDisk += sStats.getElementCountOnDisk();
                        putCnt += sStats.getPutCount();
                        missCnt += sStats.getMissCount();
                        hitCnt += sStats.getHitCount();
                        size += sStats.getSizeInMemory();
                        subTable.addContent(row);
                    }
                    row = new TableRow();
                    row.addContent(this.headerCell("Total &nbsp;", 1, 1));
                    row.addContent(this.headerCell("" + (elementsInMem + elementsOnDisk), 1, 1));
                    row.addContent(this.headerCell("" + hitCnt, 1, 1));
                    row.addContent(this.headerCell("" + missCnt, 1, 1));
                    row.addContent(this.headerCell("" + putCnt, 1, 1));
                    row.addContent(this.headerCell("" + elementsInMem, 1, 1));
                    row.addContent(this.headerCell("" + elementsOnDisk, 1, 1));
                    row.addContent(this.headerCell(size + " bytes", 1, 1));
                    subTable.addContent(row);
                    row = new TableRow();
                    row.addContent(this.cell(subTable.toHtml(), 1, 2, true));
                    table.addContent(row);
                }
                row = new TableRow();
                row.addContent(this.cell("<hr>", 1, 2, false));
                table.addContent(row);
                table.addContent(linkToTop);
            }
            row = new TableRow();
            row.addContent(this.headerCell("<A name=\"Query\">Query</A>:", 1, 2));
            table.addContent(row);
            row = new TableRow();
            row.addContent(this.cell(" &nbsp; Execution Count", 1, 1, true));
            row.addContent(this.cell(stats.getQueryExecutionCount() + "", 1, 1, false));
            table.addContent(row);
            row = new TableRow();
            row.addContent(this.cell(" &nbsp; Execution Max Time", 1, 1, true));
            row.addContent(this.cell(stats.getQueryExecutionMaxTime() + " ms", 1, 1, false));
            table.addContent(row);
            row = new TableRow();
            row.addContent(this.cell(" &nbsp; Cache Hit Count", 1, 1, true));
            row.addContent(this.cell(stats.getQueryCacheHitCount() + " ms", 1, 1, false));
            table.addContent(row);
            row = new TableRow();
            row.addContent(this.cell(" &nbsp; Cache Miss Count", 1, 1, true));
            row.addContent(this.cell(stats.getQueryCacheMissCount() + " ms", 1, 1, false));
            table.addContent(row);
            row = new TableRow();
            row.addContent(this.cell(" &nbsp; Cache Put Count", 1, 1, true));
            row.addContent(this.cell(stats.getQueryCachePutCount() + "", 1, 1, false));
            table.addContent(row);
            row = new TableRow();
            row.addContent(this.cell("<hr>", 1, 2, false));
            table.addContent(row);
            table.addContent(linkToTop);
            if (!summaryOnly) {
                row = new TableRow();
                row.addContent(this.headerCell("<A name=\"QueryDetail\">Query Statistics Detail</A>:", 1, 2));
                table.addContent(row);
                String[] cQueryStrings = stats.getQueries();
                if (cQueryStrings == null || cQueryStrings.length == 0) {
                    row = new TableRow();
                    row.addContent(this.cell("No query strings found", 1, 2, false));
                    table.addContent(row);
                } else {
                    subTable = new Table();
                    subTable.setCellSpacing(1);
                    subTable.setCellPadding(3);
                    row = new TableRow();
                    row.addContent(this.headerCell(" &nbsp; ", 1, 1));
                    row.addContent(this.headerCell(" Execs ", 1, 1));
                    row.addContent(this.headerCell(" Rows ", 1, 1));
                    row.addContent(this.headerCell(" Max Time ", 1, 1));
                    row.addContent(this.headerCell(" Min Time ", 1, 1));
                    row.addContent(this.headerCell(" Avg Time ", 1, 1));
                    row.addContent(this.headerCell(" Cache Hits ", 1, 1));
                    row.addContent(this.headerCell(" Cache Misses ", 1, 1));
                    row.addContent(this.headerCell(" Cache Puts ", 1, 1));
                    subTable.addContent(row);
                    for (int i3 = 0; i3 < cQueryStrings.length; ++i3) {
                        String cQueryString = cQueryStrings[i3];
                        QueryStatistics qStats = stats.getQueryStatistics(cQueryString);
                        row = new TableRow();
                        if (i3 % 2 == 0) {
                            row.setBgColor(evenRowColor);
                        }
                        row.addContent(this.cell(cQueryString + " &nbsp;", 1, 1, false));
                        row.addContent(this.cell(qStats.getExecutionCount() + "", 1, 1, false));
                        row.addContent(this.cell(qStats.getExecutionRowCount() + "", 1, 1, false));
                        row.addContent(this.cell(qStats.getExecutionMaxTime() + " ms", 1, 1, false));
                        row.addContent(this.cell(qStats.getExecutionMinTime() + " ms", 1, 1, false));
                        row.addContent(this.cell(qStats.getExecutionAvgTime() + " ms", 1, 1, false));
                        row.addContent(this.cell(qStats.getCacheHitCount() + "", 1, 1, false));
                        row.addContent(this.cell(qStats.getCacheMissCount() + "", 1, 1, false));
                        row.addContent(this.cell(qStats.getCachePutCount() + "", 1, 1, false));
                        subTable.addContent(row);
                    }
                    row = new TableRow();
                    row.addContent(this.cell(subTable.toHtml(), 1, 2, true));
                    table.addContent(row);
                }
                row = new TableRow();
                row.addContent(this.cell("<hr>", 1, 2, false));
                table.addContent(row);
                table.addContent(linkToTop);
            }
            hibStats.append(table.toHtml());
        }
        catch (Exception e) {
            hibStats.append("Exception occured: " + e.getMessage());
            e.printStackTrace();
        }
        return hibStats.toString();
    }

    private TableHeaderCell headerCell(String content, int rowSpan, int colSpan) {
        TableHeaderCell cell = new TableHeaderCell();
        cell.setRowSpan(rowSpan);
        cell.setColSpan(colSpan);
        cell.setNoWrap(true);
        cell.setAlign("left");
        cell.setValign("top");
        cell.addContent("<font size=\"-1\">");
        cell.addContent(content);
        cell.addContent("</font>");
        return cell;
    }

    private TableCell cell(String content, int rowSpan, int colSpan, boolean noWrap) {
        TableCell cell = this.cell(content, rowSpan, colSpan, noWrap, "left", "top");
        return cell;
    }

    private TableCell cell(String content, int rowSpan, int colSpan, boolean noWrap, String align, String valign) {
        TableCell cell = new TableCell();
        cell.setRowSpan(rowSpan);
        cell.setColSpan(colSpan);
        cell.setNoWrap(noWrap);
        cell.setAlign(align);
        cell.setValign(valign);
        cell.addContent("<font size=\"-1\">");
        cell.addContent(content);
        cell.addContent("</font>");
        return cell;
    }
}

