/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.reservation;

import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.reservation.Reservation;

public class CourseReservation
extends Reservation {
    private Course iCourse;
    public static final int DEFAULT_PRIORITY = 400;
    public static final boolean DEFAULT_MUST_BE_USED = false;
    public static final boolean DEFAULT_CAN_ASSIGN_OVER_LIMIT = true;
    public static final boolean DEFAULT_ALLOW_OVERLAP = false;

    public CourseReservation(long id, Course course) {
        super(id, course.getOffering(), 400, false, true, false);
        this.iCourse = course;
    }

    @Override
    public double getReservationLimit() {
        return this.iCourse.getLimit();
    }

    public Course getCourse() {
        return this.iCourse;
    }

    @Override
    public boolean isApplicable(Student student) {
        for (Request r : student.getRequests()) {
            if (!(r instanceof CourseRequest)) continue;
            for (Course course : ((CourseRequest)r).getCourses()) {
                if (!course.equals(this.getCourse())) continue;
                return true;
            }
        }
        return false;
    }
}

