/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.online.selection;

import java.util.List;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.ToolBox;
import org.cpsolver.studentsct.model.Choice;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.online.selection.StudentSchedulingAssistantWeights;

public class ResectioningWeights
extends StudentSchedulingAssistantWeights {
    private double iSameChoiceFactor = 0.125;
    private double iSameRoomsFactor = 0.007;
    private double iSameTimeFactor = 0.07;
    private double iSameNameFactor = 0.014;
    private LastSectionProvider iLastSectionProvider = null;

    public ResectioningWeights(DataProperties properties) {
        super(properties);
        this.iSameChoiceFactor = properties.getPropertyDouble("StudentWeights.SameChoiceFactor", this.iSameChoiceFactor);
        this.iSameRoomsFactor = properties.getPropertyDouble("StudentWeights.SameRoomsFactor", this.iSameRoomsFactor);
        this.iSameTimeFactor = properties.getPropertyDouble("StudentWeights.SameTimeFactor", this.iSameTimeFactor);
        this.iSameNameFactor = properties.getPropertyDouble("StudentWeights.SameNameFactor", this.iSameNameFactor);
    }

    public void setLastSectionProvider(LastSectionProvider lastSectionProvider) {
        this.iLastSectionProvider = lastSectionProvider;
    }

    @Override
    public double getWeight(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
        double weight = super.getWeight(assignment, enrollment);
        if (enrollment.isCourseRequest() && enrollment.getAssignments() != null && this.iLastSectionProvider != null) {
            int sameChoice = 0;
            int sameTime = 0;
            int sameRooms = 0;
            int sameName = 0;
            for (Section section : enrollment.getSections()) {
                if (this.iLastSectionProvider.sameLastChoice(section)) {
                    ++sameChoice;
                }
                if (this.iLastSectionProvider.sameLastTime(section)) {
                    ++sameTime;
                }
                if (this.iLastSectionProvider.sameLastRoom(section)) {
                    ++sameRooms;
                }
                if (!this.iLastSectionProvider.sameLastName(section, enrollment.getCourse())) continue;
                ++sameName;
            }
            CourseRequest cr = (CourseRequest)enrollment.getRequest();
            if (sameChoice == 0 && !cr.getSelectedChoices().isEmpty()) {
                for (Section section : enrollment.getSections()) {
                    if (!cr.getSelectedChoices().contains(section.getChoice())) continue;
                    ++sameChoice;
                }
            }
            double size = enrollment.getAssignments().size();
            double sameChoiceFraction = (size - (double)sameChoice) / size;
            double sameTimeFraction = (size - (double)sameTime) / size;
            double sameRoomsFraction = (size - (double)sameRooms) / size;
            double sameNameFraction = (size - (double)sameName) / size;
            double base = this.getBaseWeight(assignment, enrollment);
            weight -= sameChoiceFraction * base * this.iSameChoiceFactor;
            weight -= sameTimeFraction * base * this.iSameTimeFactor;
            weight -= sameRoomsFraction * base * this.iSameRoomsFactor;
            weight -= sameNameFraction * base * this.iSameNameFactor;
        }
        return weight;
    }

    public static boolean sameChoice(Section s, Choice ch) {
        return ResectioningWeights.sameChoice(s, ch == null ? null : ch.getId());
    }

    public static boolean sameChoice(Section s, String ch) {
        if (s.getChoice() == null && ch == null) {
            return true;
        }
        if (s.getChoice() == null || ch == null) {
            return false;
        }
        return s.getChoice().getId().equals(ch);
    }

    public static boolean isSame(Enrollment e1, Enrollment e2) {
        if (e1.getSections().size() != e2.getSections().size()) {
            return false;
        }
        block0: for (Section s1 : e1.getSections()) {
            for (Section s2 : e2.getSections()) {
                if (!ResectioningWeights.sameChoice(s1, s2.getChoice())) continue;
                continue block0;
            }
            return false;
        }
        return true;
    }

    public static boolean sameRooms(Section s, List<RoomLocation> rooms) {
        if (s.getRooms() == null && rooms == null) {
            return true;
        }
        if (s.getRooms() == null || rooms == null) {
            return false;
        }
        return s.getRooms().size() == rooms.size() && s.getRooms().containsAll(rooms);
    }

    public static boolean sameTime(Section s, TimeLocation t) {
        if (s.getTime() == null && t == null) {
            return true;
        }
        if (s.getTime() == null || t == null) {
            return false;
        }
        return s.getTime().getStartSlot() == t.getStartSlot() && s.getTime().getLength() == t.getLength() && s.getTime().getDayCode() == t.getDayCode() && ToolBox.equals(s.getTime().getDatePatternName(), t.getDatePatternName());
    }

    public static boolean sameName(Long courseId, Section s1, Section s2) {
        return s1.getName(courseId).equals(s2.getName(courseId));
    }

    public static interface LastSectionProvider {
        public boolean sameLastChoice(Section var1);

        public boolean sameLastTime(Section var1);

        public boolean sameLastRoom(Section var1);

        public boolean sameLastName(Section var1, Course var2);
    }
}

